/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.validation;

import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.validation.DocumentMetadataValidation;
import com.openexchange.groupware.infostore.validation.FilenamesMayNotContainSlashesValidator;
import junit.framework.TestCase;

public class FilenamesMayNotContainSlashesValidatorTest
extends TestCase {
    public void testFailsValidationWithSlashInFilename() {
        DocumentMetadataValidation validation = this.validateFilename("filename/with/slahes");
        FilenamesMayNotContainSlashesValidatorTest.assertNotNull((String)"Validation was null", (Object)validation);
        FilenamesMayNotContainSlashesValidatorTest.assertTrue((String)"Exepcted error in filename", (boolean)validation.hasErrors(Metadata.FILENAME_LITERAL));
    }

    public void testPassesValidationWithoutSlashInFilename() {
        DocumentMetadataValidation validation = this.validateFilename("filename_without_slahes");
        FilenamesMayNotContainSlashesValidatorTest.assertNotNull((String)"Validation was null", (Object)validation);
        FilenamesMayNotContainSlashesValidatorTest.assertFalse((String)"Got unexpected error in filename", (boolean)validation.hasErrors(Metadata.FILENAME_LITERAL));
    }

    private DocumentMetadataValidation validateFilename(String filename) {
        DocumentMetadataImpl document = new DocumentMetadataImpl();
        document.setFileName(filename);
        return new FilenamesMayNotContainSlashesValidator().validate(null, (DocumentMetadata)document, null, null);
    }
}

