/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.container.CommonObjectTest;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import java.util.Date;

public class CalendarObjectTest
extends CommonObjectTest {
    private CalendarObject seriesMaster = null;
    private CalendarObject ocurrence1 = null;
    private CalendarObject ocurrence2 = null;
    private CalendarObject exception = null;
    private CalendarObject single = null;

    public void testIsPartOfSeries() {
        CalendarObjectTest.assertTrue((boolean)this.seriesMaster.isPartOfSeries());
        CalendarObjectTest.assertTrue((boolean)this.ocurrence1.isPartOfSeries());
        CalendarObjectTest.assertTrue((boolean)this.ocurrence2.isPartOfSeries());
        CalendarObjectTest.assertTrue((boolean)this.exception.isPartOfSeries());
        CalendarObjectTest.assertFalse((boolean)this.single.isPartOfSeries());
    }

    public void testIsSpecificOcurrence() {
        CalendarObjectTest.assertTrue((boolean)this.ocurrence1.isSpecificOcurrence());
        CalendarObjectTest.assertTrue((boolean)this.ocurrence2.isSpecificOcurrence());
        CalendarObjectTest.assertTrue((boolean)this.exception.isSpecificOcurrence());
        CalendarObjectTest.assertFalse((boolean)this.seriesMaster.isSpecificOcurrence());
        CalendarObjectTest.assertFalse((boolean)this.single.isSpecificOcurrence());
    }

    public void testIsException() {
        CalendarObjectTest.assertTrue((boolean)this.exception.isException());
        CalendarObjectTest.assertTrue((boolean)this.ocurrence1.isException());
        CalendarObjectTest.assertTrue((boolean)this.ocurrence2.isException());
        CalendarObjectTest.assertFalse((boolean)this.seriesMaster.isException());
        CalendarObjectTest.assertFalse((boolean)this.single.isException());
    }

    public void testIsMaster() {
        CalendarObjectTest.assertTrue((boolean)this.seriesMaster.isMaster());
        CalendarObjectTest.assertFalse((boolean)this.ocurrence1.isMaster());
        CalendarObjectTest.assertFalse((boolean)this.ocurrence2.isMaster());
        CalendarObjectTest.assertFalse((boolean)this.exception.isMaster());
        CalendarObjectTest.assertFalse((boolean)this.single.isMaster());
    }

    public void testIsSingle() {
        CalendarObjectTest.assertTrue((boolean)this.single.isSingle());
        CalendarObjectTest.assertFalse((boolean)this.ocurrence1.isSingle());
        CalendarObjectTest.assertFalse((boolean)this.ocurrence2.isSingle());
        CalendarObjectTest.assertFalse((boolean)this.exception.isSingle());
        CalendarObjectTest.assertFalse((boolean)this.seriesMaster.isSingle());
    }

    public void setUp() {
        int masterId = 12;
        int singleId = 14;
        this.seriesMaster = new TestCalendarObject();
        this.seriesMaster.setObjectID(masterId);
        this.seriesMaster.setRecurrenceID(masterId);
        this.seriesMaster.setRecurrenceType(1);
        this.seriesMaster.setInterval(1);
        this.seriesMaster.setRecurrencePosition(0);
        this.ocurrence1 = new TestCalendarObject();
        this.ocurrence1.setObjectID(masterId);
        this.ocurrence1.setRecurrenceID(masterId);
        this.ocurrence1.setRecurrencePosition(2);
        this.ocurrence2 = new TestCalendarObject();
        this.ocurrence2.setObjectID(masterId);
        this.ocurrence2.setRecurrenceID(masterId);
        this.ocurrence2.setRecurrenceDatePosition(new Date());
        this.exception = new TestCalendarObject();
        this.exception.setRecurrenceID(masterId);
        this.exception.setRecurrenceType(0);
        this.exception.setRecurrencePosition(3);
        this.exception.setInterval(1);
        this.single = new TestCalendarObject();
        this.single.setObjectID(singleId);
        this.single.setRecurrenceID(0);
        this.single.setRecurrenceType(0);
    }

    public void fillCalendarObject(CalendarObject co) {
        super.fillCommonObject((CommonObject)co);
        co.setAlarmFlag(true);
        co.setChangeExceptions(new Date[]{new Date(0L), new Date(2L)});
        co.setConfirm(3);
        co.setConfirmMessage("bier");
        co.setDayInMonth(3);
        co.setDays(2);
        co.setDeleteExceptions(new Date[]{new Date(0L), new Date(2L)});
        co.setEndDate(new Date(3L));
        co.setInterval(2);
        co.setMonth(2);
        co.setNote("Blupp");
        co.setNotification(true);
        co.setOccurrence(23);
        co.setParticipants(new Participant[0]);
        co.setRecurrenceCalculator(2);
        co.setRecurrenceCount(23);
        co.setRecurrenceDatePosition(new Date(23L));
        co.setRecurrenceID(2);
        co.setRecurrencePosition(3);
        co.setRecurrenceType(3);
        co.setStartDate(new Date(2L));
        co.setTitle("Bla");
        co.setUntil(new Date(2L));
        co.setUsers(new UserParticipant[0]);
    }

    @Override
    public void testAttrAccessors() {
        TestCalendarObject object = new TestCalendarObject();
        CalendarObjectTest.assertFalse((boolean)object.contains(222));
        CalendarObjectTest.assertFalse((boolean)object.containsOccurrence());
        object.setOccurrence(-12);
        CalendarObjectTest.assertTrue((boolean)object.contains(222));
        CalendarObjectTest.assertTrue((boolean)object.containsOccurrence());
        CalendarObjectTest.assertEquals((Object)-12, (Object)object.get(222));
        object.set(222, 12);
        CalendarObjectTest.assertEquals((int)12, (int)object.getOccurrence());
        object.remove(222);
        CalendarObjectTest.assertFalse((boolean)object.contains(222));
        CalendarObjectTest.assertFalse((boolean)object.containsOccurrence());
        CalendarObjectTest.assertFalse((boolean)object.contains(216));
        CalendarObjectTest.assertFalse((boolean)object.containsUntil());
        object.setUntil(new Date(42L));
        CalendarObjectTest.assertTrue((boolean)object.contains(216));
        CalendarObjectTest.assertTrue((boolean)object.containsUntil());
        CalendarObjectTest.assertEquals((Object)new Date(42L), (Object)object.get(216));
        object.set(216, new Date(23L));
        CalendarObjectTest.assertEquals((Object)new Date(23L), (Object)object.getUntil());
        object.remove(216);
        CalendarObjectTest.assertFalse((boolean)object.contains(216));
        CalendarObjectTest.assertFalse((boolean)object.containsUntil());
        CalendarObjectTest.assertFalse((boolean)object.contains(221));
        CalendarObjectTest.assertFalse((boolean)object.containsUserParticipants());
        UserParticipant[] users = new UserParticipant[]{new UserParticipant(1)};
        UserParticipant[] otherUsers = new UserParticipant[]{new UserParticipant(2)};
        object.setUsers(users);
        CalendarObjectTest.assertTrue((boolean)object.contains(221));
        CalendarObjectTest.assertTrue((boolean)object.containsUserParticipants());
        CalendarObjectTest.assertEquals((Object)users, (Object)object.get(221));
        object.set(221, otherUsers);
        CalendarObjectTest.assertEquals((Object)otherUsers, (Object)object.getUsers());
        object.remove(221);
        CalendarObjectTest.assertFalse((boolean)object.contains(221));
        CalendarObjectTest.assertFalse((boolean)object.containsUserParticipants());
        CalendarObjectTest.assertFalse((boolean)object.contains(203));
        CalendarObjectTest.assertFalse((boolean)object.containsNote());
        object.setNote("Bla");
        CalendarObjectTest.assertTrue((boolean)object.contains(203));
        CalendarObjectTest.assertTrue((boolean)object.containsNote());
        CalendarObjectTest.assertEquals((Object)"Bla", (Object)object.get(203));
        object.set(203, "Blupp");
        CalendarObjectTest.assertEquals((String)"Blupp", (String)object.getNote());
        object.remove(203);
        CalendarObjectTest.assertFalse((boolean)object.contains(203));
        CalendarObjectTest.assertFalse((boolean)object.containsNote());
        CalendarObjectTest.assertFalse((boolean)object.contains(208));
        CalendarObjectTest.assertFalse((boolean)object.containsRecurrenceDatePosition());
        object.setRecurrenceDatePosition(new Date(42L));
        CalendarObjectTest.assertTrue((boolean)object.contains(208));
        CalendarObjectTest.assertTrue((boolean)object.containsRecurrenceDatePosition());
        CalendarObjectTest.assertEquals((Object)new Date(42L), (Object)object.get(208));
        object.set(208, new Date(23L));
        CalendarObjectTest.assertEquals((Object)new Date(23L), (Object)object.getRecurrenceDatePosition());
        object.remove(208);
        CalendarObjectTest.assertFalse((boolean)object.contains(208));
        CalendarObjectTest.assertFalse((boolean)object.containsRecurrenceDatePosition());
        CalendarObjectTest.assertFalse((boolean)object.contains(202));
        CalendarObjectTest.assertFalse((boolean)object.containsEndDate());
        object.setEndDate(new Date(42L));
        CalendarObjectTest.assertTrue((boolean)object.contains(202));
        CalendarObjectTest.assertTrue((boolean)object.containsEndDate());
        CalendarObjectTest.assertEquals((Object)new Date(42L), (Object)object.get(202));
        object.set(202, new Date(23L));
        CalendarObjectTest.assertEquals((Object)new Date(23L), (Object)object.getEndDate());
        object.remove(202);
        CalendarObjectTest.assertFalse((boolean)object.contains(202));
        CalendarObjectTest.assertFalse((boolean)object.containsEndDate());
        CalendarObjectTest.assertFalse((boolean)object.contains(207));
        CalendarObjectTest.assertFalse((boolean)object.containsRecurrencePosition());
        object.setRecurrencePosition(-12);
        CalendarObjectTest.assertTrue((boolean)object.contains(207));
        CalendarObjectTest.assertTrue((boolean)object.containsRecurrencePosition());
        CalendarObjectTest.assertEquals((Object)-12, (Object)object.get(207));
        object.set(207, 12);
        CalendarObjectTest.assertEquals((int)12, (int)object.getRecurrencePosition());
        object.remove(207);
        CalendarObjectTest.assertFalse((boolean)object.contains(207));
        CalendarObjectTest.assertFalse((boolean)object.containsRecurrencePosition());
        object.setRecurrenceCalculator(-12);
        CalendarObjectTest.assertEquals((Object)-12, (Object)object.get(218));
        object.set(218, 12);
        CalendarObjectTest.assertEquals((int)12, (int)object.getRecurrenceCalculator());
        CalendarObjectTest.assertFalse((boolean)object.contains(212));
        CalendarObjectTest.assertFalse((boolean)object.containsDays());
        object.setDays(-12);
        CalendarObjectTest.assertTrue((boolean)object.contains(212));
        CalendarObjectTest.assertTrue((boolean)object.containsDays());
        CalendarObjectTest.assertEquals((Object)-12, (Object)object.get(212));
        object.set(212, 12);
        CalendarObjectTest.assertEquals((int)12, (int)object.getDays());
        object.remove(212);
        CalendarObjectTest.assertFalse((boolean)object.contains(212));
        CalendarObjectTest.assertFalse((boolean)object.containsDays());
        CalendarObjectTest.assertFalse((boolean)object.contains(217));
        CalendarObjectTest.assertFalse((boolean)object.containsNotification());
        object.setNotification(false);
        CalendarObjectTest.assertTrue((boolean)object.contains(217));
        CalendarObjectTest.assertTrue((boolean)object.containsNotification());
        CalendarObjectTest.assertEquals((Object)false, (Object)object.get(217));
        object.set(217, true);
        CalendarObjectTest.assertEquals((boolean)true, (boolean)object.getNotification());
        object.remove(217);
        CalendarObjectTest.assertFalse((boolean)object.contains(217));
        CalendarObjectTest.assertFalse((boolean)object.containsNotification());
        CalendarObjectTest.assertFalse((boolean)object.contains(214));
        CalendarObjectTest.assertFalse((boolean)object.containsMonth());
        object.setMonth(-12);
        CalendarObjectTest.assertTrue((boolean)object.contains(214));
        CalendarObjectTest.assertTrue((boolean)object.containsMonth());
        CalendarObjectTest.assertEquals((Object)-12, (Object)object.get(214));
        object.set(214, 12);
        CalendarObjectTest.assertEquals((int)12, (int)object.getMonth());
        object.remove(214);
        CalendarObjectTest.assertFalse((boolean)object.contains(214));
        CalendarObjectTest.assertFalse((boolean)object.containsMonth());
        CalendarObjectTest.assertFalse((boolean)object.contains(222));
        CalendarObjectTest.assertFalse((boolean)object.containsRecurrenceCount());
        object.setRecurrenceCount(-12);
        CalendarObjectTest.assertTrue((boolean)object.contains(222));
        CalendarObjectTest.assertTrue((boolean)object.containsRecurrenceCount());
        CalendarObjectTest.assertEquals((Object)-12, (Object)object.get(222));
        object.set(222, 12);
        CalendarObjectTest.assertEquals((int)12, (int)object.getRecurrenceCount());
        object.remove(222);
        CalendarObjectTest.assertFalse((boolean)object.contains(222));
        CalendarObjectTest.assertFalse((boolean)object.containsRecurrenceCount());
        CalendarObjectTest.assertFalse((boolean)object.contains(213));
        CalendarObjectTest.assertFalse((boolean)object.containsDayInMonth());
        object.setDayInMonth(-12);
        CalendarObjectTest.assertTrue((boolean)object.contains(213));
        CalendarObjectTest.assertTrue((boolean)object.containsDayInMonth());
        CalendarObjectTest.assertEquals((Object)-12, (Object)object.get(213));
        object.set(213, 12);
        CalendarObjectTest.assertEquals((int)12, (int)object.getDayInMonth());
        object.remove(213);
        CalendarObjectTest.assertFalse((boolean)object.contains(213));
        CalendarObjectTest.assertFalse((boolean)object.containsDayInMonth());
        CalendarObjectTest.assertFalse((boolean)object.contains(209));
        CalendarObjectTest.assertFalse((boolean)object.containsRecurrenceType());
        object.setRecurrenceType(-12);
        CalendarObjectTest.assertTrue((boolean)object.contains(209));
        CalendarObjectTest.assertTrue((boolean)object.containsRecurrenceType());
        CalendarObjectTest.assertEquals((Object)-12, (Object)object.get(209));
        object.set(209, 12);
        CalendarObjectTest.assertEquals((int)12, (int)object.getRecurrenceType());
        object.remove(209);
        CalendarObjectTest.assertFalse((boolean)object.contains(209));
        CalendarObjectTest.assertFalse((boolean)object.containsRecurrenceType());
        CalendarObjectTest.assertFalse((boolean)object.contains(201));
        CalendarObjectTest.assertFalse((boolean)object.containsStartDate());
        object.setStartDate(new Date(42L));
        CalendarObjectTest.assertTrue((boolean)object.contains(201));
        CalendarObjectTest.assertTrue((boolean)object.containsStartDate());
        CalendarObjectTest.assertEquals((Object)new Date(42L), (Object)object.get(201));
        object.set(201, new Date(23L));
        CalendarObjectTest.assertEquals((Object)new Date(23L), (Object)object.getStartDate());
        object.remove(201);
        CalendarObjectTest.assertFalse((boolean)object.contains(201));
        CalendarObjectTest.assertFalse((boolean)object.containsStartDate());
        CalendarObjectTest.assertFalse((boolean)object.contains(215));
        CalendarObjectTest.assertFalse((boolean)object.containsInterval());
        object.setInterval(-12);
        CalendarObjectTest.assertTrue((boolean)object.contains(215));
        CalendarObjectTest.assertTrue((boolean)object.containsInterval());
        CalendarObjectTest.assertEquals((Object)-12, (Object)object.get(215));
        object.set(215, 12);
        CalendarObjectTest.assertEquals((int)12, (int)object.getInterval());
        object.remove(215);
        CalendarObjectTest.assertFalse((boolean)object.contains(215));
        CalendarObjectTest.assertFalse((boolean)object.containsInterval());
        CalendarObjectTest.assertFalse((boolean)object.contains(200));
        CalendarObjectTest.assertFalse((boolean)object.containsTitle());
        object.setTitle("Bla");
        CalendarObjectTest.assertTrue((boolean)object.contains(200));
        CalendarObjectTest.assertTrue((boolean)object.containsTitle());
        CalendarObjectTest.assertEquals((Object)"Bla", (Object)object.get(200));
        object.set(200, "Blupp");
        CalendarObjectTest.assertEquals((String)"Blupp", (String)object.getTitle());
        object.remove(200);
        CalendarObjectTest.assertFalse((boolean)object.contains(200));
        CalendarObjectTest.assertFalse((boolean)object.containsTitle());
        CalendarObjectTest.assertFalse((boolean)object.contains(206));
        CalendarObjectTest.assertFalse((boolean)object.containsRecurrenceID());
        object.setRecurrenceID(-12);
        CalendarObjectTest.assertTrue((boolean)object.contains(206));
        CalendarObjectTest.assertTrue((boolean)object.containsRecurrenceID());
        CalendarObjectTest.assertEquals((Object)-12, (Object)object.get(206));
        object.set(206, 12);
        CalendarObjectTest.assertEquals((int)12, (int)object.getRecurrenceID());
        object.remove(206);
        CalendarObjectTest.assertFalse((boolean)object.contains(206));
        CalendarObjectTest.assertFalse((boolean)object.containsRecurrenceID());
        CalendarObjectTest.assertFalse((boolean)object.contains(220));
        CalendarObjectTest.assertFalse((boolean)object.containsParticipants());
        object.setParticipants((Participant[])users);
        CalendarObjectTest.assertTrue((boolean)object.contains(220));
        CalendarObjectTest.assertTrue((boolean)object.containsParticipants());
        CalendarObjectTest.assertEquals((Object)users, (Object)object.get(220));
        object.set(220, otherUsers);
        CalendarObjectTest.assertEquals((Object)otherUsers, (Object)object.getParticipants());
        object.remove(220);
        CalendarObjectTest.assertFalse((boolean)object.contains(220));
        CalendarObjectTest.assertFalse((boolean)object.containsParticipants());
    }

    private static class TestCalendarObject
    extends CalendarObject {
        private TestCalendarObject() {
        }
    }
}

