/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.CalendarTestManager;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Bug44167Test
extends CalDAVTest {
    private CalendarTestManager manager2;
    private FolderObject subfolder;
    private String sharedFolderID;

    @Override
    protected String getDefaultUserAgent() {
        return "iOS/9.1 (13B143) dataaccessd/1.0";
    }

    @Before
    public void setUp() throws Exception {
        this.manager2 = new CalendarTestManager(new AJAXClient(AJAXClient.User.User2));
        this.manager2.setFailOnError(true);
        FolderObject calendarFolder = this.manager2.getClient().execute(new GetRequest((API)EnumAPI.OX_NEW, this.manager2.getPrivateFolder())).getFolder();
        String subFolderName = "testfolder_" + Bug44167Test.randomUID();
        FolderObject folder = new FolderObject();
        folder.setFolderName(subFolderName);
        folder.setParentFolderID(calendarFolder.getObjectID());
        folder.setModule(calendarFolder.getModule());
        folder.setType(calendarFolder.getType());
        OCLPermission perm = new OCLPermission();
        perm.setEntity(this.getClient().getValues().getUserId());
        perm.setGroupPermission(false);
        perm.setAllPermission(8, 4, 0, 0);
        List permissions = calendarFolder.getPermissions();
        permissions.add(perm);
        folder.setPermissions(calendarFolder.getPermissions());
        InsertResponse response = this.manager2.getClient().execute(new InsertRequest((API)EnumAPI.OX_NEW, folder));
        folder.setObjectID(response.getId());
        folder.setLastModified(response.getTimestamp());
        this.subfolder = folder;
        this.sharedFolderID = String.valueOf(folder.getObjectID());
    }

    @After
    public void tearDown() throws Exception {
        if (null != this.manager2) {
            if (null != this.subfolder) {
                this.manager2.getClient().execute(new DeleteRequest((API)EnumAPI.OX_NEW, this.subfolder));
            }
            this.manager2.cleanUp();
            this.manager2.getClient().logout();
        }
    }

    @Test
    public void testAcknowledgeForeignRecurringReminder() throws Exception {
        SyncToken syncToken = new SyncToken(this.fetchSyncToken(this.sharedFolderID));
        String uid = Bug44167Test.randomUID();
        Date start = TimeTools.D("next saturday at 15:30");
        Date end = TimeTools.D("next saturday at 17:15");
        Date initialAcknowledged = TimeTools.D("next saturday at 15:14");
        Appointment appointment = new Appointment();
        appointment.setUid(uid);
        appointment.setTitle("Bug44167Test");
        appointment.setIgnoreConflicts(true);
        appointment.setRecurrenceType(1);
        appointment.setInterval(1);
        appointment.setStartDate(start);
        appointment.setEndDate(end);
        appointment.setParentFolderID(Integer.parseInt(this.sharedFolderID));
        appointment.setAlarm(15);
        appointment.addParticipant((Participant)new UserParticipant(this.manager2.getClient().getValues().getUserId()));
        appointment.addParticipant((Participant)new UserParticipant(new AJAXClient(AJAXClient.User.User3).getValues().getUserId()));
        this.manager2.insert(appointment);
        Map<String, String> eTags = this.syncCollection(syncToken, this.sharedFolderID).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = this.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug44167Test.assertContains(uid, calendarData);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        calendar.setTime(initialAcknowledged);
        calendar.add(5, 1);
        calendar.setTime(initialAcknowledged);
        calendar.add(12, 3);
        calendar.add(13, 17);
        Date acknowledgedDate = calendar.getTime();
        iCalResource.getVEvent().getComponents().clear();
        String iCal = "BEGIN:VALARM\r\nACKNOWLEDGED:" + Bug44167Test.formatAsUTC(acknowledgedDate) + "\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "TRIGGER:-PT15M\r\n" + "UID:F7FCDC9A-BA2A-4548-BC5A-815008F0FC6E\r\n" + "X-WR-ALARMUID:F7FCDC9A-BA2A-4548-BC5A-815008F0FC6E\r\n" + "END:VALARM\r\n";
        SimpleICal.Component vAlarm = SimpleICal.parse(iCal, "VALARM");
        iCalResource.getVEvent().getComponents().add(vAlarm);
        Assert.assertEquals((String)"response code wrong", (long)403L, (long)this.putICalUpdate(iCalResource));
    }
}

