/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;

public class Bug43376Test
extends CalDAVTest {
    @Test
    public void testSnoozeReminderOfOccurrence() throws Exception {
        String uid = Bug43376Test.randomUID();
        Date start = TimeTools.D("next saturday at 15:30");
        Date end = TimeTools.D("next saturday at 17:15");
        Date initialAcknowledged = TimeTools.D("next saturday at 15:14");
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTSTART;TZID=Europe/Berlin:" + Bug43376Test.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + Bug43376Test.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:RecurringReminder\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "RRULE:FREQ=DAILY;INTERVAL=1\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:7B669A77-E205-4B03-A1AF-40FB146C4A3F\r\n" + "UID:7B669A77-E205-4B03-A1AF-40FB146C4A3F\r\n" + "TRIGGER:-PT15M\r\n" + "DESCRIPTION:Ereignisbenachrichtigung\r\n" + "ACTION:DISPLAY\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "UID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        calendar.setTime(start);
        calendar.add(5, 2);
        Date exceptionStart = calendar.getTime();
        calendar.setTime(end);
        calendar.add(5, 2);
        Date exceptionEnd = calendar.getTime();
        calendar.setTime(exceptionStart);
        calendar.add(12, -14);
        calendar.add(13, 17);
        Date acknowledgedDate = calendar.getTime();
        calendar.add(12, 5);
        Date nextTrigger = calendar.getTime();
        calendar.add(12, -1);
        Date nextAcknowledged = calendar.getTime();
        String relatedUID = Bug43376Test.randomUID();
        iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTSTART;TZID=Europe/Berlin:" + Bug43376Test.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + Bug43376Test.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:RecurringReminder\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "RRULE:FREQ=DAILY;INTERVAL=1\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "UID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "X-MOZ-LASTACK:" + Bug43376Test.formatAsUTC(initialAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + Bug43376Test.formatAsUTC(acknowledgedDate) + "\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "UID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug43376Test.format(exceptionStart, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + Bug43376Test.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:RecurringReminder\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "RECURRENCE-ID:" + Bug43376Test.formatAsUTC(exceptionStart) + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + Bug43376Test.randomUID() + "\r\n" + "UID:" + relatedUID + "\r\n" + "TRIGGER:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "ACTION:DISPLAY\r\n" + "ACKNOWLEDGED:" + Bug43376Test.formatAsUTC(acknowledgedDate) + "\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + Bug43376Test.randomUID() + "\r\n" + "UID:" + Bug43376Test.randomUID() + "\r\n" + "TRIGGER;VALUE=DATE-TIME:" + Bug43376Test.formatAsUTC(nextTrigger) + "\r\n" + "DESCRIPTION:Alarm\r\n" + "RELATED-TO:" + relatedUID + "\r\n" + "ACTION:DISPLAY\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + Bug43376Test.randomUID() + "\r\n" + "UID:" + Bug43376Test.randomUID() + "\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        Assert.assertTrue((String)"change exceptions found on server", (null == appointment.getChangeException() || 0 == appointment.getChangeException().length ? 1 : 0) != 0);
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"More than one VEVENT in iCal found", (long)1L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        List<SimpleICal.Component> vAlarms = iCalResource.getVEvent().getVAlarms();
        Assert.assertEquals((String)"Unexpected number of VALARMs found", (long)2L, (long)vAlarms.size());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)vAlarms.get(0).getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)Bug43376Test.formatAsUTC(nextAcknowledged), (Object)vAlarms.get(0).getPropertyValue("ACKNOWLEDGED"));
        Assert.assertNotNull((String)"No RELATED-TO found", (Object)vAlarms.get(1).getProperty("RELATED-TO"));
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT8M43S", (Object)vAlarms.get(1).getPropertyValue("TRIGGER"));
    }

    @Test
    public void testSnoozeReminderOfFurtherOccurrence() throws Exception {
        String uid = Bug43376Test.randomUID();
        Date start = TimeTools.D("next saturday at 15:30");
        Date end = TimeTools.D("next saturday at 17:15");
        Date initialAcknowledged = TimeTools.D("next saturday at 15:14");
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        calendar.setTime(start);
        calendar.add(5, 1);
        Date firstExceptionStart = calendar.getTime();
        calendar.setTime(end);
        calendar.add(5, 1);
        Date firstExceptionEnd = calendar.getTime();
        calendar.setTime(firstExceptionStart);
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTSTART;TZID=Europe/Berlin:" + Bug43376Test.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + Bug43376Test.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:RecurringReminder\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "RRULE:FREQ=DAILY;INTERVAL=1\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:7B669A77-E205-4B03-A1AF-40FB146C4A3F\r\n" + "UID:7B669A77-E205-4B03-A1AF-40FB146C4A3F\r\n" + "TRIGGER:-PT15M\r\n" + "DESCRIPTION:Ereignisbenachrichtigung\r\n" + "ACTION:DISPLAY\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "UID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug43376Test.format(firstExceptionStart, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + Bug43376Test.format(firstExceptionEnd, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:RecurringReminder EDIT\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "RECURRENCE-ID:" + Bug43376Test.formatAsUTC(firstExceptionStart) + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:8B669A77-E205-4B03-A1AF-40FB146C4A3F\r\n" + "UID:8B669A77-E205-4B03-A1AF-40FB146C4A3F\r\n" + "TRIGGER:-PT15M\r\n" + "DESCRIPTION:Ereignisbenachrichtigung\r\n" + "ACTION:DISPLAY\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "UID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        calendar.setTime(start);
        calendar.add(5, 2);
        Date exceptionStart = calendar.getTime();
        calendar.setTime(end);
        calendar.add(5, 2);
        Date exceptionEnd = calendar.getTime();
        calendar.setTime(exceptionStart);
        calendar.add(12, -14);
        calendar.add(13, 17);
        Date acknowledgedDate = calendar.getTime();
        calendar.add(12, 5);
        Date nextTrigger = calendar.getTime();
        calendar.add(12, -1);
        Date nextAcknowledged = calendar.getTime();
        String relatedUID = Bug43376Test.randomUID();
        iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTSTART;TZID=Europe/Berlin:" + Bug43376Test.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + Bug43376Test.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:RecurringReminder\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "RRULE:FREQ=DAILY;INTERVAL=1\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "UID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "X-MOZ-LASTACK:" + Bug43376Test.formatAsUTC(initialAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + Bug43376Test.formatAsUTC(acknowledgedDate) + "\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "UID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug43376Test.format(firstExceptionStart, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + Bug43376Test.format(firstExceptionEnd, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:RecurringReminder EDIT\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "RECURRENCE-ID:" + Bug43376Test.formatAsUTC(firstExceptionStart) + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:8B669A77-E205-4B03-A1AF-40FB146C4A3F\r\n" + "UID:8B669A77-E205-4B03-A1AF-40FB146C4A3F\r\n" + "TRIGGER:-PT15M\r\n" + "DESCRIPTION:Ereignisbenachrichtigung\r\n" + "ACTION:DISPLAY\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "UID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug43376Test.format(exceptionStart, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + Bug43376Test.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:RecurringReminder\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + Bug43376Test.formatAsUTC(new Date()) + "\r\n" + "RECURRENCE-ID:" + Bug43376Test.formatAsUTC(exceptionStart) + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + Bug43376Test.randomUID() + "\r\n" + "UID:" + relatedUID + "\r\n" + "TRIGGER:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "ACTION:DISPLAY\r\n" + "ACKNOWLEDGED:" + Bug43376Test.formatAsUTC(acknowledgedDate) + "\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + Bug43376Test.randomUID() + "\r\n" + "UID:" + Bug43376Test.randomUID() + "\r\n" + "TRIGGER;VALUE=DATE-TIME:" + Bug43376Test.formatAsUTC(nextTrigger) + "\r\n" + "DESCRIPTION:Alarm\r\n" + "RELATED-TO:" + relatedUID + "\r\n" + "ACTION:DISPLAY\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + Bug43376Test.randomUID() + "\r\n" + "UID:" + Bug43376Test.randomUID() + "\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        Assert.assertTrue((String)"additional change exception found on server", (null != appointment.getChangeException() && 1 == appointment.getChangeException().length ? 1 : 0) != 0);
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"More than two VEVENT in iCal found", (long)2L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        List<SimpleICal.Component> vAlarms = iCalResource.getVEvent().getVAlarms();
        Assert.assertEquals((String)"Unexpected number of VALARMs found", (long)2L, (long)vAlarms.size());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)vAlarms.get(0).getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)Bug43376Test.formatAsUTC(nextAcknowledged), (Object)vAlarms.get(0).getPropertyValue("ACKNOWLEDGED"));
        Assert.assertNotNull((String)"No RELATED-TO found", (Object)vAlarms.get(1).getProperty("RELATED-TO"));
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT8M43S", (Object)vAlarms.get(1).getPropertyValue("TRIGGER"));
    }
}

