/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;

public class Bug40657Test
extends CalDAVTest {
    @Test
    public void testApplyToAllFutureOccurrences() throws Exception {
        String uid = Bug40657Test.randomUID();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        Date start = TimeTools.D("next monday at 09:00");
        calendar.setTime(start);
        calendar.add(10, 1);
        Date end = calendar.getTime();
        calendar.setTime(start);
        calendar.add(5, 1);
        Date recurrenceID = calendar.getTime();
        calendar.add(10, 3);
        Date exceptionStart = calendar.getTime();
        calendar.add(10, 1);
        Date exceptionEnd = calendar.getTime();
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nTRANSP:OPAQUE\r\nDTEND;TZID=Europe/Berlin:" + Bug40657Test.format(end, "Europe/Berlin") + "\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + Bug40657Test.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:3\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:test99\r\n" + "LAST-MODIFIED:" + Bug40657Test.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug40657Test.format(start, "Europe/Berlin") + "\r\n" + "CREATED:" + Bug40657Test.formatAsUTC(new Date()) + "\r\n" + "RRULE:FREQ=DAILY;INTERVAL=1\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:DC22FB18-20C8-4BFC-9DB2-87EC952B615E\r\n" + "UID:DC22FB18-20C8-4BFC-9DB2-87EC952B615E\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "CREATED:" + Bug40657Test.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "DTEND;TZID=Europe/Berlin:" + Bug40657Test.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "SUMMARY:test99\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug40657Test.format(exceptionStart, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + Bug40657Test.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:4\r\n" + "RECURRENCE-ID;TZID=Europe/Berlin:" + Bug40657Test.format(recurrenceID, "Europe/Berlin") + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:6125CE9E-F034-4C42-9480-CF8058393F5F\r\n" + "UID:6125CE9E-F034-4C42-9480-CF8058393F5F\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertNull((Object)appointment.getUntil());
        Assert.assertNotNull((Object)appointment.getChangeException());
        Assert.assertEquals((long)1L, (long)appointment.getChangeException().length);
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertEquals((long)2L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((Object)recurrenceID, (Object)iCalResource.getVEvents().get(1).getRecurrenceID());
        Assert.assertNotNull((Object)iCalResource.getVEvent().getProperty("RRULE"));
        Assert.assertFalse((boolean)iCalResource.getVEvent().getProperty("RRULE").getValue().contains("UNTIL"));
        calendar.setTime(start);
        calendar.add(5, 3);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date until = calendar.getTime();
        SimpleICal.Property rRule = iCalResource.getVEvent().getProperty("RRULE");
        iCalResource.getVEvent().setProperty("RRULE", rRule.getValue() + ";UNTIL=" + Bug40657Test.formatAsUTC(until));
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(iCalResource));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertNotNull((Object)appointment.getUntil());
        Assert.assertNotNull((Object)appointment.getChangeException());
        Assert.assertEquals((long)1L, (long)appointment.getChangeException().length);
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertEquals((long)2L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((Object)recurrenceID, (Object)iCalResource.getVEvents().get(1).getRecurrenceID());
        Assert.assertNotNull((Object)iCalResource.getVEvent().getProperty("RRULE"));
        Assert.assertTrue((boolean)iCalResource.getVEvent().getProperty("RRULE").getValue().contains("UNTIL"));
    }
}

