/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.SyncToken;
import com.openexchange.dav.WebDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.dav.caldav.methods.MkCalendarMethod;
import com.openexchange.dav.caldav.reports.CalendarMultiGetReportInfo;
import com.openexchange.dav.reports.SyncCollectionResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.Charsets;
import com.openexchange.test.CalendarTestManager;
import com.openexchange.test.PermissionTools;
import com.openexchange.test.TaskTestManager;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.MoveMethod;
import org.apache.jackrabbit.webdav.client.methods.PutMethod;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.json.JSONException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class CalDAVTest
extends WebDAVTest {
    protected static final int TIMEOUT = 10000;
    private CalendarTestManager testManager = null;
    private TaskTestManager taskTestManager = null;
    private int folderId;
    private final List<FolderObject> createdFolders = new ArrayList<FolderObject>();

    @Parameterized.Parameters(name="AuthMethod={0}")
    public static Iterable<Object[]> params() {
        return CalDAVTest.availableAuthMethods();
    }

    @Before
    public void setUpFixtures() throws Exception {
        this.folderId = this.getAJAXClient().getValues().getPrivateAppointmentFolder();
        this.testManager = new CalendarTestManager(this.getAJAXClient());
        this.testManager.setFailOnError(true);
        this.taskTestManager = new TaskTestManager(this.getAJAXClient());
    }

    @After
    public void cleanUp() throws Exception {
        if (null != this.createdFolders && 0 < this.createdFolders.size()) {
            this.client.execute(new DeleteRequest((API)EnumAPI.OX_NEW, this.createdFolders.toArray(new FolderObject[0])));
        }
        if (null != this.getManager()) {
            this.getManager().cleanUp();
        }
        if (null != this.taskTestManager) {
            this.taskTestManager.cleanUp();
        }
    }

    protected String getDefaultFolderID() {
        return Integer.toString(this.folderId);
    }

    protected FolderObject createFolder(String folderName) throws OXException, IOException, JSONException {
        return this.createFolder(this.getFolder(this.folderId), folderName);
    }

    protected CalendarTestManager getManager() {
        return this.testManager;
    }

    protected TaskTestManager getTaskManager() {
        return this.taskTestManager;
    }

    @Override
    protected String getDefaultUserAgent() {
        return "CalendarStore/5.0.2 (1166); iCal/5.0.2 (1571); Mac OS X/10.7.3 (11D50d)";
    }

    protected void delete(Appointment appointment) {
        this.getManager().delete(appointment);
    }

    @Override
    protected String fetchSyncToken(String folderID) throws Exception {
        return super.fetchSyncToken("/caldav/" + folderID);
    }

    protected String fetchSyncToken() throws Exception {
        return this.fetchSyncToken(this.getDefaultFolderID());
    }

    @Override
    protected SyncCollectionResponse syncCollection(SyncToken syncToken, String folderID) throws Exception {
        return super.syncCollection(syncToken, "/caldav/" + folderID);
    }

    protected SyncCollectionResponse syncCollection(SyncToken syncToken) throws Exception {
        return this.syncCollection(syncToken, this.getDefaultFolderID());
    }

    protected List<ICalResource> calendarMultiget(Collection<String> hrefs) throws Exception {
        return this.calendarMultiget(this.getDefaultFolderID(), hrefs);
    }

    protected List<ICalResource> calendarMultiget(String folderID, Collection<String> hrefs) throws Exception {
        MultiStatusResponse[] responses;
        ArrayList<ICalResource> calendarData = new ArrayList<ICalResource>();
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.GETETAG);
        props.add(PropertyNames.CALENDAR_DATA);
        CalendarMultiGetReportInfo reportInfo = new CalendarMultiGetReportInfo(hrefs.toArray(new String[hrefs.size()]), props);
        for (MultiStatusResponse response : responses = this.getWebDAVClient().doReport(reportInfo, CalDAVTest.getBaseUri() + "/caldav/" + folderID + "/")) {
            if (!response.getProperties(200).contains(PropertyNames.GETETAG)) continue;
            String href = response.getHref();
            Assert.assertNotNull((String)"got no href from response", (Object)href);
            String data = this.extractTextContent(PropertyNames.CALENDAR_DATA, response);
            Assert.assertNotNull((String)"got no address data from response", (Object)data);
            String eTag = this.extractTextContent(PropertyNames.GETETAG, response);
            Assert.assertNotNull((String)"got no etag data from response", (Object)eTag);
            calendarData.add(new ICalResource(data, href, eTag));
        }
        return calendarData;
    }

    protected int putICal(String resourceName, String iCal) throws Exception {
        return this.putICal(this.getDefaultFolderID(), resourceName, iCal);
    }

    protected int putICal(String folderID, String resourceName, String iCal) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("If-None-Match", "*");
        return this.putICal(folderID, resourceName, iCal, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int putICal(String folderID, String resourceName, String iCal, Map<String, String> headers) throws Exception {
        int n;
        PutMethod put = null;
        try {
            String href = "/caldav/" + folderID + "/" + CalDAVTest.urlEncode(resourceName) + ".ics";
            put = new PutMethod(CalDAVTest.getBaseUri() + href);
            for (String key : headers.keySet()) {
                put.addRequestHeader(key, headers.get(key));
            }
            put.setRequestEntity((RequestEntity)new StringRequestEntity(iCal, "text/calendar", null));
            n = this.getWebDAVClient().executeMethod((HttpMethod)put);
        }
        catch (Throwable throwable) {
            CalDAVTest.release(put);
            throw throwable;
        }
        CalDAVTest.release((HttpMethodBase)put);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int move(ICalResource iCalResource, String targetFolderID) throws Exception {
        int n;
        MoveMethod move = null;
        try {
            int status;
            String targetHref = "/caldav/" + targetFolderID + "/" + iCalResource.getHref().substring(1 + iCalResource.getHref().lastIndexOf(47));
            move = new MoveMethod(CalDAVTest.getBaseUri() + iCalResource.getHref(), CalDAVTest.getBaseUri() + targetHref, false);
            if (null != iCalResource.getETag()) {
                move.addRequestHeader("If-Match", iCalResource.getETag());
            }
            if (201 == (status = this.getWebDAVClient().executeMethod((HttpMethod)move))) {
                iCalResource.setHref(targetHref);
            }
            n = status;
        }
        catch (Throwable throwable) {
            CalDAVTest.release(move);
            throw throwable;
        }
        CalDAVTest.release((HttpMethodBase)move);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mkCalendar(String targetResourceName, DavPropertySet setProperties) throws Exception {
        MkCalendarMethod mkCalendar = null;
        try {
            String targetHref = "/caldav/" + targetResourceName + '/';
            mkCalendar = new MkCalendarMethod(CalDAVTest.getBaseUri() + targetHref, setProperties);
            Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.getWebDAVClient().executeMethod((HttpMethod)mkCalendar));
        }
        catch (Throwable throwable) {
            CalDAVTest.release(mkCalendar);
            throw throwable;
        }
        CalDAVTest.release((HttpMethodBase)mkCalendar);
    }

    protected ICalResource get(String resourceName) throws Exception {
        return this.get(this.getDefaultFolderID(), resourceName, null, null);
    }

    protected ICalResource get(String folderID, String resourceName) throws Exception {
        return this.get(folderID, resourceName, null, null);
    }

    protected ICalResource get(String folderID, String resourceName, String ifMatchEtag) throws Exception {
        return this.get(folderID, resourceName, null, ifMatchEtag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICalResource get(String folderID, String resourceName, String ifNoneMatchEtag, String ifMatchEtag) throws Exception {
        ICalResource iCalResource;
        GetMethod get = null;
        try {
            String href = "/caldav/" + folderID + "/" + CalDAVTest.urlEncode(resourceName) + ".ics";
            get = new GetMethod(CalDAVTest.getBaseUri() + href);
            if (null != ifNoneMatchEtag) {
                get.addRequestHeader("If-None-Match", ifNoneMatchEtag);
            }
            if (null != ifMatchEtag) {
                get.addRequestHeader("If-Match", ifMatchEtag);
            }
            Assert.assertEquals((String)"response code wrong", (long)200L, (long)this.getWebDAVClient().executeMethod((HttpMethod)get));
            byte[] responseBody = get.getResponseBody();
            Assert.assertNotNull((String)"got no response body", (Object)responseBody);
            iCalResource = new ICalResource(new String(responseBody, Charsets.UTF_8), href, get.getResponseHeader("ETag").getValue());
        }
        catch (Throwable throwable) {
            CalDAVTest.release(get);
            throw throwable;
        }
        CalDAVTest.release((HttpMethodBase)get);
        return iCalResource;
    }

    private static String urlEncode(String name) throws URISyntaxException {
        return new URI(null, name, null).toString();
    }

    protected int putICalUpdate(String resourceName, String iCal, String ifMatchEtag) throws Exception {
        return this.putICalUpdate(this.getDefaultFolderID(), resourceName, iCal, ifMatchEtag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int putICalUpdate(String folderID, String resourceName, String iCal, String ifMatchEtag) throws Exception {
        int n;
        PutMethod put = null;
        try {
            String href = "/caldav/" + folderID + "/" + CalDAVTest.urlEncode(resourceName) + ".ics";
            put = new PutMethod(CalDAVTest.getBaseUri() + href);
            if (null != ifMatchEtag) {
                put.addRequestHeader("If-Match", ifMatchEtag);
            }
            put.setRequestEntity((RequestEntity)new StringRequestEntity(iCal, "text/calendar", null));
            n = this.getWebDAVClient().executeMethod((HttpMethod)put);
        }
        catch (Throwable throwable) {
            CalDAVTest.release(put);
            throw throwable;
        }
        CalDAVTest.release((HttpMethodBase)put);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int putICalUpdate(ICalResource iCalResource) throws Exception {
        int n;
        PutMethod put = null;
        try {
            put = new PutMethod(CalDAVTest.getBaseUri() + iCalResource.getHref());
            if (null != iCalResource.getETag()) {
                put.addRequestHeader("If-Match", iCalResource.getETag());
            }
            put.setRequestEntity((RequestEntity)new StringRequestEntity(iCalResource.toString(), "text/calendar", null));
            n = this.getWebDAVClient().executeMethod((HttpMethod)put);
        }
        catch (Throwable throwable) {
            CalDAVTest.release(put);
            throw throwable;
        }
        CalDAVTest.release((HttpMethodBase)put);
        return n;
    }

    protected Appointment getAppointment(String folderID, String uid) throws OXException {
        Appointment[] appointments;
        for (Appointment appointment : appointments = this.testManager.all(CalDAVTest.parse(folderID), new Date(0L), new Date(100000000000000L), new int[]{1, 206, 20, 223})) {
            if (!uid.equals(appointment.getUid()) || 0 < appointment.getRecurrenceID() && appointment.getRecurrenceID() != appointment.getObjectID()) continue;
            return this.testManager.get(appointment);
        }
        return null;
    }

    protected List<Appointment> getChangeExcpetions(Appointment appointment) throws OXException {
        List<Appointment> exceptions = this.testManager.getChangeExceptions(appointment.getParentFolderID(), appointment.getObjectID(), new int[]{1, 20, 223});
        if (null != exceptions && 0 < exceptions.size()) {
            for (int i = 0; i < exceptions.size(); ++i) {
                exceptions.set(i, this.testManager.get(exceptions.get(i)));
            }
        }
        return exceptions;
    }

    protected Task getTask(String folderID, String uid) throws OXException {
        Task[] tasks;
        for (Task task : tasks = this.taskTestManager.getAllTasksOnServer(CalDAVTest.parse(folderID), new int[]{1, 20, 223})) {
            if (!uid.equals(task.getUid())) continue;
            return this.taskTestManager.getTaskFromServer(CalDAVTest.parse(folderID), task.getObjectID());
        }
        return null;
    }

    protected void rememberForCleanUp(Appointment appointment) {
        if (null != appointment) {
            this.getManager().getCreatedEntities().add(appointment);
        }
    }

    protected Appointment getAppointment(String uid) throws OXException {
        return this.getAppointment(this.getDefaultFolderID(), uid);
    }

    protected static int parse(String id) {
        return Integer.parseInt(id);
    }

    protected static String format(Date date, TimeZone timeZone) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmm'00'");
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(date);
    }

    protected static String format(Date date, String timeZoneID) {
        return CalDAVTest.format(date, TimeZone.getTimeZone(timeZoneID));
    }

    protected static Appointment generateAppointment(Date start, Date end, String uid, String summary, String location) {
        Appointment appointment = new Appointment();
        appointment.setTitle(summary);
        appointment.setLocation(location);
        appointment.setStartDate(start);
        appointment.setEndDate(end);
        appointment.setUid(uid);
        return appointment;
    }

    protected static String generateICal(Date start, Date end, String uid, String summary, String location) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BEGIN:VCALENDAR").append("\r\n").append("VERSION:2.0").append("\r\n").append("PRODID:-//Apple Inc.//iCal 5.0.2//EN").append("\r\n").append("CALSCALE:GREGORIAN").append("\r\n").append("BEGIN:VTIMEZONE").append("\r\n").append("TZID:Europe/Amsterdam").append("\r\n").append("BEGIN:DAYLIGHT").append("\r\n").append("TZOFFSETFROM:+0100").append("\r\n").append("RRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU").append("\r\n").append("DTSTART:19810329T020000").append("\r\n").append("TZNAME:CEST").append("\r\n").append("TZOFFSETTO:+0200").append("\r\n").append("END:DAYLIGHT").append("\r\n").append("BEGIN:STANDARD").append("\r\n").append("TZOFFSETFROM:+0200").append("\r\n").append("RRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU").append("\r\n").append("DTSTART:19961027T030000").append("\r\n").append("TZNAME:CET").append("\r\n").append("TZOFFSETTO:+0100").append("\r\n").append("END:STANDARD").append("\r\n").append("END:VTIMEZONE").append("\r\n").append("BEGIN:VEVENT").append("\r\n").append("CREATED:").append(CalDAVTest.formatAsUTC(new Date())).append("\r\n");
        if (null != uid) {
            stringBuilder.append("UID:").append(uid).append("\r\n");
        }
        if (null != end) {
            stringBuilder.append("DTEND;TZID=Europe/Amsterdam:").append(CalDAVTest.format(end, "Europe/Amsterdam")).append("\r\n");
        }
        stringBuilder.append("TRANSP:OPAQUE").append("\r\n");
        if (null != summary) {
            stringBuilder.append("SUMMARY:").append(summary).append("\r\n");
        }
        if (null != location) {
            stringBuilder.append("LOCATION:").append(location).append("\r\n");
        }
        if (null != start) {
            stringBuilder.append("DTSTART;TZID=Europe/Amsterdam:").append(CalDAVTest.format(start, "Europe/Amsterdam")).append("\r\n");
        }
        stringBuilder.append("DTSTAMP:").append(CalDAVTest.formatAsUTC(new Date())).append("\r\n").append("SEQUENCE:0").append("\r\n").append("END:VEVENT").append("\r\n").append("END:VCALENDAR").append("\r\n");
        return stringBuilder.toString();
    }

    protected static String generateVTodo(Date start, Date due, String uid, String summary, String location) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BEGIN:VCALENDAR").append("\r\n").append("VERSION:2.0").append("\r\n").append("PRODID:-//Apple Inc.//iCal 5.0.2//EN").append("\r\n").append("CALSCALE:GREGORIAN").append("\r\n").append("BEGIN:VTIMEZONE").append("\r\n").append("TZID:Europe/Amsterdam").append("\r\n").append("BEGIN:DAYLIGHT").append("\r\n").append("TZOFFSETFROM:+0100").append("\r\n").append("RRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU").append("\r\n").append("DTSTART:19810329T020000").append("\r\n").append("TZNAME:CEST").append("\r\n").append("TZOFFSETTO:+0200").append("\r\n").append("END:DAYLIGHT").append("\r\n").append("BEGIN:STANDARD").append("\r\n").append("TZOFFSETFROM:+0200").append("\r\n").append("RRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU").append("\r\n").append("DTSTART:19961027T030000").append("\r\n").append("TZNAME:CET").append("\r\n").append("TZOFFSETTO:+0100").append("\r\n").append("END:STANDARD").append("\r\n").append("END:VTIMEZONE").append("\r\n").append("BEGIN:VTODO").append("\r\n").append("CREATED:").append(CalDAVTest.formatAsUTC(new Date())).append("\r\n");
        if (null != uid) {
            stringBuilder.append("UID:").append(uid).append("\r\n");
        }
        if (null != due) {
            stringBuilder.append("DUE;TZID=Europe/Amsterdam:").append(CalDAVTest.format(due, "Europe/Amsterdam")).append("\r\n");
        }
        stringBuilder.append("TRANSP:OPAQUE").append("\r\n");
        if (null != summary) {
            stringBuilder.append("SUMMARY:").append(summary).append("\r\n");
        }
        if (null != location) {
            stringBuilder.append("LOCATION:").append(location).append("\r\n");
        }
        if (null != start) {
            stringBuilder.append("DTSTART;TZID=Europe/Amsterdam:").append(CalDAVTest.format(start, "Europe/Amsterdam")).append("\r\n");
        }
        stringBuilder.append("DTSTAMP:").append(CalDAVTest.formatAsUTC(new Date())).append("\r\n").append("SEQUENCE:0").append("\r\n").append("END:VTODO").append("\r\n").append("END:VCALENDAR").append("\r\n");
        return stringBuilder.toString();
    }

    public static void assertAppointmentEquals(Appointment appointment, Date expectedStart, Date expectedEnd, String expectedUid, String expectedTitle, String expectedLocation) {
        Assert.assertNotNull((String)"appointment is null", (Object)appointment);
        Assert.assertEquals((String)"start date wrong", (Object)expectedStart, (Object)appointment.getStartDate());
        Assert.assertEquals((String)"end date wrong", (Object)expectedEnd, (Object)appointment.getEndDate());
        Assert.assertEquals((String)"uid wrong", (Object)expectedUid, (Object)appointment.getUid());
        Assert.assertEquals((String)"title wrong", (Object)expectedTitle, (Object)appointment.getTitle());
        Assert.assertEquals((String)"location wrong", (Object)expectedLocation, (Object)appointment.getLocation());
    }

    public static ICalResource assertContains(String uid, Collection<ICalResource> iCalResources) {
        ICalResource match = null;
        for (ICalResource iCalResource : iCalResources) {
            if (!uid.equals(iCalResource.getVEvent().getUID())) continue;
            Assert.assertNull((String)("duplicate match for UID '" + uid + "'"), match);
            match = iCalResource;
        }
        Assert.assertNotNull((String)("no iCal resource with UID '" + uid + "' found"), match);
        return match;
    }

    protected Appointment create(Appointment appointment) {
        return this.create(this.getDefaultFolderID(), appointment);
    }

    protected Appointment create(String folderID, Appointment appointment) {
        appointment.setParentFolderID(CalDAVTest.parse(folderID));
        appointment.setIgnoreConflicts(true);
        return this.getManager().insert(appointment);
    }

    protected Appointment update(Appointment appointment) {
        appointment.setIgnoreConflicts(true);
        this.getManager().update(appointment);
        return appointment;
    }

    protected FolderObject createPublicFolder() throws OXException, IOException, JSONException {
        return this.createPublicFolder(CalDAVTest.randomUID());
    }

    protected FolderObject createPublicFolder(String name) throws OXException, IOException, JSONException {
        FolderObject folder = new FolderObject();
        folder.setModule(2);
        folder.setParentFolderID(2);
        folder.setPermissions(PermissionTools.P(this.client.getValues().getUserId(), "arawada/a"));
        folder.setFolderName(name);
        InsertRequest request = new InsertRequest((API)EnumAPI.OX_NEW, folder);
        InsertResponse response = this.client.execute(request);
        response.fillObject((DataObject)folder);
        folder.setLastModified(new Date());
        this.createdFolders.add(folder);
        return folder;
    }

    protected static void assertDummyAlarm(SimpleICal.Component component) {
        List<SimpleICal.Component> vAlarms = component.getVAlarms();
        Assert.assertEquals((String)"Expected exactly one VAlarm.", (long)1L, (long)vAlarms.size());
        SimpleICal.Component vAlarm = vAlarms.get(0);
        Assert.assertEquals((String)"Expected dummy trigger.", (Object)"19760401T005545Z", (Object)vAlarm.getProperty("TRIGGER").getValue());
        Assert.assertEquals((String)"Expected dummy property.", (Object)"TRUE", (Object)vAlarm.getProperty("X-APPLE-LOCAL-DEFAULT-ALARM").getValue());
        Assert.assertEquals((String)"Expected dummy property.", (Object)"TRUE", (Object)vAlarm.getProperty("X-APPLE-DEFAULT-ALARM").getValue());
    }
}

