/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.TaskTools;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.ajax.task.actions.UpdateResponse;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Task;
import java.util.TimeZone;

public class Bug22305Test
extends AbstractTaskTest {
    private AJAXClient anton;
    private AJAXClient berta;
    private int antonId;
    private int bertaId;
    private TimeZone bertaTZ;
    private Task task;
    private Task bertaTask;

    public Bug22305Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.anton = this.getClient();
        this.antonId = this.anton.getValues().getUserId();
        this.berta = new AJAXClient(AJAXClient.User.User2);
        this.bertaId = this.berta.getValues().getUserId();
        this.bertaTZ = this.berta.getValues().getTimeZone();
        this.task = Create.createWithDefaults(this.getPrivateFolder(), "Task to test for bug 22305");
        this.task.addParticipant((Participant)new UserParticipant(this.antonId));
        this.task.addParticipant((Participant)new UserParticipant(this.bertaId));
        InsertRequest request = new InsertRequest(this.task, this.getTimeZone());
        InsertResponse response = this.anton.execute(request);
        response.fillTask(this.task);
        this.bertaTask = TaskTools.valuesForUpdate(this.task, this.berta.getValues().getPrivateTaskFolder());
        this.bertaTask.addParticipant((Participant)new UserParticipant(this.bertaId));
        UpdateRequest uReq = new UpdateRequest(this.bertaTask, this.bertaTZ);
        UpdateResponse uResp = this.berta.execute(uReq);
        this.task.setLastModified(uResp.getTimestamp());
        this.bertaTask.setLastModified(uResp.getTimestamp());
    }

    @Override
    protected void tearDown() throws Exception {
        DeleteRequest request = new DeleteRequest(this.bertaTask);
        this.berta.execute(request);
        super.tearDown();
    }

    public void testConfirmWithIdOnlyInBody() throws Throwable {
        this.bertaTask = TaskTools.valuesForUpdate(this.bertaTask);
        this.bertaTask.setNote("Update to test for NullPointerException");
        UpdateRequest request = new UpdateRequest(this.bertaTask, this.bertaTZ, false);
        UpdateResponse response = this.berta.execute(request);
        Bug22305Test.assertFalse((boolean)response.hasError());
        this.bertaTask.setLastModified(response.getTimestamp());
    }
}

