/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.subscribe.test;

import com.openexchange.ajax.subscribe.test.AbstractSubscriptionTest;
import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.subscribe.Subscription;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class AllSubscriptionsTest
extends AbstractSubscriptionTest {
    public AllSubscriptionsTest(String name) {
        super(name);
    }

    public void testBasicOXMFAllRequest() throws OXException, IOException, SAXException, JSONException {
        FolderObject folder = this.createDefaultContactFolder();
        DynamicFormDescription formDescription = this.generateFormDescription();
        Subscription subscription = this.generateOXMFSubscription(formDescription);
        subscription.setFolderId(folder.getObjectID());
        this.subMgr.newAction(subscription);
        AllSubscriptionsTest.assertFalse((String)"Precondition: Creation of test file should work", (boolean)this.subMgr.getLastResponse().hasError());
        List<String> columns = Arrays.asList("id", "folder", "source");
        JSONArray all = this.subMgr.allAction(folder.getObjectID(), columns);
        AllSubscriptionsTest.assertFalse((String)"Should be able to handle all request", (boolean)this.subMgr.getLastResponse().hasError());
        AllSubscriptionsTest.assertEquals((String)"Should only have one result", (int)1, (int)all.length());
        JSONArray elements = all.getJSONArray(0);
        AllSubscriptionsTest.assertEquals((String)"Should have three elements", (int)3, (int)elements.length());
        AllSubscriptionsTest.assertEquals((String)"Should return the same ID", (int)subscription.getId(), (int)elements.getInt(0));
        AllSubscriptionsTest.assertEquals((String)"Should return the same folder", (String)subscription.getFolderId(), (String)elements.getString(1));
        AllSubscriptionsTest.assertEquals((String)"Should return the same source ID", (String)subscription.getSource().getId(), (String)elements.getString(2));
    }

    public void testAllRequestForUser() throws OXException, IOException, SAXException, JSONException {
        FolderObject folder = this.createDefaultContactFolder();
        DynamicFormDescription formDescription = this.generateFormDescription();
        Subscription subscription = this.generateOXMFSubscription(formDescription);
        subscription.setFolderId(folder.getObjectID());
        this.subMgr.newAction(subscription);
        AllSubscriptionsTest.assertFalse((String)"Precondition: Creation of test file should work", (boolean)this.subMgr.getLastResponse().hasError());
        List<String> columns = Arrays.asList("id", "folder", "source");
        JSONArray all = this.subMgr.allAction(folder.getObjectID(), columns);
        AllSubscriptionsTest.assertFalse((String)"Should be able to handle all request", (boolean)this.subMgr.getLastResponse().hasError());
        boolean containsSubscription = false;
        for (int i = 0; i < all.length(); ++i) {
            JSONArray actual = all.getJSONArray(i);
            if (actual.getInt(0) != subscription.getId()) continue;
            containsSubscription = true;
            break;
        }
        AllSubscriptionsTest.assertTrue((String)"Subscription is not contained in all request.", (boolean)containsSubscription);
    }
}

