/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.share.actions.ResolveShareResponse;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.modules.Module;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.ShareTarget;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResolveLegacyLinkTest
extends ShareTest {
    public ResolveLegacyLinkTest(String name) {
        super(name);
    }

    public void testOpeningALegacyLinkWorks() throws Exception {
        OCLGuestPermission guestPermission = ResolveLegacyLinkTest.createNamedGuestPermission(ResolveLegacyLinkTest.randomUID() + "@example.com", "Test Guest");
        int module = ResolveLegacyLinkTest.randomModule();
        EnumAPI api = ResolveLegacyLinkTest.randomFolderAPI();
        FolderObject folder = this.insertSharedFolder(ResolveLegacyLinkTest.randomFolderAPI(), module, this.getDefaultFolder(module), guestPermission);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        ResolveLegacyLinkTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        ResolveLegacyLinkTest.checkPermissions(guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        ResolveLegacyLinkTest.checkGuestPermission(guestPermission, guest);
        URI uri = new URI(this.discoverShareURL(guest));
        String path = uri.getPath();
        Matcher m = Pattern.compile("(.*)/share/([a-z0-9]+/)").matcher(path);
        ResolveLegacyLinkTest.assertTrue((boolean)m.find());
        String servletPrefix = m.group(1);
        String baseToken = m.group(2);
        String legacyTarget = String.format("%08x", new ShareTarget(folder.getModule(), Integer.toString(folder.getObjectID())).hashCode());
        String legacyUrl = uri.getScheme() + "://" + uri.getHost() + servletPrefix + "/share/" + baseToken + legacyTarget;
        GuestClient guestClient = this.resolveShare(legacyUrl);
        ResolveShareResponse shareResolveResponse = guestClient.getShareResolveResponse();
        ResolveLegacyLinkTest.assertEquals((int)folder.getModule(), (int)Module.getModuleInteger((String)shareResolveResponse.getModule()));
        ResolveLegacyLinkTest.assertEquals((String)Integer.toString(folder.getObjectID()), (String)shareResolveResponse.getFolder());
        ResolveLegacyLinkTest.assertNull((Object)shareResolveResponse.getItem());
    }
}

