/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.share.actions.FolderShare;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.recipient.RecipientType;
import java.util.List;

public class ListFolderSharesTest
extends ShareTest {
    public ListFolderSharesTest(String name) {
        super(name);
    }

    public void testListSharedFoldersToAnonymous() throws Exception {
        int module = ListFolderSharesTest.randomModule();
        this.testListSharedFolders(ListFolderSharesTest.randomGuestPermission(RecipientType.ANONYMOUS, module), module);
    }

    public void testListSharedFoldersToGuest() throws Exception {
        int module = ListFolderSharesTest.randomModule();
        this.testListSharedFolders(ListFolderSharesTest.randomGuestPermission(RecipientType.GUEST, module), module);
    }

    public void testListSharedFoldersToGroup() throws Exception {
        OCLPermission permission = new OCLPermission(0, 0);
        permission.setAllPermission(4, 4, 4, 4);
        permission.setGroupPermission(true);
        this.testListSharedFolders(permission, ListFolderSharesTest.randomModule());
    }

    public void testListSharedFoldersToUser() throws Exception {
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        int userId = client2.getValues().getUserId();
        client2.logout();
        OCLPermission permission = new OCLPermission(userId, 0);
        permission.setAllPermission(4, 4, 0, 0);
        this.testListSharedFolders(permission, ListFolderSharesTest.randomModule());
    }

    private void testListSharedFolders(OCLPermission permission, int module) throws Exception {
        FolderObject folder = this.insertSharedFolder(EnumAPI.OX_NEW, module, this.getDefaultFolder(module), permission);
        OCLPermission matchingPermission = null;
        for (OCLPermission oclPermission : folder.getPermissions()) {
            if (oclPermission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = oclPermission;
            break;
        }
        ListFolderSharesTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        ListFolderSharesTest.checkPermissions(permission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(EnumAPI.OX_NEW, module, folder.getObjectID(), matchingPermission.getEntity());
        ListFolderSharesTest.checkGuestPermission(permission, guest);
    }

    public void testDontListPublicFolders() throws Exception {
        int module = ListFolderSharesTest.randomModule();
        OCLGuestPermission guestPermission = ListFolderSharesTest.randomGuestPermission(module);
        FolderObject folder = this.insertPublicFolder(EnumAPI.OX_NEW, module);
        folder.addPermission((OCLPermission)guestPermission);
        folder = this.updateFolder(EnumAPI.OX_NEW, folder);
        OCLPermission matchingPermission = null;
        for (OCLPermission oclPermission : folder.getPermissions()) {
            if (oclPermission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = oclPermission;
            break;
        }
        ListFolderSharesTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        ListFolderSharesTest.checkPermissions(guestPermission, matchingPermission);
        FolderShare matchingShare = null;
        List<FolderShare> shares = ListFolderSharesTest.getFolderShares(this.client, EnumAPI.OX_NEW, module);
        for (FolderShare share : shares) {
            if (share.getObjectID() != folder.getObjectID()) continue;
            matchingShare = share;
            break;
        }
        ListFolderSharesTest.assertNull((String)"Share in public folder listed", matchingShare);
    }

    public void testDontListPublicFoldersInSubfolder() throws Exception {
        int module = ListFolderSharesTest.randomModule();
        OCLGuestPermission guestPermission = ListFolderSharesTest.randomGuestPermission(module);
        FolderObject folder = this.insertPublicFolder(EnumAPI.OX_NEW, module);
        FolderObject subfolder = folder.clone();
        subfolder.setParentFolderID(folder.getObjectID());
        subfolder.removeObjectID();
        subfolder.addPermission((OCLPermission)guestPermission);
        subfolder = this.insertFolder(EnumAPI.OX_NEW, subfolder);
        OCLPermission matchingPermission = null;
        for (OCLPermission oclPermission : subfolder.getPermissions()) {
            if (oclPermission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = oclPermission;
            break;
        }
        ListFolderSharesTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        ListFolderSharesTest.checkPermissions(guestPermission, matchingPermission);
        FolderShare matchingShare = null;
        List<FolderShare> shares = ListFolderSharesTest.getFolderShares(this.client, EnumAPI.OX_NEW, module);
        for (FolderShare share : shares) {
            if (share.getObjectID() != subfolder.getObjectID()) continue;
            matchingShare = share;
            break;
        }
        ListFolderSharesTest.assertNull((String)"Share in public folder listed", matchingShare);
    }
}

