/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;

public class CreateSubfolderTest
extends ShareTest {
    public CreateSubfolderTest(String name) {
        super(name);
    }

    public void testCreateSubfolderWithAdminFlagRandomly() throws Exception {
        this.testCreateSubfolderWithAdminFlag(CreateSubfolderTest.randomFolderAPI(), 8);
    }

    public void noTestCreateSubfolderWithAdminFlagExtensively() throws Exception {
        for (EnumAPI api : TESTED_FOLDER_APIS) {
            this.testCreateSubfolderWithAdminFlag(api, 8);
        }
    }

    private void testCreateSubfolderWithAdminFlag(EnumAPI api, int module) throws Exception {
        this.testCreateSubfolderWithAdminFlag(api, module, this.getDefaultFolder(module));
    }

    private void testCreateSubfolderWithAdminFlag(EnumAPI api, int module, int parent) throws Exception {
        OCLGuestPermission guestPermission = CreateSubfolderTest.createNamedAuthorPermission(CreateSubfolderTest.randomUID() + "@example.com", CreateSubfolderTest.randomUID());
        guestPermission.setFolderPermission(8);
        guestPermission.setFolderAdmin(true);
        FolderObject folder = this.insertSharedFolder(api, module, parent, guestPermission);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        CreateSubfolderTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        CreateSubfolderTest.checkPermissions(guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        CreateSubfolderTest.checkGuestPermission(guestPermission, guest);
        GuestClient guestClient = this.resolveShare(guest, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
        String originalName = CreateSubfolderTest.randomUID();
        FolderObject subfolder = new FolderObject();
        subfolder.setFolderName(originalName);
        subfolder.setModule(folder.getModule());
        subfolder.setType(folder.getType());
        subfolder.setParentFolderID(folder.getObjectID());
        subfolder.setPermissionsAsArray(folder.getPermissionsAsArray());
        InsertResponse insertResponse = guestClient.execute(new InsertRequest((API)api, subfolder));
        insertResponse.fillObject((DataObject)subfolder);
        subfolder.setLastModified(insertResponse.getTimestamp());
        FolderObject reloadedSubfolder = this.getFolder(api, subfolder.getObjectID());
        CreateSubfolderTest.assertNotNull((Object)reloadedSubfolder);
        super.remember(reloadedSubfolder);
        CreateSubfolderTest.assertEquals((String)"Folder name wrong", (String)originalName, (String)reloadedSubfolder.getFolderName());
        subfolder.setFolderName(CreateSubfolderTest.randomUID());
        InsertResponse updateResponse = guestClient.execute(new UpdateRequest((API)api, subfolder));
        CreateSubfolderTest.assertFalse((String)"Errors/warnings in response", (updateResponse.hasError() || updateResponse.getResponse().hasWarnings() ? 1 : 0) != 0);
        reloadedSubfolder = this.getFolder(api, subfolder.getObjectID());
        CreateSubfolderTest.assertNotNull((Object)reloadedSubfolder);
        super.remember(reloadedSubfolder);
        CreateSubfolderTest.assertEquals((String)"Folder name wrong", (String)subfolder.getFolderName(), (String)reloadedSubfolder.getFolderName());
        CommonDeleteResponse deleteResponse = guestClient.execute(new DeleteRequest((API)api, subfolder));
        CreateSubfolderTest.assertFalse((String)"Errors/warnings in response", (deleteResponse.hasError() || deleteResponse.getResponse().hasWarnings() ? 1 : 0) != 0);
    }
}

