/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.bugs;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.infostore.actions.GetInfostoreRequest;
import com.openexchange.ajax.infostore.actions.GetInfostoreResponse;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.file.storage.DefaultFileStorageObjectPermission;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;

public class Bug41184Test
extends ShareTest {
    private AJAXClient client2;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.client2) {
            this.client2.logout();
        }
        super.tearDown();
    }

    public Bug41184Test(String name) {
        super(name);
    }

    public void testAccessSharedFileInSharedFolder() throws Exception {
        int userId = this.client2.getValues().getUserId();
        OCLPermission permission = new OCLPermission(userId, 0);
        permission.setAllPermission(4, 4, 0, 0);
        FolderObject folder = this.insertSharedFolder(EnumAPI.OX_NEW, 8, this.getDefaultFolder(8), permission);
        String folderLink = this.discoverInvitationLink(this.client, this.client2.getValues().getDefaultAddress());
        Assert.assertNotNull((String)"Invitation link not found", (Object)folderLink);
        String fragmentParams = new URI(folderLink).getRawFragment();
        Matcher folderMatcher = Pattern.compile("folder=([0-9]+)").matcher(fragmentParams);
        Assert.assertTrue((String)"Folder param missing in fragment", (boolean)folderMatcher.find());
        Assert.assertEquals((Object)String.valueOf(folder.getObjectID()), (Object)folderMatcher.group(1));
        DefaultFileStorageObjectPermission objectPermission = new DefaultFileStorageObjectPermission(userId, false, 1);
        File file = this.insertSharedFile(folder.getObjectID(), (FileStorageObjectPermission)objectPermission);
        String fileLink = this.discoverInvitationLink(this.client, this.client2.getValues().getDefaultAddress());
        Assert.assertNotNull((String)"Invitation link not found", (Object)fileLink);
        fragmentParams = new URI(fileLink).getRawFragment();
        folderMatcher = Pattern.compile("folder=([0-9]+)").matcher(fragmentParams);
        Assert.assertTrue((String)"Folder param missing in fragment", (boolean)folderMatcher.find());
        Assert.assertEquals((Object)"10", (Object)folderMatcher.group(1));
        Matcher fileMatcher = Pattern.compile("id=([0-9]+/[0-9]+)").matcher(fragmentParams);
        Assert.assertTrue((String)"ID param missing in fragment", (boolean)fileMatcher.find());
        FileID fileID = new FileID(file.getId());
        fileID.setFolderId("10");
        Assert.assertEquals((Object)fileID.toUniqueID(), (Object)fileMatcher.group(1));
        GetInfostoreRequest getRequest = new GetInfostoreRequest(fileMatcher.group(1));
        GetInfostoreResponse getResponse = this.client.execute(getRequest);
        File metadata = getResponse.getDocumentMetadata();
        Bug41184Test.assertNotNull((Object)metadata);
        Bug41184Test.assertEquals((String)metadata.getId(), (String)fileMatcher.group(1));
        Bug41184Test.assertEquals((String)metadata.getFolderId(), (String)folderMatcher.group(1));
        getRequest = new GetInfostoreRequest(file.getId());
        getResponse = this.client.execute(getRequest);
        metadata = getResponse.getDocumentMetadata();
        Bug41184Test.assertNotNull((Object)metadata);
        Bug41184Test.assertEquals((String)metadata.getId(), (String)file.getId());
        Bug41184Test.assertEquals((String)metadata.getFolderId(), (String)file.getFolderId());
    }
}

