/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.bugs;

import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreRequest;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreResponse;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFileStorageGuestObjectPermission;
import com.openexchange.file.storage.File;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.share.notification.ShareNotificationService;
import java.util.Collections;

public class Bug40596Test
extends ShareTest {
    public Bug40596Test(String name) {
        super(name);
    }

    public void testBug40596() throws Exception {
        File file = this.insertFile(this.client.getValues().getPrivateInfostoreFolder());
        this.remember(file);
        OCLGuestPermission guestPermission = Bug40596Test.createNamedGuestPermission("testbug40596@example.com", "Bug 40596", "secret");
        DefaultFileStorageGuestObjectPermission objectPermission = (DefaultFileStorageGuestObjectPermission)Bug40596Test.asObjectPermission(guestPermission);
        objectPermission.setPermissions(4);
        file.setObjectPermissions(Collections.singletonList(objectPermission));
        UpdateInfostoreRequest updateInfostoreRequest = new UpdateInfostoreRequest(file, new File.Field[]{File.Field.OBJECT_PERMISSIONS}, file.getLastModified());
        updateInfostoreRequest.setNotifyPermissionEntities(ShareNotificationService.Transport.MAIL);
        updateInfostoreRequest.setFailOnError(false);
        UpdateInfostoreResponse updateInfostoreResponse = this.getClient().execute(updateInfostoreRequest);
        Bug40596Test.assertTrue((boolean)updateInfostoreResponse.hasError());
        OXException e = updateInfostoreResponse.getException();
        Bug40596Test.assertTrue((boolean)InfostoreExceptionCodes.VALIDATION_FAILED_INAPPLICABLE_PERMISSIONS.equals(e));
    }
}

