/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session.actions;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.session.LoginTools;
import com.openexchange.ajax.session.actions.AbstractRequest;
import com.openexchange.ajax.session.actions.TokenLoginJSONParser;
import com.openexchange.ajax.session.actions.TokenLoginJSONResponse;
import com.openexchange.java.util.UUIDs;
import java.util.ArrayList;
import java.util.UUID;

public final class TokenLoginJSONRequest
extends AbstractRequest<TokenLoginJSONResponse> {
    public TokenLoginJSONRequest(String login, String password, String authId, String client, String version, boolean autologin, String clientToken, boolean json) {
        super(TokenLoginJSONRequest.createParameter(login, password, authId, client, version, autologin, clientToken, json, false));
    }

    public TokenLoginJSONRequest(String login, String password, boolean jsonResponse) {
        this(login, password, LoginTools.generateAuthId(), AJAXClient.class.getName(), "7.4.2", true, UUIDs.getUnformattedString((UUID)UUID.randomUUID()), jsonResponse);
    }

    public TokenLoginJSONRequest(String login, String password, boolean jsonResponse, boolean passwordInURL) {
        super(TokenLoginJSONRequest.createParameter(login, password, LoginTools.generateAuthId(), AJAXClient.class.getName(), "7.4.2", true, UUIDs.getUnformattedString((UUID)UUID.randomUUID()), jsonResponse, passwordInURL));
    }

    private static AJAXRequest.Parameter[] createParameter(String login, String password, String authId, String client, String version, boolean autologin, String clientToken, boolean json, boolean passwordInURL) {
        ArrayList<AJAXRequest.Parameter> retval = new ArrayList<AJAXRequest.Parameter>();
        if (passwordInURL) {
            retval.add(new AJAXRequest.URLParameter("password", password));
        }
        retval.add(new AJAXRequest.URLParameter("action", "tokenLogin"));
        retval.add(new AJAXRequest.URLParameter("authId", authId));
        retval.add(new AJAXRequest.FieldParameter("login", login));
        retval.add(new AJAXRequest.FieldParameter("password", password));
        retval.add(new AJAXRequest.FieldParameter("client", client));
        retval.add(new AJAXRequest.FieldParameter("version", version));
        retval.add(new AJAXRequest.FieldParameter("autologin", Boolean.toString(autologin)));
        retval.add(new AJAXRequest.FieldParameter("clientToken", clientToken));
        if (json) {
            retval.add(new AJAXRequest.URLParameter("jsonResponse", true));
        }
        return retval.toArray(new AJAXRequest.Parameter[retval.size()]);
    }

    public TokenLoginJSONParser getParser() {
        return new TokenLoginJSONParser(false);
    }
}

