/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.resource.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.resource.actions.AbstractResourceRequest;
import com.openexchange.ajax.resource.actions.ResourceListResponse;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ResourceListRequest
extends AbstractResourceRequest<ResourceListResponse> {
    private final boolean failOnError;
    private final int[] ids;

    public ResourceListRequest(int[] ids, boolean failOnError) {
        this.ids = ids;
        this.failOnError = failOnError;
    }

    public ResourceListRequest(int[] ids) {
        this(ids, true);
    }

    @Override
    public Object getBody() throws JSONException {
        JSONArray data = new JSONArray();
        for (int id : this.ids) {
            JSONObject jo = new JSONObject();
            jo.put("id", id);
            data.put((Object)jo);
        }
        return data;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        ArrayList<AJAXRequest.Parameter> params = new ArrayList<AJAXRequest.Parameter>();
        params.add(new AJAXRequest.Parameter("action", "list"));
        return params.toArray(new AJAXRequest.Parameter[params.size()]);
    }

    public ResourceListParser getParser() {
        return new ResourceListParser(this.failOnError);
    }

    private static final class ResourceListParser
    extends AbstractAJAXParser<ResourceListResponse> {
        ResourceListParser(boolean failOnError) {
            super(failOnError);
        }

        @Override
        protected ResourceListResponse createResponse(Response response) throws JSONException {
            return new ResourceListResponse(response);
        }
    }
}

