/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.provider;

import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.oauth.provider.IconBytes;
import com.openexchange.ajax.oauth.provider.OAuthClient;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.exception.OXException;
import com.openexchange.oauth.provider.resourceserver.scope.Scope;
import com.openexchange.oauth.provider.rmi.client.ClientDataDto;
import com.openexchange.oauth.provider.rmi.client.ClientDto;
import com.openexchange.oauth.provider.rmi.client.IconDto;
import com.openexchange.oauth.provider.rmi.client.RemoteClientManagement;
import java.rmi.Naming;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractOAuthTest {
    protected ClientDto clientApp;
    protected OAuthClient client;
    protected AJAXClient ajaxClient;
    protected Scope scope;

    protected AbstractOAuthTest(Scope scope) throws OXException {
        AJAXConfig.init();
        this.scope = scope;
    }

    @Before
    public void before() throws Exception {
        this.clientApp = AbstractOAuthTest.registerTestClient();
        if (this.scope == null) {
            this.scope = Scope.parseScope((String)this.clientApp.getDefaultScope());
        }
        this.client = new OAuthClient(AJAXClient.User.User1, this.clientApp.getId(), this.clientApp.getSecret(), (String)this.clientApp.getRedirectURIs().get(0), this.scope);
        this.ajaxClient = new AJAXClient(AJAXClient.User.User1);
    }

    @After
    public void after() throws Exception {
        this.ajaxClient.logout();
        this.client.logout();
        AbstractOAuthTest.unregisterTestClient(this.clientApp);
    }

    public static ClientDto registerTestClient() throws Exception {
        ClientDataDto clientData = AbstractOAuthTest.prepareClient("Test App " + System.currentTimeMillis());
        RemoteClientManagement clientManagement = (RemoteClientManagement)Naming.lookup("rmi://" + AJAXConfig.getProperty(AJAXConfig.Property.RMI_HOST) + ":1099/" + RemoteClientManagement.RMI_NAME);
        return clientManagement.registerClient("default", clientData, AbstractOAuthTest.getMasterAdminCredentials());
    }

    public static ClientDataDto prepareClient(String name) {
        IconDto icon = new IconDto();
        icon.setData(IconBytes.DATA);
        icon.setMimeType("image/jpg");
        ArrayList<String> redirectURIs = new ArrayList<String>(2);
        redirectURIs.add("http://localhost");
        redirectURIs.add("http://localhost:8080");
        ClientDataDto clientData = new ClientDataDto();
        clientData.setName(name);
        clientData.setDescription(name);
        clientData.setIcon(icon);
        clientData.setContactAddress("webmaster@example.com");
        clientData.setWebsite("http://www.example.com");
        clientData.setDefaultScope(Scope.newInstance((String[])new String[]{"read_contacts", "write_contacts", "read_calendar", "write_calendar", "read_tasks", "write_tasks"}).toString());
        clientData.setRedirectURIs(redirectURIs);
        return clientData;
    }

    public static Credentials getMasterAdminCredentials() {
        String username = AJAXConfig.getProperty(AJAXConfig.Property.OX_ADMIN_MASTER);
        String password = AJAXConfig.getProperty(AJAXConfig.Property.OX_ADMIN_MASTER_PWD);
        return new Credentials(username, password);
    }

    public static void unregisterTestClient(ClientDto oAuthClientApp) throws Exception {
        RemoteClientManagement clientManagement = (RemoteClientManagement)Naming.lookup("rmi://" + AJAXConfig.getProperty(AJAXConfig.Property.RMI_HOST) + ":1099/" + RemoteClientManagement.RMI_NAME);
        clientManagement.unregisterClient(oAuthClientApp.getId(), AbstractOAuthTest.getMasterAdminCredentials());
    }
}

