/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mailaccount.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.mailaccount.actions.MailAccountListParser;
import com.openexchange.ajax.mailaccount.actions.MailAccountListResponse;
import org.json.JSONArray;

public class MailAccountListRequest
implements AJAXRequest<MailAccountListResponse> {
    private final boolean failOnError;
    private final int[] ids;
    private final int[] cols;
    private final String columns;
    private final JSONArray idArray;

    public MailAccountListRequest(boolean failOnError, int[] ids, int[] cols) {
        this.failOnError = failOnError;
        this.ids = ids;
        this.cols = cols;
        StringBuilder bob = new StringBuilder();
        for (int colId : cols) {
            bob.append(colId).append(',');
        }
        bob.setLength(bob.length() - 1);
        this.columns = bob.toString();
        this.idArray = new JSONArray();
        for (int id : ids) {
            this.idArray.put(id);
        }
    }

    public MailAccountListRequest(int[] ids, int[] cols) {
        this(true, ids, cols);
    }

    @Override
    public Object getBody() {
        return this.idArray;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "list"), new AJAXRequest.Parameter("columns", this.columns)};
    }

    @Override
    public AbstractAJAXParser<MailAccountListResponse> getParser() {
        return new MailAccountListParser(this.failOnError, this.cols);
    }

    @Override
    public String getServletPath() {
        return "/ajax/account";
    }
}

