/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.AllRequest;
import com.openexchange.ajax.mail.actions.AllResponse;
import com.openexchange.ajax.mail.actions.CopyRequest;
import com.openexchange.ajax.mail.actions.SendRequest;
import com.openexchange.ajax.mail.actions.SendResponse;
import com.openexchange.exception.OXException;
import java.io.IOException;
import javax.mail.internet.AddressException;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class CopyTest
extends AbstractMailTest {
    private static final Logger LOG = LoggerFactory.getLogger(CopyTest.class);
    private String mailObject_25kb;

    public CopyTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
        this.clearFolder(this.getDraftsFolder());
        this.mailObject_25kb = this.createSelfAddressed25KBMailObject().toString();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCopyingOneFolder() throws IOException, SAXException, JSONException, AddressException, OXException {
        String destinationFolderID = this.getDraftsFolder();
        SendResponse sr = this.getClient().execute(new SendRequest(this.mailObject_25kb));
        String mailID = sr.getFolderAndID()[1];
        LOG.info("Sent one mail, id : " + mailID);
        AllResponse allR = Executor.execute(this.getSession(), new AllRequest(this.getInboxFolder(), COLUMNS_DEFAULT_LIST, 0, null, true));
        if (allR.hasError()) {
            CopyTest.fail((String)allR.getException().toString());
        }
        CopyTest.assertEquals((String)"There should be only one message in the source folder", (int)1, (int)allR.getMailMessages(COLUMNS_DEFAULT_LIST).length);
        allR = Executor.execute(this.getSession(), new AllRequest(destinationFolderID, COLUMNS_DEFAULT_LIST, 0, null, true));
        if (allR.hasError()) {
            CopyTest.fail((String)allR.getException().toString());
        }
        CopyTest.assertEquals((String)"There should be no messages in the destination folder", (int)0, (int)allR.getMailMessages(COLUMNS_DEFAULT_LIST).length);
        Executor.execute(this.getSession(), new CopyRequest(mailID, this.getInboxFolder(), destinationFolderID));
        allR = Executor.execute(this.getSession(), new AllRequest(destinationFolderID, COLUMNS_DEFAULT_LIST, 0, null, true));
        if (allR.hasError()) {
            CopyTest.fail((String)allR.getException().toString());
        }
        CopyTest.assertEquals((String)"There should be exactly one message in the destination folder", (int)1, (int)allR.getMailMessages(COLUMNS_DEFAULT_LIST).length);
    }
}

