/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.thirdparty.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.infostore.thirdparty.actions.AbstractFileRequest;
import com.openexchange.ajax.infostore.thirdparty.actions.DeleteFileParser;
import com.openexchange.ajax.infostore.thirdparty.actions.DeleteFileResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeleteFileRequest
extends AbstractFileRequest<DeleteFileResponse> {
    private final String fileId;
    private final String folderId;
    long futureTimestamp;

    public DeleteFileRequest(String fileId, String folderId) {
        super(true);
        this.fileId = fileId;
        this.folderId = folderId;
        Date date = new Date();
        this.futureTimestamp = date.getTime() + 10000L;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        ArrayList<AJAXRequest.Parameter> list = new ArrayList<AJAXRequest.Parameter>();
        list.add(new AJAXRequest.URLParameter("action", "delete"));
        list.add(new AJAXRequest.Parameter("timestamp", this.futureTimestamp));
        return list.toArray(new AJAXRequest.Parameter[list.size()]);
    }

    @Override
    public AbstractAJAXParser<? extends DeleteFileResponse> getParser() {
        return new DeleteFileParser(this.failOnError);
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        JSONArray jsonArr = new JSONArray();
        JSONObject body = new JSONObject();
        body.put("id", (Object)this.fileId);
        body.put("folder", (Object)this.folderId);
        jsonArr.put((Object)body);
        return jsonArr;
    }
}

