/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.ajax.infostore.actions.AllInfostoreRequest;
import com.openexchange.ajax.infostore.actions.GetInfostoreRequest;
import com.openexchange.ajax.infostore.actions.GetInfostoreResponse;
import com.openexchange.ajax.infostore.actions.InfostoreTestManager;
import com.openexchange.ajax.infostore.actions.ListInfostoreRequest;
import com.openexchange.ajax.infostore.actions.ListInfostoreResponse;
import com.openexchange.configuration.MailConfig;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.DefaultFileStorageObjectPermission;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.search.Order;
import com.openexchange.java.util.UUIDs;
import com.openexchange.test.FolderTestManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.json.JSONException;

public class InfostoreObjectPermissionTest
extends AbstractAJAXSession {
    private AJAXClient client2;
    private InfostoreTestManager itm;
    private Map<String, Boolean> shareStates;
    private Map<String, com.openexchange.file.storage.File> allFiles;
    private FolderTestManager ftm;
    private FolderObject testFolder;

    public InfostoreObjectPermissionTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.ftm = new FolderTestManager(this.client);
        String folderName = "InfostoreObjectPermissionTest_" + System.currentTimeMillis();
        this.testFolder = this.ftm.generatePrivateFolder(folderName, 8, this.client.getValues().getPrivateInfostoreFolder(), this.client.getValues().getUserId());
        this.testFolder = this.ftm.insertFolderOnServer(this.testFolder);
        this.allFiles = new HashMap<String, com.openexchange.file.storage.File>();
        this.shareStates = new HashMap<String, Boolean>();
        this.itm = new InfostoreTestManager(this.client);
        this.itm.setFailOnError(true);
        File upload = new File(MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR), "contact_image.png");
        Random r = new Random();
        for (int i = 0; i < 10; ++i) {
            boolean shared = false;
            List<DefaultFileStorageObjectPermission> objectPermissions = null;
            if (r.nextBoolean()) {
                objectPermissions = Collections.singletonList(new DefaultFileStorageObjectPermission(this.client2.getValues().getUserId(), false, 1));
                shared = true;
            }
            com.openexchange.file.storage.File newDocument = this.newDocument(this.testFolder.getObjectID(), objectPermissions);
            this.itm.newAction(newDocument, upload);
            this.allFiles.put(newDocument.getId(), newDocument);
            this.shareStates.put(newDocument.getId(), shared);
        }
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.itm != null) {
            this.itm.cleanUp();
        }
        if (this.ftm != null) {
            this.ftm.cleanUp();
        }
        if (this.client2 != null) {
            this.client2.logout();
        }
        super.tearDown();
    }

    public void testReadPermission() throws Exception {
        AbstractColumnsResponse allResp = this.client2.execute(new AllInfostoreRequest(this.testFolder.getObjectID(), Metadata.columns((Metadata[])Metadata.HTTPAPI_VALUES_ARRAY), 1, Order.ASCENDING, false));
        OXException exception = allResp.getException();
        InfostoreObjectPermissionTest.assertTrue((String)"Expected exception: InfostoreExceptionCodes.NO_READ_PERMISSION", (boolean)InfostoreExceptionCodes.NO_READ_PERMISSION.equals(exception));
        ArrayList<String> sharedFiles = new ArrayList<String>(10);
        ArrayList<String> otherFiles = new ArrayList<String>(10);
        for (Map.Entry<String, Boolean> entry : this.shareStates.entrySet()) {
            if (entry.getValue().booleanValue()) {
                sharedFiles.add(entry.getKey());
                continue;
            }
            otherFiles.add(entry.getKey());
        }
        ArrayList<ListInfostoreRequest.ListItem> listItems = new ArrayList<ListInfostoreRequest.ListItem>(sharedFiles.size());
        for (String id : sharedFiles) {
            listItems.add(new ListInfostoreRequest.ListItem(Integer.toString(this.testFolder.getObjectID()), id.toString()));
        }
        ListInfostoreResponse listResp = this.client2.execute(new ListInfostoreRequest(listItems, Metadata.columns((Metadata[])Metadata.HTTPAPI_VALUES_ARRAY), false));
        exception = listResp.getException();
        InfostoreObjectPermissionTest.assertNotNull((Object)((Object)exception));
        listItems.clear();
        for (String id : sharedFiles) {
            GetInfostoreResponse getResp = this.client2.execute(new GetInfostoreRequest(id));
            com.openexchange.file.storage.File doc = getResp.getDocumentMetadata();
            InfostoreObjectPermissionTest.assertNotNull((Object)doc);
            InfostoreObjectPermissionTest.assertEquals((int)10, (int)Integer.valueOf(doc.getFolderId()));
            InfostoreObjectPermissionTest.assertEquals((String)id, (String)doc.getId());
            listItems.add(new ListInfostoreRequest.ListItem(Integer.toString(10), id.toString()));
        }
        listResp = this.client2.execute(new ListInfostoreRequest(listItems, Metadata.columns((Metadata[])Metadata.HTTPAPI_VALUES_ARRAY)));
        Object[][] array = listResp.getArray();
        for (int i = 0; i < array.length; ++i) {
            Object[] doc = array[i];
            InfostoreObjectPermissionTest.assertEquals((int)10, (int)Integer.parseInt((String)doc[listResp.getColumnPos(20)]));
            InfostoreObjectPermissionTest.assertEquals((String)((ListInfostoreRequest.ListItem)listItems.get(i)).getId(), (String)doc[listResp.getColumnPos(1)].toString());
        }
        allResp = this.client2.execute(new AllInfostoreRequest(10, Metadata.columns((Metadata[])Metadata.HTTPAPI_VALUES_ARRAY), 1, Order.ASCENDING));
        HashSet foundIds = new HashSet(sharedFiles);
        for (Object[] doc : allResp.getArray()) {
            int docId = Integer.parseInt((String)doc[allResp.getColumnPos(1)]);
            foundIds.remove(docId);
        }
        InfostoreObjectPermissionTest.assertTrue((String)"Not all shared documents have been found", (boolean)foundIds.isEmpty());
        listItems.clear();
        for (String id : otherFiles) {
            GetInfostoreRequest req = new GetInfostoreRequest(id);
            req.setFailOnError(false);
            GetInfostoreResponse getResp = this.client2.execute(req);
            OXException exception2 = getResp.getException();
            InfostoreObjectPermissionTest.assertNotNull((Object)((Object)exception2));
            listItems.add(new ListInfostoreRequest.ListItem(this.allFiles.get(id)));
        }
        listResp = this.client2.execute(new ListInfostoreRequest(listItems, Metadata.columns((Metadata[])Metadata.HTTPAPI_VALUES_ARRAY), false));
        exception = listResp.getException();
        InfostoreObjectPermissionTest.assertNotNull((Object)((Object)exception));
        allResp = this.client.execute(new AllInfostoreRequest(10, Metadata.columns((Metadata[])Metadata.HTTPAPI_VALUES_ARRAY), 1, Order.ASCENDING));
        for (Object[] doc : allResp.getArray()) {
            int docId = Integer.parseInt((String)doc[allResp.getColumnPos(1)]);
            InfostoreObjectPermissionTest.assertFalse((boolean)this.allFiles.containsKey(docId));
        }
        listItems.clear();
        for (String id : this.allFiles.keySet()) {
            listItems.add(new ListInfostoreRequest.ListItem(Integer.toString(10), id.toString()));
        }
        listResp = this.client.execute(new ListInfostoreRequest(listItems, Metadata.columns((Metadata[])Metadata.HTTPAPI_VALUES_ARRAY)));
        for (Object[] doc : listResp.getArray()) {
            int docId = Integer.parseInt((String)doc[allResp.getColumnPos(1)]);
            InfostoreObjectPermissionTest.assertFalse((boolean)this.allFiles.containsKey(docId));
        }
    }

    private com.openexchange.file.storage.File newDocument(int folderId, List<FileStorageObjectPermission> objectPermissions) throws OXException, IOException, JSONException {
        DefaultFile doc = new DefaultFile();
        doc.setTitle(UUIDs.getUnformattedString((UUID)UUID.randomUUID()));
        doc.setDescription("Infostore Item Description");
        doc.setFileMIMEType("image/png");
        doc.setFolderId(String.valueOf(folderId));
        doc.setObjectPermissions(objectPermissions);
        doc.setFileName("contact_image.png");
        return doc;
    }
}

