/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.importexport.AbstractImportExportServletTest;
import com.openexchange.importexport.formats.Format;
import com.openexchange.test.OXTestToolkit;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class VCardImportExportServletTest
extends AbstractImportExportServletTest {
    private int folderId;

    public VCardImportExportServletTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.folderId = this.createFolder("vcard-contact-roundtrip-" + System.currentTimeMillis(), 3);
    }

    public void testVCardRoundtrip() throws Exception {
        InputStream is = new ByteArrayInputStream(this.IMPORT_VCARD.getBytes());
        WebConversation webconv = this.getWebConversation();
        PostMethodWebRequest req = new PostMethodWebRequest(this.getUrl(this.IMPORT_SERVLET, this.folderId, Format.VCARD), true);
        req.selectFile("file", "contact.vcf", is, Format.VCARD.getMimeType());
        WebResponse webRes = webconv.getResource((WebRequest)req);
        VCardImportExportServletTest.extractFromCallback(webRes.getText());
        webconv = this.getWebConversation();
        req = new GetMethodWebRequest(this.getUrl(this.EXPORT_SERVLET, this.folderId, Format.VCARD));
        webRes = webconv.sendRequest((WebRequest)req);
        is = webRes.getInputStream();
        String resultingVCard = OXTestToolkit.readStreamAsString(is);
        String[] result = resultingVCard.split("\n");
        block0: for (Map.Entry element : this.VCARD_ELEMENTS.entrySet()) {
            VCardImportExportServletTest.assertTrue((String)("Missing element: " + (String)element.getKey()), (boolean)resultingVCard.contains((CharSequence)element.getKey()));
            for (String r : result) {
                if (!r.startsWith((String)element.getKey())) continue;
                VCardImportExportServletTest.assertTrue((String)("Missing value " + (String)element.getValue()), (boolean)r.contains((CharSequence)element.getValue()));
                continue block0;
            }
        }
    }

    public void testMultiVCardRoundtrip() throws Exception {
        InputStream is = new ByteArrayInputStream((this.IMPORT_VCARD + this.IMPORT_VCARD_2).getBytes());
        WebConversation webconv = this.getWebConversation();
        PostMethodWebRequest req = new PostMethodWebRequest(this.getUrl(this.IMPORT_SERVLET, this.folderId, Format.VCARD), true);
        req.selectFile("file", "contact.vcf", is, Format.VCARD.getMimeType());
        WebResponse webRes = webconv.getResource((WebRequest)req);
        VCardImportExportServletTest.extractFromCallback(webRes.getText());
        webconv = this.getWebConversation();
        req = new GetMethodWebRequest(this.getUrl(this.EXPORT_SERVLET, this.folderId, Format.VCARD));
        webRes = webconv.sendRequest((WebRequest)req);
        is = webRes.getInputStream();
        String resultingVCard = OXTestToolkit.readStreamAsString(is);
        System.out.println(resultingVCard);
        String[] resultingVCards = resultingVCard.split("END:VCARD\\r?\\nBEGIN:VCARD");
        VCardImportExportServletTest.assertEquals((String)"Expected two vCards.", (int)2, (int)resultingVCards.length);
        String[] result0 = resultingVCards[0].split("\n");
        String[] result1 = resultingVCards[1].split("\n");
        block0: for (Map.Entry element : this.VCARD_ELEMENTS.entrySet()) {
            VCardImportExportServletTest.assertTrue((String)("Missing element: " + (String)element.getKey()), (boolean)resultingVCard.contains((CharSequence)element.getKey()));
            for (String r : result0) {
                if (!r.startsWith((String)element.getKey())) continue;
                VCardImportExportServletTest.assertTrue((String)("Missing value " + (String)element.getValue()), (boolean)r.contains((CharSequence)element.getValue()));
                continue block0;
            }
        }
        block2: for (Map.Entry element : this.VCARD_ELEMENTS_2.entrySet()) {
            VCardImportExportServletTest.assertTrue((String)("Missing element: " + (String)element.getKey()), (boolean)resultingVCard.contains((CharSequence)element.getKey()));
            for (String r : result1) {
                if (!r.startsWith((String)element.getKey())) continue;
                VCardImportExportServletTest.assertTrue((String)("Missing value " + (String)element.getValue()), (boolean)r.contains((CharSequence)element.getValue()));
                continue block2;
            }
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.removeFolder(this.folderId);
        super.tearDown();
    }
}

