/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.importexport.actions.CSVImportRequest;
import com.openexchange.ajax.importexport.actions.CSVImportResponse;
import com.openexchange.ajax.importexport.actions.VCardImportRequest;
import com.openexchange.ajax.importexport.actions.VCardImportResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.java.Charsets;
import com.openexchange.java.util.UUIDs;
import java.io.ByteArrayInputStream;
import org.json.JSONArray;
import org.json.JSONObject;

public class Bug36943Test
extends AbstractManagedContactTest {
    public Bug36943Test(String name) {
        super(name);
    }

    public void testImportCSVWithAstralSymbols() throws Exception {
        String lastName = "Pile of \ud83d\udca9 poo";
        String csv = "\"Sur name\",\"Given name\",\"Email 1\"\n\"" + lastName + "\",\"Otto\",\"otto@example.com\"\n";
        CSVImportRequest request = new CSVImportRequest(this.folderID, new ByteArrayInputStream(csv.getBytes("UTF-8")), false, new AJAXRequest.Parameter("charset", "UTF-8"));
        CSVImportResponse response = this.getClient().execute(request);
        Bug36943Test.assertFalse((String)"response has error", (boolean)response.hasError());
        JSONArray data = (JSONArray)response.getData();
        Bug36943Test.assertNotNull((String)"got no data", (Object)data);
        Bug36943Test.assertEquals((int)1, (int)data.length());
        Contact contact = this.manager.getAction(this.folderID, data.getJSONObject(0).getInt("id"));
        Bug36943Test.assertNotNull((String)"imported contact not found", (Object)contact);
        Bug36943Test.assertNotNull((String)"no last name imported", (Object)contact.getSurName());
        String expectedLastName = lastName.replaceAll("\ud83d\udca9", "");
        Bug36943Test.assertEquals((String)"wrong last name imported", (String)expectedLastName, (String)contact.getSurName());
    }

    public void testImportVCardWithAstralSymbols() throws Exception {
        String uid = UUIDs.getUnformattedStringFromRandom();
        String firstName = "Pile of \ud83d\udca9 poo";
        String lastName = "test";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:" + lastName + ";" + firstName + ";;;" + "\r\n" + "FN:" + firstName + " " + lastName + "\r\n" + "UID:" + uid + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.0//EN" + "\r\n" + "END:VCARD" + "\r\n";
        VCardImportRequest importRequest = new VCardImportRequest(this.folderID, new ByteArrayInputStream(vCard.getBytes(Charsets.UTF_8)));
        VCardImportResponse importResponse = this.getClient().execute(importRequest);
        JSONArray data = (JSONArray)importResponse.getData();
        Bug36943Test.assertTrue((String)"got no data from import request", (null != data && 0 < data.length() ? 1 : 0) != 0);
        JSONObject jsonObject = data.getJSONObject(0);
        Bug36943Test.assertNotNull((String)"got no data from import request", (Object)jsonObject);
        int objectID = jsonObject.optInt("id");
        Bug36943Test.assertTrue((String)"got no object id from import request", (0 < objectID ? 1 : 0) != 0);
        Contact contact = this.manager.getAction(this.folderID, objectID);
        Bug36943Test.assertNotNull((String)"imported contact not found", (Object)contact);
        Bug36943Test.assertNotNull((String)"no last name imported", (Object)contact.getSurName());
        String expectedLastName = lastName.replaceAll("\ud83d\udca9", "");
        Bug36943Test.assertEquals((String)"wrong last name imported", (String)expectedLastName, (String)contact.getSurName());
    }
}

