/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.config;

import com.openexchange.ajax.config.actions.GetRequest;
import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.SetResponse;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.java.Autoboxing;
import com.openexchange.tools.RandomString;
import java.util.Random;

public class BugTests
extends AbstractAJAXSession {
    private AJAXClient client;
    private Random rand;

    public BugTests(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.rand = new Random(System.currentTimeMillis());
    }

    public void testBug5607() throws Throwable {
        String drafts = this.client.execute(new GetRequest(Tree.DraftsFolder)).getString();
        BugTests.assertNotNull((String)"Can't get drafts folder.", (Object)drafts);
        String sent = this.client.execute(new GetRequest(Tree.SentFolder)).getString();
        BugTests.assertNotNull((String)"Can't get sent folder.", (Object)sent);
        String spam = this.client.execute(new GetRequest(Tree.SpamFolder)).getString();
        BugTests.assertNotNull((String)"Can't get spam folder.", (Object)spam);
        String trash = this.client.execute(new GetRequest(Tree.TrashFolder)).getString();
        BugTests.assertNotNull((String)"Can't get trash folder.", (Object)trash);
    }

    public void testBug6462() throws Throwable {
        for (Tree tree : new Tree[]{Tree.CalendarNotification, Tree.TaskNotification}) {
            boolean origValue = this.client.execute(new GetRequest(tree)).getBoolean();
            for (boolean test : new boolean[]{true, false}) {
                this.client.execute(new SetRequest(tree, Boolean.toString(test)));
                boolean testValue = this.client.execute(new GetRequest(tree)).getBoolean();
                BugTests.assertEquals((String)"Setting calendar/task notification failed.", (boolean)test, (boolean)testValue);
            }
            this.client.execute(new SetRequest(tree, Autoboxing.B((boolean)origValue)));
            boolean testValue = this.client.execute(new GetRequest(tree)).getBoolean();
            BugTests.assertEquals((String)"Restoring original value failed.", (boolean)origValue, (boolean)testValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteSenderAddress() throws Throwable {
        String origAddress = this.client.execute(new GetRequest(Tree.SendAddress)).getString();
        try {
            String garbage;
            while ((garbage = RandomString.generateLetter(20)).equals(origAddress)) {
            }
            SetResponse response = this.client.execute(new SetRequest(Tree.SendAddress, garbage, false));
            if (!response.hasError()) {
                BugTests.fail((String)"SendAddress in config tree can be written with garbage.");
            }
        }
        finally {
            this.client.execute(new SetRequest(Tree.SendAddress, origAddress));
        }
    }
}

