/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.attach.actions;

import com.openexchange.ajax.attach.AttachmentTools;
import com.openexchange.ajax.attach.actions.AbstractAttachmentRequest;
import com.openexchange.ajax.attach.actions.ListParser;
import com.openexchange.ajax.attach.actions.ListResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.groupware.container.CommonObject;
import java.util.ArrayList;
import java.util.TimeZone;
import org.json.JSONArray;

public final class ListRequest
extends AbstractAttachmentRequest<ListResponse> {
    private CommonObject object;
    private int[] attachmentIds;
    private int[] columns;
    private TimeZone timezone;

    public ListRequest(CommonObject object, int[] attachmentIds, int[] columns, TimeZone timezone) {
        this.object = object;
        this.attachmentIds = attachmentIds;
        this.columns = columns;
        this.timezone = timezone;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        ArrayList<AJAXRequest.Parameter> params = new ArrayList<AJAXRequest.Parameter>();
        params.add(new AJAXRequest.URLParameter("action", "list"));
        params.add(new AJAXRequest.URLParameter("attached", this.object.getObjectID()));
        params.add(new AJAXRequest.URLParameter("folder", this.object.getParentFolderID()));
        params.add(new AJAXRequest.URLParameter("module", AttachmentTools.determineModule(this.object)));
        params.add(new AJAXRequest.URLParameter("columns", this.columns));
        if (null != this.timezone) {
            params.add(new AJAXRequest.Parameter("timezone", this.timezone.getID()));
        }
        return params.toArray(new AJAXRequest.Parameter[params.size()]);
    }

    public ListParser getParser() {
        return new ListParser(this.columns);
    }

    @Override
    public Object getBody() {
        JSONArray array = new JSONArray();
        for (int attachmentId : this.attachmentIds) {
            array.put(attachmentId);
        }
        return array.toString();
    }
}

