/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.SearchRequest;
import com.openexchange.ajax.appointment.action.SearchResponse;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.server.impl.OCLPermission;
import java.util.Date;
import org.json.JSONArray;

public class Bug18558Test
extends AbstractAJAXSession {
    private AJAXClient clientA;
    private AJAXClient clientB;
    private AJAXClient clientC;
    private AJAXClient clientD;
    private Appointment appointment;

    public Bug18558Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.clientA = this.getClient();
        this.clientB = new AJAXClient(AJAXClient.User.User2);
        this.clientC = new AJAXClient(AJAXClient.User.User3);
        this.clientD = new AJAXClient(AJAXClient.User.User4);
        FolderObject folderA = new FolderObject();
        folderA.setObjectID(this.clientA.getValues().getPrivateAppointmentFolder());
        folderA.setLastModified(new Date(Long.MAX_VALUE));
        folderA.setPermissionsAsArray(new OCLPermission[]{Create.ocl(this.clientA.getValues().getUserId(), false, true, 128, 128, 128, 128), Create.ocl(this.clientD.getValues().getUserId(), false, false, 128, 128, 128, 128)});
        CommonInsertResponse response = this.clientA.execute(new UpdateRequest((API)EnumAPI.OX_OLD, folderA));
        response.fillObject((DataObject)folderA);
        FolderObject folderB = new FolderObject();
        folderB.setObjectID(this.clientB.getValues().getPrivateAppointmentFolder());
        folderB.setLastModified(new Date(Long.MAX_VALUE));
        folderB.setPermissionsAsArray(new OCLPermission[]{Create.ocl(this.clientB.getValues().getUserId(), false, true, 128, 128, 128, 128), Create.ocl(this.clientD.getValues().getUserId(), false, false, 128, 128, 128, 128)});
        response = this.clientB.execute(new UpdateRequest((API)EnumAPI.OX_OLD, folderB));
        response.fillObject((DataObject)folderB);
        this.appointment = new Appointment();
        this.appointment.setTitle("Bug18558Test" + System.currentTimeMillis());
        this.appointment.setStartDate(TimeTools.D("01.04.2011 08:00"));
        this.appointment.setEndDate(TimeTools.D("01.04.2011 09:00"));
        this.appointment.setParentFolderID(this.clientC.getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setUsers(new UserParticipant[]{new UserParticipant(this.clientA.getValues().getUserId()), new UserParticipant(this.clientB.getValues().getUserId())});
        this.appointment.setParticipants(new Participant[]{new UserParticipant(this.clientA.getValues().getUserId()), new UserParticipant(this.clientB.getValues().getUserId())});
        InsertRequest insertRequest = new InsertRequest(this.appointment, this.clientC.getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.clientC.execute(insertRequest);
        insertResponse.fillObject((DataObject)this.appointment);
    }

    public void testBug18558Test() throws Exception {
        SearchRequest search = new SearchRequest(this.appointment.getTitle(), -1, new int[]{1, 20, 200, 221, 220});
        SearchResponse searchResponse = this.clientD.execute(search);
        JSONArray jsonArray = (JSONArray)searchResponse.getResponse().getData();
        boolean foundA = false;
        boolean foundB = false;
        Bug18558Test.assertEquals((String)"Expected appointment exactly twice.", (int)2, (int)jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONArray result = jsonArray.getJSONArray(i);
            if (result.getInt(0) != this.appointment.getObjectID()) continue;
            if (result.getInt(1) == this.clientA.getValues().getPrivateAppointmentFolder()) {
                foundA = true;
            }
            if (result.getInt(1) == this.clientB.getValues().getPrivateAppointmentFolder()) {
                foundB = true;
            }
            Bug18558Test.assertEquals((String)"Expected 3 Users.", (int)3, (int)result.getJSONArray(3).length());
            Bug18558Test.assertEquals((String)"Expected 3 Participants.", (int)3, (int)result.getJSONArray(4).length());
            this.checkGet(this.appointment.getObjectID(), result.getInt(1));
        }
        Bug18558Test.assertTrue((String)"Did not find appointment in folder of first user.", (boolean)foundA);
        Bug18558Test.assertTrue((String)"Did not find appointment in folder of second user.", (boolean)foundB);
    }

    private void checkGet(int objectId, int folderId) throws Exception {
        GetRequest getRequest = new GetRequest(folderId, objectId);
        GetResponse getResponse = this.clientD.execute(getRequest);
        Bug18558Test.assertFalse((String)"No error expected.", (boolean)getResponse.hasError());
    }

    @Override
    public void tearDown() throws Exception {
        this.appointment.setLastModified(new Date(Long.MAX_VALUE));
        if (this.appointment.getObjectID() > 0) {
            this.clientC.execute(new DeleteRequest(this.appointment));
        }
        super.tearDown();
    }
}

