/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user;

import com.openexchange.user.UserServiceInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class UserServiceInterceptorRegistry
implements ServiceTrackerCustomizer<UserServiceInterceptor, UserServiceInterceptor> {
    private final List<UserServiceInterceptor> interceptors;
    private final Comparator<UserServiceInterceptor> comparator;
    private final BundleContext context;

    public UserServiceInterceptorRegistry(BundleContext context) {
        this.context = context;
        this.interceptors = new LinkedList<UserServiceInterceptor>();
        this.comparator = new Comparator<UserServiceInterceptor>(){

            @Override
            public int compare(UserServiceInterceptor s1, UserServiceInterceptor s2) {
                return s2.getRanking() - s1.getRanking();
            }
        };
    }

    public UserServiceInterceptor addingService(ServiceReference<UserServiceInterceptor> reference) {
        UserServiceInterceptor service = (UserServiceInterceptor)this.context.getService(reference);
        this.addInterceptor(service);
        return service;
    }

    public void modifiedService(ServiceReference<UserServiceInterceptor> reference, UserServiceInterceptor service) {
    }

    public void removedService(ServiceReference<UserServiceInterceptor> reference, UserServiceInterceptor service) {
        this.removeInterceptor(service);
        this.context.ungetService(reference);
    }

    public synchronized List<UserServiceInterceptor> getInterceptors() {
        return new ArrayList<UserServiceInterceptor>(this.interceptors);
    }

    synchronized void addInterceptor(UserServiceInterceptor interceptor) {
        this.interceptors.add(interceptor);
        Collections.sort(this.interceptors, this.comparator);
    }

    synchronized void removeInterceptor(UserServiceInterceptor interceptor) {
        this.interceptors.remove(interceptor);
    }
}

