/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet.ratelimit.impl;

import com.google.common.util.concurrent.RateLimiter;
import com.openexchange.tools.servlet.ratelimit.Rate;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class GoogleRate
implements Rate {
    private final AtomicLong lastLogStamp;
    private final AtomicLong lastAccessTime;
    private volatile RateLimiter googleRateLimiter;
    private volatile boolean deprecated;
    private final int permits;
    private volatile long millis;

    public GoogleRate(int numberCalls, int timeLength, TimeUnit timeUnit) {
        this.permits = numberCalls;
        this.millis = TimeUnit.SECONDS.convert(timeLength, timeUnit);
        double rate = (double)numberCalls / (double)this.millis;
        this.googleRateLimiter = RateLimiter.create((double)rate);
        this.lastLogStamp = new AtomicLong(0L);
        this.lastAccessTime = new AtomicLong(Long.MIN_VALUE);
        this.deprecated = false;
    }

    @Override
    public AtomicLong getLastLogStamp() {
        return this.lastLogStamp;
    }

    @Override
    public long lastAccessTime() {
        return this.lastAccessTime.get();
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markDeprecatedIfElapsed(long threshold) {
        RateLimiter rateLimiter = this.googleRateLimiter;
        synchronized (rateLimiter) {
            if (this.lastAccessTime.get() > threshold) {
                return false;
            }
            this.deprecated = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rate.Result consume(long now) {
        RateLimiter rateLimiter = this.googleRateLimiter;
        synchronized (rateLimiter) {
            this.lastAccessTime.set(now);
            if (this.deprecated) {
                return Rate.Result.DEPRECATED;
            }
        }
        boolean permitted = this.googleRateLimiter.tryAcquire(1);
        return permitted ? Rate.Result.SUCCESS : Rate.Result.FAILED;
    }

    @Override
    public void setTimeInMillis(long timeInMillis) {
        this.millis = timeInMillis;
        double rate = (double)this.permits / (double)timeInMillis;
        this.googleRateLimiter = RateLimiter.create((double)rate);
    }

    @Override
    public int getPermits() {
        return this.permits;
    }

    @Override
    public long getTimeInMillis() {
        return this.millis;
    }
}

