/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.cache.impl.FolderQueryCacheManager;
import com.openexchange.config.ConfigurationService;
import com.openexchange.contact.ContactService;
import com.openexchange.database.Databases;
import com.openexchange.database.IncorrectStringSQLException;
import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.StaticDBPoolProvider;
import com.openexchange.event.impl.EventClient;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionConstants;
import com.openexchange.folder.FolderDeleteListenerService;
import com.openexchange.folder.internal.FolderDeleteListenerRegistry;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.cache.CacheFolderStorage;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarCache;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.database.impl.versioncontrol.VersionControlResult;
import com.openexchange.groupware.infostore.database.impl.versioncontrol.VersionControlUtil;
import com.openexchange.groupware.infostore.facade.impl.EventFiringInfostoreFacadeImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tasks.Tasks;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Charsets;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.preferences.ServerUserSetting;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.arrays.Arrays;
import com.openexchange.tools.exceptions.SimpleIncorrectStringAttribute;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderDependentDeleter;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import com.openexchange.tools.oxfolder.OXFolderUtility;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMapManagement;
import com.openexchange.tools.oxfolder.treeconsistency.CheckPermissionOnInsert;
import com.openexchange.tools.oxfolder.treeconsistency.CheckPermissionOnRemove;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OXFolderManagerImpl
extends OXFolderManager
implements OXExceptionConstants {
    private static final Logger LOG = LoggerFactory.getLogger(OXFolderManagerImpl.class);
    private static final int[] SYSTEM_PUBLIC_FOLDERS = new int[]{2, 15};
    private static volatile Boolean setAdminAsCreatorForPublicDriveFolder;
    static final int OPTION_NONE = 0;
    static final int OPTION_DENY_MODULE_UPDATE = 1;
    private static final int OPTION_OVERRIDE_CREATED_BY = 2;
    private static final int OPTION_TRASHING = 4;
    private static final String TABLE_OXFOLDER_TREE = "oxfolder_tree";
    private final Connection readCon;
    private final Connection writeCon;
    private final Context ctx;
    private final UserPermissionBits userPerms;
    private final User user;
    private final Session session;
    private final List<OXException> warnings;
    private OXFolderAccess oxfolderAccess;
    private AppointmentSQLInterface cSql;
    private static final int SPECIAL_CONTACT_COLLECT_FOLDER = 0;
    private static Map<String, Integer> fieldMapping;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean setAdminAsCreatorForPublicDriveFolder() {
        Boolean tmp = setAdminAsCreatorForPublicDriveFolder;
        if (null != tmp) return tmp;
        Class<OXFolderManagerImpl> clazz = OXFolderManagerImpl.class;
        synchronized (OXFolderManagerImpl.class) {
            tmp = setAdminAsCreatorForPublicDriveFolder;
            if (null != tmp) return tmp;
            boolean defaultValue = false;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return defaultValue;
            }
            setAdminAsCreatorForPublicDriveFolder = tmp = Boolean.valueOf(service.getBoolProperty("com.openexchange.infostore.setAdminAsCreatorForPublicDriveFolder", defaultValue));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    public AppointmentSQLInterface getCSql() {
        return this.cSql;
    }

    public void setCSql(AppointmentSQLInterface sql) {
        this.cSql = sql;
    }

    OXFolderManagerImpl(Session session) throws OXException {
        this(session, null, null);
    }

    OXFolderManagerImpl(Session session, OXFolderAccess oxfolderAccess) throws OXException {
        this(session, oxfolderAccess, null, null);
    }

    OXFolderManagerImpl(Session session, Connection readCon, Connection writeCon) throws OXException {
        this(session, null, readCon, writeCon);
    }

    OXFolderManagerImpl(Session session, OXFolderAccess oxfolderAccess, Connection readCon, Connection writeCon) throws OXException {
        this.session = session;
        if (session instanceof ServerSession) {
            ServerSession serverSession = (ServerSession)session;
            this.ctx = serverSession.getContext();
            this.userPerms = serverSession.getUserPermissionBits();
            this.user = serverSession.getUser();
        } else {
            this.ctx = ContextStorage.getStorageContext(session.getContextId());
            this.userPerms = UserPermissionBitsStorage.getInstance().getUserPermissionBits(session.getUserId(), this.ctx);
            this.user = UserStorage.getInstance().getUser(session.getUserId(), this.ctx);
        }
        this.readCon = readCon;
        this.writeCon = writeCon;
        this.oxfolderAccess = oxfolderAccess;
        AppointmentSqlFactoryService factory = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class);
        this.cSql = factory != null ? factory.createAppointmentSql(session) : null;
        this.warnings = new LinkedList<OXException>();
    }

    @Override
    public List<OXException> getWarnings() {
        return this.warnings;
    }

    private OXFolderAccess getOXFolderAccess() {
        if (this.oxfolderAccess != null) {
            return this.oxfolderAccess;
        }
        this.oxfolderAccess = new OXFolderAccess(this.writeCon, this.ctx);
        return this.oxfolderAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FolderObject createFolder(FolderObject folderObj, boolean checkPermissions, long createTime) throws OXException {
        TIntSet diff;
        if (!folderObj.containsFolderName() || folderObj.getFolderName() == null || folderObj.getFolderName().length() == 0) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("title", "", this.ctx.getContextId());
        }
        if (!folderObj.containsParentFolderID()) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("folder_id", "", this.ctx.getContextId());
        }
        if (!folderObj.containsModule()) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("module", "", this.ctx.getContextId());
        }
        if (!folderObj.containsType()) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("type", "", this.ctx.getContextId());
        }
        if (9 == folderObj.getParentFolderID()) {
            folderObj.setType(2);
        }
        if (folderObj.getPermissions() == null || folderObj.getPermissions().size() == 0) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("permissions", "", this.ctx.getContextId());
        }
        FolderObject parentFolder = this.getOXFolderAccess().getFolderObject(folderObj.getParentFolderID());
        if (checkPermissions) {
            try {
                EffectivePermission p = parentFolder.getEffectiveUserPermission(this.user.getId(), this.userPerms, this.readCon);
                if (!p.canCreateSubfolders()) {
                    OXException fe = OXFolderExceptionCode.NO_CREATE_SUBFOLDER_PERMISSION.create(this.user.getId(), parentFolder.getObjectID(), this.ctx.getContextId());
                    if (p.getUnderlyingPermission().canCreateSubfolders()) {
                        fe.setCategory(CATEGORY_PERMISSION_DENIED);
                    }
                    throw fe;
                }
                if (!this.userPerms.hasModuleAccess(folderObj.getModule())) {
                    throw OXFolderExceptionCode.NO_MODULE_ACCESS.create(CATEGORY_PERMISSION_DENIED, this.user.getId(), OXFolderUtility.folderModule2String(folderObj.getModule()), this.ctx.getContextId());
                }
                if (parentFolder.getType() == 2 && !this.userPerms.hasFullPublicFolderAccess() && folderObj.getModule() != 8) {
                    throw OXFolderExceptionCode.NO_PUBLIC_FOLDER_WRITE_ACCESS.create(this.user.getId(), parentFolder.getObjectID(), this.ctx.getContextId());
                }
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        if (!OXFolderUtility.checkFolderTypeAgainstParentType(parentFolder, folderObj.getType())) {
            throw OXFolderExceptionCode.INVALID_TYPE.create(parentFolder.getObjectID(), OXFolderUtility.folderType2String(folderObj.getType()), this.ctx.getContextId());
        }
        if (!OXFolderManagerImpl.isKnownModule(folderObj.getModule())) {
            throw OXFolderExceptionCode.UNKNOWN_MODULE.create(OXFolderUtility.folderModule2String(folderObj.getModule()), this.ctx.getContextId());
        }
        if (!OXFolderUtility.checkFolderModuleAgainstParentModule(parentFolder.getObjectID(), parentFolder.getModule(), folderObj.getModule(), this.ctx.getContextId())) {
            throw OXFolderExceptionCode.INVALID_MODULE.create(parentFolder.getObjectID(), OXFolderUtility.folderModule2String(folderObj.getModule()), this.ctx.getContextId());
        }
        if (parentFolder.isShared(this.user.getId())) {
            OXFolderUtility.checkSharedSubfolderOwnerPermission(parentFolder, folderObj, this.user.getId(), this.ctx);
            folderObj.setCreatedBy(parentFolder.getCreatedBy());
        } else if (8 == folderObj.getModule() && OXFolderManagerImpl.setAdminAsCreatorForPublicDriveFolder() && this.isPublicInfoStoreFolder(parentFolder)) {
            folderObj.setCreatedBy(this.ctx.getMailadmin());
        }
        OXFolderUtility.checkPermissionsAgainstSessionUserConfig(this.session, folderObj, parentFolder.getNonSystemPermissionsAsArray());
        OXFolderUtility.checkFolderPermissions(folderObj, this.user.getId(), this.ctx, this.warnings);
        OXFolderUtility.checkPermissionsAgainstUserConfigs(folderObj, this.ctx);
        if (2 == folderObj.getType()) {
            new CheckPermissionOnInsert(this.session, this.writeCon, this.ctx).checkParentPermissions(parentFolder.getObjectID(), folderObj.getNonSystemPermissionsAsArray(), createTime);
        }
        OXFolderUtility.checkTargetFolderName(this.readCon, this.ctx, this.user, -1, folderObj.getModule(), folderObj.getParentFolderID(), folderObj.getFolderName(), this.user.getId());
        if (folderObj.getType() == 1 && folderObj.getPermissions().size() > 1 && !(diff = OXFolderUtility.getShareUsers(null, folderObj.getPermissions(), this.user.getId(), this.ctx)).isEmpty()) {
            FolderObject[] allSharedFolders;
            try {
                TIntCollection fuids = OXFolderSQL.getSharedFoldersOf(this.user.getId(), this.readCon, this.ctx);
                int length = fuids.size();
                allSharedFolders = new FolderObject[length];
                TIntIterator iter = fuids.iterator();
                for (int i = 0; i < length; ++i) {
                    allSharedFolders[i] = this.getOXFolderAccess().getFolderObject(iter.next());
                }
            }
            catch (DataTruncation e) {
                throw this.parseTruncated(e, folderObj, TABLE_OXFOLDER_TREE);
            }
            catch (IncorrectStringSQLException e) {
                throw OXFolderManagerImpl.handleIncorrectStringError(e, this.session);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            OXFolderUtility.checkSimilarNamedSharedFolder(diff, allSharedFolders, folderObj.getFolderName(), this.ctx);
        }
        OXFolderUtility.checkForDuplicateNonSystemPermissions(folderObj, this.ctx);
        int fuid = this.generateFolderID();
        boolean created = false;
        try {
            OXFolderSQL.insertFolderSQL(fuid, this.user.getId(), folderObj, createTime, this.ctx, this.writeCon);
            created = true;
            folderObj.setObjectID(fuid);
        }
        catch (DataTruncation e) {
            throw this.parseTruncated(e, folderObj, TABLE_OXFOLDER_TREE);
        }
        catch (IncorrectStringSQLException e) {
            throw OXFolderManagerImpl.handleIncorrectStringError(e, this.session);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            if (!created) {
                FolderCacheManager manager = FolderCacheManager.getInstance();
                manager.removeFolderObject(parentFolder.getObjectID(), this.ctx);
            }
        }
        Date creatingDate = new Date(createTime);
        folderObj.setCreationDate(creatingDate);
        if (!folderObj.containsCreatedBy()) {
            folderObj.setCreatedBy(this.user.getId());
        }
        folderObj.setLastModified(creatingDate);
        folderObj.setModifiedBy(this.user.getId());
        folderObj.setSubfolderFlag(false);
        folderObj.setDefaultFolder(false);
        parentFolder.setSubfolderFlag(true);
        parentFolder.setLastModified(creatingDate);
        ConditionTreeMapManagement.dropFor(this.ctx.getContextId());
        Connection wc = this.writeCon;
        boolean create = wc == null;
        try {
            if (create) {
                wc = DBPool.pickupWriteable(this.ctx);
            }
            if (FolderCacheManager.isInitialized()) {
                FolderCacheManager manager = FolderCacheManager.getInstance();
                manager.removeFolderObject(parentFolder.getObjectID(), this.ctx);
                manager.loadFolderObject(parentFolder.getObjectID(), this.ctx, wc);
                folderObj.fill(manager.getFolderObject(fuid, false, this.ctx, wc));
            } else {
                folderObj.fill(FolderObject.loadFolderObjectFromDB(fuid, this.ctx, wc));
            }
            if (FolderQueryCacheManager.isInitialized()) {
                FolderQueryCacheManager.getInstance().invalidateContextQueries(this.session);
            }
            if (CalendarCache.isInitialized()) {
                CalendarCache.getInstance().invalidateGroup(this.ctx.getContextId());
            }
            try {
                if (8 == folderObj.getModule()) {
                    new EventClient(this.session).create(folderObj, parentFolder, this.getFolderPath(folderObj, parentFolder, wc));
                } else {
                    new EventClient(this.session).create(folderObj, parentFolder);
                }
            }
            catch (OXException e) {
                LOG.warn("Create event could not be enqueued", (Throwable)e);
            }
            FolderObject folderObject = folderObj;
            return folderObject;
        }
        finally {
            if (create && wc != null) {
                DBPool.closeWriterAfterReading(this.ctx, wc);
                wc = null;
            }
        }
    }

    private boolean isPublicInfoStoreFolder(FolderObject parentFolder) throws OXException {
        int fuid = parentFolder.getObjectID();
        if (fuid <= 10) {
            return false;
        }
        if (15 == fuid) {
            return true;
        }
        return this.isPublicInfoStoreFolder(this.getOXFolderAccess().getFolderObject(parentFolder.getParentFolderID()));
    }

    private int generateFolderID() throws OXException {
        int fuid = -1;
        boolean created = false;
        boolean transactionStarted = false;
        Connection wc = this.writeCon;
        if (wc == null) {
            wc = DBPool.pickupWriteable(this.ctx);
            created = true;
        }
        try {
            if (created) {
                Databases.startTransaction((Connection)wc);
            } else if (wc.getAutoCommit()) {
                Databases.startTransaction((Connection)wc);
                transactionStarted = true;
            }
            fuid = IDGenerator.getId(this.ctx, 20, wc);
            if (created || transactionStarted) {
                wc.commit();
            }
        }
        catch (SQLException e) {
            if (created) {
                Databases.rollback((Connection)wc);
            }
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            if (created) {
                Databases.autocommit((Connection)wc);
                DBPool.closeWriterSilent(this.ctx, wc);
            } else if (transactionStarted) {
                Databases.autocommit((Connection)wc);
            }
        }
        if (fuid < 20) {
            throw OXFolderExceptionCode.INVALID_SEQUENCE_ID.create(fuid, 20, this.ctx.getContextId());
        }
        return fuid;
    }

    @Override
    public FolderObject updateFolder(FolderObject fo, boolean checkPermissions, boolean handDown, long lastModified) throws OXException {
        return this.updateFolder(fo, checkPermissions, handDown, lastModified, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FolderObject updateFolder(FolderObject fo, boolean checkPermissions, boolean handDown, long lastModified, int options) throws OXException {
        int newParentFolderID;
        if (checkPermissions) {
            if (fo.containsType() && fo.getType() == 2 && fo.getModule() != 8 && !this.userPerms.hasFullPublicFolderAccess()) {
                throw OXFolderExceptionCode.NO_PUBLIC_FOLDER_WRITE_ACCESS.create(this.session.getUserId(), fo.getObjectID(), this.ctx.getContextId());
            }
            EffectivePermission perm = this.getOXFolderAccess().getFolderPermission(fo.getObjectID(), this.user.getId(), this.userPerms);
            if (!perm.isFolderVisible() || !perm.getUnderlyingPermission().isFolderVisible()) {
                throw OXFolderExceptionCode.NOT_VISIBLE.create(fo.getObjectID(), this.session.getUserId(), this.ctx.getContextId());
            }
            if (!perm.isFolderAdmin() || !perm.getUnderlyingPermission().isFolderAdmin()) {
                throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(this.session.getUserId(), fo.getObjectID(), this.ctx.getContextId());
            }
            if (fo.getObjectID() == OXFolderManagerImpl.getPublishedMailAttachmentsFolder(this.session)) {
                throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(this.session.getUserId(), fo.getObjectID(), this.ctx.getContextId());
            }
        }
        boolean performMove = fo.containsParentFolderID();
        FolderObject originalFolder = this.getFolderFromMaster(fo.getObjectID());
        int oldParentId = originalFolder.getParentFolderID();
        FolderObject storageObject = originalFolder.clone();
        int optionz = options;
        if ((optionz & 4) <= 0 && performMove && (newParentFolderID = fo.getParentFolderID()) > 0 && newParentFolderID != storageObject.getParentFolderID() && 16 == this.getFolderTypeFromMaster(newParentFolderID) && 16 != this.getFolderTypeFromMaster(storageObject.getParentFolderID())) {
            int folderId = fo.getObjectID();
            String name = fo.containsFolderName() && !Strings.isEmpty((String)fo.getFolderName()) ? fo.getFolderName() : storageObject.getFolderName();
            try {
                while (-1 != OXFolderSQL.lookUpFolderOnUpdate(folderId, newParentFolderID, name, storageObject.getModule(), this.readCon, this.ctx)) {
                    name = OXFolderManagerImpl.incrementSequenceNumber(name);
                }
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            this.deleteDependentEntities(this.writeCon, storageObject, true);
            fo.setFolderName(name);
            fo.setPermissions(this.getFolderFromMaster(newParentFolderID).getPermissions());
            optionz |= this.user.getId() != storageObject.getCreatedBy() ? 2 : 0;
        }
        Map<Integer, Integer> folderId2OldOwner = null;
        try {
            int newParentFolderID2;
            if (fo.containsPermissions() || fo.containsModule() || fo.containsMeta()) {
                newParentFolderID2 = fo.getParentFolderID();
                if (performMove && newParentFolderID2 > 0 && newParentFolderID2 != storageObject.getParentFolderID()) {
                    folderId2OldOwner = this.determineCurrentOwnerships(originalFolder);
                    this.move(fo.getObjectID(), newParentFolderID2, fo.getCreatedBy(), fo.getFolderName(), storageObject, lastModified);
                    storageObject = this.getFolderFromMaster(fo.getObjectID());
                } else if (fo.containsPermissions()) {
                    this.checkTrashFolderPermissionChange(fo, storageObject);
                }
                this.update(fo, optionz, storageObject, lastModified, handDown);
            } else if (fo.containsFolderName()) {
                newParentFolderID2 = fo.getParentFolderID();
                if (performMove && newParentFolderID2 > 0 && newParentFolderID2 != storageObject.getParentFolderID()) {
                    folderId2OldOwner = this.determineCurrentOwnerships(originalFolder);
                    this.move(fo.getObjectID(), newParentFolderID2, fo.getCreatedBy(), fo.getFolderName(), storageObject, lastModified);
                } else {
                    this.rename(fo, storageObject, lastModified);
                }
            } else if (performMove) {
                folderId2OldOwner = this.determineCurrentOwnerships(originalFolder);
                this.move(fo.getObjectID(), fo.getParentFolderID(), fo.getCreatedBy(), null, storageObject, lastModified);
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        if (null != folderId2OldOwner) {
            this.adjustFileStorageLocations(folderId2OldOwner);
        }
        ConditionTreeMapManagement.dropFor(this.ctx.getContextId());
        Connection wc = this.writeCon;
        boolean create = wc == null;
        try {
            if (create) {
                wc = DBPool.pickupWriteable(this.ctx);
            }
            if (FolderCacheManager.isEnabled()) {
                FolderCacheManager cacheManager = FolderCacheManager.getInstance();
                cacheManager.removeFolderObject(fo.getObjectID(), this.ctx);
                fo.fill(cacheManager.getFolderObject(fo.getObjectID(), false, this.ctx, wc));
                int parentFolderID = fo.getParentFolderID();
                if (parentFolderID > 0) {
                    cacheManager.removeFolderObject(parentFolderID, this.ctx);
                    cacheManager.loadFolderObject(parentFolderID, this.ctx, wc);
                }
                if (0 < oldParentId && oldParentId != parentFolderID) {
                    cacheManager.removeFolderObject(oldParentId, this.ctx);
                    cacheManager.loadFolderObject(oldParentId, this.ctx, wc);
                }
            } else {
                fo.fill(FolderObject.loadFolderObjectFromDB(fo.getObjectID(), this.ctx, wc));
            }
            if (FolderQueryCacheManager.isInitialized()) {
                FolderQueryCacheManager.getInstance().invalidateContextQueries(this.session);
            }
            if (CalendarCache.isInitialized()) {
                CalendarCache.getInstance().invalidateGroup(this.ctx.getContextId());
            }
            if (5 != fo.getModule()) {
                try {
                    FolderObject newParentFolder = FolderObject.loadFolderObjectFromDB(fo.getParentFolderID(), this.ctx, wc, true, false);
                    if (8 == fo.getModule()) {
                        new EventClient(this.session).modify(originalFolder, fo, newParentFolder, this.getFolderPath(fo, newParentFolder, wc));
                    } else {
                        new EventClient(this.session).modify(originalFolder, fo, newParentFolder);
                    }
                }
                catch (OXException e) {
                    LOG.warn("Update event could not be enqueued", (Throwable)e);
                }
            }
            FolderObject folderObject = fo;
            return folderObject;
        }
        finally {
            if (create && wc != null) {
                DBPool.closeWriterAfterReading(this.ctx, wc);
                wc = null;
            }
        }
    }

    private void checkTrashFolderPermissionChange(FolderObject fo, FolderObject storageObject) throws OXException {
        FolderObject trashFolder = this.getTrashFolder(storageObject.getModule());
        if (null != trashFolder) {
            boolean belowTrash;
            int trashFolderID = trashFolder.getObjectID();
            if (storageObject.getObjectID() == trashFolderID || storageObject.getParentFolderID() == trashFolderID) {
                belowTrash = true;
            } else {
                OXFolderAccess folderAccess = this.getOXFolderAccess();
                FolderObject p = storageObject;
                while (p.getParentFolderID() != trashFolderID && 20 < p.getParentFolderID()) {
                    p = folderAccess.getFolderObject(p.getParentFolderID());
                }
                boolean bl = belowTrash = p.getParentFolderID() == trashFolderID;
            }
            if (belowTrash && !OXFolderUtility.equalPermissions(fo.getNonSystemPermissionsAsArray(), storageObject.getNonSystemPermissionsAsArray())) {
                throw OXFolderExceptionCode.NO_TRASH_PERMISSIONS_CHANGE_ALLOWED.create(fo.getObjectID(), this.ctx.getContextId());
            }
        }
    }

    private Map<Integer, Integer> determineCurrentOwnerships(FolderObject folder) throws OXException {
        ArrayList<Integer> folderIds = new ArrayList<Integer>(8);
        folderIds.add(folder.getObjectID());
        if (folder.hasSubfolders()) {
            try {
                folderIds.addAll(OXFolderSQL.getSubfolderIDs(folder.getObjectID(), this.writeCon, this.ctx, true));
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        LinkedHashMap<Integer, Integer> folderId2OldOwner = new LinkedHashMap<Integer, Integer>(folderIds.size());
        for (Integer folderId : folderIds) {
            folderId2OldOwner.put(folderId, this.getFolderFromMaster(folderId).getCreatedBy());
        }
        return folderId2OldOwner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void adjustFileStorageLocations(Map<Integer, Integer> folderId2OldOwner) throws OXException {
        boolean bl;
        Connection wc;
        LinkedList<Map<Integer, List<VersionControlResult>>> results = new LinkedList<Map<Integer, List<VersionControlResult>>>();
        boolean error = true;
        try {
            for (Map.Entry<Integer, Integer> f2o : folderId2OldOwner.entrySet()) {
                int folderId = f2o.getKey();
                int n = this.getFolderOwnerFromMaster(folderId);
                int oldOwner = f2o.getValue();
                if (oldOwner == n) continue;
                Connection wc2 = this.writeCon;
                boolean create = wc2 == null;
                Map<Integer, List<VersionControlResult>> modified = null;
                try {
                    if (create) {
                        wc2 = DBPool.pickupWriteable(this.ctx);
                    }
                    if ((modified = VersionControlUtil.changeFileStoreLocationsIfNecessary(oldOwner, n, folderId, this.ctx, wc2)).isEmpty()) continue;
                    results.add(modified);
                }
                finally {
                    if (!create || wc2 == null) continue;
                    if (null != modified && !modified.isEmpty()) {
                        DBPool.closeWriterSilent(this.ctx, wc2);
                    } else {
                        DBPool.closeWriterAfterReading(this.ctx, wc2);
                    }
                    wc2 = null;
                }
            }
            error = false;
            if (!error) return;
            wc = this.writeCon;
            bl = wc == null;
        }
        catch (Throwable throwable) {
            if (!error) throw throwable;
            Connection wc2 = this.writeCon;
            boolean create2 = wc2 == null;
            try {
                for (Map map : results) {
                    for (Map.Entry documentEntry : map.entrySet()) {
                        Integer documentId = (Integer)documentEntry.getKey();
                        List versionInfo = (List)documentEntry.getValue();
                        try {
                            VersionControlUtil.restoreVersionControl(Collections.singletonMap(documentId, versionInfo), this.ctx, wc2);
                        }
                        catch (Exception e) {
                            LOG.error("Failed to restore InfoStore/Drive files for document {} in context {}", new Object[]{documentId, this.ctx.getContextId(), e});
                        }
                    }
                }
                throw throwable;
            }
            finally {
                if (create2 && wc2 != null) {
                    DBPool.closeWriterSilent(this.ctx, wc2);
                    wc2 = null;
                }
            }
        }
        boolean create = bl;
        try {
            for (Map map : results) {
                for (Map.Entry documentEntry : map.entrySet()) {
                    Integer documentId = (Integer)documentEntry.getKey();
                    List versionInfo = (List)documentEntry.getValue();
                    try {
                        VersionControlUtil.restoreVersionControl(Collections.singletonMap(documentId, versionInfo), this.ctx, wc);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to restore InfoStore/Drive files for document {} in context {}", new Object[]{documentId, this.ctx.getContextId(), e});
                    }
                }
            }
            return;
        }
        finally {
            if (create && wc != null) {
                DBPool.closeWriterSilent(this.ctx, wc);
                wc = null;
            }
        }
    }

    protected void update(FolderObject fo, int options, FolderObject storageObj, long lastModified, boolean handDown) throws OXException {
        TIntSet diff;
        if (fo.getObjectID() <= 0) {
            throw OXFolderExceptionCode.INVALID_OBJECT_ID.create(fo.getObjectID());
        }
        boolean containsPermissions = fo.containsPermissions();
        if (fo.getPermissions() == null || fo.getPermissions().isEmpty()) {
            if (containsPermissions) {
                throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("permissions", fo.getObjectID(), this.ctx.getContextId());
            }
            fo.setPermissionsAsArray(storageObj.getPermissionsAsArray());
        }
        if (fo.containsParentFolderID() && fo.getParentFolderID() > 0 && storageObj.getParentFolderID() != fo.getParentFolderID()) {
            throw OXFolderExceptionCode.NO_MOVE_THROUGH_UPDATE.create(fo.getObjectID());
        }
        if (fo.containsFolderName()) {
            if (fo.getFolderName() == null || fo.getFolderName().trim().length() == 0) {
                throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("title", fo.getObjectID(), this.ctx.getContextId());
            }
            if (storageObj.isDefaultFolder() && !fo.getFolderName().equals(storageObj.getFolderName())) {
                throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_RENAME.create(fo.getObjectID(), this.ctx.getContextId());
            }
        }
        if (fo.containsModule() && fo.getModule() != storageObj.getModule() && 5 != storageObj.getModule()) {
            if (!OXFolderManagerImpl.isKnownModule(fo.getModule())) {
                throw OXFolderExceptionCode.UNKNOWN_MODULE.create(OXFolderUtility.folderModule2String(fo.getModule()), this.ctx.getContextId());
            }
            if (storageObj.isDefaultFolder()) {
                throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_MODULE_UPDATE.create();
            }
            if (!this.isFolderEmpty(storageObj.getObjectID(), storageObj.getModule())) {
                throw OXFolderExceptionCode.DENY_FOLDER_MODULE_UPDATE.create();
            }
            if ((options & 1) > 0) {
                throw OXFolderExceptionCode.NO_FOLDER_MODULE_UPDATE.create();
            }
            FolderObject parent = this.getFolderFromMaster(storageObj.getParentFolderID());
            if (!OXFolderUtility.checkFolderModuleAgainstParentModule(parent.getObjectID(), parent.getModule(), fo.getModule(), this.ctx.getContextId())) {
                throw OXFolderExceptionCode.INVALID_MODULE.create(parent.getObjectID(), OXFolderUtility.folderModule2String(fo.getModule()), this.ctx.getContextId());
            }
        } else {
            fo.setModule(storageObj.getModule());
        }
        if (storageObj.isShared(this.user.getId())) {
            throw OXFolderExceptionCode.NO_SHARED_FOLDER_UPDATE.create(fo.getObjectID(), this.ctx.getContextId());
        }
        fo.setType(storageObj.getType());
        if ((options & 2) <= 0) {
            fo.setCreatedBy(storageObj.getCreatedBy());
        }
        fo.setDefaultFolder(storageObj.isDefaultFolder());
        OXFolderUtility.checkPermissionsAgainstSessionUserConfig(this.session, fo, storageObj.getNonSystemPermissionsAsArray());
        OXFolderUtility.checkFolderPermissions(fo, this.user.getId(), this.ctx, this.warnings);
        OXFolderUtility.checkPermissionsAgainstUserConfigs(this.readCon, fo, this.ctx);
        OXFolderUtility.checkSystemFolderPermissions(fo.getObjectID(), fo.getNonSystemPermissionsAsArray(), this.user, this.ctx);
        if (2 == fo.getType() || 8 == storageObj.getModule()) {
            OCLPermission[] removedPerms = OXFolderUtility.getPermissionsWithoutFolderAccess(fo.getNonSystemPermissionsAsArray(), storageObj.getNonSystemPermissionsAsArray());
            if (removedPerms.length > 0) {
                new CheckPermissionOnRemove(this.session, this.writeCon, this.ctx).checkPermissionsOnUpdate(fo.getObjectID(), removedPerms, lastModified);
            }
            new CheckPermissionOnInsert(this.session, this.writeCon, this.ctx).checkParentPermissions(storageObj.getParentFolderID(), fo.getNonSystemPermissionsAsArray(), lastModified);
        }
        boolean rename = false;
        if (fo.containsFolderName() && !storageObj.getFolderName().equals(fo.getFolderName())) {
            rename = true;
            OXFolderUtility.checkTargetFolderName(this.readCon, this.ctx, this.user, fo.getObjectID(), fo.getModule(), storageObj.getParentFolderID(), fo.getFolderName(), storageObj.getCreatedBy());
        }
        if (fo.getType() == 1 && fo.getPermissions().size() > 1 && !(diff = OXFolderUtility.getShareUsers(rename ? null : storageObj.getPermissions(), fo.getPermissions(), this.user.getId(), this.ctx)).isEmpty()) {
            FolderObject[] allSharedFolders;
            OXFolderAccess folderAccess = this.getOXFolderAccess();
            try {
                TIntCollection fuids = OXFolderSQL.getSharedFoldersOf(this.user.getId(), this.readCon, this.ctx);
                int size = fuids.size();
                allSharedFolders = new FolderObject[size];
                TIntIterator iter = fuids.iterator();
                for (int i = 0; i < size; ++i) {
                    int fuid = iter.next();
                    if (fuid == fo.getObjectID()) continue;
                    allSharedFolders[i] = folderAccess.getFolderObject(fuid);
                }
            }
            catch (DataTruncation e) {
                throw this.parseTruncated(e, fo, TABLE_OXFOLDER_TREE);
            }
            catch (IncorrectStringSQLException e) {
                throw OXFolderManagerImpl.handleIncorrectStringError(e, this.session);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            OXFolderUtility.checkSimilarNamedSharedFolder(diff, allSharedFolders, rename ? fo.getFolderName() : storageObj.getFolderName(), this.ctx);
        }
        OXFolderUtility.checkForDuplicateNonSystemPermissions(fo, this.ctx);
        try {
            OXFolderSQL.updateFolderSQL(this.user.getId(), fo, lastModified, this.ctx, this.writeCon);
        }
        catch (DataTruncation e) {
            throw this.parseTruncated(e, fo, TABLE_OXFOLDER_TREE);
        }
        catch (IncorrectStringSQLException e) {
            throw OXFolderManagerImpl.handleIncorrectStringError(e, this.session);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        if (handDown) {
            try {
                List<OCLPermission> permissions;
                if (containsPermissions && (permissions = fo.getPermissions()) != null && !permissions.isEmpty()) {
                    this.handDown(fo.getObjectID(), options, permissions, lastModified, FolderCacheManager.isEnabled() ? FolderCacheManager.getInstance() : null);
                }
            }
            catch (DataTruncation e) {
                throw this.parseTruncated(e, fo, TABLE_OXFOLDER_TREE);
            }
            catch (IncorrectStringSQLException e) {
                throw OXFolderManagerImpl.handleIncorrectStringError(e, this.session);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (ProcedureFailedException e) {
                Throwable cause = e.getCause();
                if (cause instanceof OXException) {
                    throw (OXException)cause;
                }
                if (cause instanceof SQLException) {
                    throw OXFolderExceptionCode.SQL_ERROR.create(cause, cause.getMessage());
                }
                throw OXFolderExceptionCode.RUNTIME_ERROR.create(cause, cause.getMessage());
            }
        }
    }

    protected void handDown(int folderId, final int options, final List<OCLPermission> permissions, final long lastModified, final FolderCacheManager cacheManager) throws OXException, SQLException {
        final Context ctx = this.ctx;
        TIntList subfolders = OXFolderSQL.getSubfolderIDs(folderId, this.writeCon, ctx);
        if (!subfolders.isEmpty()) {
            final Session session = this.session;
            subfolders.forEach(new TIntProcedure(){

                public boolean execute(int subfolderId) {
                    try {
                        FolderObject tmp = new FolderObject(subfolderId);
                        tmp.setPermissions(permissions);
                        OXFolderManagerImpl.this.update(tmp, options, OXFolderManagerImpl.this.getFolderFromMaster(subfolderId), lastModified, true);
                        if (null != cacheManager) {
                            cacheManager.removeFolderObject(subfolderId, ctx);
                        }
                        CacheFolderStorage.getInstance().removeFromCache(Integer.toString(subfolderId), FolderStorage.REAL_TREE_ID, true, session);
                        OXFolderManagerImpl.this.handDown(subfolderId, options, permissions, lastModified, cacheManager);
                        return true;
                    }
                    catch (OXException e) {
                        throw new ProcedureFailedException(e);
                    }
                    catch (SQLException e) {
                        throw new ProcedureFailedException(e);
                    }
                    catch (RuntimeException e) {
                        throw new ProcedureFailedException(e);
                    }
                }
            });
        }
    }

    private int getFolderTypeFromMaster(int folderId) throws OXException {
        return this.getFolderFromMaster(folderId, false, false).getType();
    }

    private int getFolderOwnerFromMaster(int folderId) throws OXException {
        return this.getFolderFromMaster(folderId, false, false).getCreatedBy();
    }

    private boolean hasSubfoldersFromMaster(int folderId) throws OXException {
        return this.getFolderFromMaster(folderId, false, false).hasSubfolders();
    }

    protected FolderObject getFolderFromMaster(int folderId) throws OXException {
        return this.getFolderFromMaster(folderId, false);
    }

    private FolderObject getFolderFromMaster(int folderId, boolean withSubfolders) throws OXException {
        return this.getFolderFromMaster(folderId, true, withSubfolders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FolderObject getFolderFromMaster(int folderId, boolean loadPermissions, boolean withSubfolders) throws OXException {
        Connection wc = this.writeCon;
        if (wc != null) {
            return FolderObject.loadFolderObjectFromDB(folderId, this.ctx, wc, loadPermissions, withSubfolders);
        }
        wc = DBPool.pickupWriteable(this.ctx);
        try {
            FolderObject folderObject = FolderObject.loadFolderObjectFromDB(folderId, this.ctx, wc, loadPermissions, withSubfolders);
            return folderObject;
        }
        finally {
            DBPool.closeWriterAfterReading(this.ctx, wc);
        }
    }

    private boolean isFolderEmpty(int folderId, int module) throws OXException {
        if (module == 1) {
            Tasks tasks2 = Tasks.getInstance();
            return this.readCon == null ? tasks2.isFolderEmpty(this.ctx, folderId) : tasks2.isFolderEmpty(this.ctx, this.readCon, folderId);
        }
        if (module == 2) {
            AppointmentSQLInterface calSql = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(this.session);
            if (this.readCon == null) {
                try {
                    return calSql.isFolderEmpty(this.user.getId(), folderId);
                }
                catch (SQLException e) {
                    throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                }
            }
            try {
                return calSql.isFolderEmpty(this.user.getId(), folderId, this.readCon);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        if (module == 3) {
            ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class, true);
            return contactService.isFolderEmpty(this.session, String.valueOf(folderId));
        }
        if (module == 8) {
            EventFiringInfostoreFacadeImpl db = new EventFiringInfostoreFacadeImpl(this.readCon == null ? new DBPoolProvider() : new StaticDBPoolProvider(this.readCon));
            return db.isFolderEmpty(folderId, this.ctx);
        }
        if (module == 5) {
            return true;
        }
        throw OXFolderExceptionCode.UNKNOWN_MODULE.create(OXFolderUtility.folderModule2String(module), this.ctx.getContextId());
    }

    private static boolean isKnownModule(int module) {
        return module == 1 || module == 2 || module == 3 || module == 8;
    }

    private void rename(FolderObject folderObj, FolderObject storageObj, long lastModified) throws OXException {
        TIntSet diff;
        if (folderObj.getObjectID() <= 0) {
            throw OXFolderExceptionCode.INVALID_OBJECT_ID.create(folderObj.getObjectID());
        }
        if (!folderObj.containsFolderName() || folderObj.getFolderName() == null || folderObj.getFolderName().trim().length() == 0) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("title", "", Autoboxing.I((int)this.ctx.getContextId()));
        }
        if (storageObj.getFolderName().equals(folderObj.getFolderName())) {
            return;
        }
        if (storageObj.isDefaultFolder()) {
            throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_RENAME.create(folderObj.getObjectID(), Autoboxing.I((int)this.ctx.getContextId()));
        }
        OXFolderUtility.checkTargetFolderName(this.readCon, this.ctx, this.user, folderObj.getObjectID(), storageObj.getModule(), storageObj.getParentFolderID(), folderObj.getFolderName(), storageObj.getCreatedBy());
        if (storageObj.getType() == 1 && storageObj.getPermissions().size() > 1 && !(diff = OXFolderUtility.getShareUsers(null, storageObj.getPermissions(), this.user.getId(), this.ctx)).isEmpty()) {
            FolderObject[] allSharedFolders;
            try {
                TIntCollection fuids = OXFolderSQL.getSharedFoldersOf(this.user.getId(), this.readCon, this.ctx);
                int size = fuids.size();
                allSharedFolders = new FolderObject[size];
                TIntIterator iter = fuids.iterator();
                for (int i = 0; i < size; ++i) {
                    int fuid = iter.next();
                    if (fuid == folderObj.getObjectID()) continue;
                    allSharedFolders[i] = this.getOXFolderAccess().getFolderObject(fuid);
                }
            }
            catch (DataTruncation e) {
                throw this.parseTruncated(e, folderObj, TABLE_OXFOLDER_TREE);
            }
            catch (IncorrectStringSQLException e) {
                throw OXFolderManagerImpl.handleIncorrectStringError(e, this.session);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            OXFolderUtility.checkSimilarNamedSharedFolder(diff, allSharedFolders, folderObj.getFolderName(), this.ctx);
        }
        try {
            OXFolderSQL.renameFolderSQL(this.user.getId(), folderObj, lastModified, this.ctx, this.writeCon);
        }
        catch (DataTruncation e) {
            throw this.parseTruncated(e, folderObj, TABLE_OXFOLDER_TREE);
        }
        catch (IncorrectStringSQLException e) {
            throw OXFolderManagerImpl.handleIncorrectStringError(e, this.session);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void move(int folderId, int targetFolderId, int createdBy, String newName, FolderObject storageSrc, long lastModified) throws OXException, SQLException {
        int oldParentId = storageSrc.getParentFolderID();
        if (oldParentId == targetFolderId && (null == newName || newName.equals(storageSrc.getFolderName()))) {
            return;
        }
        if (storageSrc.isDefaultFolder()) {
            throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_MOVE.create(storageSrc.getObjectID(), Autoboxing.I((int)this.ctx.getContextId()));
        }
        String folderName = null == newName ? storageSrc.getFolderName() : newName;
        OXFolderUtility.checkTargetFolderName(this.readCon, this.ctx, this.user, folderId, storageSrc.getModule(), targetFolderId, folderName, createdBy);
        FolderObject storageDest = this.getOXFolderAccess().getFolderObject(targetFolderId);
        try {
            if (storageSrc.isShared(this.user.getId())) {
                throw OXFolderExceptionCode.NO_SHARED_FOLDER_MOVE.create(storageSrc.getObjectID(), Autoboxing.I((int)this.ctx.getContextId()));
            }
            if (storageDest.isShared(this.user.getId())) {
                throw OXFolderExceptionCode.NO_SHARED_FOLDER_TARGET.create(storageDest.getObjectID(), Autoboxing.I((int)this.ctx.getContextId()));
            }
            if (storageSrc.getType() == 5) {
                throw OXFolderExceptionCode.NO_SYSTEM_FOLDER_MOVE.create(storageSrc.getObjectID(), Autoboxing.I((int)this.ctx.getContextId()));
            }
            if (storageSrc.getType() == 1 && (storageDest.getType() == 2 || storageDest.getType() == 5 && targetFolderId != 1)) {
                throw OXFolderExceptionCode.ONLY_PRIVATE_TO_PRIVATE_MOVE.create(storageSrc.getObjectID(), Autoboxing.I((int)this.ctx.getContextId()));
            }
            if (storageSrc.getType() == 2 && (storageDest.getType() == 1 || storageDest.getType() == 5 && !Arrays.contains((int[])SYSTEM_PUBLIC_FOLDERS, (int)targetFolderId))) {
                throw OXFolderExceptionCode.ONLY_PUBLIC_TO_PUBLIC_MOVE.create(storageSrc.getObjectID(), Autoboxing.I((int)this.ctx.getContextId()));
            }
            if (storageSrc.getModule() == 8 && storageDest.getModule() != 8 && targetFolderId != 9) {
                throw OXFolderExceptionCode.INCOMPATIBLE_MODULES.create(OXFolderUtility.folderModule2String(storageSrc.getModule()), OXFolderUtility.folderModule2String(storageDest.getModule()));
            }
            if (storageSrc.getModule() != 8 && storageDest.getModule() == 8) {
                throw OXFolderExceptionCode.INCOMPATIBLE_MODULES.create(OXFolderUtility.folderModule2String(storageSrc.getModule()), OXFolderUtility.folderModule2String(storageDest.getModule()));
            }
            if (storageDest.getEffectiveUserPermission(this.user.getId(), this.userPerms).getFolderPermission() < 8) {
                throw OXFolderExceptionCode.NO_CREATE_SUBFOLDER_PERMISSION.create(this.user.getId(), storageDest.getObjectID(), Autoboxing.I((int)this.ctx.getContextId()));
            }
            if (folderId == targetFolderId) {
                throw OXFolderExceptionCode.NO_EQUAL_MOVE.create(Autoboxing.I((int)this.ctx.getContextId()));
            }
        }
        catch (RuntimeException e) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, Autoboxing.I((int)this.ctx.getContextId()));
        }
        if (storageSrc.hasSubfolders()) {
            TIntArrayList parentIDList = new TIntArrayList(1);
            parentIDList.add(storageSrc.getObjectID());
            if (OXFolderUtility.isDescendentFolder((TIntList)parentIDList, targetFolderId, this.readCon, this.ctx)) {
                throw OXFolderExceptionCode.NO_SUBFOLDER_MOVE.create(storageSrc.getObjectID(), this.ctx.getContextId());
            }
            int numOfMoveableSubfolders = OXFolderSQL.getNumOfMoveableSubfolders(storageSrc.getObjectID(), this.user.getId(), this.user.getGroups(), this.readCon, this.ctx);
            if (numOfMoveableSubfolders != storageSrc.getSubfolderIds(true, this.ctx).size()) {
                throw OXFolderExceptionCode.NO_SUBFOLDER_MOVE_ACCESS.create(this.session.getUserId(), storageSrc.getObjectID(), this.ctx.getContextId());
            }
        }
        this.processDeletedFolderThroughMove(storageSrc, new CheckPermissionOnRemove(this.session, this.writeCon, this.ctx), lastModified);
        try {
            storageSrc.setFolderName(newName);
            OXFolderSQL.moveFolderSQL(this.user.getId(), storageSrc, storageDest, lastModified, this.ctx, this.readCon, this.writeCon);
        }
        catch (DataTruncation e) {
            throw this.parseTruncated(e, storageSrc, TABLE_OXFOLDER_TREE);
        }
        catch (IncorrectStringSQLException e) {
            throw OXFolderManagerImpl.handleIncorrectStringError(e, this.session);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        if (16 != storageDest.getType()) {
            this.processInsertedFolderThroughMove(this.getFolderFromMaster(folderId), new CheckPermissionOnInsert(this.session, this.writeCon, this.ctx), lastModified);
        }
        int optNewOwner = 16 == storageDest.getType() ? this.user.getId() : 0;
        this.adjustFolderTypeOnMove(storageSrc, storageDest, true, optNewOwner);
        this.changeOwnerOnMove(storageSrc, targetFolderId, oldParentId, true);
        OXFolderSQL.updateLastModified(storageSrc.getParentFolderID(), lastModified, this.user.getId(), this.writeCon, this.ctx);
        OXFolderSQL.updateLastModified(storageSrc.getObjectID(), lastModified, this.user.getId(), this.writeCon, this.ctx);
        OXFolderSQL.updateLastModified(storageDest.getObjectID(), lastModified, this.user.getId(), this.writeCon, this.ctx);
        if (FolderCacheManager.isEnabled()) {
            boolean create;
            Connection wc = this.writeCon;
            boolean bl = create = wc == null;
            if (create) {
                wc = DBPool.pickupWriteable(this.ctx);
            }
            try {
                int destParentId;
                int srcParentId = storageSrc.getParentFolderID();
                if (srcParentId > 0) {
                    FolderCacheManager.getInstance().loadFolderObject(srcParentId, this.ctx, wc);
                }
                if ((destParentId = storageDest.getParentFolderID()) > 0) {
                    FolderCacheManager.getInstance().loadFolderObject(destParentId, this.ctx, wc);
                }
            }
            finally {
                if (create && wc != null) {
                    DBPool.closeWriterSilent(this.ctx, wc);
                }
            }
        }
    }

    private boolean adjustFolderTypeOnMove(FolderObject sourceFolder, FolderObject destinationFolder, boolean recursive, int optNewOwner) throws OXException, SQLException {
        int[] inheritingTypes;
        if (sourceFolder.getType() != destinationFolder.getType() && (Arrays.contains((int[])(inheritingTypes = new int[]{16, 21, 20, 22, 23, 24}), (int)destinationFolder.getType()) || Arrays.contains((int[])inheritingTypes, (int)sourceFolder.getType()))) {
            List<Integer> folderIDs;
            if (!recursive || !sourceFolder.hasSubfolders()) {
                folderIDs = Collections.singletonList(sourceFolder.getObjectID());
            } else {
                folderIDs = new ArrayList<Integer>();
                folderIDs.add(sourceFolder.getObjectID());
                folderIDs.addAll(OXFolderSQL.getSubfolderIDs(sourceFolder.getObjectID(), this.readCon, this.ctx, true));
            }
            int type = 15 == destinationFolder.getObjectID() ? 2 : destinationFolder.getType();
            return 0 < OXFolderSQL.updateFolderType(this.writeCon, this.ctx, type, optNewOwner, folderIDs);
        }
        return false;
    }

    private boolean changeOwnerOnMove(FolderObject fo, int newParentId, int oldParentId, boolean recursive) throws OXException, SQLException {
        FolderObject oldParent;
        boolean wasPublicInfoStoreFolder;
        FolderObject newParent;
        boolean isPublicInfoStoreFolder;
        if (8 == fo.getModule() && newParentId > 0 && newParentId != oldParentId && OXFolderManagerImpl.setAdminAsCreatorForPublicDriveFolder() && (isPublicInfoStoreFolder = this.isPublicInfoStoreFolder(newParent = this.getFolderFromMaster(newParentId))) != (wasPublicInfoStoreFolder = this.isPublicInfoStoreFolder(oldParent = this.getFolderFromMaster(oldParentId)))) {
            List<Integer> folderIDs;
            if (!recursive || !fo.hasSubfolders()) {
                folderIDs = Collections.singletonList(fo.getObjectID());
            } else {
                folderIDs = new ArrayList<Integer>();
                folderIDs.add(fo.getObjectID());
                folderIDs.addAll(OXFolderSQL.getSubfolderIDs(fo.getObjectID(), this.readCon, this.ctx, true));
            }
            int newOwner = isPublicInfoStoreFolder ? this.ctx.getMailadmin() : newParent.getCreatedBy();
            return 0 < OXFolderSQL.updateFolderOwner(this.writeCon, this.ctx, newOwner, folderIDs);
        }
        return false;
    }

    private void processDeletedFolderThroughMove(FolderObject folder, CheckPermissionOnRemove checker, long lastModified) throws OXException, SQLException, OXException {
        int folderId = folder.getObjectID();
        ArrayList<Integer> subflds = FolderObject.getSubfolderIds(folderId, this.ctx, this.writeCon);
        for (Integer subfld : subflds) {
            this.processDeletedFolderThroughMove(this.getOXFolderAccess().getFolderObject(subfld), checker, lastModified);
        }
        checker.checkPermissionsOnDelete(folder.getParentFolderID(), folderId, folder.getNonSystemPermissionsAsArray(), lastModified);
        OXFolderSQL.deleteAllSystemPermission(folderId, this.writeCon, this.ctx);
    }

    private void processInsertedFolderThroughMove(FolderObject folder, CheckPermissionOnInsert checker, long lastModified) throws OXException, SQLException, OXException {
        int folderId = folder.getObjectID();
        checker.checkParentPermissions(folder.getParentFolderID(), folder.getNonSystemPermissionsAsArray(), lastModified);
        ArrayList<Integer> subflds = FolderObject.getSubfolderIds(folderId, this.ctx, this.writeCon);
        for (Integer subfld : subflds) {
            this.processInsertedFolderThroughMove(this.getOXFolderAccess().getFolderObject(subfld), checker, lastModified);
        }
    }

    @Override
    public FolderObject clearFolder(FolderObject fo, boolean checkPermissions, long lastModified) throws OXException {
        EffectivePermission p;
        if (fo.getObjectID() <= 0) {
            throw OXFolderExceptionCode.INVALID_OBJECT_ID.create(fo.getObjectID());
        }
        if (!fo.containsParentFolderID() || fo.getParentFolderID() <= 0) {
            fo.setParentFolderID(this.getOXFolderAccess().getParentFolderID(fo.getObjectID()));
        } else {
            try {
                if (!OXFolderSQL.exists(fo.getObjectID(), this.readCon, this.ctx)) {
                    throw OXFolderExceptionCode.NOT_EXISTS.create(fo.getObjectID(), this.ctx.getContextId());
                }
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        if (checkPermissions && !(p = this.getOXFolderAccess().getFolderPermission(fo.getObjectID(), this.user.getId(), this.userPerms)).isFolderVisible()) {
            if (p.getUnderlyingPermission().isFolderVisible()) {
                throw OXFolderExceptionCode.NOT_VISIBLE.create(fo.getObjectID(), this.user.getId(), this.ctx.getContextId());
            }
            throw OXFolderExceptionCode.NOT_VISIBLE.create(CATEGORY_PERMISSION_DENIED, fo.getObjectID(), this.user.getId(), this.ctx.getContextId());
        }
        if (!this.getOXFolderAccess().canDeleteAllObjectsInFolder(fo, this.session, this.ctx)) {
            throw OXFolderExceptionCode.NOT_ALL_OBJECTS_DELETION.create(this.user.getId(), fo.getObjectID(), this.ctx.getContextId());
        }
        int module = fo.getModule();
        switch (module) {
            case 2: {
                this.deleteContainedAppointments(fo.getObjectID());
                break;
            }
            case 1: {
                this.deleteContainedTasks(fo.getObjectID());
                break;
            }
            case 3: {
                this.deleteContainedContacts(fo.getObjectID());
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                this.deleteContainedDocuments(fo.getObjectID());
                break;
            }
            default: {
                throw OXFolderExceptionCode.UNKNOWN_MODULE.create(module, this.ctx.getContextId());
            }
        }
        if (16 == fo.getType()) {
            TIntObjectHashMap deleteableFolders = new TIntObjectHashMap();
            try {
                TIntList subfolders = OXFolderSQL.getSubfolderIDs(fo.getObjectID(), this.readCon, this.ctx);
                for (int i = 0; i < subfolders.size(); ++i) {
                    deleteableFolders.putAll(this.gatherDeleteableFolders(subfolders.get(i), this.user.getId(), this.userPerms, StringCollection.getSqlInString(this.user.getId(), this.user.getGroups())));
                }
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            if (0 < deleteableFolders.size()) {
                this.deleteValidatedFolders((TIntObjectMap<TIntObjectMap<?>>)deleteableFolders, lastModified, fo.getType());
            }
        }
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FolderObject deleteFolder(FolderObject fo, boolean checkPermissions, long lastModified, boolean hardDelete) throws OXException {
        FolderObject folderObject;
        block27: {
            TIntObjectMap<TIntObjectMap<?>> deleteableFolders;
            FolderObject trashFolder;
            int folderId = fo.getObjectID();
            if (folderId <= 0) {
                throw OXFolderExceptionCode.INVALID_OBJECT_ID.create(fo.getObjectID());
            }
            if (folderId < 20) {
                throw OXFolderExceptionCode.NO_SYSTEM_FOLDER_MOVE.create(fo.getObjectID(), this.ctx.getContextId());
            }
            OXFolderAccess folderAccess = this.getOXFolderAccess();
            FolderObject folder = folderAccess.getFolderObject(folderId);
            if (checkPermissions) {
                EffectivePermission p = folder.getEffectiveUserPermission(this.user.getId(), this.userPerms);
                if (!p.isFolderVisible()) {
                    if (p.getUnderlyingPermission().isFolderVisible()) {
                        throw OXFolderExceptionCode.NOT_VISIBLE.create(folderId, this.user.getId(), this.ctx.getContextId());
                    }
                    throw OXFolderExceptionCode.NOT_VISIBLE.create(CATEGORY_PERMISSION_DENIED, folderId, this.user.getId(), this.ctx.getContextId());
                }
                if (!p.isFolderAdmin()) {
                    if (!p.getUnderlyingPermission().isFolderAdmin()) {
                        throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(this.user.getId(), folder.getObjectID(), this.ctx.getContextId());
                    }
                    throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(CATEGORY_PERMISSION_DENIED, this.user.getId(), folder.getObjectID(), this.ctx.getContextId());
                }
            }
            FolderObject parentFolder = folderAccess.getFolderObject(folder.getParentFolderID());
            if (!hardDelete && null != (trashFolder = this.getTrashFolder(folder.getModule()))) {
                boolean belowTrash;
                int trashFolderID = trashFolder.getObjectID();
                if (parentFolder.getObjectID() == trashFolderID || parentFolder.getParentFolderID() == trashFolderID) {
                    belowTrash = true;
                } else {
                    FolderObject p = parentFolder;
                    while (p.getParentFolderID() != trashFolderID && 20 < p.getParentFolderID()) {
                        p = folderAccess.getFolderObject(p.getParentFolderID());
                    }
                    boolean bl = belowTrash = p.getParentFolderID() == trashFolderID;
                }
                if (!belowTrash) {
                    String name = folder.getFolderName();
                    try {
                        while (-1 != OXFolderSQL.lookUpFolderOnUpdate(folderId, trashFolderID, name, folder.getModule(), this.readCon, this.ctx)) {
                            name = OXFolderManagerImpl.incrementSequenceNumber(name);
                        }
                    }
                    catch (SQLException e) {
                        throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                    }
                    this.deleteDependentEntities(this.writeCon, folder, true);
                    FolderObject toUpdate = new FolderObject(name, folderId, folder.getModule(), folder.getType(), this.user.getId());
                    toUpdate.setParentFolderID(trashFolderID);
                    toUpdate.setPermissions(trashFolder.getPermissions());
                    int options = 4;
                    return this.updateFolder(toUpdate, false, true, lastModified, options |= this.user.getId() != folder.getCreatedBy() ? 2 : 0);
                }
            }
            try {
                deleteableFolders = this.gatherDeleteableFolders(folderId, this.user.getId(), this.userPerms, StringCollection.getSqlInString(this.user.getId(), this.user.getGroups()));
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            int type = this.getOXFolderAccess().getFolderType(folderId);
            this.deleteValidatedFolders(deleteableFolders, lastModified, type);
            if (FolderQueryCacheManager.isInitialized()) {
                FolderQueryCacheManager.getInstance().invalidateContextQueries(this.session);
            }
            if (CalendarCache.isInitialized()) {
                CalendarCache.getInstance().invalidateGroup(this.ctx.getContextId());
            }
            ConditionTreeMapManagement.dropFor(this.ctx.getContextId());
            Connection wc = this.writeCon;
            boolean create = wc == null;
            try {
                if (create) {
                    wc = DBPool.pickupWriteable(this.ctx);
                }
                boolean hasSubfolders = !OXFolderSQL.getSubfolderIDs(parentFolder.getObjectID(), wc, this.ctx).isEmpty();
                OXFolderSQL.updateSubfolderFlag(parentFolder.getObjectID(), hasSubfolders, lastModified, wc, this.ctx);
                if (FolderCacheManager.isEnabled() && FolderCacheManager.isInitialized()) {
                    FolderCacheManager.getInstance().removeFolderObject(parentFolder.getObjectID(), this.ctx);
                    FolderCacheManager.getInstance().loadFolderObject(parentFolder.getObjectID(), this.ctx, wc);
                }
                fo.fill(FolderObject.loadFolderObjectFromDB(folderId, this.ctx, wc, true, false, "del_oxfolder_tree", "del_oxfolder_permissions"));
                folderObject = fo;
                if (!create || wc == null) break block27;
            }
            catch (Throwable throwable) {
                try {
                    if (create && wc != null) {
                        DBPool.closeWriterSilent(this.ctx, wc);
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                }
            }
            DBPool.closeWriterSilent(this.ctx, wc);
        }
        return folderObject;
    }

    void deleteValidatedFolders(TIntObjectMap<TIntObjectMap<?>> deleteableIDs, long lastModified, int type) throws OXException {
        TIntHashSet validatedFolders = new TIntHashSet();
        TIntObjectProcedure procedure = new TIntObjectProcedure<TIntObjectMap<?>>((TIntSet)validatedFolders){
            final /* synthetic */ TIntSet val$validatedFolders;
            {
                this.val$validatedFolders = tIntSet;
            }

            public boolean execute(int folderId, TIntObjectMap<?> hashMap) {
                if (null != hashMap) {
                    TIntObjectMap<?> tmp = hashMap;
                    tmp.forEachEntry((TIntObjectProcedure)this);
                }
                this.val$validatedFolders.add(folderId);
                return true;
            }
        };
        deleteableIDs.forEachEntry(procedure);
        for (int validatedFolder : validatedFolders.toArray()) {
            this.deleteValidatedFolder(validatedFolder, lastModified, type, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDependentEntities(Connection wcon, FolderObject folder, boolean handDown) throws OXException {
        if (null == wcon) {
            Connection wc = null;
            try {
                wc = DBPool.pickupWriteable(this.ctx);
                OXFolderDependentDeleter.folderDeleted(wc, this.session, folder, handDown);
            }
            finally {
                if (null != wc) {
                    DBPool.closeWriterSilent(this.ctx, wc);
                }
            }
        } else {
            OXFolderDependentDeleter.folderDeleted(wcon, this.session, folder, handDown);
        }
    }

    private static String incrementSequenceNumber(String folderName) {
        String name = folderName;
        Pattern regex = Pattern.compile("\\((\\d+)\\)\\z");
        Matcher matcher = regex.matcher(name);
        if (!matcher.find()) {
            name = name + " (1)";
        } else if (0 == matcher.groupCount() || 0 < matcher.groupCount() && Strings.isEmpty((String)matcher.group(1))) {
            name = name.substring(0, matcher.start()) + " (1)";
        } else {
            int number = 0;
            try {
                number = Integer.valueOf(matcher.group(1).trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            name = name.substring(0, matcher.start()) + '(' + String.valueOf(1 + number) + ')';
        }
        return name;
    }

    private FolderObject getTrashFolder(int module) throws OXException {
        try {
            return this.getOXFolderAccess().getDefaultFolder(this.user.getId(), module, 16);
        }
        catch (OXException e) {
            if (!OXFolderExceptionCode.NO_DEFAULT_FOLDER_FOUND.equals(e)) {
                throw e;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteValidatedFolder(int folderID, long lastModified, int type, boolean hardDelete) throws OXException {
        block26: {
            FolderObject storageFolder;
            try {
                storageFolder = this.getFolderFromMaster(folderID, false);
            }
            catch (OXException e) {
                if (!OXFolderExceptionCode.NOT_EXISTS.equals(e)) {
                    throw e;
                }
                return;
            }
            if (hardDelete) {
                this.deleteContainedItems(folderID);
                try {
                    OXFolderSQL.delOXFolder(folderID, this.session.getUserId(), lastModified, true, false, this.ctx, this.writeCon);
                }
                catch (SQLException e) {
                    throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                }
            }
            Iterator<FolderDeleteListenerService> iter = FolderDeleteListenerRegistry.getInstance().getDeleteListenerServices();
            while (iter.hasNext()) {
                FolderDeleteListenerService next = iter.next();
                try {
                    next.onFolderDelete(folderID, this.ctx);
                }
                catch (OXException e) {
                    LOG.error("Folder delete listener \"{}\" failed for folder {} int context {}", new Object[]{next.getClass().getName(), folderID, this.ctx.getContextId(), e});
                    throw e;
                }
            }
            this.deleteContainedItems(folderID);
            OCLPermission[] perms = this.getOXFolderAccess().getFolderObject(folderID).getPermissionsAsArray();
            int parent = this.getOXFolderAccess().getParentFolderID(folderID);
            try {
                OXFolderSQL.delWorkingOXFolder(folderID, this.session.getUserId(), lastModified, this.ctx, this.writeCon);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            if (2 == type) {
                new CheckPermissionOnRemove(this.session, this.writeCon, this.ctx).checkPermissionsOnDelete(parent, folderID, perms, lastModified);
            }
            if (FolderQueryCacheManager.isInitialized()) {
                FolderQueryCacheManager.getInstance().invalidateContextQueries(this.ctx.getContextId());
            }
            if (CalendarCache.isInitialized()) {
                CalendarCache.getInstance().invalidateGroup(this.ctx.getContextId());
            }
            ConditionTreeMapManagement.dropFor(this.ctx.getContextId());
            if (FolderCacheManager.isEnabled() && FolderCacheManager.isInitialized()) {
                try {
                    FolderCacheManager.getInstance().removeFolderObject(folderID, this.ctx);
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
            }
            Connection wc = this.writeCon;
            boolean closeWriter = false;
            if (wc == null) {
                wc = DBPool.pickupWriteable(this.ctx);
                closeWriter = true;
            }
            try {
                ServerUserSetting sus = ServerUserSetting.getInstance(wc);
                Integer collectFolder = sus.getContactCollectionFolder(this.ctx.getContextId(), this.user.getId());
                if (null != collectFolder && folderID == collectFolder) {
                    sus.setContactCollectOnMailAccess(this.ctx.getContextId(), this.user.getId(), false);
                    sus.setContactCollectOnMailTransport(this.ctx.getContextId(), this.user.getId(), false);
                    sus.setContactCollectionFolder(this.ctx.getContextId(), this.user.getId(), null);
                }
                this.deleteDependentEntities(wc, storageFolder, false);
                if (hardDelete) break block26;
                FolderObject fo = FolderObject.loadFolderObjectFromDB(folderID, this.ctx, wc, true, false, "del_oxfolder_tree", "del_oxfolder_permissions");
                try {
                    if (8 == fo.getModule()) {
                        FolderObject parentFolder = FolderObject.loadFolderObjectFromDB(fo.getParentFolderID(), this.ctx, wc, true, false);
                        new EventClient(this.session).delete(fo, parentFolder, this.getFolderPath(fo, parentFolder, wc));
                        break block26;
                    }
                    new EventClient(this.session).delete(fo);
                }
                catch (OXException e) {
                    LOG.warn("Delete event could not be enqueued", (Throwable)e);
                }
            }
            finally {
                if (closeWriter) {
                    DBPool.closeWriterSilent(this.ctx, wc);
                }
            }
        }
    }

    private void deleteContainedItems(int folderID) throws OXException {
        int module = this.getOXFolderAccess().getFolderModule(folderID);
        switch (module) {
            case 2: {
                this.deleteContainedAppointments(folderID);
                break;
            }
            case 1: {
                this.deleteContainedTasks(folderID);
                break;
            }
            case 3: {
                this.deleteContainedContacts(folderID);
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                this.deleteContainedDocuments(folderID);
                break;
            }
            default: {
                throw OXFolderExceptionCode.UNKNOWN_MODULE.create(module, this.ctx.getContextId());
            }
        }
    }

    private void deleteContainedAppointments(int folderID) throws OXException {
        try {
            if (null == this.writeCon) {
                this.cSql.deleteAppointmentsInFolder(folderID);
            } else {
                this.cSql.deleteAppointmentsInFolder(folderID, this.writeCon);
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteContainedTasks(int folderID) throws OXException {
        Tasks tasks2 = Tasks.getInstance();
        if (null == this.writeCon) {
            Connection wc = null;
            try {
                wc = DBPool.pickupWriteable(this.ctx);
                tasks2.deleteTasksInFolder(this.session, wc, folderID);
            }
            finally {
                if (null != wc) {
                    DBPool.closeWriterSilent(this.ctx, wc);
                }
            }
        } else {
            tasks2.deleteTasksInFolder(this.session, this.writeCon, folderID);
        }
    }

    private void deleteContainedContacts(int folderID) throws OXException {
        ServerServiceRegistry.getInstance().getService(ContactService.class).deleteContacts(this.session, String.valueOf(folderID));
    }

    private void deleteContainedDocuments(int folderID) throws OXException {
        EventFiringInfostoreFacadeImpl infostoreFacade;
        if (this.writeCon == null) {
            infostoreFacade = new EventFiringInfostoreFacadeImpl(new DBPoolProvider());
        } else {
            infostoreFacade = new EventFiringInfostoreFacadeImpl(new StaticDBPoolProvider(this.writeCon));
            infostoreFacade.setCommitsTransaction(false);
        }
        infostoreFacade.setTransactional(true);
        infostoreFacade.startTransaction();
        try {
            infostoreFacade.removeDocument(folderID, Long.MAX_VALUE, ServerSessionAdapter.valueOf(this.session, this.ctx));
            infostoreFacade.commit();
        }
        catch (OXException x) {
            infostoreFacade.rollback();
            if (InfostoreExceptionCodes.CURRENTLY_LOCKED.equals(x)) {
                throw OXFolderExceptionCode.DELETE_FAILED_LOCKED_DOCUMENTS.create(x, folderID, this.ctx.getContextId());
            }
            throw x;
        }
        catch (RuntimeException x) {
            infostoreFacade.rollback();
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(x, this.ctx.getContextId());
        }
        finally {
            infostoreFacade.finish();
        }
    }

    private TIntObjectMap<TIntObjectMap<?>> gatherDeleteableFolders(int folderID, int userId, UserPermissionBits userPerms, String permissionIDs) throws OXException, OXException, SQLException {
        TIntObjectHashMap deleteableIDs = new TIntObjectHashMap();
        Integer[] specials = new Integer[1];
        Integer i = null;
        ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        if (null != service && service.getBoolProperty("com.openexchange.contactcollector.folder.deleteDenied", false)) {
            i = ServerUserSetting.getInstance(this.writeCon).getContactCollectionFolder(this.ctx.getContextId(), userId);
        }
        specials[0] = i;
        this.gatherDeleteableSubfoldersRecursively(folderID, userId, userPerms, permissionIDs, (TIntObjectMap<TIntObjectMap<?>>)deleteableIDs, folderID, specials);
        return deleteableIDs;
    }

    private void gatherDeleteableSubfoldersRecursively(int folderID, int userId, UserPermissionBits userPerms, String permissionIDs, TIntObjectMap<TIntObjectMap<?>> deleteableIDs, int initParent, Integer[] specials) throws OXException, OXException, SQLException {
        FolderObject delFolder = this.getOXFolderAccess().getFolderObject(folderID);
        if (delFolder.isShared(userId)) {
            throw OXFolderExceptionCode.NO_SHARED_FOLDER_DELETION.create(userId, folderID, this.ctx.getContextId());
        }
        if (delFolder.isDefaultFolder()) {
            throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_DELETION.create(userId, folderID, this.ctx.getContextId());
        }
        EffectivePermission effectivePerm = this.getOXFolderAccess().getFolderPermission(folderID, userId, userPerms);
        if (!effectivePerm.isFolderVisible()) {
            if (!effectivePerm.getUnderlyingPermission().isFolderVisible()) {
                if (initParent == folderID) {
                    throw OXFolderExceptionCode.NOT_VISIBLE.create(folderID, userId, this.ctx.getContextId());
                }
                throw OXFolderExceptionCode.HIDDEN_FOLDER_ON_DELETION.create(initParent, this.ctx.getContextId(), userId);
            }
            if (initParent == folderID) {
                throw OXFolderExceptionCode.NOT_VISIBLE.create(CATEGORY_PERMISSION_DENIED, folderID, userId, this.ctx.getContextId());
            }
            throw OXFolderExceptionCode.HIDDEN_FOLDER_ON_DELETION.create(CATEGORY_PERMISSION_DENIED, initParent, this.ctx.getContextId(), userId);
        }
        if (!effectivePerm.isFolderAdmin()) {
            if (!effectivePerm.getUnderlyingPermission().isFolderAdmin()) {
                throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(userId, folderID, this.ctx.getContextId());
            }
            throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(CATEGORY_PERMISSION_DENIED, userId, folderID, this.ctx.getContextId());
        }
        if (!this.getOXFolderAccess().canDeleteAllObjectsInFolder(delFolder, this.session, this.ctx)) {
            throw OXFolderExceptionCode.NOT_ALL_OBJECTS_DELETION.create(userId, folderID, this.ctx.getContextId());
        }
        for (Integer special : specials) {
            if (null == special || special != folderID) continue;
            throw OXFolderExceptionCode.DELETE_DENIED.create(folderID, this.ctx.getContextId());
        }
        TIntList subfolders = OXFolderSQL.getSubfolderIDs(delFolder.getObjectID(), this.readCon, this.ctx);
        if (subfolders.isEmpty()) {
            deleteableIDs.put(folderID, null);
            return;
        }
        TIntObjectHashMap subMap = new TIntObjectHashMap();
        int size = subfolders.size();
        for (int i = 0; i < size; ++i) {
            this.gatherDeleteableSubfoldersRecursively(subfolders.get(i), userId, userPerms, permissionIDs, (TIntObjectMap<TIntObjectMap<?>>)subMap, initParent, specials);
        }
        deleteableIDs.put(folderID, (Object)subMap);
    }

    private String[] getFolderPath(FolderObject folder, FolderObject parentFolder, Connection connection) throws OXException {
        int startID;
        ArrayList<String> folderPath = new ArrayList<String>();
        folderPath.add(String.valueOf(folder.getObjectID()));
        if (null == parentFolder) {
            startID = folder.getParentFolderID();
            folderPath.add(String.valueOf(startID));
        } else {
            folderPath.add(String.valueOf(parentFolder.getObjectID()));
            startID = parentFolder.getParentFolderID();
            folderPath.add(String.valueOf(startID));
        }
        if (0 != startID) {
            try {
                List<Integer> pathToRoot = OXFolderSQL.getPathToRoot(startID, connection, this.ctx);
                for (Integer id : pathToRoot) {
                    folderPath.add(String.valueOf(id));
                }
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        return folderPath.toArray(new String[folderPath.size()]);
    }

    @Override
    public void cleanUpTestFolders(int[] fuids, Context ctx) {
        for (int fuid : fuids) {
            try {
                OXFolderSQL.hardDeleteOXFolder(fuid, ctx, null);
                ConditionTreeMapManagement.dropFor(ctx.getContextId());
                if (!FolderCacheManager.isEnabled() || !FolderCacheManager.isInitialized()) continue;
                try {
                    FolderCacheManager.getInstance().removeFolderObject(fuid, ctx);
                }
                catch (OXException e) {
                    LOG.warn("", (Throwable)e);
                }
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    private static User getUser(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUser();
        }
        return UserStorage.getInstance().getUser(session.getUserId(), session.getContextId());
    }

    private static OXException handleIncorrectStringError(IncorrectStringSQLException e, Session session) throws OXException {
        String column = e.getColumn();
        if (null == column) {
            return OXFolderExceptionCode.INVALID_CHARACTER_SIMPLE.create(e, new Object[0]);
        }
        String displayName = OXFolderUtility.column2Field(column);
        if (null == displayName) {
            return OXFolderExceptionCode.INVALID_CHARACTER.create(e, e.getIncorrectString(), e.getColumn());
        }
        if (null == session) {
            return OXFolderExceptionCode.INVALID_CHARACTER.create(e, e.getIncorrectString(), displayName);
        }
        String translatedName = StringHelper.valueOf(OXFolderManagerImpl.getUser(session).getLocale()).getString(displayName);
        OXException oxe = OXFolderExceptionCode.INVALID_CHARACTER.create(e, e.getIncorrectString(), translatedName);
        oxe.addProblematic((OXException.ProblematicAttribute)new SimpleIncorrectStringAttribute(fieldMapping.get(column), e.getIncorrectString()));
        return oxe;
    }

    private static Object getFolderValue(int folderField, FolderObject folder) {
        if (300 == folderField) {
            return folder.getFolderName();
        }
        if (1 == folderField) {
            return folder.getObjectID();
        }
        if (20 == folderField) {
            return folder.getParentFolderID();
        }
        if (301 == folderField) {
            return folder.getModule();
        }
        if (302 == folderField) {
            return folder.getType();
        }
        if (4 == folderField) {
            return folder.getCreationDate();
        }
        if (2 == folderField) {
            return folder.getCreatedBy();
        }
        if (5 == folderField) {
            return folder.getLastModified();
        }
        if (3 == folderField) {
            return folder.getModifiedBy();
        }
        throw new IllegalStateException("Unknown folder field ID: " + folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OXException parseTruncated(DataTruncation exc, FolderObject folder, String tableName) {
        OXException fe;
        String[] fields = DBUtils.parseTruncatedFields(exc);
        OXException.Truncated[] truncateds = new OXException.Truncated[fields.length];
        StringBuilder sFields = new StringBuilder(fields.length << 3);
        for (int i = 0; i < fields.length; ++i) {
            sFields.append(fields[i]);
            sFields.append(", ");
            final int fieldId = fieldMapping.get(fields[i]);
            Object tmp = OXFolderManagerImpl.getFolderValue(fieldId, folder);
            final int valueLength = tmp instanceof String ? Charsets.getBytes((String)((String)tmp), (Charset)Charsets.UTF_8).length : 0;
            int tmp2 = -1;
            boolean closeReadCon = false;
            Connection readCon = this.readCon;
            if (readCon == null) {
                try {
                    readCon = DBPool.pickup(this.ctx);
                }
                catch (OXException e) {
                    LOG.error("A readable connection could not be fetched from pool", (Throwable)e);
                    return OXFolderExceptionCode.SQL_ERROR.create(exc, exc.getMessage());
                }
                closeReadCon = true;
            }
            try {
                tmp2 = DBUtils.getColumnSize(readCon, tableName, fields[i]);
            }
            catch (SQLException e) {
                LOG.error("", (Throwable)e);
                tmp2 = -1;
            }
            finally {
                if (closeReadCon) {
                    DBPool.closeReaderSilent(this.ctx, readCon);
                }
            }
            final int length = -1 == tmp2 ? 0 : tmp2;
            truncateds[i] = new OXException.Truncated(){

                public int getId() {
                    return fieldId;
                }

                public int getLength() {
                    return valueLength;
                }

                public int getMaxSize() {
                    return length;
                }
            };
        }
        sFields.setLength(sFields.length() - 2);
        if (truncateds.length > 0) {
            OXException.Truncated truncated = truncateds[0];
            fe = 1 == truncateds.length && 300 == truncated.getId() ? OXFolderExceptionCode.TRUNCATED_FOLDERNAME.create(exc, sFields.toString(), truncated.getMaxSize(), truncated.getLength()) : OXFolderExceptionCode.TRUNCATED.create(exc, sFields.toString(), truncated.getMaxSize(), truncated.getLength());
        } else {
            fe = OXFolderExceptionCode.TRUNCATED.create(exc, sFields.toString(), 0, 0);
        }
        for (OXException.Truncated truncated : truncateds) {
            fe.addProblematic((OXException.ProblematicAttribute)truncated);
        }
        return fe;
    }

    private static int getPublishedMailAttachmentsFolder(Session session) {
        if (null == session) {
            return -1;
        }
        Integer i = (Integer)session.getParameter(MailSessionParameterNames.getParamPublishingInfostoreFolderID());
        return null == i ? -1 : i;
    }

    static {
        HashMap<String, Integer> fieldMapping = new HashMap<String, Integer>(9);
        fieldMapping.put("fuid", 1);
        fieldMapping.put("parent", 20);
        fieldMapping.put("fname", 300);
        fieldMapping.put("module", 301);
        fieldMapping.put("type", 302);
        fieldMapping.put("creating_date", 4);
        fieldMapping.put("created_from", 2);
        fieldMapping.put("changing_date", 5);
        fieldMapping.put("changed_from", 3);
        OXFolderManagerImpl.fieldMapping = Collections.unmodifiableMap(fieldMapping);
    }

    private static final class ProcedureFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1821041261492515385L;

        public ProcedureFailedException(Throwable cause) {
            super(cause);
        }
    }
}

