/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource.json.resultconverter;

import com.openexchange.ajax.anonymizer.AnonymizerService;
import com.openexchange.ajax.anonymizer.Anonymizers;
import com.openexchange.ajax.anonymizer.Module;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.results.CollectionDelta;
import com.openexchange.resource.Resource;
import com.openexchange.resource.json.ResourceWriter;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ResourceJsonResultConverter
implements ResultConverter {
    @Override
    public String getInputFormat() {
        return "resource";
    }

    @Override
    public String getOutputFormat() {
        return "json";
    }

    @Override
    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }

    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        try {
            this.convert0(requestData, result, session);
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void convert0(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException, JSONException {
        Object resultObject = result.getResultObject();
        if (resultObject instanceof Resource) {
            result.setResultObject(ResourceWriter.writeResource(Anonymizers.anonymizeIfGuest((Resource)resultObject, Module.RESOURCE, session)), "json");
        } else if (resultObject instanceof CollectionDelta) {
            JSONArray jDeletedResources;
            List deleted;
            CollectionDelta collectionDelta = (CollectionDelta)resultObject;
            List resources = collectionDelta.getNewAndModified();
            JSONArray jResources = new JSONArray(resources.size());
            if (Anonymizers.isGuest(session)) {
                AnonymizerService<Resource> anonymizer = Anonymizers.optAnonymizerFor(Module.RESOURCE);
                for (Resource resource : resources) {
                    resource = anonymizer.anonymize(resource, session);
                    jResources.put((Object)ResourceWriter.writeResource(resource));
                }
            } else {
                for (Resource resource : resources) {
                    jResources.put((Object)ResourceWriter.writeResource(resource));
                }
            }
            if (null == (deleted = collectionDelta.getDeleted())) {
                jDeletedResources = new JSONArray(0);
            } else {
                jDeletedResources = new JSONArray(deleted.size());
                if (Anonymizers.isGuest(session)) {
                    AnonymizerService<Resource> anonymizer = Anonymizers.optAnonymizerFor(Module.RESOURCE);
                    for (Resource resource : deleted) {
                        resource = anonymizer.anonymize(resource, session);
                        jDeletedResources.put((Object)ResourceWriter.writeResource(resource));
                    }
                } else {
                    for (Resource resource : deleted) {
                        jDeletedResources.put((Object)ResourceWriter.writeResource(resource));
                    }
                }
            }
            JSONObject jResult = new JSONObject(3);
            jResult.put("new", (Object)jResources).put("modified", (Object)jResources);
            jResult.put("deleted", (Object)jDeletedResources);
            result.setResultObject(jResult, "json");
        } else if ("all".equalsIgnoreCase(requestData.getAction())) {
            Collection resources = (Collection)resultObject;
            JSONArray jIdentifiers = new JSONArray(resources.size());
            for (Resource resource : resources) {
                jIdentifiers.put(resource.getIdentifier());
            }
            result.setResultObject(jIdentifiers, "json");
        } else {
            Collection resources = (Collection)resultObject;
            JSONArray jResources = new JSONArray(resources.size());
            if (Anonymizers.isGuest(session)) {
                AnonymizerService<Resource> anonymizer = Anonymizers.optAnonymizerFor(Module.RESOURCE);
                for (Resource resource : resources) {
                    resource = anonymizer.anonymize(resource, session);
                    jResources.put((Object)ResourceWriter.writeResource(resource));
                }
            } else {
                for (Resource resource : resources) {
                    jResources.put((Object)ResourceWriter.writeResource(resource));
                }
            }
            result.setResultObject(jResources, "json");
        }
    }
}

