/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.report.internal;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.impl.ContextExceptionCodes;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.arrays.Arrays;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.array.TIntArrayList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class Tools {
    public static List<Integer> getAllContextIds() throws OXException {
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        ArrayList<Integer> retval = new ArrayList<Integer>();
        Connection readConnection = dbService.getReadOnly();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = readConnection.prepareStatement("SELECT cid FROM context");
            result = stmt.executeQuery();
            while (result.next()) {
                retval.add(result.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                throw ContextExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                dbService.backReadOnly(readConnection);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        dbService.backReadOnly(readConnection);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User[] getUser(int contextId) throws OXException {
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection readOnly = dbService.getReadOnly(contextId);
        ArrayList<UserImpl> users = new ArrayList<UserImpl>();
        try {
            int[] userIds = Tools.listAllUser(contextId, readOnly);
            int length = userIds.length;
            if (0 == length) {
                User[] userArray = new User[]{};
                return userArray;
            }
            for (int i = 0; i < length; i += 1000) {
                PreparedStatement stmt = null;
                ResultSet result = null;
                try {
                    int[] currentUserIds = Arrays.extract((int[])userIds, (int)i, (int)1000);
                    stmt = readOnly.prepareStatement(DBUtils.getIN("SELECT id,mailEnabled,mail,guestCreatedBy FROM user WHERE user.cid=? AND id IN (", currentUserIds.length));
                    int pos = 1;
                    stmt.setInt(pos++, contextId);
                    for (int userId : currentUserIds) {
                        stmt.setInt(pos++, userId);
                    }
                    result = stmt.executeQuery();
                    while (result.next()) {
                        UserImpl user = new UserImpl();
                        pos = 1;
                        user.setId(result.getInt(pos++));
                        user.setMailEnabled(result.getBoolean(pos++));
                        user.setMail(result.getString(pos++));
                        user.setCreatedBy(result.getInt(pos++));
                        users.add(user);
                    }
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(result, stmt);
            }
        }
        catch (SQLException e) {
            throw UserExceptionCode.LOAD_FAILED.create(e, e.getMessage());
        }
        finally {
            dbService.backReadOnly(contextId, readOnly);
        }
        return users.toArray(new User[users.size()]);
    }

    private static int[] listAllUser(int contextID, Connection con) throws OXException {
        int[] users;
        StringBuilder stringBuilder = new StringBuilder("SELECT id FROM user WHERE cid=?");
        String sql = stringBuilder.toString();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, contextID);
            result = stmt.executeQuery();
            TIntArrayList tmp = new TIntArrayList();
            while (result.next()) {
                tmp.add(result.getInt(1));
            }
            users = tmp.toArray();
        }
        catch (SQLException e) {
            try {
                throw UserExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return users;
    }

    public static final Map<String, Integer> getAllSchemata(Logger logger) throws SQLException, OXException {
        Connection readcon;
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        LinkedHashMap<String, Integer> schemaMap = new LinkedHashMap<String, Integer>(50);
        try {
            readcon = dbService.getReadOnly();
        }
        catch (OXException e) {
            logger.error("", (Throwable)e);
            throw e;
        }
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = readcon.createStatement();
            rs = statement.executeQuery("SELECT read_db_pool_id, db_schema FROM context_server2db_pool GROUP BY db_schema");
            while (rs.next()) {
                schemaMap.put(rs.getString(2), rs.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                logger.error("", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, statement);
                dbService.backReadOnly(readcon);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, statement);
        dbService.backReadOnly(readcon);
        return schemaMap;
    }
}

