/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.java.Strings;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import java.util.ArrayList;
import javax.mail.internet.InternetAddress;

public final class PlainTextAddress
extends InternetAddress {
    private static final long serialVersionUID = -3276144799717449603L;
    private static final String TYPE = "rfc822";
    private final String plainAddress;
    private final int hashCode;

    public static PlainTextAddress[] getAddresses(String[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return new PlainTextAddress[0];
        }
        PlainTextAddress[] retval = new PlainTextAddress[addresses.length];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = new PlainTextAddress(addresses[i]);
        }
        return retval;
    }

    public static InternetAddress[] parseAddresses(String addressList) {
        if (Strings.isEmpty((String)addressList)) {
            return new PlainTextAddress[0];
        }
        String[] addrs = Strings.splitByCommaNotInQuotes((String)addressList);
        ArrayList<PlainTextAddress> l = new ArrayList<PlainTextAddress>(addrs.length);
        for (String addr : addrs) {
            l.add(new PlainTextAddress(addr));
        }
        return l.toArray(new InternetAddress[l.size()]);
    }

    public PlainTextAddress(String address) {
        this.plainAddress = MimeMessageUtility.decodeMultiEncodedHeader(address);
        this.hashCode = Strings.asciiLowerCase((String)address).hashCode();
    }

    public String getType() {
        return TYPE;
    }

    public String toString() {
        return this.plainAddress;
    }

    public String getAddress() {
        return this.plainAddress;
    }

    public String getPersonal() {
        return null;
    }

    public boolean equals(Object address) {
        if (address instanceof InternetAddress) {
            InternetAddress ia = (InternetAddress)address;
            return this.plainAddress.equalsIgnoreCase(ia.getAddress());
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toUnicodeString() {
        return this.plainAddress;
    }
}

