/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.writer;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.html.HtmlService;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.json.writer.MessageWriter;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.text.Enriched2HtmlConverter;
import com.openexchange.mail.text.HtmlProcessing;
import com.openexchange.mail.text.Rtf2HtmlConverter;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.utils.DisplayMode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.TimeZoneUtils;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JSONObjectConverter {
    private final Session session;
    private final Context ctx;
    private final JSONObject rawJSONMailObject;
    private TimeZone timeZone;
    private final UserSettingMail usm;
    private final DisplayMode displayMode;
    private final MailPath mailPath;
    private final boolean[] modified;
    private static final Enriched2HtmlConverter ENRCONV = new Enriched2HtmlConverter();

    public JSONObjectConverter(JSONObject rawJSONMailObject, DisplayMode displayMode, Session session, UserSettingMail usm, Context ctx) throws OXException {
        this.rawJSONMailObject = rawJSONMailObject;
        this.modified = new boolean[1];
        this.session = session;
        this.ctx = ctx;
        this.usm = usm;
        this.displayMode = displayMode;
        String key = MailJSONField.MSGREF.getKey();
        String mailPathStr = rawJSONMailObject.optString(key);
        this.mailPath = null != mailPathStr ? new MailPath(mailPathStr) : null;
    }

    private TimeZone getTimeZone() throws OXException {
        if (this.timeZone == null) {
            this.timeZone = TimeZoneUtils.getTimeZone(UserStorage.getInstance().getUser(this.session.getUserId(), this.ctx).getTimeZone());
        }
        return this.timeZone;
    }

    public JSONObject raw2Json() throws OXException {
        try {
            JSONObject jsonObject = new JSONObject();
            if (DisplayMode.MODIFYABLE.equals((Object)this.displayMode) && null != this.mailPath) {
                jsonObject.put(MailJSONField.MSGREF.getKey(), (Object)this.mailPath.toString());
            }
            JSONObjectConverter.copyValue("folder_id", this.rawJSONMailObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.UNREAD.getKey(), this.rawJSONMailObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.ACCOUNT_NAME.getKey(), this.rawJSONMailObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.ACCOUNT_ID.getKey(), this.rawJSONMailObject, jsonObject);
            this.raw2JsonMail0(this.rawJSONMailObject, jsonObject);
            return jsonObject;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void raw2JsonMail0(JSONObject rawJSONMailObject, JSONObject jsonObject) throws OXException {
        try {
            JSONObjectConverter.copyValue("id", rawJSONMailObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.ATTACHMENT_FILE_NAME.getKey(), rawJSONMailObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.HAS_ATTACHMENTS.getKey(), rawJSONMailObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.CONTENT_TYPE.getKey(), rawJSONMailObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.SIZE.getKey(), rawJSONMailObject, jsonObject);
            this.raw2Json0(rawJSONMailObject, jsonObject);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void raw2Json0(JSONObject rawJSONMailObject, JSONObject jsonObject) throws OXException {
        try {
            JSONObject jo;
            JSONArray bodyArr;
            JSONObjectConverter.copyValue(MailJSONField.RECIPIENT_BCC.getKey(), rawJSONMailObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.RECIPIENT_CC.getKey(), rawJSONMailObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.COLOR_LABEL.getKey(), rawJSONMailObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.CID.getKey(), rawJSONMailObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.FROM.getKey(), rawJSONMailObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.PRIORITY.getKey(), rawJSONMailObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.VCARD.getKey(), rawJSONMailObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.DISPOSITION_NOTIFICATION_TO.getKey(), rawJSONMailObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.HEADERS.getKey(), rawJSONMailObject, jsonObject);
            String key = MailJSONField.RECEIVED_DATE.getKey();
            if (rawJSONMailObject.hasAndNotNull(key)) {
                long receivedDateMillis = rawJSONMailObject.getLong(key);
                jsonObject.put(key, MessageWriter.addUserTimezone(receivedDateMillis, this.getTimeZone()));
            } else {
                jsonObject.put(key, JSONObject.NULL);
            }
            key = MailJSONField.SENT_DATE.getKey();
            if (rawJSONMailObject.hasAndNotNull(key)) {
                long sentDateMillis = rawJSONMailObject.getLong(key);
                jsonObject.put(key, MessageWriter.addUserTimezone(sentDateMillis, this.getTimeZone()));
            } else {
                jsonObject.put(key, JSONObject.NULL);
            }
            JSONObjectConverter.copyValue(MailJSONField.SUBJECT.getKey(), rawJSONMailObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.FLAGS.getKey(), rawJSONMailObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.RECIPIENT_TO.getKey(), rawJSONMailObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.USER.getKey(), rawJSONMailObject, jsonObject);
            JSONArray attachmentsArr = new JSONArray();
            JSONArray opt = rawJSONMailObject.optJSONArray("body");
            if (null == opt || 0 == opt.length()) {
                bodyArr = new JSONArray();
                bodyArr.put((Object)JSONObjectConverter.dummyObject());
            } else {
                bodyArr = opt;
            }
            int bodyLen = bodyArr.length();
            if (this.usm.isDisplayHtmlInlineContent()) {
                JSONObject htmlObject = JSONObjectConverter.extractObject(bodyArr, "text/htm");
                if (null == htmlObject) {
                    jo = 0 == bodyLen ? JSONObjectConverter.dummyObject() : bodyArr.getJSONObject(0);
                    this.handleTextPart(jo, attachmentsArr);
                } else {
                    this.handleHTMLPart(htmlObject, attachmentsArr);
                }
            } else {
                JSONObject textObject = JSONObjectConverter.extractObject(bodyArr, "text/plain", "text/enriched", "text/richtext", "text/rtf");
                if (null == textObject) {
                    if (bodyLen == 0) {
                        jo = JSONObjectConverter.dummyObject();
                        this.handleTextPart(jo, attachmentsArr);
                    } else {
                        jo = bodyArr.getJSONObject(0);
                        if (DisplayMode.MODIFYABLE.getMode() <= this.displayMode.getMode()) {
                            this.asDisplayText(jo, jo.getString(MailJSONField.CONTENT.getKey()), DisplayMode.DISPLAY.equals((Object)this.displayMode), attachmentsArr);
                        } else if (DisplayMode.RAW.equals((Object)this.displayMode)) {
                            attachmentsArr.put((Object)jo);
                        } else {
                            attachmentsArr.put((Object)jo);
                        }
                    }
                } else {
                    this.handleTextPart(textObject, attachmentsArr);
                }
            }
            JSONArray attachArr = rawJSONMailObject.optJSONArray(MailJSONField.ATTACHMENTS.getKey());
            if (null != attachArr) {
                int len = attachArr.length();
                for (int i = 0; i < len; ++i) {
                    attachmentsArr.put(attachArr.get(i));
                }
            }
            jsonObject.put(MailJSONField.ATTACHMENTS.getKey(), (Object)attachmentsArr);
            JSONArray nestedMsgs = rawJSONMailObject.optJSONArray(MailJSONField.NESTED_MESSAGES.getKey());
            if (null != nestedMsgs) {
                JSONArray nestedMessages = new JSONArray();
                int len = nestedMsgs.length();
                for (int i = 0; i < len; ++i) {
                    JSONObject nestedMsg = nestedMsgs.getJSONObject(i);
                    JSONObject jo2 = new JSONObject();
                    this.raw2JsonMail0(nestedMsg, jo2);
                    nestedMessages.put((Object)jo2);
                }
                jsonObject.put(MailJSONField.NESTED_MESSAGES.getKey(), (Object)nestedMessages);
            }
            if (!jsonObject.has(MailJSONField.MODIFIED.getKey())) {
                jsonObject.put(MailJSONField.MODIFIED.getKey(), this.modified[0] ? 1 : 0);
            }
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void handleTextPart(JSONObject textObject, JSONArray attachmentsArr) throws OXException, JSONException {
        if (DisplayMode.MODIFYABLE.getMode() <= this.displayMode.getMode()) {
            String displayVersion = this.getHtmlDisplayVersion(new ContentType(textObject.getString(MailJSONField.CONTENT_TYPE.getKey())), textObject.getString(MailJSONField.CONTENT.getKey()));
            this.asPlainText(textObject, displayVersion, attachmentsArr);
        } else if (DisplayMode.RAW.equals((Object)this.displayMode)) {
            attachmentsArr.put((Object)textObject);
        } else {
            attachmentsArr.put((Object)textObject);
        }
    }

    private void handleHTMLPart(JSONObject htmlObject, JSONArray attachmentsArr) throws OXException {
        if (DisplayMode.MODIFYABLE.getMode() <= this.displayMode.getMode()) {
            this.asDisplayHtml(htmlObject, attachmentsArr);
        } else if (DisplayMode.RAW.equals((Object)this.displayMode)) {
            attachmentsArr.put((Object)htmlObject);
        } else {
            attachmentsArr.put((Object)htmlObject);
        }
    }

    private void asAttachment(JSONObject bodyObject, JSONArray attachmentsArr) throws OXException {
        try {
            JSONObject jsonObject = new JSONObject();
            JSONObjectConverter.copyValue(MailListField.ID.getKey(), bodyObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.CONTENT_TYPE.getKey(), bodyObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.DISPOSITION.getKey(), bodyObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.SIZE.getKey(), bodyObject, jsonObject);
            JSONObjectConverter.copyValue(MailJSONField.ATTACHMENT_FILE_NAME.getKey(), bodyObject, jsonObject);
            jsonObject.put(MailJSONField.CONTENT.getKey(), JSONObject.NULL);
            attachmentsArr.put((Object)jsonObject);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void asPlainText(JSONObject textObject, String content, JSONArray attachmentsArr) throws OXException {
        try {
            JSONObject jsonObject = new JSONObject();
            JSONObjectConverter.copyValue(MailListField.ID.getKey(), textObject, jsonObject);
            jsonObject.put(MailJSONField.DISPOSITION.getKey(), (Object)"inline");
            jsonObject.put(MailJSONField.CONTENT_TYPE.getKey(), (Object)"text/plain");
            jsonObject.put(MailJSONField.SIZE.getKey(), content.length());
            jsonObject.put(MailJSONField.CONTENT.getKey(), (Object)content);
            attachmentsArr.put((Object)jsonObject);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void asDisplayHtml(JSONObject htmlObject, JSONArray attachmentsArr) throws OXException {
        try {
            JSONObject jsonObject = new JSONObject();
            JSONObjectConverter.copyValue(MailListField.ID.getKey(), htmlObject, jsonObject);
            String content = HtmlProcessing.formatHTMLForDisplay(htmlObject.getString(MailJSONField.CONTENT.getKey()), "UTF-8", this.session, this.mailPath, this.usm, this.modified, this.displayMode, false);
            jsonObject.put(MailJSONField.CONTENT.getKey(), (Object)content);
            jsonObject.put(MailJSONField.CONTENT_TYPE.getKey(), (Object)"text/html");
            jsonObject.put(MailJSONField.SIZE.getKey(), content.length());
            jsonObject.put(MailJSONField.DISPOSITION.getKey(), (Object)"inline");
            attachmentsArr.put((Object)jsonObject);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void asDisplayHtml(JSONObject htmlObject, String content, JSONArray attachmentsArr) throws OXException {
        try {
            JSONObject jsonObject = new JSONObject();
            JSONObjectConverter.copyValue(MailListField.ID.getKey(), htmlObject, jsonObject);
            jsonObject.put(MailJSONField.CONTENT.getKey(), (Object)content);
            JSONObjectConverter.copyValue(MailJSONField.CONTENT_TYPE.getKey(), htmlObject, jsonObject);
            jsonObject.put(MailJSONField.SIZE.getKey(), content.length());
            jsonObject.put(MailJSONField.DISPOSITION.getKey(), (Object)"inline");
            attachmentsArr.put((Object)jsonObject);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void asDisplayText(JSONObject htmlObject, String htmlContent, boolean addAttachment, JSONArray attachmentsArr) throws OXException {
        try {
            JSONObject jsonObject = new JSONObject();
            JSONObjectConverter.copyValue(MailListField.ID.getKey(), htmlObject, jsonObject);
            jsonObject.put(MailJSONField.CONTENT_TYPE.getKey(), (Object)"text/plain");
            HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
            String plainText = htmlService.html2text(htmlContent, true);
            String content = HtmlProcessing.formatTextForDisplay(plainText, this.usm, this.displayMode);
            jsonObject.put(MailJSONField.DISPOSITION.getKey(), (Object)"inline");
            JSONObjectConverter.copyValue(MailJSONField.SIZE.getKey(), htmlObject, jsonObject);
            jsonObject.put(MailJSONField.CONTENT.getKey(), (Object)content);
            attachmentsArr.put((Object)jsonObject);
            if (addAttachment) {
                JSONObject originalVersion = new JSONObject();
                JSONObjectConverter.copyValue(MailListField.ID.getKey(), htmlObject, originalVersion);
                jsonObject.put(MailJSONField.CONTENT_TYPE.getKey(), (Object)"text/html");
                originalVersion.put(MailJSONField.DISPOSITION.getKey(), (Object)"attachment");
                originalVersion.put(MailJSONField.SIZE.getKey(), htmlContent.length());
                originalVersion.put(MailJSONField.CONTENT.getKey(), JSONObject.NULL);
                String fileName = htmlObject.optString(MailJSONField.ATTACHMENT_FILE_NAME.getKey());
                if (fileName == null) {
                    originalVersion.put(MailJSONField.ATTACHMENT_FILE_NAME.getKey(), JSONObject.NULL);
                } else {
                    originalVersion.put(MailJSONField.ATTACHMENT_FILE_NAME.getKey(), (Object)MimeMessageUtility.decodeMultiEncodedHeader(fileName));
                }
                attachmentsArr.put((Object)originalVersion);
            }
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private String getHtmlDisplayVersion(ContentType contentType, String src) {
        String baseType = contentType.getBaseType().toLowerCase(Locale.ENGLISH);
        if (baseType.startsWith("text/enriched") || baseType.startsWith("text/richtext")) {
            return HtmlProcessing.formatHTMLForDisplay(ENRCONV.convert(src), contentType.getCharsetParameter(), this.session, this.mailPath, this.usm, this.modified, this.displayMode, false);
        }
        if (baseType.startsWith("text/rtf")) {
            return HtmlProcessing.formatHTMLForDisplay(Rtf2HtmlConverter.convertRTFToHTML(src), contentType.getCharsetParameter(), this.session, this.mailPath, this.usm, this.modified, this.displayMode, false);
        }
        return HtmlProcessing.formatTextForDisplay(src, this.usm, this.displayMode);
    }

    private static JSONObject extractObject(JSONArray bodyArr, String ... contentTypes) throws JSONException {
        JSONObject retval = null;
        int bodyLen = bodyArr.length();
        for (int i = 0; null == retval && i < bodyLen; ++i) {
            JSONObject jsonObject = bodyArr.getJSONObject(i);
            String ct = jsonObject.optString(MailJSONField.CONTENT_TYPE.getKey());
            if (null == ct || !JSONObjectConverter.startsWithEither(ct, contentTypes)) continue;
            retval = jsonObject;
        }
        return retval;
    }

    private static boolean startsWithEither(String s, String[] prefixes) {
        boolean startsWith = false;
        for (int i = 0; !startsWith && i < prefixes.length; ++i) {
            startsWith = s.startsWith(prefixes[i]);
        }
        return startsWith;
    }

    private static JSONObject dummyObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(MailJSONField.DISPOSITION.getKey(), (Object)"inline");
        jsonObject.put(MailJSONField.CONTENT_TYPE.getKey(), (Object)"text/plain");
        jsonObject.put(MailJSONField.SIZE.getKey(), 0);
        jsonObject.put(MailJSONField.CONTENT.getKey(), (Object)"");
        return jsonObject;
    }

    private static void copyValue(String key, JSONObject src, JSONObject dst) throws JSONException {
        if (src.hasAndNotNull(key)) {
            dst.put(key, src.opt(key));
        }
    }
}

