/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.helper.DownloadUtility;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Streams;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipException;
import javax.mail.MessageRemovedException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

@Action(method=RequestMethod.GET, name="zip_attachments", description="Get multiple mail attachments as a ZIP file.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", description="The folder identifier."), @Parameter(name="id", description="Object ID of the mail which contains the attachments."), @Parameter(name="attachment", description="A comma-separated list of IDs of the requested attachments")}, responseDescription="The raw byte data of the ZIP file.")
public final class GetMultipleAttachmentAction
extends AbstractMailAction {
    public GetMultipleAttachmentAction(ServiceLookup services) {
        super(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        try {
            String folderPath = req.checkParameter("folder");
            String uid = req.checkParameter("id");
            String[] sequenceIds = req.optStringArray("attachment");
            MailServletInterface mailInterface = this.getMailInterface(req);
            ManagedFile mf = null;
            String fullFileName = this.getFileName(req.getSession().getUser().getLocale(), mailInterface.getMessage(folderPath, uid));
            AJAXRequestData ajaxRequestData = req.getRequest();
            if (null != ajaxRequestData && ajaxRequestData.setResponseHeader("Content-Type", "application/zip")) {
                try {
                    StringBuilder sb = new StringBuilder(512);
                    sb.append("attachment");
                    DownloadUtility.appendFilenameParameter(fullFileName, "application/zip", ajaxRequestData.getUserAgent(), sb);
                    ajaxRequestData.setResponseHeader("Content-Disposition", sb.toString());
                    this.createZipArchive(folderPath, uid, sequenceIds, mailInterface, ajaxRequestData.optOutputStream());
                    AJAXRequestResult aJAXRequestResult = new AJAXRequestResult(AJAXRequestResult.DIRECT_OBJECT, "direct").setType(AJAXRequestResult.ResultType.DIRECT);
                    return aJAXRequestResult;
                }
                catch (IOException e) {
                    throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
                }
            }
            mf = mailInterface.getMessageAttachments(folderPath, uid, sequenceIds);
            ThresholdFileHolder fileHolder = new ThresholdFileHolder();
            InputStream zipInputStream = mf.getInputStream();
            try {
                fileHolder.write(zipInputStream);
            }
            finally {
                Streams.close((Closeable)zipInputStream);
            }
            req.getRequest().setFormat("file");
            fileHolder.setName(fullFileName);
            fileHolder.setContentType("application/zip");
            return new AJAXRequestResult((Object)fileHolder, "file");
            finally {
                if (null != mf) {
                    mf.delete();
                    mf = null;
                }
            }
        }
        catch (OXException e) {
            if (!(e.getCause() instanceof IOException)) throw e;
            IOException ioe = (IOException)e.getCause();
            if ("com.sun.mail.util.MessageRemovedIOException".equals(ioe.getClass().getName())) throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(ioe, new Object[0]);
            if (!(e.getCause() instanceof MessageRemovedException)) throw e;
            throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(ioe, new Object[0]);
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    protected String getFileName(Locale userLocale, MailMessage message) {
        String fileName = message.getSubject();
        if (fileName == null) {
            fileName = StringHelper.valueOf(userLocale).getString("[No Subject]");
        }
        return fileName + ".zip";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createZipArchive(String folderPath, String uid, String[] sequenceIds, MailServletInterface mailInterface, OutputStream out) throws OXException {
        ZipArchiveOutputStream zipOutput = new ZipArchiveOutputStream(out);
        zipOutput.setEncoding("UTF-8");
        zipOutput.setUseLanguageEncodingFlag(true);
        try {
            int buflen = 8192;
            byte[] buf = new byte[8192];
            if (null == sequenceIds) {
                for (MailPart mailPart : mailInterface.getAllMessageAttachments(folderPath, uid)) {
                    this.addPart2Archive(mailPart, zipOutput, 8192, buf);
                }
            } else {
                for (String sequenceId : sequenceIds) {
                    MailPart mailPart = mailInterface.getMessageAttachment(folderPath, uid, sequenceId, false);
                    this.addPart2Archive(mailPart, zipOutput, 8192, buf);
                }
            }
        }
        finally {
            Streams.close((Closeable)zipOutput);
        }
    }

    private void addPart2Archive(MailPart mailPart, ZipArchiveOutputStream zipOutput, int buflen, byte[] buf) throws OXException {
        InputStream in = mailPart.getInputStream();
        try {
            int read;
            ZipArchiveEntry entry;
            String name = mailPart.getFileName();
            if (null == name) {
                List<String> extensions = MimeType2ExtMap.getFileExtensions(mailPart.getContentType().getBaseType());
                name = extensions == null || extensions.isEmpty() ? "part.dat" : "part." + extensions.get(0);
            }
            int num = 1;
            while (true) {
                try {
                    int pos = name.indexOf(46);
                    String entryName = pos < 0 ? name + (num > 1 ? "_(" + num + ")" : "") : name.substring(0, pos) + (num > 1 ? "_(" + num + ")" : "") + name.substring(pos);
                    entry = new ZipArchiveEntry(entryName);
                    zipOutput.putArchiveEntry((ArchiveEntry)entry);
                }
                catch (ZipException e) {
                    String message = e.getMessage();
                    if (message == null || !message.startsWith("duplicate entry")) {
                        throw e;
                    }
                    ++num;
                    continue;
                }
                break;
            }
            long size = 0L;
            while ((read = in.read(buf, 0, buflen)) > 0) {
                zipOutput.write(buf, 0, read);
                size += (long)read;
            }
            entry.setSize(size);
            zipOutput.closeArchiveEntry();
        }
        catch (IOException e) {
            throw FileStorageExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            Streams.close((Closeable)in);
        }
    }
}

