/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.attachment.AttachmentToken;
import com.openexchange.mail.attachment.AttachmentTokenService;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.session.ServerSession;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.GET, name="attachmentToken", description="Get an attachment token.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", description="The folder identifier."), @Parameter(name="id", description="Object ID of the mail which contains the attachment."), @Parameter(name="attachment", description="ID of the requested attachment OR"), @Parameter(name="cid", description="Value of header 'Content-ID' of the requested attachment")}, responseDescription="A JSON object providing the attachment token")
@DispatcherNotes(allowPublicSession=true)
public final class GetAttachmentTokenAction
extends AbstractMailAction {
    public GetAttachmentTokenAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        try {
            MailServletInterface mailInterface;
            MailPart mailPart;
            boolean checkIp;
            int ttlMillis;
            ServerSession session = req.getSession();
            String folderPath = req.checkParameter("folder");
            String uid = req.checkParameter("id");
            String sequenceId = req.getParameter("attachment");
            String imageContentId = req.getParameter("cid");
            if (sequenceId == null && imageContentId == null) {
                throw MailExceptionCode.MISSING_PARAM.create("attachment" + " | " + "cid");
            }
            String tmp = req.getParameter("ttlMillis");
            try {
                ttlMillis = tmp == null ? -1 : Integer.parseInt(tmp.trim());
            }
            catch (NumberFormatException e) {
                ttlMillis = -1;
            }
            String tmp2 = req.getParameter("oneTime");
            boolean oneTime = null == tmp2 ? false : Boolean.parseBoolean(tmp2.trim());
            String tmp3 = req.getParameter("checkIp");
            boolean bl = checkIp = null == tmp3 ? false : Boolean.parseBoolean(tmp3.trim());
            if (AJAXRequestDataTools.parseBoolParameter("checkPart", req.getRequest()) && (mailPart = (mailInterface = this.getMailInterface(req)).getMessageAttachment(folderPath, uid, sequenceId, true)) == null) {
                throw MailExceptionCode.NO_ATTACHMENT_FOUND.create(sequenceId);
            }
            AttachmentToken token = new AttachmentToken(ttlMillis <= 0 ? 3600000L : (long)ttlMillis);
            token.setAccessInfo(MailFolderUtility.prepareMailFolderParam(folderPath).getAccountId(), session);
            token.setAttachmentInfo(folderPath, uid, sequenceId);
            AttachmentTokenService service = ServerServiceRegistry.getInstance().getService(AttachmentTokenService.class, true);
            service.putToken(token.setOneTime(oneTime).setCheckIp(checkIp), session);
            JSONObject attachmentObject = new JSONObject(2);
            attachmentObject.put("id", (Object)token.getId());
            attachmentObject.put("jsessionid", (Object)token.getJSessionId());
            return new AJAXRequestResult((Object)attachmentObject, "json");
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

