/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.compose;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.compose.CompositionSpaceRegistry;
import com.openexchange.mail.compose.CompositionSpaces;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.PutIfAbsent;
import com.openexchange.session.Session;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositionSpace {
    private static final String PARAM_REGISTRY = "__comp.registry";
    final String id;
    private volatile MailPath replyFor;
    private final Queue<MailPath> forwardsFor;
    private final Queue<MailPath> draftEditsFor;
    private final Queue<MailPath> cleanUps;
    volatile long lastAccessed;
    final long idleTime;
    final Session session;
    private volatile ScheduledTimerTask scheduledTimerTask;

    static CompositionSpaceRegistry getRegistry(Session session) {
        CompositionSpaceRegistry newRegistry;
        CompositionSpaceRegistry registry = (CompositionSpaceRegistry)session.getParameter(PARAM_REGISTRY);
        if (null == registry && null == (registry = (CompositionSpaceRegistry)((PutIfAbsent)session).setParameterIfAbsent(PARAM_REGISTRY, (Object)(newRegistry = new CompositionSpaceRegistry())))) {
            registry = newRegistry;
        }
        return registry;
    }

    public static void destroyCompositionSpace(String csid, boolean apply, Session session) {
        if (apply) {
            try {
                CompositionSpaces.applyCompositionSpace(csid, session);
            }
            catch (Exception e) {
                Logger logger = LoggerFactory.getLogger(CompositionSpace.class);
                logger.warn("Failed to apply composition space", (Throwable)e);
            }
        }
        CompositionSpaces.destroy(csid, session);
    }

    public static CompositionSpace getCompositionSpace(String csid, Session session) {
        return CompositionSpace.getRegistry(session).getCompositionSpace(csid, session);
    }

    public static CompositionSpace optCompositionSpace(String csid, Session session) {
        CompositionSpaceRegistry registry = (CompositionSpaceRegistry)session.getParameter(PARAM_REGISTRY);
        if (null == registry) {
            return null;
        }
        return registry.optCompositionSpace(csid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropCompositionSpaces(Session session) {
        CompositionSpaceRegistry registry = (CompositionSpaceRegistry)session.getParameter(PARAM_REGISTRY);
        if (null != registry) {
            try {
                CompositionSpaces.destroy(registry, session);
            }
            finally {
                session.setParameter(PARAM_REGISTRY, null);
            }
        }
    }

    CompositionSpace(String id, Session session) {
        this.session = session;
        this.id = id;
        this.cleanUps = new ConcurrentLinkedQueue<MailPath>();
        this.forwardsFor = new ConcurrentLinkedQueue<MailPath>();
        this.draftEditsFor = new ConcurrentLinkedQueue<MailPath>();
        this.idleTime = TimeUnit.MINUTES.toMillis(15L);
        this.lastAccessed = System.currentTimeMillis();
    }

    void markActive() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (System.currentTimeMillis() - CompositionSpace.this.lastAccessed > CompositionSpace.this.idleTime) {
                    CompositionSpaces.destroy(CompositionSpace.this.id, CompositionSpace.this.session);
                }
            }
        };
        TimerService timerService = ServerServiceRegistry.getInstance().getService(TimerService.class);
        this.scheduledTimerTask = timerService.scheduleAtFixedRate(task, 5L, 5L, TimeUnit.MINUTES);
    }

    void markInactive() {
        ScheduledTimerTask scheduledTimerTask = this.scheduledTimerTask;
        if (null != scheduledTimerTask) {
            scheduledTimerTask.cancel();
            this.scheduledTimerTask = null;
        }
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public CompositionSpace touch() {
        this.lastAccessed = System.currentTimeMillis();
        return this;
    }

    public String getId() {
        return this.id;
    }

    private boolean isMarkedAsReplyOrForward0(MailPath toCheck, boolean considerReply, boolean considerForward) {
        if (considerReply && this.areEqual(toCheck, this.replyFor)) {
            return true;
        }
        if (considerForward) {
            for (MailPath forwardFor : this.forwardsFor) {
                if (!this.areEqual(toCheck, forwardFor)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMarkedAsReplyOrForward(MailPath toCheck) {
        if (null == toCheck) {
            return false;
        }
        return this.isMarkedAsReplyOrForward0(toCheck, true, true);
    }

    public boolean isMarkedAsReply(MailPath toCheck) {
        if (null == toCheck) {
            return false;
        }
        return this.isMarkedAsReplyOrForward0(toCheck, true, false);
    }

    public boolean isMarkedAsForward(MailPath toCheck) {
        if (null == toCheck) {
            return false;
        }
        return this.isMarkedAsReplyOrForward0(toCheck, false, true);
    }

    public Queue<MailPath> getDraftEditsFor() {
        return this.draftEditsFor;
    }

    public void addDraftEditFor(MailPath draftEditFor) {
        this.draftEditsFor.offer(draftEditFor);
        this.lastAccessed = System.currentTimeMillis();
    }

    public MailPath getReplyFor() {
        return this.replyFor;
    }

    public void setReplyFor(MailPath replyFor) {
        this.replyFor = replyFor;
        this.lastAccessed = System.currentTimeMillis();
    }

    public Queue<MailPath> getForwardsFor() {
        return this.forwardsFor;
    }

    public void addForwardFor(MailPath forwardFor) {
        this.forwardsFor.offer(forwardFor);
        this.lastAccessed = System.currentTimeMillis();
    }

    public Queue<MailPath> getCleanUps() {
        return this.cleanUps;
    }

    public void addCleanUp(MailPath mailPath) {
        this.cleanUps.offer(mailPath);
        this.lastAccessed = System.currentTimeMillis();
    }

    private boolean areEqual(MailPath mailPath, MailPath other) {
        MailPath extractedOther;
        if (null == mailPath) {
            return false;
        }
        if (mailPath.equals(other)) {
            return true;
        }
        int unifiedMailId = this.getUnifiedMailId();
        MailPath extractedPath = CompositionSpaces.optUnifiedInboxUID(mailPath, unifiedMailId);
        if (null != extractedPath && extractedPath.equals(other)) {
            return true;
        }
        MailPath mailPath2 = extractedOther = null == other ? null : CompositionSpaces.optUnifiedInboxUID(other, unifiedMailId);
        return null != extractedOther && (mailPath.equals(extractedOther) || null != extractedPath && extractedPath.equals(extractedOther));
    }

    private int getUnifiedMailId() {
        int unifiedMailId = -1;
        UnifiedInboxManagement uim = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class);
        if (null != uim) {
            try {
                unifiedMailId = uim.getUnifiedINBOXAccountID(this.session);
            }
            catch (OXException e) {
                unifiedMailId = -1;
            }
        }
        return unifiedMailId;
    }
}

