/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.config.cascade.ComposedConfigProperty;
import com.openexchange.config.cascade.ConfigView;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.contact.ContactService;
import com.openexchange.dataretention.DataRetentionService;
import com.openexchange.dataretention.RetentionData;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.folderstorage.cache.CacheFolderStorage;
import com.openexchange.group.Group;
import com.openexchange.group.GroupStorage;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.groupware.importexport.MailImportResult;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.upload.impl.UploadUtility;
import com.openexchange.groupware.upload.quotachecker.MailUploadQuotaChecker;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Collators;
import com.openexchange.java.Reference;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.IndexRange;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailFields;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.MailSessionCache;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.Quota;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailFolderStorageEnhanced;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.IMailMessageStorageBatch;
import com.openexchange.mail.api.IMailMessageStorageBatchCopyMove;
import com.openexchange.mail.api.IMailMessageStorageExt;
import com.openexchange.mail.api.IMailMessageStorageMimeSupport;
import com.openexchange.mail.api.ISimplifiedThreadStructure;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.api.unified.UnifiedFullName;
import com.openexchange.mail.api.unified.UnifiedViewService;
import com.openexchange.mail.cache.MailMessageCache;
import com.openexchange.mail.config.IPRange;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.config.MailReloadable;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.TextBodyMailPart;
import com.openexchange.mail.event.EventPool;
import com.openexchange.mail.event.PooledEvent;
import com.openexchange.mail.json.actions.AbstractArchiveMailAction;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.dataobjects.MimeRawSource;
import com.openexchange.mail.mime.processing.MimeForward;
import com.openexchange.mail.mime.utils.MimeStorageUtility;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.parser.handlers.NonInlineForwardPartHandler;
import com.openexchange.mail.permission.DefaultMailPermission;
import com.openexchange.mail.permission.MailPermission;
import com.openexchange.mail.search.ComparisonType;
import com.openexchange.mail.search.FlagTerm;
import com.openexchange.mail.search.HeaderTerm;
import com.openexchange.mail.search.ReceivedDateTerm;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SearchUtility;
import com.openexchange.mail.search.service.SearchTermMapper;
import com.openexchange.mail.threader.Conversation;
import com.openexchange.mail.threader.Conversations;
import com.openexchange.mail.threader.ThreadableMapping;
import com.openexchange.mail.transport.MailTransport;
import com.openexchange.mail.transport.MtaStatusInfo;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.mail.transport.TransportProviderRegistry;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mail.utils.MailMessageComparator;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.mail.utils.MsisdnUtility;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.mailaccount.internal.RdbMailAccountStorage;
import com.openexchange.objectusecount.IncrementArguments;
import com.openexchange.objectusecount.ObjectUseCountService;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.spamhandler.SpamHandlerRegistry;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.AbstractTrackableTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.threadpool.behavior.CallerRunsBehavior;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.iterator.ArrayIterator;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.iterator.SearchIteratorDelegator;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.sql.SearchStrings;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import com.openexchange.user.UserService;
import com.sun.mail.smtp.SMTPSendFailedException;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.Collator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.zip.ZipException;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.idn.IDNA;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MailServletInterfaceImpl
extends MailServletInterface {
    private static final MailField[] FIELDS_FULL = new MailField[]{MailField.FULL};
    private static final MailField[] FIELDS_ID_INFO = new MailField[]{MailField.ID, MailField.FOLDER_ID};
    private static final MailField[] HEADERS = new MailField[]{MailField.ID, MailField.HEADERS};
    private static final String LAST_SEND_TIME = "com.openexchange.mail.lastSendTimestamp";
    private static final String INBOX_ID = "INBOX";
    private static final int MAX_NUMBER_OF_MESSAGES_2_CACHE = 50;
    private static final Logger LOG = LoggerFactory.getLogger(MailServletInterfaceImpl.class);
    private final Context ctx;
    private final int contextId;
    private boolean init;
    private MailConfig mailConfig;
    private MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess;
    private int accountId;
    final Session session;
    private final UserSettingMail usm;
    private Locale locale;
    private User user;
    private final Collection<OXException> warnings = new ArrayList<OXException>(2);
    private final ArrayList<MailImportResult> mailImportResults = new ArrayList();
    private MailAccount mailAccount;
    private final MailFields folderAndId;
    private final boolean checkParameters;
    private static final MailField[] FIELDS_ID = new MailField[]{MailField.ID};
    private static final int SPAM_HAM = -1;
    private static final int SPAM_NOOP = 0;
    private static final int SPAM_SPAM = 1;
    private static final MailMessageComparator COMPARATOR_DESC = new MailMessageComparator(MailSortField.RECEIVED_DATE, true, null);
    private static volatile Integer maxForwardCount;
    private static final MailListField[] FIELDS_FLAGS;
    private static final transient Object[] ARGS_FLAG_SEEN_SET;
    private static final transient Object[] ARGS_FLAG_SEEN_UNSET;
    private static final String INVALID = "<>";
    private static final MailListField[] FIELDS_COLOR_LABEL;
    private static final Map<String, Object> MORE_PROPS_UPDATE_LABEL;
    private static final Map<String, Object> MORE_PROPS_UPDATE_FLAGS;
    private static final int SUBFOLDERS_NOT_ALLOWED_ERROR_CODE = 2012;
    private static final String SUBFOLDERS_NOT_ALLOWED_PREFIX = "IMAP";

    MailServletInterfaceImpl(Session session) throws OXException {
        if (session instanceof ServerSession) {
            ServerSession serverSession = (ServerSession)session;
            this.ctx = serverSession.getContext();
            this.usm = serverSession.getUserSettingMail();
            if (!serverSession.getUserPermissionBits().hasWebMail()) {
                throw MailExceptionCode.NO_MAIL_ACCESS.create();
            }
            this.user = serverSession.getUser();
        } else {
            this.ctx = ContextStorage.getInstance().getContext(session.getContextId());
            this.usm = UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), this.ctx);
            if (!UserConfigurationStorage.getInstance().getUserConfiguration(session.getUserId(), this.ctx).hasWebMail()) {
                throw MailExceptionCode.NO_MAIL_ACCESS.create();
            }
        }
        this.session = session;
        this.contextId = session.getContextId();
        this.folderAndId = new MailFields(MailField.ID, MailField.FOLDER_ID);
        this.checkParameters = false;
    }

    private User getUser() throws OXException {
        if (null == this.user) {
            this.user = UserStorage.getInstance().getUser(this.session.getUserId(), this.session.getContextId());
        }
        return this.user;
    }

    private Locale getUserLocale() {
        if (null == this.locale) {
            if (this.session instanceof ServerSession) {
                this.locale = ((ServerSession)this.session).getUser().getLocale();
            } else {
                UserService userService = ServerServiceRegistry.getInstance().getService(UserService.class);
                if (null == userService) {
                    return Locale.ENGLISH;
                }
                try {
                    this.locale = userService.getUser(this.session.getUserId(), this.ctx).getLocale();
                }
                catch (OXException e) {
                    LOG.warn("", (Throwable)e);
                    return Locale.ENGLISH;
                }
            }
        }
        return this.locale;
    }

    private MailAccount getMailAccount() throws OXException {
        if (this.mailAccount == null) {
            try {
                MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class);
                this.mailAccount = storageService.getMailAccount(this.accountId, this.session.getUserId(), this.session.getContextId());
            }
            catch (RuntimeException e) {
                throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        }
        return this.mailAccount;
    }

    @Override
    public Collection<OXException> getWarnings() {
        return Collections.unmodifiableCollection(this.warnings);
    }

    @Override
    public boolean expungeFolder(String folder, boolean hardDelete) throws OXException {
        FullnameArgument fullnameArgument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = fullnameArgument.getAccountId();
        this.initConnection(accountId);
        String fullName = fullnameArgument.getFullname();
        IMailFolderStorage folderStorage = this.mailAccess.getFolderStorage();
        if (folderStorage instanceof IMailFolderStorageEnhanced) {
            ((IMailFolderStorageEnhanced)folderStorage).expungeFolder(fullName, hardDelete);
        } else {
            IMailMessageStorage messageStorage = this.mailAccess.getMessageStorage();
            MailMessage[] messages = messageStorage.searchMessages(fullName, IndexRange.NULL, MailSortField.RECEIVED_DATE, OrderDirection.ASC, new FlagTerm(2, true), FIELDS_ID);
            LinkedList<String> mailIds = new LinkedList<String>();
            for (MailMessage mailMessage : messages) {
                if (null == mailMessage) continue;
                mailIds.add(mailMessage.getMailId());
            }
            if (hardDelete) {
                messageStorage.deleteMessages(fullName, mailIds.toArray(new String[mailIds.size()]), true);
            } else {
                String trashFolder = folderStorage.getTrashFolder();
                if (fullName.equals(trashFolder)) {
                    messageStorage.deleteMessages(fullName, mailIds.toArray(new String[mailIds.size()]), true);
                } else {
                    messageStorage.moveMessages(fullName, trashFolder, mailIds.toArray(new String[mailIds.size()]), true);
                }
            }
        }
        this.postEvent(accountId, fullName, true);
        String trashFullname = MailFolderUtility.prepareMailFolderParam(this.getTrashFolder(accountId)).getFullname();
        if (!hardDelete) {
            this.postEvent(accountId, trashFullname, true);
        }
        return true;
    }

    @Override
    public boolean clearFolder(String folder) throws OXException {
        FullnameArgument fullnameArgument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = fullnameArgument.getAccountId();
        this.initConnection(accountId);
        String fullName = fullnameArgument.getFullname();
        boolean backup = !UserSettingMailStorage.getInstance().getUserSettingMail(this.session.getUserId(), this.ctx).isHardDeleteMsgs() && !fullName.startsWith(this.mailAccess.getFolderStorage().getTrashFolder());
        this.mailAccess.getFolderStorage().clearFolder(fullName, !backup);
        this.postEvent(accountId, fullName, true);
        String trashFullname = MailFolderUtility.prepareMailFolderParam(this.getTrashFolder(accountId)).getFullname();
        if (backup) {
            this.postEvent(accountId, trashFullname, true);
        }
        try {
            MailMessageCache.getInstance().removeFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
        if (fullName.startsWith(trashFullname)) {
            MailFolder[] subf;
            for (MailFolder element : subf = this.mailAccess.getFolderStorage().getSubfolders(fullName, true)) {
                String subFullname = element.getFullname();
                this.mailAccess.getFolderStorage().deleteFolder(subFullname, true);
                this.postEvent(accountId, subFullname, false);
            }
            this.postEvent(accountId, trashFullname, false);
        }
        return true;
    }

    @Override
    public boolean clearFolder(String folder, boolean hardDelete) throws OXException {
        FullnameArgument fullnameArgument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = fullnameArgument.getAccountId();
        this.initConnection(accountId);
        String fullName = fullnameArgument.getFullname();
        boolean backup = hardDelete ? false : !UserSettingMailStorage.getInstance().getUserSettingMail(this.session.getUserId(), this.ctx).isHardDeleteMsgs() && !fullName.startsWith(this.mailAccess.getFolderStorage().getTrashFolder());
        this.mailAccess.getFolderStorage().clearFolder(fullName, !backup);
        this.postEvent(accountId, fullName, true);
        String trashFullname = MailFolderUtility.prepareMailFolderParam(this.getTrashFolder(accountId)).getFullname();
        if (backup) {
            this.postEvent(accountId, trashFullname, true);
        }
        try {
            MailMessageCache.getInstance().removeFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
        if (fullName.startsWith(trashFullname)) {
            MailFolder[] subf;
            for (MailFolder element : subf = this.mailAccess.getFolderStorage().getSubfolders(fullName, true)) {
                String subFullname = element.getFullname();
                this.mailAccess.getFolderStorage().deleteFolder(subFullname, true);
                this.postEvent(accountId, subFullname, false);
            }
            this.postEvent(accountId, trashFullname, false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean putIntoCache) throws OXException {
        try {
            MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = this.mailAccess;
            if (mailAccess != null) {
                mailAccess.close(putIntoCache);
            }
        }
        finally {
            this.mailAccess = null;
            this.init = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] copyMessages(String sourceFolder, String destFolder, String[] msgUIDs, boolean move) throws OXException {
        FullnameArgument source = MailFolderUtility.prepareMailFolderParam(sourceFolder);
        FullnameArgument dest = MailFolderUtility.prepareMailFolderParam(destFolder);
        String sourceFullname = source.getFullname();
        String destFullname = dest.getFullname();
        int sourceAccountId = source.getAccountId();
        this.initConnection(sourceAccountId);
        int destAccountId = dest.getAccountId();
        if (sourceAccountId == destAccountId) {
            String[] maildIds;
            IMailMessageStorage messageStorage = this.mailAccess.getMessageStorage();
            MailMessage[] flagInfo = null;
            if (move) {
                String spamFullname = this.mailAccess.getFolderStorage().getSpamFolder();
                int spamAction = this.usm.isSpamEnabled() ? (spamFullname.equals(sourceFullname) ? -1 : (spamFullname.equals(destFullname) ? 1 : 0)) : 0;
                if (spamAction != 0) {
                    if (spamAction == 1) {
                        flagInfo = messageStorage.getMessages(sourceFullname, msgUIDs, new MailField[]{MailField.FLAGS});
                        SpamHandlerRegistry.getSpamHandlerBySession(this.session, this.accountId).handleSpam(this.accountId, sourceFullname, msgUIDs, false, this.session);
                    } else {
                        flagInfo = messageStorage.getMessages(sourceFullname, msgUIDs, new MailField[]{MailField.FLAGS});
                        SpamHandlerRegistry.getSpamHandlerBySession(this.session, this.accountId).handleHam(this.accountId, sourceFullname, msgUIDs, false, this.session);
                    }
                }
            }
            if (move) {
                maildIds = messageStorage.moveMessages(sourceFullname, destFullname, msgUIDs, false);
                this.postEvent(sourceAccountId, sourceFullname, true, true);
            } else {
                maildIds = messageStorage.copyMessages(sourceFullname, destFullname, msgUIDs, false);
            }
            if (null != flagInfo) {
                LinkedList<String> list = new LinkedList<String>();
                for (int i = 0; i < maildIds.length; ++i) {
                    void mailMessage = flagInfo[i];
                    if (null == mailMessage || mailMessage.isSeen()) continue;
                    list.add(maildIds[i]);
                }
                messageStorage.updateMessageFlags(destFullname, list.toArray(new String[list.size()]), 32, false);
            }
            this.postEvent(sourceAccountId, destFullname, true, true);
            try {
                if (move) {
                    MailMessageCache.getInstance().removeFolderMessages(sourceAccountId, sourceFullname, this.session.getUserId(), this.contextId);
                }
                MailMessageCache.getInstance().removeFolderMessages(destAccountId, destFullname, this.session.getUserId(), this.contextId);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
            return maildIds;
        }
        MailAccess<?, ?> destAccess = this.initMailAccess(destAccountId);
        try {
            ConfigurationService service;
            MailMessage[] flagInfo = null;
            if (move) {
                int spamActionSource = 0;
                boolean spamActionDest = false;
                if (this.usm.isSpamEnabled()) {
                    if (sourceFullname.equals(this.mailAccess.getFolderStorage().getSpamFolder())) {
                        spamActionSource = -1;
                    }
                    if (destFullname.equals(destAccess.getFolderStorage().getSpamFolder())) {
                        spamActionDest = true;
                    }
                }
                if (-1 == spamActionSource) {
                    flagInfo = this.mailAccess.getMessageStorage().getMessages(sourceFullname, msgUIDs, new MailField[]{MailField.FLAGS});
                    SpamHandlerRegistry.getSpamHandlerBySession(this.session, this.accountId).handleHam(this.accountId, sourceFullname, msgUIDs, false, this.session);
                }
                if (spamActionDest) {
                    flagInfo = this.mailAccess.getMessageStorage().getMessages(sourceFullname, msgUIDs, new MailField[]{MailField.FLAGS});
                    SpamHandlerRegistry.getSpamHandlerBySession(this.session, this.accountId).handleSpam(this.accountId, sourceFullname, msgUIDs, false, this.session);
                }
            }
            int chunkSize = null == (service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class)) ? 50 : service.getIntProperty("com.openexchange.mail.externalChunkSize", 50);
            int length = msgUIDs.length;
            LinkedList<String> retval = new LinkedList<String>();
            int start = 0;
            while (start < length) {
                int len;
                int end = start + chunkSize;
                if (end > length) {
                    end = length;
                    len = end - start;
                } else {
                    len = chunkSize;
                }
                String[] ids = new String[len];
                System.arraycopy(msgUIDs, start, ids, 0, len);
                MailMessage[] messages = this.mailAccess.getMessageStorage().getMessages(sourceFullname, ids, FIELDS_FULL);
                String[] destIds = destAccess.getMessageStorage().appendMessages(destFullname, messages);
                if (null == destIds || 0 == destIds.length) {
                    String[] stringArray = new String[]{};
                    return stringArray;
                }
                if (move) {
                    this.mailAccess.getMessageStorage().deleteMessages(sourceFullname, MailServletInterfaceImpl.messages2ids(messages), true);
                    this.postEvent(sourceAccountId, sourceFullname, true, true);
                }
                if (null != flagInfo) {
                    LinkedList<String> list = new LinkedList<String>();
                    for (int i = 0; i < destIds.length; ++i) {
                        MailMessage mailMessage = flagInfo[i];
                        if (null == mailMessage || mailMessage.isSeen()) continue;
                        list.add(destIds[i]);
                    }
                    destAccess.getMessageStorage().updateMessageFlags(destFullname, list.toArray(new String[list.size()]), 32, false);
                }
                this.postEvent(destAccountId, destFullname, true, true);
                try {
                    if (move) {
                        MailMessageCache.getInstance().removeFolderMessages(sourceAccountId, sourceFullname, this.session.getUserId(), this.contextId);
                    }
                    MailMessageCache.getInstance().removeFolderMessages(destAccountId, destFullname, this.session.getUserId(), this.contextId);
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
                retval.addAll(Arrays.asList(destIds));
                start = end;
            }
            String[] stringArray = retval.toArray(new String[retval.size()]);
            return stringArray;
        }
        finally {
            destAccess.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyAllMessages(String sourceFolder, String destFolder, boolean move) throws OXException {
        FullnameArgument source = MailFolderUtility.prepareMailFolderParam(sourceFolder);
        FullnameArgument dest = MailFolderUtility.prepareMailFolderParam(destFolder);
        String sourceFullname = source.getFullname();
        String destFullname = dest.getFullname();
        int sourceAccountId = source.getAccountId();
        this.initConnection(sourceAccountId);
        int destAccountId = dest.getAccountId();
        if (sourceAccountId == destAccountId) {
            MailMessage idm;
            int i;
            MailMessage[] allIds;
            IMailMessageStorage messageStorage = this.mailAccess.getMessageStorage();
            String[] mailIds = null;
            MailMessage[] flagInfo = null;
            if (move) {
                String spamFullname = this.mailAccess.getFolderStorage().getSpamFolder();
                int spamAction = this.usm.isSpamEnabled() ? (spamFullname.equals(sourceFullname) ? -1 : (spamFullname.equals(destFullname) ? 1 : 0)) : 0;
                if (spamAction != 0) {
                    MailMessage idm2;
                    int i2;
                    MailMessage[] allIds2;
                    if (spamAction == 1) {
                        allIds2 = messageStorage.getAllMessages(sourceFullname, null, MailSortField.RECEIVED_DATE, OrderDirection.ASC, new MailField[]{MailField.ID});
                        mailIds = new String[allIds2.length];
                        i2 = allIds2.length;
                        while (i2-- > 0) {
                            idm2 = allIds2[i2];
                            mailIds[i2] = null == idm2 ? null : allIds2[i2].getMailId();
                        }
                        flagInfo = messageStorage.getMessages(sourceFullname, mailIds, new MailField[]{MailField.FLAGS});
                        SpamHandlerRegistry.getSpamHandlerBySession(this.session, this.accountId).handleSpam(this.accountId, sourceFullname, mailIds, false, this.session);
                    } else {
                        allIds2 = messageStorage.getAllMessages(sourceFullname, null, MailSortField.RECEIVED_DATE, OrderDirection.ASC, new MailField[]{MailField.ID});
                        mailIds = new String[allIds2.length];
                        i2 = allIds2.length;
                        while (i2-- > 0) {
                            idm2 = allIds2[i2];
                            mailIds[i2] = null == idm2 ? null : allIds2[i2].getMailId();
                        }
                        flagInfo = messageStorage.getMessages(sourceFullname, mailIds, new MailField[]{MailField.FLAGS});
                        SpamHandlerRegistry.getSpamHandlerBySession(this.session, this.accountId).handleHam(this.accountId, sourceFullname, mailIds, false, this.session);
                    }
                }
            }
            if (messageStorage instanceof IMailMessageStorageBatchCopyMove) {
                IMailMessageStorageBatchCopyMove batchCopyMove = (IMailMessageStorageBatchCopyMove)messageStorage;
                if (move) {
                    batchCopyMove.moveMessages(sourceFullname, destFullname);
                    this.postEvent(sourceAccountId, sourceFullname, true, true);
                } else {
                    batchCopyMove.copyMessages(sourceFullname, destFullname);
                }
            } else {
                if (null == mailIds) {
                    allIds = messageStorage.getAllMessages(sourceFullname, null, MailSortField.RECEIVED_DATE, OrderDirection.ASC, new MailField[]{MailField.ID});
                    mailIds = new String[allIds.length];
                    i = allIds.length;
                    while (i-- > 0) {
                        idm = allIds[i];
                        mailIds[i] = null == idm ? null : allIds[i].getMailId();
                    }
                }
                if (move) {
                    messageStorage.moveMessages(sourceFullname, destFullname, mailIds, true);
                    this.postEvent(sourceAccountId, sourceFullname, true, true);
                } else {
                    messageStorage.copyMessages(sourceFullname, destFullname, mailIds, true);
                }
            }
            if (null != flagInfo) {
                if (null == mailIds) {
                    allIds = messageStorage.getAllMessages(sourceFullname, null, MailSortField.RECEIVED_DATE, OrderDirection.ASC, new MailField[]{MailField.ID});
                    mailIds = new String[allIds.length];
                    i = allIds.length;
                    while (i-- > 0) {
                        idm = allIds[i];
                        mailIds[i] = null == idm ? null : allIds[i].getMailId();
                    }
                }
                LinkedList<String> list = new LinkedList<String>();
                for (i = 0; i < mailIds.length; ++i) {
                    void mailMessage = flagInfo[i];
                    if (null == mailMessage || mailMessage.isSeen()) continue;
                    list.add(mailIds[i]);
                }
                messageStorage.updateMessageFlags(destFullname, list.toArray(new String[list.size()]), 32, false);
            }
            this.postEvent(sourceAccountId, destFullname, true, true);
            try {
                if (move) {
                    MailMessageCache.getInstance().removeFolderMessages(sourceAccountId, sourceFullname, this.session.getUserId(), this.contextId);
                }
                MailMessageCache.getInstance().removeFolderMessages(destAccountId, destFullname, this.session.getUserId(), this.contextId);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
            return;
        }
        MailAccess<?, ?> destAccess = this.initMailAccess(destAccountId);
        try {
            ConfigurationService service;
            int chunkSize;
            String[] mailIds = null;
            MailMessage[] flagInfo = null;
            if (move) {
                MailMessage idm;
                int i;
                MailMessage[] allIds;
                int spamActionSource = 0;
                boolean spamActionDest = false;
                if (this.usm.isSpamEnabled()) {
                    if (sourceFullname.equals(this.mailAccess.getFolderStorage().getSpamFolder())) {
                        spamActionSource = -1;
                    }
                    if (destFullname.equals(destAccess.getFolderStorage().getSpamFolder())) {
                        spamActionDest = true;
                    }
                }
                if (-1 == spamActionSource) {
                    allIds = this.mailAccess.getMessageStorage().getAllMessages(sourceFullname, null, MailSortField.RECEIVED_DATE, OrderDirection.ASC, new MailField[]{MailField.ID});
                    mailIds = new String[allIds.length];
                    i = allIds.length;
                    while (i-- > 0) {
                        idm = allIds[i];
                        mailIds[i] = null == idm ? null : allIds[i].getMailId();
                    }
                    flagInfo = this.mailAccess.getMessageStorage().getMessages(sourceFullname, mailIds, new MailField[]{MailField.FLAGS});
                    SpamHandlerRegistry.getSpamHandlerBySession(this.session, this.accountId).handleHam(this.accountId, sourceFullname, mailIds, false, this.session);
                }
                if (spamActionDest) {
                    allIds = this.mailAccess.getMessageStorage().getAllMessages(sourceFullname, null, MailSortField.RECEIVED_DATE, OrderDirection.ASC, new MailField[]{MailField.ID});
                    mailIds = new String[allIds.length];
                    i = allIds.length;
                    while (i-- > 0) {
                        idm = allIds[i];
                        mailIds[i] = null == idm ? null : allIds[i].getMailId();
                    }
                    flagInfo = this.mailAccess.getMessageStorage().getMessages(sourceFullname, mailIds, new MailField[]{MailField.FLAGS});
                    SpamHandlerRegistry.getSpamHandlerBySession(this.session, this.accountId).handleSpam(this.accountId, sourceFullname, mailIds, false, this.session);
                }
            }
            int n = chunkSize = null == (service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class)) ? 50 : service.getIntProperty("com.openexchange.mail.externalChunkSize", 50);
            if (null == mailIds) {
                MailMessage[] allIds = this.mailAccess.getMessageStorage().getAllMessages(sourceFullname, null, MailSortField.RECEIVED_DATE, OrderDirection.ASC, new MailField[]{MailField.ID});
                mailIds = new String[allIds.length];
                int i = allIds.length;
                while (i-- > 0) {
                    MailMessage idm = allIds[i];
                    mailIds[i] = null == idm ? null : allIds[i].getMailId();
                }
            }
            int total = mailIds.length;
            LinkedList<String> retval = new LinkedList<String>();
            int start = 0;
            while (start < total) {
                int len;
                int end = start + chunkSize;
                if (end > total) {
                    end = total;
                    len = end - start;
                } else {
                    len = chunkSize;
                }
                String[] ids = new String[len];
                System.arraycopy(mailIds, start, ids, 0, len);
                MailMessage[] messages = this.mailAccess.getMessageStorage().getMessages(sourceFullname, ids, FIELDS_FULL);
                String[] destIds = destAccess.getMessageStorage().appendMessages(destFullname, messages);
                if (null == destIds || 0 == destIds.length) {
                    return;
                }
                if (move) {
                    this.mailAccess.getMessageStorage().deleteMessages(sourceFullname, MailServletInterfaceImpl.messages2ids(messages), true);
                    this.postEvent(sourceAccountId, sourceFullname, true, true);
                }
                if (null != flagInfo) {
                    LinkedList<String> list = new LinkedList<String>();
                    for (int i = 0; i < destIds.length; ++i) {
                        MailMessage mailMessage = flagInfo[i];
                        if (null == mailMessage || mailMessage.isSeen()) continue;
                        list.add(destIds[i]);
                    }
                    destAccess.getMessageStorage().updateMessageFlags(destFullname, list.toArray(new String[list.size()]), 32, false);
                }
                this.postEvent(destAccountId, destFullname, true, true);
                try {
                    if (move) {
                        MailMessageCache.getInstance().removeFolderMessages(sourceAccountId, sourceFullname, this.session.getUserId(), this.contextId);
                    }
                    MailMessageCache.getInstance().removeFolderMessages(destAccountId, destFullname, this.session.getUserId(), this.contextId);
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
                retval.addAll(Arrays.asList(destIds));
                start = end;
            }
        }
        finally {
            destAccess.close(true);
        }
    }

    @Override
    public String deleteFolder(String folder) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        IMailFolderStorage folderStorage = this.mailAccess.getFolderStorage();
        String trashFullname = folderStorage.getTrashFolder();
        boolean hardDelete = fullName.startsWith(trashFullname);
        Map<String, Map<?, ?>> subfolders = this.subfolders(fullName);
        String retval = MailFolderUtility.prepareFullname(accountId, folderStorage.deleteFolder(fullName, hardDelete));
        this.postEvent(accountId, fullName, false, true, false);
        try {
            MailMessageCache.getInstance().removeFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
        if (!hardDelete) {
            this.postEventRemote(accountId, trashFullname, false);
        }
        this.postEvent4Subfolders(accountId, subfolders);
        return retval;
    }

    private void postEvent4Subfolders(int accountId, Map<String, Map<?, ?>> subfolders) {
        int size = subfolders.size();
        Iterator<Map.Entry<String, Map<?, ?>>> iter = subfolders.entrySet().iterator();
        for (int i = 0; i < size; ++i) {
            Map.Entry<String, Map<?, ?>> entry = iter.next();
            Map<String, Map<?, ?>> m = entry.getValue();
            if (!m.isEmpty()) {
                this.postEvent4Subfolders(accountId, m);
            }
            this.postEventRemote(accountId, entry.getKey(), false);
        }
    }

    private Map<String, Map<?, ?>> subfolders(String fullName) throws OXException {
        HashMap m = new HashMap();
        this.subfoldersRecursively(fullName, m);
        return m;
    }

    private void subfoldersRecursively(String parent, Map<String, Map<?, ?>> m) throws OXException {
        MailFolder[] mailFolders = this.mailAccess.getFolderStorage().getSubfolders(parent, true);
        if (null == mailFolders || 0 == mailFolders.length) {
            Map emptyMap = Collections.emptyMap();
            m.put(parent, emptyMap);
        } else {
            HashMap subMap = new HashMap();
            int size = mailFolders.length;
            for (int i = 0; i < size; ++i) {
                String fullName = mailFolders[i].getFullname();
                this.subfoldersRecursively(fullName, subMap);
            }
            m.put(parent, subMap);
        }
    }

    @Override
    public boolean deleteMessages(String folder, String[] msgUIDs, boolean hardDelete) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        String trashFullname = this.mailAccess.getFolderStorage().getTrashFolder();
        boolean hd = hardDelete || UserSettingMailStorage.getInstance().getUserSettingMail(this.session.getUserId(), this.ctx).isHardDeleteMsgs() || null != trashFullname && fullName.startsWith(trashFullname);
        this.mailAccess.getMessageStorage().deleteMessages(fullName, msgUIDs, hd);
        try {
            MailMessageCache.getInstance().removeFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
        this.postEvent(accountId, fullName, true, true, false);
        if (!hd) {
            this.postEvent(accountId, trashFullname, true, true, false);
        }
        return true;
    }

    @Override
    public int[] getAllMessageCount(String folder) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        this.initConnection(argument.getAccountId());
        String fullName = argument.getFullname();
        IMailFolderStorage folderStorage = this.mailAccess.getFolderStorage();
        MailFolder f = folderStorage.getFolder(fullName);
        if (folderStorage instanceof IMailFolderStorageEnhanced) {
            IMailFolderStorageEnhanced storageEnhanced = (IMailFolderStorageEnhanced)folderStorage;
            int totalCounter = storageEnhanced.getTotalCounter(fullName);
            int unreadCounter = storageEnhanced.getUnreadCounter(fullName);
            int newCounter = storageEnhanced.getNewCounter(fullName);
            return new int[]{totalCounter, newCounter, unreadCounter, f.getDeletedMessageCount()};
        }
        int totalCounter = this.mailAccess.getMessageStorage().searchMessages(fullName, IndexRange.NULL, MailSortField.RECEIVED_DATE, OrderDirection.ASC, null, FIELDS_ID).length;
        int unreadCounter = this.mailAccess.getMessageStorage().getUnreadMessages(fullName, MailSortField.RECEIVED_DATE, OrderDirection.DESC, FIELDS_ID, -1).length;
        return new int[]{totalCounter, f.getNewMessageCount(), unreadCounter, f.getDeletedMessageCount()};
    }

    @Override
    public SearchIterator<MailMessage> getAllMessages(String folder, int sortCol, int order, int[] fields, String[] headerFields, int[] fromToIndices, boolean supportsContinuation) throws OXException {
        return this.getMessages(folder, fromToIndices, sortCol, order, null, null, false, fields, headerFields, supportsContinuation);
    }

    @Override
    public List<List<MailMessage>> getAllSimpleThreadStructuredMessages(String folder, boolean includeSent, boolean cache, int sortCol, int order, int[] fields, int[] fromToIndices, final long lookAhead) throws OXException {
        IndexRange indexRange;
        Future messagesFromSentFolder;
        IMailMessageStorage messageStorage;
        MailFields mailFields;
        boolean mergeWithSent;
        String fullName;
        block12: {
            FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
            int accountId = argument.getAccountId();
            this.initConnection(accountId);
            fullName = argument.getFullname();
            mergeWithSent = includeSent && !this.mailAccess.getFolderStorage().getSentFolder().equals(fullName);
            mailFields = new MailFields(MailField.getFields(fields));
            mailFields.add(MailField.FOLDER_ID);
            mailFields.add(MailField.toField(MailListField.getField(sortCol)));
            messageStorage = this.mailAccess.getMessageStorage();
            if (messageStorage instanceof ISimplifiedThreadStructure) {
                ISimplifiedThreadStructure simplifiedThreadStructure = (ISimplifiedThreadStructure)((Object)messageStorage);
                try {
                    return simplifiedThreadStructure.getThreadSortedMessages(fullName, mergeWithSent, cache, null == fromToIndices ? IndexRange.NULL : new IndexRange(fromToIndices[0], fromToIndices[1]), lookAhead, MailSortField.getField(sortCol), OrderDirection.getOrderDirection(order), mailFields.toArray());
                }
                catch (OXException e) {
                    if (2046 == e.getCode() && ("MSG".equals(e.getPrefix()) || SUBFOLDERS_NOT_ALLOWED_PREFIX.equals(e.getPrefix())) || MailExceptionCode.UNSUPPORTED_OPERATION.equals(e)) break block12;
                    throw e;
                }
            }
        }
        if (mergeWithSent) {
            final String sentFolder = this.mailAccess.getFolderStorage().getSentFolder();
            messagesFromSentFolder = ThreadPools.getThreadPool().submit((Task)new AbstractTask<List<MailMessage>>(){

                public List<MailMessage> call() throws Exception {
                    return Conversations.messagesFor(sentFolder, (int)lookAhead, mailFields, messageStorage);
                }
            });
        } else {
            messagesFromSentFolder = null;
        }
        List<Conversation> conversations = Conversations.conversationsFor(fullName, (int)lookAhead, mailFields, messageStorage);
        if (null != messagesFromSentFolder) {
            List sentMessages = (List)MailServletInterfaceImpl.getFrom(messagesFromSentFolder);
            for (Conversation conversation : conversations) {
                for (MailMessage sentMessage : sentMessages) {
                    if (!conversation.referencesOrIsReferencedBy(sentMessage)) continue;
                    conversation.addMessage(sentMessage);
                }
            }
        }
        Conversations.fold(conversations);
        MailMessageComparator threadComparator = COMPARATOR_DESC;
        List<List<MailMessage>> list = new LinkedList<List<MailMessage>>();
        for (Conversation conversation : conversations) {
            list.add(conversation.getMessages(threadComparator));
        }
        MailSortField sortField = MailSortField.getField(sortCol);
        MailSortField effectiveSortField = null == sortField ? MailSortField.RECEIVED_DATE : sortField;
        Comparator<List<MailMessage>> listComparator = this.getListComparator(effectiveSortField, OrderDirection.getOrderDirection(order), folder, this.getUserLocale());
        Collections.sort(list, listComparator);
        IndexRange indexRange2 = indexRange = null == fromToIndices ? IndexRange.NULL : new IndexRange(fromToIndices[0], fromToIndices[1]);
        if (null != indexRange) {
            int fromIndex = indexRange.start;
            int toIndex = indexRange.end;
            int size = list.size();
            if (fromIndex > size) {
                return Collections.emptyList();
            }
            if (toIndex >= size) {
                toIndex = size;
            }
            list = list.subList(fromIndex, toIndex);
        }
        this.setAccountInfo2(list);
        return list;
    }

    private static Future<ThreadableMapping> getThreadableMapping(final String sentFolder, final int limit, final MailFields mailFields, final IMailMessageStorage messageStorage) {
        AbstractTrackableTask<ThreadableMapping> task = new AbstractTrackableTask<ThreadableMapping>(){

            public ThreadableMapping call() throws Exception {
                List<MailMessage> mails = Conversations.messagesFor(sentFolder, limit, mailFields, messageStorage);
                return new ThreadableMapping(64).initWith(mails);
            }
        };
        return ThreadPools.getThreadPool().submit((Task)task, CallerRunsBehavior.getInstance());
    }

    private Comparator<List<MailMessage>> getListComparator(final MailSortField sortField, final OrderDirection order, final String folder, Locale locale) {
        final MailMessageComparator comparator = new MailMessageComparator(sortField, OrderDirection.DESC.equals((Object)order), locale);
        Comparator<List<MailMessage>> listComparator = new Comparator<List<MailMessage>>(){

            @Override
            public int compare(List<MailMessage> o1, List<MailMessage> o2) {
                MailMessage msg1 = this.lookUpFirstBelongingToFolder(folder, o1);
                MailMessage msg2 = this.lookUpFirstBelongingToFolder(folder, o2);
                int result = comparator.compare(o1.get(0), o2.get(0));
                if (0 != result || MailSortField.RECEIVED_DATE != sortField) {
                    return result;
                }
                String inReplyTo1 = msg1.getInReplyTo();
                String inReplyTo2 = msg2.getInReplyTo();
                result = null == inReplyTo1 ? (null == inReplyTo2 ? 0 : -1) : (null == inReplyTo2 ? 1 : 0);
                return 0 == result ? new MailMessageComparator(MailSortField.SENT_DATE, OrderDirection.DESC.equals((Object)order), null).compare(msg1, msg2) : result;
            }

            private MailMessage lookUpFirstBelongingToFolder(String folder2, List<MailMessage> mails) {
                for (MailMessage mail : mails) {
                    if (!folder2.equals(mail.getFolder())) continue;
                    return mail;
                }
                return mails.get(0);
            }
        };
        return listComparator;
    }

    private static <T> T getFrom(Future<T> f) throws OXException {
        if (null == f) {
            return null;
        }
        try {
            return f.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw MailExceptionCode.INTERRUPT_ERROR.create(e, e.getMessage());
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof MessagingException) {
                throw MimeMailException.handleMessagingException((MessagingException)cause);
            }
            throw (OXException)((Object)ThreadPools.launderThrowable((ExecutionException)e, OXException.class));
        }
    }

    private <C extends Collection<MailMessage>, W extends Collection<C>> W setAccountInfo2(W col) throws OXException {
        MailAccount account = this.getMailAccount();
        String name = account.getName();
        int id = account.getId();
        for (Collection mailMessages : col) {
            for (MailMessage mailMessage : mailMessages) {
                if (null == mailMessage) continue;
                mailMessage.setAccountId(id);
                mailMessage.setAccountName(name);
            }
        }
        return col;
    }

    @Override
    public SearchIterator<MailMessage> getAllThreadedMessages(String folder, int sortCol, int order, int[] fields, int[] fromToIndices) throws OXException {
        return this.getThreadedMessages(folder, fromToIndices, sortCol, order, null, null, false, fields);
    }

    @Override
    public SearchIterator<MailFolder> getChildFolders(String parentFolder, boolean all) throws OXException {
        String[] names;
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(parentFolder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String parentFullname = argument.getFullname();
        LinkedList<MailFolder> children = new LinkedList<MailFolder>(Arrays.asList(this.mailAccess.getFolderStorage().getSubfolders(parentFullname, all)));
        if (children.isEmpty()) {
            return SearchIteratorAdapter.emptyIterator();
        }
        if (0 == accountId && MailProperties.getInstance().isHidePOP3StorageFolders()) {
            Set<String> pop3StorageFolders = RdbMailAccountStorage.getPOP3StorageFolders(this.session);
            Iterator it = children.iterator();
            while (it.hasNext()) {
                MailFolder mailFolder = (MailFolder)it.next();
                if (!pop3StorageFolders.contains(mailFolder.getFullname())) continue;
                it.remove();
            }
        }
        if (!"default".equals(parentFullname) && !INBOX_ID.equals(parentFullname)) {
            Collections.sort(children, new SimpleMailFolderComparator(this.getUserLocale()));
            return new SearchIteratorDelegator(children.iterator(), children.size());
        }
        if (this.isDefaultFoldersChecked(accountId)) {
            names = this.getSortedDefaultMailFolders(accountId);
        } else {
            LinkedList<String> tmp = new LinkedList<String>();
            FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(this.getInboxFolder(accountId));
            if (null != fa) {
                tmp.add(fa.getFullname());
            }
            if (null != (fa = MailFolderUtility.prepareMailFolderParam(this.getDraftsFolder(accountId)))) {
                tmp.add(fa.getFullname());
            }
            if (null != (fa = MailFolderUtility.prepareMailFolderParam(this.getSentFolder(accountId)))) {
                tmp.add(fa.getFullname());
            }
            if (null != (fa = MailFolderUtility.prepareMailFolderParam(this.getSpamFolder(accountId)))) {
                tmp.add(fa.getFullname());
            }
            if (null != (fa = MailFolderUtility.prepareMailFolderParam(this.getTrashFolder(accountId)))) {
                tmp.add(fa.getFullname());
            }
            names = tmp.toArray(new String[tmp.size()]);
        }
        Collections.sort(children, new MailFolderComparator(names, this.getUserLocale()));
        return new SearchIteratorDelegator(children.iterator(), children.size());
    }

    @Override
    public String getConfirmedHamFolder(int accountId) throws OXException {
        if (this.isDefaultFoldersChecked(accountId)) {
            return MailFolderUtility.prepareFullname(accountId, this.getDefaultMailFolder(5, accountId));
        }
        this.initConnection(accountId);
        return MailFolderUtility.prepareFullname(accountId, this.mailAccess.getFolderStorage().getConfirmedHamFolder());
    }

    @Override
    public String getConfirmedSpamFolder(int accountId) throws OXException {
        if (this.isDefaultFoldersChecked(accountId)) {
            return MailFolderUtility.prepareFullname(accountId, this.getDefaultMailFolder(4, accountId));
        }
        this.initConnection(accountId);
        return MailFolderUtility.prepareFullname(accountId, this.mailAccess.getFolderStorage().getConfirmedSpamFolder());
    }

    private String getDefaultMailFolder(int index, int accountId) {
        String[] arr = (String[])MailSessionCache.getInstance(this.session).getParameter(accountId, MailSessionParameterNames.getParamDefaultFolderArray());
        return arr == null ? null : arr[index];
    }

    private String[] getSortedDefaultMailFolders(int accountId) {
        String[] arr = (String[])MailSessionCache.getInstance(this.session).getParameter(accountId, MailSessionParameterNames.getParamDefaultFolderArray());
        if (arr == null) {
            return new String[0];
        }
        return new String[]{INBOX_ID, arr[0], arr[1], arr[2], arr[3]};
    }

    @Override
    public int getDeletedMessageCount(String folder) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        this.initConnection(argument.getAccountId());
        String fullName = argument.getFullname();
        return this.mailAccess.getFolderStorage().getFolder(fullName).getDeletedMessageCount();
    }

    @Override
    public String getDraftsFolder(int accountId) throws OXException {
        if (this.isDefaultFoldersChecked(accountId)) {
            return MailFolderUtility.prepareFullname(accountId, this.getDefaultMailFolder(0, accountId));
        }
        this.initConnection(accountId);
        return MailFolderUtility.prepareFullname(accountId, this.mailAccess.getFolderStorage().getDraftsFolder());
    }

    @Override
    public MailFolder getFolder(String folder, boolean checkFolder) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        this.initConnection(argument.getAccountId());
        String fullName = argument.getFullname();
        return this.mailAccess.getFolderStorage().getFolder(fullName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int maxForwardCount() {
        Integer tmp = maxForwardCount;
        if (null != tmp) return tmp;
        Class<MailServletInterfaceImpl> clazz = MailServletInterfaceImpl.class;
        synchronized (MailServletInterfaceImpl.class) {
            tmp = maxForwardCount;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 8;
            }
            maxForwardCount = tmp = Integer.valueOf(service.getIntProperty("com.openexchange.mail.maxForwardCount", 8));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailMessage getForwardMessageForDisplay(String[] folders2, String[] fowardMsgUIDs, UserSettingMail usm, boolean setFrom) throws OXException {
        if (null == folders2 || null == fowardMsgUIDs || folders2.length != fowardMsgUIDs.length) {
            throw new IllegalArgumentException("Illegal arguments");
        }
        int maxForwardCount = MailServletInterfaceImpl.maxForwardCount();
        if (maxForwardCount > 0 && folders2.length > maxForwardCount) {
            throw MailExceptionCode.TOO_MANY_FORWARD_MAILS.create(maxForwardCount);
        }
        FullnameArgument[] arguments = new FullnameArgument[folders2.length];
        for (int i = 0; i < folders2.length; ++i) {
            arguments[i] = MailFolderUtility.prepareMailFolderParam(folders2[i]);
        }
        boolean sameAccount = true;
        int accountId = arguments[0].getAccountId();
        int length = arguments.length;
        for (int i = 1; sameAccount && i < length; ++i) {
            sameAccount = accountId == arguments[i].getAccountId();
        }
        TransportProperties transportProperties = TransportProperties.getInstance();
        MailUploadQuotaChecker checker = new MailUploadQuotaChecker(usm);
        long maxPerMsg = checker.getFileQuotaMax();
        long max = checker.getQuotaMax();
        if (sameAccount) {
            this.initConnection(accountId);
            MailMessage[] originalMails = new MailMessage[folders2.length];
            if (transportProperties.isPublishOnExceededQuota() && (!transportProperties.isPublishPrimaryAccountOnly() || 0 == accountId)) {
                for (int i = 0; i < length; ++i) {
                    String fullName = arguments[i].getFullname();
                    MailMessage origMail = this.mailAccess.getMessageStorage().getMessage(fullName, fowardMsgUIDs[i], false);
                    if (null == origMail) {
                        throw MailExceptionCode.MAIL_NOT_FOUND.create(fowardMsgUIDs[i], fullName);
                    }
                    origMail.loadContent();
                    originalMails[i] = origMail;
                }
            } else {
                long total = 0L;
                for (int i = 0; i < length; ++i) {
                    String fullName = arguments[i].getFullname();
                    MailMessage origMail = this.mailAccess.getMessageStorage().getMessage(fullName, fowardMsgUIDs[i], false);
                    if (null == origMail) {
                        throw MailExceptionCode.MAIL_NOT_FOUND.create(fowardMsgUIDs[i], fullName);
                    }
                    long size = origMail.getSize();
                    if (size <= 0L) {
                        size = 2048L;
                    }
                    if (maxPerMsg > 0L && size > maxPerMsg) {
                        String fileName = origMail.getSubject();
                        throw MailExceptionCode.UPLOAD_QUOTA_EXCEEDED_FOR_FILE.create(UploadUtility.getSize(maxPerMsg), null == fileName ? "" : fileName, UploadUtility.getSize(size));
                    }
                    if (max > 0L && (total += size) > max) {
                        throw MailExceptionCode.UPLOAD_QUOTA_EXCEEDED.create(UploadUtility.getSize(max));
                    }
                    origMail.loadContent();
                    originalMails[i] = origMail;
                }
            }
            return this.mailAccess.getLogicTools().getFowardMessage(originalMails, usm, setFrom);
        }
        MailMessage[] originalMails = new MailMessage[folders2.length];
        if (transportProperties.isPublishOnExceededQuota() && (!transportProperties.isPublishPrimaryAccountOnly() || 0 == accountId)) {
            for (int i = 0; i < length && sameAccount; ++i) {
                MailAccess<?, ?> ma = this.initMailAccess(arguments[i].getAccountId());
                try {
                    MailMessage origMail = ma.getMessageStorage().getMessage(arguments[i].getFullname(), fowardMsgUIDs[i], false);
                    if (null == origMail) {
                        throw MailExceptionCode.MAIL_NOT_FOUND.create(fowardMsgUIDs[i], arguments[i].getFullname());
                    }
                    origMail.loadContent();
                    originalMails[i] = origMail;
                    continue;
                }
                finally {
                    ma.close(true);
                }
            }
        } else {
            long total = 0L;
            for (int i = 0; i < length && sameAccount; ++i) {
                MailAccess<?, ?> ma = this.initMailAccess(arguments[i].getAccountId());
                try {
                    MailMessage origMail = ma.getMessageStorage().getMessage(arguments[i].getFullname(), fowardMsgUIDs[i], false);
                    if (null == origMail) {
                        throw MailExceptionCode.MAIL_NOT_FOUND.create(fowardMsgUIDs[i], arguments[i].getFullname());
                    }
                    long size = origMail.getSize();
                    if (size <= 0L) {
                        size = 2048L;
                    }
                    if (maxPerMsg > 0L && size > maxPerMsg) {
                        String fileName = origMail.getSubject();
                        throw MailExceptionCode.UPLOAD_QUOTA_EXCEEDED_FOR_FILE.create(maxPerMsg, null == fileName ? "" : fileName, size);
                    }
                    if (max > 0L && (total += size) > max) {
                        throw MailExceptionCode.UPLOAD_QUOTA_EXCEEDED.create(max);
                    }
                    origMail.loadContent();
                    originalMails[i] = origMail;
                    continue;
                }
                finally {
                    ma.close(true);
                }
            }
        }
        int[] accountIDs = new int[originalMails.length];
        for (int i = 0; i < accountIDs.length; ++i) {
            accountIDs[i] = arguments[i].getAccountId();
        }
        return MimeForward.getFowardMail(originalMails, this.session, accountIDs, usm, setFrom);
    }

    @Override
    public String getInboxFolder(int accountId) throws OXException {
        if (this.isDefaultFoldersChecked(accountId)) {
            return MailFolderUtility.prepareFullname(accountId, INBOX_ID);
        }
        this.initConnection(accountId);
        return MailFolderUtility.prepareFullname(accountId, this.mailAccess.getFolderStorage().getFolder(INBOX_ID).getFullname());
    }

    @Override
    public MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> getMailAccess() throws OXException {
        return this.mailAccess;
    }

    @Override
    public MailConfig getMailConfig() throws OXException {
        return this.mailConfig;
    }

    @Override
    public int getAccountID() {
        return this.accountId;
    }

    @Override
    public MailMessage getMessage(String folder, String msgUID) throws OXException {
        return this.getMessage(folder, msgUID, true);
    }

    @Override
    public MailMessage getMessage(String folder, String msgUID, boolean markAsSeen) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        if ("default".equals(folder)) {
            throw MailExceptionCode.FOLDER_DOES_NOT_HOLD_MESSAGES.create("default");
        }
        String fullName = argument.getFullname();
        MailMessage mail = this.mailAccess.getMessageStorage().getMessage(fullName, msgUID, markAsSeen);
        if (mail != null) {
            if (!mail.containsAccountId() || mail.getAccountId() < 0) {
                mail.setAccountId(accountId);
            }
            if (mail.containsPrevSeen() && !mail.isPrevSeen()) {
                this.postEvent("com/openexchange/push/attributes", accountId, fullName, true, true);
            }
            try {
                if (MailMessageCache.getInstance().containsFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId)) {
                    MailMessageCache.getInstance().updateCachedMessages(new String[]{mail.getMailId()}, accountId, fullName, this.session.getUserId(), this.contextId, FIELDS_FLAGS, mail.isSeen() ? ARGS_FLAG_SEEN_SET : ARGS_FLAG_SEEN_UNSET);
                }
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
        return mail;
    }

    @Override
    public MailPart getMessageAttachment(String folder, String msgUID, String attachmentPosition, boolean displayVersion) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        return this.mailAccess.getMessageStorage().getAttachment(fullName, msgUID, attachmentPosition);
    }

    @Override
    public List<MailPart> getAllMessageAttachments(String folder, String msgUID) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        MailMessage message = this.mailAccess.getMessageStorage().getMessage(folder, fullName, false);
        if (null == message) {
            throw MailExceptionCode.MAIL_NOT_FOUND.create(msgUID, fullName);
        }
        NonInlineForwardPartHandler handler = new NonInlineForwardPartHandler();
        new MailMessageParser().setInlineDetectorBehavior(true).parseMailMessage(message, handler);
        return handler.getNonInlineParts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedFile getMessages(String folder, String[] msgIds) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        MailMessage[] mails = new MailMessage[msgIds.length];
        for (int i = 0; i < msgIds.length; ++i) {
            mails[i] = this.mailAccess.getMessageStorage().getMessage(fullName, msgIds[i], false);
        }
        ManagedFileManagement mfm = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class, true);
        ManagedFile[] files = new ManagedFile[mails.length];
        try {
            UnsynchronizedByteArrayOutputStream bout = new UnsynchronizedByteArrayOutputStream(8192);
            for (int i = 0; i < files.length; ++i) {
                MailMessage mail = mails[i];
                if (null == mail) {
                    files[i] = null;
                    continue;
                }
                bout.reset();
                mail.writeTo((OutputStream)bout);
                files[i] = mfm.createManagedFile(bout.toByteArray());
            }
            try {
                File tempFile = mfm.newTempFile();
                ZipArchiveOutputStream zipOutput = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(tempFile));
                zipOutput.setEncoding("UTF-8");
                zipOutput.setUseLanguageEncodingFlag(true);
                try {
                    byte[] buf = new byte[8192];
                    HashSet<String> names = new HashSet<String>(files.length);
                    for (int i = 0; i < files.length; ++i) {
                        File tmpFile;
                        ManagedFile file = files[i];
                        File file2 = tmpFile = null == file ? null : file.getFile();
                        if (null == tmpFile) continue;
                        FileInputStream in = new FileInputStream(tmpFile);
                        try {
                            int len;
                            ZipArchiveEntry entry;
                            String subject = mails[i].getSubject();
                            String ext = ".eml";
                            String name = (Strings.isEmpty((String)subject) ? "mail" + (i + 1) : MailServletInterfaceImpl.saneForFileName(subject)) + ext;
                            int reslen = name.lastIndexOf(46);
                            int count = 1;
                            while (!names.add(name)) {
                                name = name.substring(0, reslen);
                                name = name + "_(" + count++ + ')' + ext;
                            }
                            int num = 1;
                            while (true) {
                                try {
                                    int pos = name.indexOf(ext);
                                    String entryName = name.substring(0, pos) + (num > 1 ? "_(" + num + ")" : "") + ext;
                                    entry = new ZipArchiveEntry(entryName);
                                    zipOutput.putArchiveEntry((ArchiveEntry)entry);
                                }
                                catch (ZipException e) {
                                    String message = e.getMessage();
                                    if (message == null || !message.startsWith("duplicate entry")) {
                                        throw e;
                                    }
                                    ++num;
                                    continue;
                                }
                                break;
                            }
                            long size = 0L;
                            while ((len = in.read(buf)) > 0) {
                                zipOutput.write(buf, 0, len);
                                size += (long)len;
                            }
                            entry.setSize(size);
                            zipOutput.closeArchiveEntry();
                            continue;
                        }
                        finally {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                LOG.error("", (Throwable)e);
                            }
                        }
                    }
                }
                finally {
                    try {
                        zipOutput.close();
                    }
                    catch (IOException e) {
                        LOG.error("", (Throwable)e);
                    }
                }
                ManagedFile managedFile = mfm.createManagedFile(tempFile);
                return managedFile;
            }
            catch (IOException e) {
                if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                    throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                }
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
        }
        finally {
            for (ManagedFile file : files) {
                if (null == file) continue;
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedFile getMessageAttachments(String folder, String msgUID, String[] attachmentPositions) throws OXException {
        MailPart[] parts;
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        if (null == attachmentPositions) {
            List<MailPart> l = this.getAllMessageAttachments(folder, msgUID);
            parts = l.toArray(new MailPart[l.size()]);
        } else {
            parts = new MailPart[attachmentPositions.length];
            for (int i = 0; i < parts.length; ++i) {
                parts[i] = this.mailAccess.getMessageStorage().getAttachment(fullName, msgUID, attachmentPositions[i]);
            }
        }
        ManagedFileManagement mfm = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class, true);
        ManagedFile[] files = new ManagedFile[parts.length];
        try {
            for (int i = 0; i < files.length; ++i) {
                MailPart part = parts[i];
                files[i] = null == part ? null : mfm.createManagedFile(part.getInputStream());
            }
            try {
                File tempFile = mfm.newTempFile();
                ZipArchiveOutputStream zipOutput = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(tempFile));
                zipOutput.setEncoding("UTF-8");
                zipOutput.setUseLanguageEncodingFlag(true);
                try {
                    byte[] buf = new byte[8192];
                    for (int i = 0; i < files.length; ++i) {
                        File tmpFile;
                        ManagedFile file = files[i];
                        File file2 = tmpFile = null == file ? null : file.getFile();
                        if (null == tmpFile) continue;
                        FileInputStream in = new FileInputStream(tmpFile);
                        try {
                            int len;
                            ZipArchiveEntry entry;
                            String name = parts[i].getFileName();
                            if (null == name) {
                                List<String> extensions = MimeType2ExtMap.getFileExtensions(parts[i].getContentType().getBaseType());
                                name = extensions == null || extensions.isEmpty() ? "part.dat" : "part." + extensions.get(0);
                            }
                            int num = 1;
                            while (true) {
                                try {
                                    int pos = name.indexOf(46);
                                    String entryName = pos < 0 ? name + (num > 1 ? "_(" + num + ")" : "") : name.substring(0, pos) + (num > 1 ? "_(" + num + ")" : "") + name.substring(pos);
                                    entry = new ZipArchiveEntry(entryName);
                                    zipOutput.putArchiveEntry((ArchiveEntry)entry);
                                }
                                catch (ZipException e) {
                                    String message = e.getMessage();
                                    if (message == null || !message.startsWith("duplicate entry")) {
                                        throw e;
                                    }
                                    ++num;
                                    continue;
                                }
                                break;
                            }
                            long size = 0L;
                            while ((len = in.read(buf)) > 0) {
                                zipOutput.write(buf, 0, len);
                                size += (long)len;
                            }
                            entry.setSize(size);
                            zipOutput.closeArchiveEntry();
                            continue;
                        }
                        finally {
                            Streams.close((Closeable)in);
                        }
                    }
                }
                finally {
                    Streams.close((Closeable)zipOutput);
                }
                ManagedFile managedFile = mfm.createManagedFile(tempFile);
                return managedFile;
            }
            catch (IOException e) {
                if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                    throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                }
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
        }
        finally {
            for (ManagedFile file : files) {
                if (null == file) continue;
                file.delete();
            }
        }
    }

    @Override
    public int getMessageCount(String folder) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        IMailFolderStorage folderStorage = this.mailAccess.getFolderStorage();
        if (folderStorage instanceof IMailFolderStorageEnhanced) {
            return ((IMailFolderStorageEnhanced)folderStorage).getTotalCounter(fullName);
        }
        return folderStorage.getFolder(fullName).getMessageCount();
    }

    @Override
    public MailPart getMessageImage(String folder, String msgUID, String cid) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        return this.mailAccess.getMessageStorage().getImageAttachment(fullName, msgUID, cid);
    }

    @Override
    public MailMessage[] getMessageList(String folder, String[] uids, int[] fields, String[] headerFields) throws OXException {
        MailMessage[] mails;
        IMailMessageStorage messageStorage;
        boolean loadHeaders;
        String fullName;
        int accountId;
        block17: {
            FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
            accountId = argument.getAccountId();
            fullName = argument.getFullname();
            loadHeaders = null != headerFields && 0 < headerFields.length;
            try {
                MailMessage[] mails2 = MailMessageCache.getInstance().getMessages(uids, accountId, fullName, this.session.getUserId(), this.contextId);
                if (null == mails2) break block17;
                this.accountId = accountId;
                if (loadHeaders) {
                    LinkedList<String> loadMe = new LinkedList<String>();
                    HashMap<String, MailMessage> finder = new HashMap<String, MailMessage>(mails2.length);
                    for (MailMessage mail : mails2) {
                        String mailId = mail.getMailId();
                        finder.put(mailId, mail);
                        if (mail.hasHeaders(headerFields)) continue;
                        loadMe.add(mailId);
                    }
                    if (!loadMe.isEmpty()) {
                        this.initConnection(accountId);
                        IMailMessageStorage messageStorage2 = this.mailAccess.getMessageStorage();
                        if (messageStorage2 instanceof IMailMessageStorageExt) {
                            IMailMessageStorageExt messageStorageExt = (IMailMessageStorageExt)messageStorage2;
                            for (MailMessage header : messageStorageExt.getMessages(fullName, loadMe.toArray(new String[loadMe.size()]), FIELDS_ID_INFO, headerFields)) {
                                MailMessage mailMessage;
                                if (null == header || null == (mailMessage = (MailMessage)finder.get(header.getMailId()))) continue;
                                mailMessage.addHeaders(header.getHeaders());
                            }
                        } else {
                            for (MailMessage header : messageStorage2.getMessages(fullName, loadMe.toArray(new String[loadMe.size()]), HEADERS)) {
                                MailMessage mailMessage;
                                if (null == header || null == (mailMessage = (MailMessage)finder.get(header.getMailId()))) continue;
                                mailMessage.addHeaders(header.getHeaders());
                            }
                        }
                    }
                }
                return mails2;
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
        this.initConnection(accountId);
        boolean cachable = uids.length < this.mailAccess.getMailConfig().getMailProperties().getMailFetchLimit();
        MailField[] useFields = MailField.getFields(fields);
        if (cachable) {
            useFields = MailFields.addIfAbsent(useFields, MimeStorageUtility.getCacheFieldsArray());
            useFields = MailFields.addIfAbsent(useFields, MailField.ID, MailField.FOLDER_ID);
        }
        if ((messageStorage = this.mailAccess.getMessageStorage()) instanceof IMailMessageStorageExt) {
            mails = ((IMailMessageStorageExt)messageStorage).getMessages(fullName, uids, useFields, headerFields);
        } else {
            MailField[] mailFields;
            if (loadHeaders) {
                MailFields col = new MailFields(useFields);
                col.add(MailField.HEADERS);
                mailFields = col.toArray();
            } else {
                mailFields = useFields;
            }
            mails = messageStorage.getMessages(fullName, uids, mailFields);
        }
        try {
            if (cachable && MailMessageCache.getInstance().containsFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId)) {
                MailMessageCache.getInstance().putMessages(accountId, mails, this.session.getUserId(), this.contextId);
            }
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
        return mails;
    }

    @Override
    public SearchTerm<?> createSearchTermFrom(com.openexchange.search.SearchTerm<?> searchTerm) throws OXException {
        return SearchTermMapper.map(searchTerm);
    }

    @Override
    public SearchIterator<MailMessage> getMessages(String folder, int[] fromToIndices, int sortCol, int order, com.openexchange.search.SearchTerm<?> searchTerm, boolean linkSearchTermsWithOR, int[] fields, String[] headerFields, boolean supportsContinuation) throws OXException {
        return this.getMessagesInternal(MailFolderUtility.prepareMailFolderParam(folder), SearchTermMapper.map(searchTerm), fromToIndices, sortCol, order, fields, headerFields, supportsContinuation);
    }

    @Override
    public SearchTerm<?> createSearchTermFrom(int[] searchCols, String[] searchPatterns, boolean linkSearchTermsWithOR) throws OXException {
        this.checkPatternLength(searchPatterns);
        SearchTerm<?> searchTerm = searchCols == null || searchCols.length == 0 ? null : SearchUtility.parseFields(searchCols, searchPatterns, linkSearchTermsWithOR);
        return searchTerm;
    }

    @Override
    public SearchIterator<MailMessage> getMessages(String folder, int[] fromToIndices, int sortCol, int order, int[] searchCols, String[] searchPatterns, boolean linkSearchTermsWithOR, int[] fields, String[] headerFields, boolean supportsContinuation) throws OXException {
        SearchTerm<?> searchTerm = this.createSearchTermFrom(searchCols, searchPatterns, linkSearchTermsWithOR);
        return this.getMessagesInternal(MailFolderUtility.prepareMailFolderParam(folder), searchTerm, fromToIndices, sortCol, order, fields, headerFields, supportsContinuation);
    }

    private SearchIterator<MailMessage> getMessagesInternal(FullnameArgument argument, SearchTerm<?> searchTerm, int[] fromToIndices, int sortCol, int order, int[] fields, String[] headerNames, boolean supportsContinuation) throws OXException {
        MailFields mfs;
        boolean onlyFolderAndID;
        MailField[] useFields;
        boolean cachable;
        if (this.checkParameters) {
            MailFields mailFields = MailFields.valueOf(fields);
            if (null == fromToIndices && mailFields.retainAll(this.folderAndId)) {
                throw MailExceptionCode.REQUEST_NOT_PERMITTED.create("Only folder and ID are allowed to be queried without a range");
            }
        }
        String fullName = argument.getFullname();
        MailMessage[] mails = null;
        IndexRange indexRange = null == fromToIndices ? IndexRange.NULL : new IndexRange(fromToIndices[0], fromToIndices[1]);
        MailSortField sortField = MailSortField.getField(sortCol);
        OrderDirection orderDir = OrderDirection.getOrderDirection(order);
        if ("unified/inbox".equalsIgnoreCase(fullName)) {
            UnifiedViewService unifiedView = ServerServiceRegistry.getInstance().getService(UnifiedViewService.class);
            if (null == unifiedView) {
                throw MailExceptionCode.FOLDER_NOT_FOUND.create(fullName);
            }
            mails = unifiedView.searchMessages(UnifiedFullName.INBOX, indexRange, sortField, orderDir, searchTerm, FIELDS_ID_INFO, this.session);
            int accountId = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class).getUnifiedINBOXAccountID(this.session);
            this.initConnection(accountId);
            fullName = UnifiedFullName.INBOX.getFullName();
        } else {
            int accountId = argument.getAccountId();
            this.initConnection(accountId);
            if (IndexRange.NULL != indexRange) {
                return this.getMessageRange(searchTerm, fields, headerNames, fullName, indexRange, sortField, orderDir, accountId);
            }
            mails = this.mailAccess.getMessageStorage().searchMessages(fullName, indexRange, sortField, orderDir, searchTerm, FIELDS_ID_INFO);
        }
        if (mails == null || mails.length == 0 || MailServletInterfaceImpl.onlyNull(mails)) {
            return SearchIteratorAdapter.emptyIterator();
        }
        boolean bl = cachable = mails.length < this.mailAccess.getMailConfig().getMailProperties().getMailFetchLimit();
        if (cachable) {
            useFields = MailFields.addIfAbsent(MailField.getFields(fields), MimeStorageUtility.getCacheFieldsArray());
            useFields = MailFields.addIfAbsent(useFields, MailField.ID, MailField.FOLDER_ID);
            onlyFolderAndID = false;
        } else {
            useFields = MailField.getFields(fields);
            boolean bl2 = onlyFolderAndID = null != headerNames && 0 < headerNames.length ? false : MailServletInterfaceImpl.onlyFolderAndID(useFields);
        }
        if (supportsContinuation && !(mfs = new MailFields(useFields)).contains(MailField.SUPPORTS_CONTINUATION)) {
            mfs.add(MailField.SUPPORTS_CONTINUATION);
            useFields = mfs.toArray();
        }
        if (!onlyFolderAndID && !MailServletInterfaceImpl.containsAll(MailServletInterfaceImpl.firstNotNull(mails), useFields)) {
            String[] mailIds = new String[mails.length];
            for (int i = 0; i < mailIds.length; ++i) {
                MailMessage m = mails[i];
                if (null == m) continue;
                mailIds[i] = m.getMailId();
            }
            if (null != headerNames && 0 < headerNames.length) {
                IMailMessageStorage messageStorage = this.mailAccess.getMessageStorage();
                if (messageStorage instanceof IMailMessageStorageExt) {
                    mails = ((IMailMessageStorageExt)messageStorage).getMessages(fullName, mailIds, useFields, headerNames);
                } else {
                    useFields = MailFields.addIfAbsent(useFields, MailField.ID);
                    mails = messageStorage.getMessages(fullName, mailIds, useFields);
                    MessageUtility.enrichWithHeaders(fullName, mails, headerNames, messageStorage);
                }
            } else {
                mails = this.mailAccess.getMessageStorage().getMessages(fullName, mailIds, useFields);
            }
            if (mails == null || mails.length == 0 || MailServletInterfaceImpl.onlyNull(mails)) {
                return SearchIteratorAdapter.emptyIterator();
            }
        }
        LinkedList<MailMessage> l = new LinkedList<MailMessage>();
        for (MailMessage mail : mails) {
            if (mail == null) continue;
            if (!mail.containsAccountId() || mail.getAccountId() < 0) {
                mail.setAccountId(this.accountId);
            }
            l.add(mail);
        }
        try {
            MailMessageCache.getInstance().removeUserMessages(this.session.getUserId(), this.contextId);
            if (cachable && mails.length > 0) {
                MailMessageCache.getInstance().putMessages(this.accountId, mails, this.session.getUserId(), this.contextId);
            }
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
        return new SearchIteratorDelegator(l);
    }

    private SearchIterator<MailMessage> getMessageRange(SearchTerm<?> searchTerm, int[] fields, String[] headerNames, String fullName, IndexRange indexRange, MailSortField sortField, OrderDirection orderDir, int accountId) throws OXException {
        MailMessage mail;
        Object[] mails;
        boolean cachable = indexRange.end - indexRange.start < this.mailAccess.getMailConfig().getMailProperties().getMailFetchLimit();
        MailField[] useFields = MailField.getFields(fields);
        if (cachable) {
            useFields = MailFields.addIfAbsent(useFields, MimeStorageUtility.getCacheFieldsArray());
            useFields = MailFields.addIfAbsent(useFields, MailField.ID, MailField.FOLDER_ID);
        }
        if (null != headerNames && 0 < headerNames.length) {
            IMailMessageStorage messageStorage = this.mailAccess.getMessageStorage();
            if (messageStorage instanceof IMailMessageStorageExt) {
                mails = ((IMailMessageStorageExt)messageStorage).searchMessages(fullName, indexRange, sortField, orderDir, searchTerm, useFields, headerNames);
            } else {
                mails = this.mailAccess.getMessageStorage().searchMessages(fullName, indexRange, sortField, orderDir, searchTerm, useFields);
                MessageUtility.enrichWithHeaders(fullName, (MailMessage[])mails, headerNames, messageStorage);
            }
        } else {
            mails = this.mailAccess.getMessageStorage().searchMessages(fullName, indexRange, sortField, orderDir, searchTerm, useFields);
        }
        ArrayList<Object> l = null;
        int j = 0;
        boolean b = true;
        while (b && j < mails.length) {
            mail = mails[j];
            if (mail == null) {
                l = new ArrayList<Object>(mails.length);
                if (j > 0) {
                    for (int k = 0; k < j; ++k) {
                        l.add(mails[k]);
                    }
                }
                b = false;
                continue;
            }
            if (!mail.containsAccountId() || mail.getAccountId() < 0) {
                mail.setAccountId(accountId);
            }
            ++j;
        }
        if (null != l && j < mails.length) {
            while (j < mails.length) {
                mail = mails[j];
                if (mail != null) {
                    if (!mail.containsAccountId() || mail.getAccountId() < 0) {
                        mail.setAccountId(accountId);
                    }
                    l.add(mail);
                }
                ++j;
            }
            mails = l.toArray(new MailMessage[l.size()]);
            l = null;
        }
        try {
            MailMessageCache.getInstance().removeUserMessages(this.session.getUserId(), this.contextId);
            if (cachable && mails.length > 0) {
                MailMessageCache.getInstance().putMessages(accountId, (MailMessage[])mails, this.session.getUserId(), this.contextId);
            }
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
        return new ArrayIterator(mails);
    }

    private static boolean onlyNull(MailMessage[] mails) {
        boolean ret = true;
        int i = mails.length;
        while (ret && i-- > 0) {
            ret = null == mails[i];
        }
        return ret;
    }

    private static MailMessage firstNotNull(MailMessage[] mails) {
        int i = mails.length;
        while (i-- > 0) {
            MailMessage m = mails[i];
            if (null == m) continue;
            return m;
        }
        return null;
    }

    private static boolean containsAll(MailMessage candidate, MailField[] fields) {
        if (null == candidate) {
            return false;
        }
        boolean contained = true;
        int length = fields.length;
        block19: for (int i = 0; contained && i < length; ++i) {
            MailField field = fields[i];
            switch (field) {
                case ACCOUNT_NAME: {
                    contained = candidate.containsAccountId() || candidate.containsAccountName();
                    continue block19;
                }
                case BCC: {
                    contained = candidate.containsBcc();
                    continue block19;
                }
                case CC: {
                    contained = candidate.containsCc();
                    continue block19;
                }
                case COLOR_LABEL: {
                    contained = candidate.containsColorLabel();
                    continue block19;
                }
                case CONTENT_TYPE: {
                    contained = candidate.containsContentType();
                    continue block19;
                }
                case DISPOSITION_NOTIFICATION_TO: {
                    contained = candidate.containsDispositionNotification();
                    continue block19;
                }
                case FLAGS: {
                    contained = candidate.containsFlags();
                    continue block19;
                }
                case FOLDER_ID: {
                    contained = true;
                    continue block19;
                }
                case FROM: {
                    contained = candidate.containsFrom();
                    continue block19;
                }
                case ID: {
                    contained = null != candidate.getMailId();
                    continue block19;
                }
                case PRIORITY: {
                    contained = candidate.containsPriority();
                    continue block19;
                }
                case RECEIVED_DATE: {
                    contained = candidate.containsReceivedDate();
                    continue block19;
                }
                case SENT_DATE: {
                    contained = candidate.containsSentDate();
                    continue block19;
                }
                case SIZE: {
                    contained = candidate.containsSize();
                    continue block19;
                }
                case SUBJECT: {
                    contained = candidate.containsSubject();
                    continue block19;
                }
                case THREAD_LEVEL: {
                    contained = candidate.containsThreadLevel();
                    continue block19;
                }
                case TO: {
                    contained = candidate.containsTo();
                    continue block19;
                }
                default: {
                    contained = false;
                }
            }
        }
        return contained;
    }

    private static boolean onlyFolderAndID(MailField[] fields) {
        if (fields.length != 2) {
            return false;
        }
        int i = 0;
        for (MailField field : fields) {
            if (MailField.ID.equals((Object)field)) {
                i |= 1;
                continue;
            }
            if (!MailField.FOLDER_ID.equals((Object)field)) continue;
            i |= 2;
        }
        return i == 3;
    }

    @Override
    public String[] appendMessages(String destFolder, MailMessage[] mails, boolean force) throws OXException {
        return this.appendMessages(destFolder, mails, force, false);
    }

    @Override
    public String[] importMessages(String destFolder, MailMessage[] mails, boolean force) throws OXException {
        return this.appendMessages(destFolder, mails, force, true);
    }

    public String[] appendMessages(String destFolder, MailMessage[] mails, boolean force, boolean isImport) throws OXException {
        if (mails == null || mails.length == 0) {
            return new String[0];
        }
        if (!force) {
            try {
                HashSet<InternetAddress> validAddrs = new HashSet<InternetAddress>(4);
                if (this.usm.getSendAddr() != null && this.usm.getSendAddr().length() > 0) {
                    validAddrs.add(new QuotedInternetAddress(this.usm.getSendAddr()));
                }
                User user = this.getUser();
                validAddrs.add(new QuotedInternetAddress(user.getMail()));
                for (String alias : user.getAliases()) {
                    validAddrs.add(new QuotedInternetAddress(alias));
                }
                boolean supportMsisdnAddresses = MailProperties.getInstance().isSupportMsisdnAddresses();
                if (supportMsisdnAddresses) {
                    MsisdnUtility.addMsisdnAddress(validAddrs, this.session);
                }
                for (MailMessage mail : mails) {
                    Object[] from = mail.getFrom();
                    List<InternetAddress> froms = Arrays.asList(from);
                    if (supportMsisdnAddresses) {
                        for (InternetAddress internetAddress : froms) {
                            String address = internetAddress.getAddress();
                            int pos = address.indexOf(47);
                            if (pos <= 0) continue;
                            internetAddress.setAddress(address.substring(0, pos));
                        }
                    }
                    if (validAddrs.containsAll(froms)) continue;
                    throw MailExceptionCode.INVALID_SENDER.create(froms.size() == 1 ? froms.get(0).toString() : Arrays.toString(from));
                }
            }
            catch (AddressException e) {
                throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
            }
        }
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(destFolder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        if (this.mailAccess.getFolderStorage().getDraftsFolder().equals(fullName)) {
            for (MailMessage mail : mails) {
                mail.setFlag(4, true);
            }
        }
        if (!isImport) {
            return this.mailAccess.getMessageStorage().appendMessages(fullName, mails);
        }
        IMailMessageStorage messageStorage = this.mailAccess.getMessageStorage();
        MailMessage[] tmp = new MailMessage[1];
        LinkedList<String> idList = new LinkedList<String>();
        for (MailMessage mail : mails) {
            MailImportResult mir = new MailImportResult();
            mir.setMail(mail);
            try {
                tmp[0] = mail;
                String[] idStr = messageStorage.appendMessages(fullName, tmp);
                mir.setId(idStr[0]);
                idList.add(idStr[0]);
            }
            catch (OXException e) {
                mir.setException(e);
            }
            this.mailImportResults.add(mir);
        }
        String[] ids = new String[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            ids[i] = (String)idList.get(i);
        }
        return ids;
    }

    @Override
    public int getNewMessageCount(String folder) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        return this.mailAccess.getFolderStorage().getFolder(fullName).getNewMessageCount();
    }

    @Override
    public SearchIterator<MailMessage> getNewMessages(String folder, int sortCol, int order, int[] fields, int limit) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        return SearchIteratorAdapter.createArrayIterator((Object[])this.mailAccess.getMessageStorage().getUnreadMessages(fullName, MailSortField.getField(sortCol), OrderDirection.getOrderDirection(order), MailField.toFields(MailListField.getFields(fields)), limit));
    }

    @Override
    public SearchIterator<MailFolder> getPathToDefaultFolder(String folder) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        return SearchIteratorAdapter.createArrayIterator((Object[])this.mailAccess.getFolderStorage().getPath2DefaultFolder(fullName));
    }

    @Override
    public long[][] getQuotas(int[] types) throws OXException {
        this.initConnection(0);
        Quota.Type[] qtypes = new Quota.Type[types.length];
        for (int i = 0; i < qtypes.length; ++i) {
            qtypes[i] = MailServletInterfaceImpl.getType(types[i]);
        }
        Quota[] quotas = this.mailAccess.getFolderStorage().getQuotas(INBOX_ID, qtypes);
        long[][] retval = new long[quotas.length][];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = quotas[i].toLongArray();
        }
        return retval;
    }

    @Override
    public long getQuotaLimit(int type) throws OXException {
        this.initConnection(0);
        if (1 == type) {
            return this.mailAccess.getFolderStorage().getStorageQuota(INBOX_ID).getLimit();
        }
        if (2 == type) {
            return this.mailAccess.getFolderStorage().getMessageQuota(INBOX_ID).getLimit();
        }
        throw new IllegalArgumentException("Unknown quota resource type: " + type);
    }

    @Override
    public long getQuotaUsage(int type) throws OXException {
        this.initConnection(0);
        if (1 == type) {
            return this.mailAccess.getFolderStorage().getStorageQuota(INBOX_ID).getUsage();
        }
        if (2 == type) {
            return this.mailAccess.getFolderStorage().getMessageQuota(INBOX_ID).getUsage();
        }
        throw new IllegalArgumentException("Unknown quota resource type: " + type);
    }

    private static Quota.Type getType(int type) {
        if (1 == type) {
            return Quota.Type.STORAGE;
        }
        if (2 == type) {
            return Quota.Type.MESSAGE;
        }
        throw new IllegalArgumentException("Unknown quota resource type: " + type);
    }

    @Override
    public MailMessage getReplyMessageForDisplay(String folder, String replyMsgUID, boolean replyToAll, UserSettingMail usm, boolean setFrom) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        MailMessage originalMail = this.mailAccess.getMessageStorage().getMessage(fullName, replyMsgUID, false);
        if (null == originalMail) {
            throw MailExceptionCode.MAIL_NOT_FOUND.create(replyMsgUID, fullName);
        }
        return this.mailAccess.getLogicTools().getReplyMessage(originalMail, replyToAll, usm, setFrom);
    }

    @Override
    public SearchIterator<MailFolder> getRootFolders() throws OXException {
        this.initConnection(0);
        return SearchIteratorAdapter.createArrayIterator((Object[])new MailFolder[]{this.mailAccess.getFolderStorage().getRootFolder()});
    }

    @Override
    public String getSentFolder(int accountId) throws OXException {
        if (this.isDefaultFoldersChecked(accountId)) {
            return MailFolderUtility.prepareFullname(accountId, this.getDefaultMailFolder(1, accountId));
        }
        this.initConnection(accountId);
        return MailFolderUtility.prepareFullname(accountId, this.mailAccess.getFolderStorage().getSentFolder());
    }

    @Override
    public String getSpamFolder(int accountId) throws OXException {
        if (this.isDefaultFoldersChecked(accountId)) {
            return MailFolderUtility.prepareFullname(accountId, this.getDefaultMailFolder(2, accountId));
        }
        this.initConnection(accountId);
        return MailFolderUtility.prepareFullname(accountId, this.mailAccess.getFolderStorage().getSpamFolder());
    }

    @Override
    public SearchIterator<MailMessage> getThreadedMessages(String folder, int[] fromToIndices, int sortCol, int order, int[] searchCols, String[] searchPatterns, boolean linkSearchTermsWithOR, int[] fields) throws OXException {
        boolean onlyFolderAndID;
        MailField[] useFields;
        boolean cacheable;
        this.checkPatternLength(searchPatterns);
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        SearchTerm<?> searchTerm = searchCols == null || searchCols.length == 0 ? null : SearchUtility.parseFields(searchCols, searchPatterns, linkSearchTermsWithOR);
        Object[] mails = this.mailAccess.getMessageStorage().getThreadSortedMessages(fullName, fromToIndices == null ? IndexRange.NULL : new IndexRange(fromToIndices[0], fromToIndices[1]), MailSortField.getField(sortCol), OrderDirection.getOrderDirection(order), searchTerm, FIELDS_ID_INFO);
        if (mails == null || mails.length == 0) {
            return SearchIteratorAdapter.emptyIterator();
        }
        boolean bl = cacheable = mails.length < this.mailAccess.getMailConfig().getMailProperties().getMailFetchLimit();
        if (cacheable) {
            useFields = MailFields.addIfAbsent(MailField.getFields(fields), MimeStorageUtility.getCacheFieldsArray());
            useFields = MailFields.addIfAbsent(useFields, MailField.ID, MailField.FOLDER_ID);
            onlyFolderAndID = false;
        } else {
            useFields = MailField.toFields(MailListField.getFields(fields));
            onlyFolderAndID = MailServletInterfaceImpl.onlyFolderAndID(useFields);
        }
        if (!onlyFolderAndID) {
            String[] mailIds = new String[mails.length];
            for (int i = 0; i < mailIds.length; ++i) {
                mailIds[i] = mails[i].getMailId();
            }
            MailMessage[] fetchedMails = this.mailAccess.getMessageStorage().getMessages(fullName, mailIds, useFields);
            for (int i = 0; i < fetchedMails.length; ++i) {
                MailMessage mailMessage = fetchedMails[i];
                if (null == mailMessage) continue;
                mailMessage.setThreadLevel(((MailMessage)mails[i]).getThreadLevel());
            }
            mails = fetchedMails;
        }
        for (MailMessage mailMessage : mails) {
            if (mailMessage == null || mailMessage.containsAccountId() && mailMessage.getAccountId() >= 0) continue;
            mailMessage.setAccountId(accountId);
        }
        try {
            MailMessageCache.getInstance().removeFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId);
            if (mails.length > 0 && cacheable) {
                MailMessageCache.getInstance().putMessages(accountId, (MailMessage[])mails, this.session.getUserId(), this.contextId);
            }
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
        return SearchIteratorAdapter.createArrayIterator((Object[])mails);
    }

    private void checkPatternLength(String[] patterns) throws OXException {
        int minimumSearchCharacters = ServerConfig.getInt(ServerConfig.Property.MINIMUM_SEARCH_CHARACTERS);
        if (0 == minimumSearchCharacters || null == patterns) {
            return;
        }
        for (String pattern : patterns) {
            if (null == pattern || SearchStrings.lengthWithoutWildcards(pattern) >= minimumSearchCharacters) continue;
            throw MailExceptionCode.PATTERN_TOO_SHORT.create(Autoboxing.I((int)minimumSearchCharacters));
        }
    }

    @Override
    public String getTrashFolder(int accountId) throws OXException {
        if (this.isDefaultFoldersChecked(accountId)) {
            return MailFolderUtility.prepareFullname(accountId, this.getDefaultMailFolder(3, accountId));
        }
        this.initConnection(accountId);
        return MailFolderUtility.prepareFullname(accountId, this.mailAccess.getFolderStorage().getTrashFolder());
    }

    @Override
    public int getUnreadMessageCount(String folder) throws OXException {
        int retval;
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        String fullName = argument.getFullname();
        if (!this.init) {
            this.mailAccess = MailAccess.getInstance(this.session, accountId);
            retval = this.mailAccess.getUnreadMessagesCount(fullName);
            this.mailConfig = this.mailAccess.getMailConfig();
            this.accountId = accountId;
            this.init = true;
        } else if (accountId != this.mailAccess.getAccountId()) {
            this.mailAccess.close(true);
            this.mailAccess = MailAccess.getInstance(this.session, accountId);
            retval = this.mailAccess.getUnreadMessagesCount(fullName);
            this.mailConfig = this.mailAccess.getMailConfig();
            this.accountId = accountId;
        } else {
            retval = this.mailAccess.getUnreadMessagesCount(fullName);
        }
        return retval;
    }

    @Override
    public void openFor(String folder) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
    }

    void initConnection(int accountId) throws OXException {
        if (!this.init) {
            this.mailAccess = this.initMailAccess(accountId);
            this.mailConfig = this.mailAccess.getMailConfig();
            this.accountId = accountId;
            this.init = true;
        } else if (accountId != this.mailAccess.getAccountId()) {
            this.mailAccess.close(true);
            this.mailAccess = this.initMailAccess(accountId);
            this.mailConfig = this.mailAccess.getMailConfig();
            this.accountId = accountId;
        }
    }

    private MailAccess<?, ?> initMailAccess(int accountId) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = MailAccess.getInstance(this.session, accountId);
        if (!mailAccess.isConnected()) {
            long start = System.currentTimeMillis();
            try {
                mailAccess.connect();
                this.warnings.addAll(mailAccess.getWarnings());
                MailServletInterface.mailInterfaceMonitor.addUseTime(System.currentTimeMillis() - start);
                MailServletInterface.mailInterfaceMonitor.changeNumSuccessfulLogins(true);
            }
            catch (OXException e) {
                if (MimeMailExceptionCode.LOGIN_FAILED.equals(e) || MimeMailExceptionCode.INVALID_CREDENTIALS.equals(e)) {
                    MailServletInterface.mailInterfaceMonitor.changeNumFailedLogins(true);
                }
                throw e;
            }
        }
        return mailAccess;
    }

    private boolean isDefaultFoldersChecked(int accountId) {
        Boolean b = (Boolean)MailSessionCache.getInstance(this.session).getParameter(accountId, MailSessionParameterNames.getParamDefaultFolderChecked());
        return b != null && b != false;
    }

    @Override
    public MailPath saveDraft(ComposedMailMessage draftMail, boolean autosave, int accountId) throws OXException {
        MailMessage draftMessage;
        if (autosave) {
            return this.autosaveDraft(draftMail, accountId);
        }
        this.initConnection(accountId);
        String draftFullname = this.mailAccess.getFolderStorage().getDraftsFolder();
        if (!draftMail.containsSentDate()) {
            draftMail.setSentDate(new Date());
        }
        if (null == (draftMessage = this.mailAccess.getMessageStorage().saveDraft(draftFullname, draftMail))) {
            return null;
        }
        MailPath mailPath = draftMessage.getMailPath();
        if (null == mailPath) {
            return null;
        }
        this.postEvent(accountId, draftFullname, true);
        return mailPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MailPath autosaveDraft(ComposedMailMessage draftMail, int accountId) throws OXException {
        this.initConnection(accountId);
        String draftFullname = this.mailAccess.getFolderStorage().getDraftsFolder();
        if (!draftMail.isDraft()) {
            draftMail.setFlag(4, true);
        }
        MailPath msgref = draftMail.getMsgref();
        MailAccess<IMailFolderStorage, IMailMessageStorage> otherAccess = null;
        try {
            MailMessage m;
            String uid;
            MailMessage origMail;
            if (null == msgref || !draftFullname.equals(msgref.getFolder())) {
                origMail = null;
            } else {
                if (msgref.getAccountId() == accountId) {
                    origMail = this.mailAccess.getMessageStorage().getMessage(msgref.getFolder(), msgref.getMailID(), false);
                } else {
                    otherAccess = MailAccess.getInstance(this.session, msgref.getAccountId());
                    otherAccess.connect(true);
                    origMail = otherAccess.getMessageStorage().getMessage(msgref.getFolder(), msgref.getMailID(), false);
                }
                if (origMail != null) {
                    NonInlineForwardPartHandler handler = new NonInlineForwardPartHandler();
                    new MailMessageParser().parseMailMessage(origMail, handler);
                    List<MailPart> parts = handler.getNonInlineParts();
                    if (!parts.isEmpty()) {
                        TransportProvider tp = TransportProviderRegistry.getTransportProviderBySession(this.session, accountId);
                        for (MailPart mailPart : parts) {
                            draftMail.addEnclosedPart(tp.getNewReferencedPart(mailPart, this.session));
                        }
                    }
                }
            }
            MailMessage filledMail = MimeMessageConverter.fillComposedMailMessage(draftMail);
            filledMail.setFlag(4, true);
            if (!filledMail.containsSentDate()) {
                filledMail.setSentDate(new Date());
            }
            if (null == (uid = this.mailAccess.getMessageStorage().appendMessages(draftFullname, new MailMessage[]{filledMail})[0])) {
                filledMail = null;
                return filledMail;
            }
            if (origMail != null) {
                if (origMail.isDraft() && null != msgref) {
                    if (msgref.getAccountId() == accountId) {
                        this.mailAccess.getMessageStorage().deleteMessages(msgref.getFolder(), new String[]{msgref.getMailID()}, true);
                    } else if (null != otherAccess) {
                        otherAccess.getMessageStorage().deleteMessages(msgref.getFolder(), new String[]{msgref.getMailID()}, true);
                    }
                }
                draftMail.setMsgref(null);
            }
            if (null == (m = this.mailAccess.getMessageStorage().getMessage(draftFullname, uid, true))) {
                throw MailExceptionCode.MAIL_NOT_FOUND.create(Long.valueOf(uid), draftFullname);
            }
            this.postEvent(accountId, draftFullname, true);
            MailPath mailPath = m.getMailPath();
            return mailPath;
        }
        finally {
            if (null != otherAccess) {
                otherAccess.close(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String saveFolder(MailFolderDescription mailFolder) throws OXException {
        if (!mailFolder.containsExists() && !mailFolder.containsFullname()) {
            throw MailExceptionCode.INSUFFICIENT_FOLDER_ATTR.create();
        }
        String name = mailFolder.getName();
        if (null != name) {
            MailServletInterfaceImpl.checkFolderName(name);
        }
        if (mailFolder.containsExists() && mailFolder.exists() || mailFolder.getFullname() != null && this.mailAccess.getFolderStorage().exists(mailFolder.getFullname())) {
            String newName;
            String oldName;
            String oldParent;
            int accountId = mailFolder.getAccountId();
            String fullName = mailFolder.getFullname();
            this.initConnection(accountId);
            char separator = mailFolder.getSeparator();
            int pos = fullName.lastIndexOf(separator);
            if (pos == -1) {
                oldParent = "";
                oldName = fullName;
            } else {
                oldParent = fullName.substring(0, pos);
                oldName = fullName.substring(pos + 1);
            }
            boolean movePerformed = false;
            if (mailFolder.containsParentFullname()) {
                int parentAccountID = mailFolder.getParentAccountId();
                if (accountId == parentAccountID) {
                    String newParent = mailFolder.getParentFullname();
                    StringBuilder newFullname = new StringBuilder(newParent).append(mailFolder.getSeparator());
                    if (mailFolder.containsName()) {
                        newFullname.append(mailFolder.getName());
                    } else {
                        newFullname.append(oldName);
                    }
                    if (!newParent.equals(oldParent)) {
                        Map<String, Map<?, ?>> subfolders = this.subfolders(fullName);
                        fullName = this.mailAccess.getFolderStorage().moveFolder(fullName, newFullname.toString());
                        movePerformed = true;
                        this.postEvent4Subfolders(accountId, subfolders);
                        this.postEventRemote(accountId, newParent, false, true);
                    }
                } else {
                    MailAccess<?, ?> otherAccess = this.initMailAccess(parentAccountID);
                    try {
                        String newParent = mailFolder.getParentFullname();
                        MailFolder p = otherAccess.getFolderStorage().getFolder(newParent);
                        MailPermission ownPermission = p.getOwnPermission();
                        if (!ownPermission.canCreateSubfolders()) {
                            throw MailExceptionCode.NO_CREATE_ACCESS.create(newParent);
                        }
                        MailFolder[] tmp = otherAccess.getFolderStorage().getSubfolders(newParent, true);
                        String lookFor = mailFolder.containsName() ? mailFolder.getName() : oldName;
                        for (MailFolder sub : tmp) {
                            if (!sub.getName().equals(lookFor)) continue;
                            throw MailExceptionCode.DUPLICATE_FOLDER.create(lookFor);
                        }
                        String destFullname = MailServletInterfaceImpl.fullCopy(this.mailAccess, fullName, otherAccess, newParent, p.getSeparator(), this.session.getUserId(), otherAccess.getMailConfig().getCapabilities().hasPermissions());
                        this.postEventRemote(parentAccountID, newParent, false, true);
                        Map<String, Map<?, ?>> subfolders = this.subfolders(fullName);
                        this.mailAccess.getFolderStorage().deleteFolder(fullName, true);
                        String prepareFullname = MailFolderUtility.prepareFullname(parentAccountID, otherAccess.getFolderStorage().updateFolder(destFullname, mailFolder));
                        this.postEvent4Subfolders(accountId, subfolders);
                        String string = prepareFullname;
                        return string;
                    }
                    finally {
                        otherAccess.close(true);
                    }
                }
            }
            if (!movePerformed && mailFolder.containsName() && !(newName = mailFolder.getName()).equals(oldName)) {
                fullName = this.mailAccess.getFolderStorage().renameFolder(fullName, newName);
                this.postEventRemote(accountId, fullName, false, true);
            }
            String prepareFullname = MailFolderUtility.prepareFullname(accountId, this.mailAccess.getFolderStorage().updateFolder(fullName, mailFolder));
            this.postEventRemote(accountId, fullName, false, true);
            return prepareFullname;
        }
        int accountId = mailFolder.getParentAccountId();
        this.initConnection(accountId);
        String prepareFullname = MailFolderUtility.prepareFullname(accountId, this.mailAccess.getFolderStorage().createFolder(mailFolder));
        this.postEventRemote(accountId, mailFolder.getParentFullname(), false, true);
        return prepareFullname;
    }

    private static String fullCopy(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> srcAccess, String srcFullname, MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> destAccess, String destParent, char destSeparator, int user, boolean hasPermissions) throws OXException {
        MailFolder[] tmp;
        MailFolder source = srcAccess.getFolderStorage().getFolder(srcFullname);
        MailFolderDescription mfd = new MailFolderDescription();
        mfd.setName(source.getName());
        mfd.setParentFullname(destParent);
        mfd.setSeparator(destSeparator);
        mfd.setSubscribed(source.isSubscribed());
        if (hasPermissions) {
            MailPermission[] perms = source.getPermissions();
            try {
                for (MailPermission perm : perms) {
                    mfd.addPermission((MailPermission)perm.clone());
                }
            }
            catch (CloneNotSupportedException e) {
                throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        }
        String destFullname = destAccess.getFolderStorage().createFolder(mfd);
        MailMessage[] msgs = srcAccess.getMessageStorage().getAllMessages(srcFullname, null, MailSortField.RECEIVED_DATE, OrderDirection.ASC, FIELDS_FULL);
        IMailMessageStorage destMessageStorage = destAccess.getMessageStorage();
        destMessageStorage.appendMessages(destFullname, msgs);
        for (MailFolder element : tmp = srcAccess.getFolderStorage().getSubfolders(srcFullname, true)) {
            MailServletInterfaceImpl.fullCopy(srcAccess, element.getFullname(), destAccess, destFullname, destSeparator, user, hasPermissions);
        }
        return destFullname;
    }

    private static void checkFolderName(String name) throws OXException {
        if (Strings.isEmpty((String)name)) {
            throw MailExceptionCode.INVALID_FOLDER_NAME_EMPTY.create();
        }
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            if (INVALID.indexOf(name.charAt(i)) < 0) continue;
            throw MailExceptionCode.INVALID_FOLDER_NAME2.create(name, INVALID);
        }
    }

    @Override
    public void sendFormMail(ComposedMailMessage composedMail, int groupId, int accountId) throws OXException {
        this.initConnection(accountId);
        try (MailTransport transport = MailTransport.getInstance(this.session, accountId);){
            GroupStorage gs = GroupStorage.getInstance();
            Group group = gs.getGroup(groupId, this.ctx);
            int[] members = group.getMember();
            UserStorage us = UserStorage.getInstance();
            ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
            String content = (String)composedMail.getContent();
            StringBuilder builder = new StringBuilder(content.length() + 64);
            TransportProvider provider = TransportProviderRegistry.getTransportProviderBySession(this.session, accountId);
            HashMap<Locale, String> greetings = new HashMap<Locale, String>(4);
            for (int userId : members) {
                User user = us.getUser(userId, this.ctx);
                Contact contact = contactService.getUser(this.session, userId, new ContactField[]{ContactField.SUR_NAME, ContactField.GIVEN_NAME});
                Locale locale = user.getLocale();
                String greeting = (String)greetings.get(locale);
                if (null == greeting) {
                    greeting = StringHelper.valueOf(locale).getString("Dear Sir or Madam");
                    greetings.put(locale, greeting);
                }
                builder.setLength(0);
                builder.append(greeting).append(' ');
                builder.append(contact.getGivenName()).append(' ').append(contact.getSurName());
                builder.append("<br><br>").append(content);
                TextBodyMailPart part = provider.getNewTextBodyPart(builder.toString());
                composedMail.setBodyPart(part);
                composedMail.removeTo();
                composedMail.removeBcc();
                composedMail.removeCc();
                composedMail.addTo(new QuotedInternetAddress(user.getMail()));
                MailProperties properties = MailProperties.getInstance();
                if (IPRange.isWhitelistedFromRateLimit(this.session.getLocalIp(), properties.getDisabledRateLimitRanges())) {
                    transport.sendMailMessage(composedMail, ComposeType.NEW);
                    continue;
                }
                if (!properties.getRateLimitPrimaryOnly() || 0 == accountId) {
                    int rateLimit = properties.getRateLimit();
                    this.rateLimitChecks(composedMail, rateLimit, properties.getMaxToCcBcc());
                    transport.sendMailMessage(composedMail, ComposeType.NEW);
                    this.setRateLimitTime(rateLimit);
                    continue;
                }
                transport.sendMailMessage(composedMail, ComposeType.NEW);
            }
        }
    }

    @Override
    public String sendMessage(ComposedMailMessage composedMail, ComposeType type, int accountId) throws OXException {
        return this.sendMessage(composedMail, type, accountId, UserSettingMailStorage.getInstance().getUserSettingMail(this.session.getUserId(), this.ctx));
    }

    @Override
    public String sendMessage(ComposedMailMessage composedMail, ComposeType type, int accountId, UserSettingMail optUserSetting) throws OXException {
        return this.sendMessage(composedMail, type, accountId, optUserSetting, null);
    }

    @Override
    public String sendMessage(ComposedMailMessage composedMail, ComposeType type, int accountId, UserSettingMail optUserSetting, MtaStatusInfo statusInfo) throws OXException {
        return this.sendMessage(composedMail, type, accountId, optUserSetting, statusInfo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendMessage(ComposedMailMessage composedMail, ComposeType type, int accountId, UserSettingMail optUserSetting, MtaStatusInfo statusInfo, String remoteAddress) throws OXException {
        OXException oxError;
        this.initConnection(accountId);
        boolean mailSent = false;
        try (MailTransport transport = MailTransport.getInstance(this.session, accountId);){
            UserSettingMail usm;
            MailMessage sentMail;
            block42: {
                ObjectUseCountService objectUseCountService;
                long startTransport;
                ArrayList<InternetAddress> validRecipients;
                block41: {
                    oxError = null;
                    validRecipients = null;
                    startTransport = System.currentTimeMillis();
                    try {
                        String remoteAddr;
                        MailProperties properties = MailProperties.getInstance();
                        String string = remoteAddr = null == remoteAddress ? this.session.getLocalIp() : remoteAddress;
                        if (IPRange.isWhitelistedFromRateLimit(remoteAddr, properties.getDisabledRateLimitRanges())) {
                            sentMail = transport.sendMailMessage(composedMail, type, null, statusInfo);
                        } else if (!properties.getRateLimitPrimaryOnly() || 0 == accountId) {
                            int rateLimit = properties.getRateLimit();
                            LOG.debug("Checking rate limit {} for request with IP {} ({}) from user {} in context {}", new Object[]{rateLimit, remoteAddr, null == remoteAddress ? "from session" : "from request", this.session.getUserId(), this.session.getContextId()});
                            this.rateLimitChecks(composedMail, rateLimit, properties.getMaxToCcBcc());
                            sentMail = transport.sendMailMessage(composedMail, type, null, statusInfo);
                            this.setRateLimitTime(rateLimit);
                        } else {
                            sentMail = transport.sendMailMessage(composedMail, type, null, statusInfo);
                        }
                        mailSent = true;
                    }
                    catch (OXException e) {
                        SMTPSendFailedException sendFailed;
                        Address[] validSentAddrs;
                        if (!MimeMailExceptionCode.SEND_FAILED_EXT.equals(e) && !MimeMailExceptionCode.SEND_FAILED_MSG_ERROR.equals(e)) {
                            throw e;
                        }
                        MailMessage ma = (MailMessage)e.getArgument("sent_message");
                        if (null == ma) {
                            throw e;
                        }
                        sentMail = ma;
                        oxError = e;
                        mailSent = true;
                        if (!(e.getCause() instanceof SMTPSendFailedException) || (validSentAddrs = (sendFailed = (SMTPSendFailedException)e.getCause()).getValidSentAddresses()) == null || validSentAddrs.length <= 0) break block41;
                        validRecipients = new ArrayList<InternetAddress>(validSentAddrs.length);
                        for (Address address : validSentAddrs) {
                            validRecipients.add((InternetAddress)address);
                        }
                    }
                }
                DataRetentionService retentionService = ServerServiceRegistry.getInstance().getService(DataRetentionService.class);
                if (null != retentionService) {
                    this.triggerDataRetention(transport, startTransport, sentMail, validRecipients, retentionService);
                }
                if (null != (objectUseCountService = ServerServiceRegistry.getInstance().getService(ObjectUseCountService.class))) {
                    InternetAddress[] addresses = composedMail.getAllRecipients();
                    LinkedHashSet<String> addrs = new LinkedHashSet<String>(addresses.length);
                    for (Address address : addresses) {
                        addrs.add(address.getAddress());
                    }
                    IncrementArguments arguments = new IncrementArguments.Builder(addrs).build();
                    objectUseCountService.incrementObjectUseCount(this.session, arguments);
                }
                try {
                    if (ComposeType.REPLY.equals((Object)type)) {
                        this.setFlagReply(composedMail.getMsgref());
                        break block42;
                    }
                    if (ComposeType.FORWARD.equals((Object)type)) {
                        MailPath supPath = composedMail.getMsgref();
                        if (null == supPath) {
                            int count = composedMail.getEnclosedCount();
                            LinkedList<MailPath> paths = new LinkedList<MailPath>();
                            for (int i = 0; i < count; ++i) {
                                MailPart part = composedMail.getEnclosedMailPart(i);
                                MailPath mailPath = part.getMsgref();
                                if (mailPath == null || !part.getContentType().isMimeType("message/rfc822")) continue;
                                paths.add(mailPath);
                            }
                            if (!paths.isEmpty()) {
                                this.setFlagMultipleForward(paths);
                            }
                        } else {
                            this.setFlagForward(supPath);
                        }
                        break block42;
                    }
                    if (ComposeType.DRAFT_NO_DELETE_ON_TRANSPORT.equals((Object)type)) break block42;
                    if (ComposeType.DRAFT.equals((Object)type)) {
                        ConfigViewFactory configViewFactory = ServerServiceRegistry.getInstance().getService(ConfigViewFactory.class);
                        if (null == configViewFactory) break block42;
                        try {
                            ConfigView view = configViewFactory.getView(this.session.getUserId(), this.session.getContextId());
                            ComposedConfigProperty property = view.property("com.openexchange.mail.deleteDraftOnTransport", Boolean.TYPE);
                            if (property.isDefined() && ((Boolean)property.get()).booleanValue()) {
                                this.deleteDraft(composedMail.getMsgref());
                            }
                            break block42;
                        }
                        catch (Exception e) {
                            LOG.warn("Draft mail cannot be deleted.", (Throwable)e);
                        }
                        break block42;
                    }
                    if (ComposeType.DRAFT_DELETE_ON_TRANSPORT.equals((Object)type)) {
                        try {
                            this.deleteDraft(composedMail.getMsgref());
                        }
                        catch (Exception e) {
                            LOG.warn("Draft mail cannot be deleted.", (Throwable)e);
                        }
                    }
                }
                catch (OXException e) {
                    this.mailAccess.addWarnings(Collections.singletonList(MailExceptionCode.FLAG_FAIL.create(e, new Object[0])));
                }
            }
            UserSettingMail userSettingMail = usm = null == optUserSetting ? UserSettingMailStorage.getInstance().getUserSettingMail(this.session.getUserId(), this.ctx) : optUserSetting;
            if (usm.isNoCopyIntoStandardSentFolder()) {
                String e = null;
                return e;
            }
            if (null != sentMail.getMailId() && null != sentMail.getFolder()) {
                String e = new MailPath(accountId, sentMail.getFolder(), sentMail.getMailId()).toString();
                return e;
            }
            String mailPath = this.append2SentFolder(sentMail).toString();
            if (null != oxError) {
                throw oxError;
            }
            String string = mailPath;
            return string;
        }
    }

    private void triggerDataRetention(final MailTransport transport, final long startTransport, final MailMessage sentMail, final Collection<InternetAddress> recipients, final DataRetentionService retentionService) {
        final Session session = this.session;
        final Logger logger = LOG;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    HashSet<Object> recipientz;
                    RetentionData retentionData = retentionService.newInstance();
                    retentionData.setStartTime(new Date(startTransport));
                    String login = transport.getTransportConfig().getLogin();
                    retentionData.setIdentifier(login);
                    retentionData.setIPAddress(session.getLocalIp());
                    retentionData.setSenderAddress(IDNA.toIDN((String)sentMail.getFrom()[0].getAddress()));
                    if (null == recipients) {
                        recipientz = new HashSet<InternetAddress>(Arrays.asList(sentMail.getTo()));
                        recipientz.addAll(Arrays.asList(sentMail.getCc()));
                        recipientz.addAll(Arrays.asList(sentMail.getBcc()));
                    } else {
                        recipientz = new HashSet(recipients);
                    }
                    int size = recipientz.size();
                    String[] recipientsArr = new String[size];
                    Iterator it = recipientz.iterator();
                    for (int i = 0; i < size; ++i) {
                        recipientsArr[i] = IDNA.toIDN((String)((InternetAddress)it.next()).getAddress());
                    }
                    retentionData.setRecipientAddresses(recipientsArr);
                    retentionService.storeOnTransport(retentionData);
                }
                catch (OXException e) {
                    logger.error("", (Throwable)e);
                }
            }
        };
        ThreadPoolService threadPool = ThreadPools.getThreadPool();
        if (null == threadPool) {
            r.run();
        } else {
            threadPool.submit(ThreadPools.task((Runnable)r), CallerRunsBehavior.getInstance());
        }
    }

    private MailPath append2SentFolder(MailMessage sentMail) throws OXException {
        String[] uidArr;
        long start = System.currentTimeMillis();
        String sentFullname = this.mailAccess.getFolderStorage().getSentFolder();
        try {
            IMailMessageStorageMimeSupport mimeSupport;
            IMailMessageStorage messageStorage = this.mailAccess.getMessageStorage();
            uidArr = messageStorage instanceof IMailMessageStorageMimeSupport ? ((mimeSupport = (IMailMessageStorageMimeSupport)messageStorage).isMimeSupported() && sentMail instanceof MimeRawSource ? mimeSupport.appendMimeMessages(sentFullname, new Message[]{(Message)((MimeRawSource)((Object)sentMail)).getPart()}) : messageStorage.appendMessages(sentFullname, new MailMessage[]{sentMail})) : messageStorage.appendMessages(sentFullname, new MailMessage[]{sentMail});
            this.postEventRemote(this.accountId, sentFullname, true, true);
            try {
                MailMessageCache.getInstance().removeFolderMessages(this.mailAccess.getAccountId(), sentFullname, this.session.getUserId(), this.contextId);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
        catch (OXException e) {
            if (e.getMessage().indexOf("quota") != -1) {
                throw MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED_QUOTA.create(e, new Object[0]);
            }
            LOG.warn("Mail with id {} in folder {} sent successfully, but a copy could not be placed in the sent folder.", new Object[]{sentMail.getMailId(), sentMail.getFolder(), e});
            throw MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED.create(e, new Object[0]);
        }
        if (uidArr != null && uidArr[0] != null) {
            this.mailAccess.getMessageStorage().updateMessageFlags(sentFullname, uidArr, 32, true);
        }
        MailPath retval = new MailPath(this.mailAccess.getAccountId(), sentFullname, uidArr[0]);
        LOG.debug("Mail copy ({}) appended in {}msec", (Object)retval, (Object)(System.currentTimeMillis() - start));
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFlagForward(MailPath path) throws OXException {
        String fullName = path.getFolder();
        String[] uids = new String[]{path.getMailID()};
        int pathAccount = path.getAccountId();
        if (this.mailAccess.getAccountId() == pathAccount) {
            this.mailAccess.getMessageStorage().updateMessageFlags(fullName, uids, 256, true);
            try {
                if (MailMessageCache.getInstance().containsFolderMessages(this.mailAccess.getAccountId(), fullName, this.session.getUserId(), this.contextId)) {
                    MailMessageCache.getInstance().updateCachedMessages(uids, this.mailAccess.getAccountId(), fullName, this.session.getUserId(), this.contextId, FIELDS_FLAGS, new Object[]{256});
                }
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        } else {
            MailAccess<IMailFolderStorage, IMailMessageStorage> otherAccess = MailAccess.getInstance(this.session, pathAccount);
            otherAccess.connect(true);
            try {
                otherAccess.getMessageStorage().updateMessageFlags(fullName, uids, 256, true);
                try {
                    if (MailMessageCache.getInstance().containsFolderMessages(otherAccess.getAccountId(), fullName, this.session.getUserId(), this.contextId)) {
                        MailMessageCache.getInstance().updateCachedMessages(uids, otherAccess.getAccountId(), fullName, this.session.getUserId(), this.contextId, FIELDS_FLAGS, new Object[]{256});
                    }
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
            }
            finally {
                otherAccess.close(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFlagMultipleForward(List<MailPath> paths) throws OXException {
        String[] ids = new String[1];
        for (MailPath path : paths) {
            ids[0] = path.getMailID();
            int pathAccount = path.getAccountId();
            if (this.mailAccess.getAccountId() == pathAccount) {
                this.mailAccess.getMessageStorage().updateMessageFlags(path.getFolder(), ids, 256, true);
                try {
                    if (!MailMessageCache.getInstance().containsFolderMessages(this.mailAccess.getAccountId(), path.getFolder(), this.session.getUserId(), this.contextId)) continue;
                    MailMessageCache.getInstance().updateCachedMessages(ids, this.mailAccess.getAccountId(), path.getFolder(), this.session.getUserId(), this.contextId, FIELDS_FLAGS, new Object[]{256});
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
                continue;
            }
            MailAccess<IMailFolderStorage, IMailMessageStorage> otherAccess = MailAccess.getInstance(this.session, pathAccount);
            otherAccess.connect(true);
            try {
                otherAccess.getMessageStorage().updateMessageFlags(path.getFolder(), ids, 256, true);
                try {
                    if (!MailMessageCache.getInstance().containsFolderMessages(otherAccess.getAccountId(), path.getFolder(), this.session.getUserId(), this.contextId)) continue;
                    MailMessageCache.getInstance().updateCachedMessages(ids, otherAccess.getAccountId(), path.getFolder(), this.session.getUserId(), this.contextId, FIELDS_FLAGS, new Object[]{256});
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
            }
            finally {
                otherAccess.close(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDraft(MailPath path) throws OXException {
        if (null == path) {
            LOG.warn("Missing msgref on draft-delete. Corresponding draft mail cannot be deleted.", new Throwable());
            return;
        }
        String fullName = path.getFolder();
        String[] uids = new String[]{path.getMailID()};
        int pathAccount = path.getAccountId();
        if (this.mailAccess.getAccountId() == pathAccount) {
            this.mailAccess.getMessageStorage().deleteMessages(fullName, uids, true);
        } else {
            MailAccess<IMailFolderStorage, IMailMessageStorage> otherAccess = null;
            try {
                otherAccess = MailAccess.getInstance(this.session, pathAccount);
                otherAccess.connect(true);
                otherAccess.getMessageStorage().deleteMessages(fullName, uids, true);
                try {
                    MailMessageCache.getInstance().removeMessages(uids, pathAccount, fullName, this.session.getUserId(), this.session.getContextId());
                }
                catch (OXException e) {
                    // empty catch block
                }
            }
            finally {
                if (null != otherAccess) {
                    otherAccess.close(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFlagReply(MailPath path) throws OXException {
        if (null == path) {
            LOG.warn("Missing msgref on reply. Corresponding mail cannot be marked as answered.", new Throwable());
            return;
        }
        String fullName = path.getFolder();
        String[] uids = new String[]{path.getMailID()};
        int pathAccount = path.getAccountId();
        if (this.mailAccess.getAccountId() == pathAccount) {
            this.mailAccess.getMessageStorage().updateMessageFlags(fullName, uids, 1, true);
            try {
                if (MailMessageCache.getInstance().containsFolderMessages(this.mailAccess.getAccountId(), fullName, this.session.getUserId(), this.contextId)) {
                    MailMessageCache.getInstance().updateCachedMessages(uids, this.mailAccess.getAccountId(), fullName, this.session.getUserId(), this.contextId, FIELDS_FLAGS, new Object[]{1});
                }
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        } else {
            MailAccess<IMailFolderStorage, IMailMessageStorage> otherAccess = MailAccess.getInstance(this.session, pathAccount);
            otherAccess.connect(true);
            try {
                otherAccess.getMessageStorage().updateMessageFlags(fullName, uids, 1, true);
                try {
                    if (MailMessageCache.getInstance().containsFolderMessages(pathAccount, fullName, this.session.getUserId(), this.contextId)) {
                        MailMessageCache.getInstance().updateCachedMessages(uids, pathAccount, fullName, this.session.getUserId(), this.contextId, FIELDS_FLAGS, new Object[]{1});
                    }
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
            }
            finally {
                otherAccess.close(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V performSynchronized(Callable<V> task, Session session) throws Exception {
        Lock lock = (Lock)session.getParameter(Session.PARAM_LOCK);
        if (null == lock) {
            lock = Session.EMPTY_LOCK;
        }
        lock.lock();
        try {
            V v = task.call();
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    private void setRateLimitTime(int rateLimit) {
        if (rateLimit > 0) {
            this.session.setParameter(LAST_SEND_TIME, (Object)System.currentTimeMillis());
        }
    }

    private void rateLimitChecks(MailMessage composedMail, int rateLimit, int maxToCcBcc) throws OXException {
        Long parameter;
        if (rateLimit > 0 && null != (parameter = (Long)this.session.getParameter(LAST_SEND_TIME)) && parameter + (long)rateLimit >= System.currentTimeMillis()) {
            NumberFormat numberInstance = NumberFormat.getNumberInstance(this.getUserLocale());
            throw MailExceptionCode.SENT_QUOTA_EXCEEDED.create(numberInstance.format((double)rateLimit / 1000.0));
        }
        if (maxToCcBcc > 0) {
            InternetAddress[] addrs = composedMail.getTo();
            int count = addrs == null ? 0 : addrs.length;
            addrs = composedMail.getCc();
            count += addrs == null ? 0 : addrs.length;
            addrs = composedMail.getBcc();
            if ((count += addrs == null ? 0 : addrs.length) > maxToCcBcc) {
                throw MailExceptionCode.RECIPIENTS_EXCEEDED.create(maxToCcBcc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendReceiptAck(String folder, String msgUID, String fromAddr) throws OXException {
        int acc;
        FullnameArgument argument;
        block14: {
            argument = MailFolderUtility.prepareMailFolderParam(folder);
            acc = argument.getAccountId();
            try {
                MailAccountStorageService ss = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
                MailAccount ma = ss.getMailAccount(acc, this.session.getUserId(), this.session.getContextId());
                if (ma.isDefaultAccount()) {
                    try {
                        HashSet<InternetAddress> validAddrs = new HashSet<InternetAddress>(4);
                        if (this.usm.getSendAddr() != null && this.usm.getSendAddr().length() > 0) {
                            validAddrs.add(new QuotedInternetAddress(this.usm.getSendAddr()));
                        }
                        User user = this.getUser();
                        validAddrs.add(new QuotedInternetAddress(user.getMail()));
                        for (String alias : user.getAliases()) {
                            validAddrs.add(new QuotedInternetAddress(alias));
                        }
                        QuotedInternetAddress fromAddress = new QuotedInternetAddress(fromAddr);
                        if (MailProperties.getInstance().isSupportMsisdnAddresses()) {
                            MsisdnUtility.addMsisdnAddress(validAddrs, this.session);
                            String address = fromAddress.getAddress();
                            int pos = address.indexOf(47);
                            if (pos > 0) {
                                fromAddress.setAddress(address.substring(0, pos));
                            }
                        }
                        if (!validAddrs.contains((Object)fromAddress)) {
                            throw MailExceptionCode.INVALID_SENDER.create(fromAddr);
                        }
                        break block14;
                    }
                    catch (AddressException e) {
                        throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
                    }
                }
                if (!new QuotedInternetAddress(ma.getPrimaryAddress()).equals((Object)new QuotedInternetAddress(fromAddr))) {
                    throw MailExceptionCode.INVALID_SENDER.create(fromAddr);
                }
            }
            catch (AddressException e) {
                throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
            }
        }
        this.initConnection(acc);
        String fullName = argument.getFullname();
        try (MailTransport transport = MailTransport.getInstance(this.session);){
            transport.sendReceiptAck(this.mailAccess.getMessageStorage().getMessage(fullName, msgUID, false), fromAddr);
        }
        this.mailAccess.getMessageStorage().updateMessageFlags(fullName, new String[]{msgUID}, 512, true);
    }

    @Override
    public void updateMessageColorLabel(String folder, String[] mailIDs, int newColorLabel) throws OXException {
        String[] ids;
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        IMailMessageStorage messageStorage = this.mailAccess.getMessageStorage();
        if (null == mailIDs) {
            if (messageStorage instanceof IMailMessageStorageBatch) {
                IMailMessageStorageBatch batch = (IMailMessageStorageBatch)messageStorage;
                ids = null;
                batch.updateMessageColorLabel(fullName, newColorLabel);
            } else {
                ids = this.getAllMessageIDs(argument);
                messageStorage.updateMessageColorLabel(fullName, ids, newColorLabel);
            }
        } else {
            ids = mailIDs;
            messageStorage.updateMessageColorLabel(fullName, ids, newColorLabel);
        }
        this.postEvent("com/openexchange/push/attributes", accountId, fullName, true, true, false, MORE_PROPS_UPDATE_LABEL);
        try {
            if (MailMessageCache.getInstance().containsFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId)) {
                MailMessageCache.getInstance().updateCachedMessages(ids, accountId, fullName, this.session.getUserId(), this.contextId, FIELDS_COLOR_LABEL, new Object[]{newColorLabel});
            }
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public String getMailIDByMessageID(String folder, String messageID) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        MailMessage[] messages = this.mailAccess.getMessageStorage().searchMessages(fullName, null, MailSortField.RECEIVED_DATE, OrderDirection.ASC, new HeaderTerm("Message-Id", messageID), FIELDS_ID_INFO);
        if (null == messages || 1 != messages.length) {
            throw MailExceptionCode.MAIL_NOT_FOUN_BY_MESSAGE_ID.create(fullName, messageID);
        }
        return messages[0].getMailId();
    }

    @Override
    public void updateMessageFlags(String folder, String[] mailIDs, int flagBits, boolean flagVal) throws OXException {
        boolean spamAction;
        String[] ids;
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        IMailMessageStorage messageStorage = this.mailAccess.getMessageStorage();
        if (null == mailIDs) {
            if (messageStorage instanceof IMailMessageStorageBatch) {
                IMailMessageStorageBatch batch = (IMailMessageStorageBatch)messageStorage;
                ids = null;
                batch.updateMessageFlags(fullName, flagBits, flagVal);
            } else {
                ids = this.getAllMessageIDs(argument);
                messageStorage.updateMessageFlags(fullName, ids, flagBits, flagVal);
            }
        } else {
            ids = mailIDs;
            messageStorage.updateMessageFlags(fullName, ids, flagBits, flagVal);
        }
        this.postEvent("com/openexchange/push/attributes", accountId, fullName, true, true, false, MORE_PROPS_UPDATE_FLAGS);
        boolean bl = spamAction = this.usm.isSpamEnabled() && (flagBits & 0x80) > 0;
        if (spamAction) {
            String spamFullname = this.mailAccess.getFolderStorage().getSpamFolder();
            this.postEvent("com/openexchange/push/attributes", accountId, spamFullname, true, true);
        }
        if (spamAction) {
            try {
                if (MailMessageCache.getInstance().containsFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId)) {
                    MailMessageCache.getInstance().removeMessages(ids, accountId, fullName, this.session.getUserId(), this.contextId);
                }
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        } else {
            try {
                if (MailMessageCache.getInstance().containsFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId)) {
                    MailMessageCache.getInstance().updateCachedMessages(ids, accountId, fullName, this.session.getUserId(), this.contextId, FIELDS_FLAGS, new Object[]{flagVal ? flagBits : flagBits * -1});
                }
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    @Override
    public MailMessage[] getUpdatedMessages(String folder, int[] fields) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        return this.mailAccess.getMessageStorage().getNewAndModifiedMessages(fullName, MailField.getFields(fields));
    }

    @Override
    public MailMessage[] getDeletedMessages(String folder, int[] fields) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        return this.mailAccess.getMessageStorage().getDeletedMessages(fullName, MailField.getFields(fields));
    }

    private static String[] messages2ids(MailMessage[] messages) {
        if (null == messages) {
            return null;
        }
        ArrayList<String> retval = new ArrayList<String>(messages.length);
        for (int i = 0; i < messages.length; ++i) {
            MailMessage mail = messages[i];
            if (null == mail) continue;
            retval.add(mail.getMailId());
        }
        return retval.toArray(new String[retval.size()]);
    }

    private void postEvent(int accountId, String fullName, boolean contentRelated) {
        this.postEvent(accountId, fullName, contentRelated, false);
    }

    private void postEventRemote(int accountId, String fullName, boolean contentRelated) {
        this.postEventRemote(accountId, fullName, contentRelated, false);
    }

    private void postEvent(int accountId, String fullName, boolean contentRelated, boolean immediateDelivery) {
        if (0 != accountId) {
            return;
        }
        EventPool.getInstance().put(new PooledEvent(this.contextId, this.session.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullName), contentRelated, immediateDelivery, false, this.session));
    }

    private void postEventRemote(int accountId, String fullName, boolean contentRelated, boolean immediateDelivery) {
        if (0 != accountId) {
            return;
        }
        EventPool.getInstance().put(new PooledEvent(this.contextId, this.session.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullName), contentRelated, immediateDelivery, true, this.session));
    }

    private void postEvent(int accountId, String fullName, boolean contentRelated, boolean immediateDelivery, boolean async) {
        if (0 != accountId) {
            return;
        }
        EventPool.getInstance().put(new PooledEvent(this.contextId, this.session.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullName), contentRelated, immediateDelivery, false, this.session).setAsync(async));
    }

    private void postEventRemote(int accountId, String fullName, boolean contentRelated, boolean immediateDelivery, boolean async) {
        if (0 != accountId) {
            return;
        }
        EventPool.getInstance().put(new PooledEvent(this.contextId, this.session.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullName), contentRelated, immediateDelivery, true, this.session).setAsync(async));
    }

    private void postEvent(String topic, int accountId, String fullName, boolean contentRelated, boolean immediateDelivery) {
        if (0 != accountId) {
            return;
        }
        EventPool.getInstance().put(new PooledEvent(topic, this.contextId, this.session.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullName), contentRelated, immediateDelivery, false, this.session));
    }

    private void postEventRemote(String topic, int accountId, String fullName, boolean contentRelated, boolean immediateDelivery) {
        if (0 != accountId) {
            return;
        }
        EventPool.getInstance().put(new PooledEvent(topic, this.contextId, this.session.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullName), contentRelated, immediateDelivery, true, this.session));
    }

    private void postEvent(String topic, int accountId, String fullName, boolean contentRelated, boolean immediateDelivery, boolean async) {
        if (0 != accountId) {
            return;
        }
        PooledEvent pooledEvent = new PooledEvent(topic, this.contextId, this.session.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullName), contentRelated, immediateDelivery, false, this.session);
        EventPool.getInstance().put(pooledEvent.setAsync(async));
    }

    private void postEventRemote(String topic, int accountId, String fullName, boolean contentRelated, boolean immediateDelivery, boolean async) {
        if (0 != accountId) {
            return;
        }
        PooledEvent pooledEvent = new PooledEvent(topic, this.contextId, this.session.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullName), contentRelated, immediateDelivery, true, this.session);
        EventPool.getInstance().put(pooledEvent.setAsync(async));
    }

    private void postEvent(String topic, int accountId, String fullName, boolean contentRelated, boolean immediateDelivery, boolean async, Map<String, Object> moreProperties) {
        if (0 != accountId) {
            return;
        }
        PooledEvent pooledEvent = new PooledEvent(topic, this.contextId, this.session.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullName), contentRelated, immediateDelivery, false, this.session);
        if (null != moreProperties) {
            for (Map.Entry<String, Object> entry : moreProperties.entrySet()) {
                pooledEvent.putProperty(entry.getKey(), entry.getValue());
            }
        }
        EventPool.getInstance().put(pooledEvent.setAsync(async));
    }

    private void postEventRemote(String topic, int accountId, String fullName, boolean contentRelated, boolean immediateDelivery, boolean async, Map<String, Object> moreProperties) {
        if (0 != accountId) {
            return;
        }
        PooledEvent pooledEvent = new PooledEvent(topic, this.contextId, this.session.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullName), contentRelated, immediateDelivery, true, this.session);
        if (null != moreProperties) {
            for (Map.Entry<String, Object> entry : moreProperties.entrySet()) {
                pooledEvent.putProperty(entry.getKey(), entry.getValue());
            }
        }
        EventPool.getInstance().put(pooledEvent.setAsync(async));
    }

    @Override
    public MailImportResult[] getMailImportResults() {
        MailImportResult[] mars = new MailImportResult[this.mailImportResults.size()];
        for (int i = 0; i < mars.length; ++i) {
            mars[i] = this.mailImportResults.get(i);
        }
        return mars;
    }

    private String[] getAllMessageIDs(FullnameArgument argument) throws OXException {
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        MailMessage[] mails = this.mailAccess.getMessageStorage().searchMessages(fullName, null, MailSortField.RECEIVED_DATE, OrderDirection.ASC, null, FIELDS_ID_INFO);
        if (mails == null || mails.length == 0) {
            return new String[0];
        }
        String[] ret = new String[mails.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = mails[i].getMailId();
        }
        return ret;
    }

    @Override
    public void archiveMailFolder(int days, String folderID, ServerSession session, boolean useDefaultName, boolean createIfAbsent) throws OXException {
        try {
            FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(folderID);
            int accountId = fa.getAccountId();
            this.initConnection(accountId);
            int[] separatorRef = new int[1];
            String archiveFullname = this.checkArchiveFullNameFor(session, separatorRef, useDefaultName, createIfAbsent);
            char separator = (char)separatorRef[0];
            String fullName = fa.getFullname();
            if (fullName.equals(archiveFullname) || fullName.startsWith(archiveFullname + separator)) {
                return;
            }
            Calendar cal = Calendar.getInstance(TimeZoneUtils.getTimeZone("UTC"));
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(11, 0);
            cal.add(5, days * -1);
            ReceivedDateTerm term = new ReceivedDateTerm(ComparisonType.LESS_THAN, cal.getTime());
            MailMessage[] msgs = this.mailAccess.getMessageStorage().searchMessages(fa.getFullname(), null, MailSortField.RECEIVED_DATE, OrderDirection.DESC, term, new MailField[]{MailField.ID, MailField.RECEIVED_DATE});
            if (null == msgs || msgs.length <= 0) {
                return;
            }
            HashMap<Integer, LinkedList<String>> map = new HashMap<Integer, LinkedList<String>>(4);
            for (MailMessage mailMessage : msgs) {
                Date receivedDate = mailMessage.getReceivedDate();
                cal.setTime(receivedDate);
                Integer year = cal.get(1);
                LinkedList<String> ids = (LinkedList<String>)map.get(year);
                if (null == ids) {
                    ids = new LinkedList<String>();
                    map.put(year, ids);
                }
                ids.add(mailMessage.getMailId());
            }
            for (Map.Entry entry : map.entrySet()) {
                String sYear = ((Integer)entry.getKey()).toString();
                String fn = archiveFullname + separator + sYear;
                if (!this.mailAccess.getFolderStorage().exists(fn)) {
                    MailFolderDescription toCreate = new MailFolderDescription();
                    toCreate.setAccountId(accountId);
                    toCreate.setParentAccountId(accountId);
                    toCreate.setParentFullname(archiveFullname);
                    toCreate.setExists(false);
                    toCreate.setFullname(fn);
                    toCreate.setName(sYear);
                    toCreate.setSeparator(separator);
                    DefaultMailPermission mp = new DefaultMailPermission();
                    mp.setEntity(session.getUserId());
                    int p = 128;
                    mp.setAllPermission(128, 128, 128, 128);
                    mp.setFolderAdmin(true);
                    mp.setGroupPermission(false);
                    toCreate.addPermission(mp);
                    try {
                        this.mailAccess.getFolderStorage().createFolder(toCreate);
                    }
                    catch (OXException e) {
                        if (SUBFOLDERS_NOT_ALLOWED_PREFIX.equals(e.getPrefix()) && e.getCode() == 2012) {
                            if (this.mailAccess.getFolderStorage().exists(archiveFullname)) {
                                fn = archiveFullname;
                            }
                            throw MailExceptionCode.ARCHIVE_SUBFOLDER_NOT_ALLOWED.create(e, new Object[0]);
                        }
                        throw e;
                    }
                    CacheFolderStorage.getInstance().removeFromCache(MailFolderUtility.prepareFullname(accountId, archiveFullname), "0", true, session);
                }
                List ids = (List)entry.getValue();
                this.mailAccess.getMessageStorage().moveMessages(fa.getFullname(), fn, ids.toArray(new String[ids.size()]), true);
            }
            return;
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            if (SUBFOLDERS_NOT_ALLOWED_PREFIX.equals(e.getPrefix()) && e.getCode() == 2012) {
                throw MailExceptionCode.ARCHIVE_SUBFOLDER_NOT_ALLOWED.create(e, new Object[0]);
            }
            throw e;
        }
    }

    @Override
    public List<AbstractArchiveMailAction.ArchiveDataWrapper> archiveMail(String folderID, List<String> ids, ServerSession session, boolean useDefaultName, boolean createIfAbsent) throws OXException {
        ArrayList<AbstractArchiveMailAction.ArchiveDataWrapper> retval = new ArrayList<AbstractArchiveMailAction.ArchiveDataWrapper>();
        FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(folderID);
        this.initConnection(fa.getAccountId());
        int[] separatorRef = new int[1];
        String archiveFullname = this.checkArchiveFullNameFor(session, separatorRef, useDefaultName, createIfAbsent);
        char separator = (char)separatorRef[0];
        String fullName = fa.getFullname();
        if (fullName.equals(archiveFullname) || fullName.startsWith(archiveFullname + separator)) {
            return null;
        }
        fullName = fa.getFullname();
        MailMessage[] msgs = this.mailAccess.getMessageStorage().getMessages(fullName, ids.toArray(new String[ids.size()]), new MailField[]{MailField.ID, MailField.RECEIVED_DATE});
        if (null == msgs || msgs.length <= 0) {
            return null;
        }
        try {
            this.move2Archive(msgs, fullName, archiveFullname, separator, retval);
        }
        catch (OXException e) {
            if (SUBFOLDERS_NOT_ALLOWED_PREFIX.equals(e.getPrefix()) && e.getCode() == 2012) {
                throw MailExceptionCode.ARCHIVE_SUBFOLDER_NOT_ALLOWED.create(e, new Object[0]);
            }
            throw e;
        }
        return retval;
    }

    @Override
    public List<AbstractArchiveMailAction.ArchiveDataWrapper> archiveMultipleMail(List<String[]> entries, final ServerSession session, final boolean useDefaultName, final boolean createIfAbsent) throws OXException {
        TIntObjectHashMap m = new TIntObjectHashMap(2);
        final ArrayList<AbstractArchiveMailAction.ArchiveDataWrapper> retval = new ArrayList<AbstractArchiveMailAction.ArchiveDataWrapper>();
        for (String[] obj : entries) {
            String fullName;
            LinkedList<String> list;
            FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(obj[0]);
            int accountId = fa.getAccountId();
            HashMap<String, LinkedList<String>> map = (HashMap<String, LinkedList<String>>)m.get(accountId);
            if (null == map) {
                map = new HashMap<String, LinkedList<String>>();
                m.put(accountId, map);
            }
            if (null == (list = (LinkedList<String>)map.get(fullName = fa.getFullname()))) {
                list = new LinkedList<String>();
                map.put(fullName, list);
            }
            list.add(obj[1]);
        }
        final Reference exceptionRef = new Reference();
        final Calendar cal = Calendar.getInstance(TimeZoneUtils.getTimeZone("UTC"));
        boolean success = m.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Map<String, List<String>>>(){

            public boolean execute(int accountId, Map<String, List<String>> mapping) {
                boolean proceed = false;
                try {
                    MailServletInterfaceImpl.this.initConnection(accountId);
                    int[] separatorRef = new int[1];
                    String archiveFullname = MailServletInterfaceImpl.this.checkArchiveFullNameFor(session, separatorRef, useDefaultName, createIfAbsent);
                    char separator = (char)separatorRef[0];
                    for (Map.Entry<String, List<String>> mappingEntry : mapping.entrySet()) {
                        String fullName = mappingEntry.getKey();
                        if (fullName.equals(archiveFullname) || fullName.startsWith(archiveFullname + separator)) continue;
                        List<String> mailIds = mappingEntry.getValue();
                        MailMessage[] msgs = MailServletInterfaceImpl.this.mailAccess.getMessageStorage().getMessages(fullName, mailIds.toArray(new String[mailIds.size()]), new MailField[]{MailField.ID, MailField.RECEIVED_DATE});
                        if (null == msgs || msgs.length <= 0) {
                            return true;
                        }
                        MailServletInterfaceImpl.this.move2Archive(msgs, fullName, archiveFullname, separator, cal, retval);
                    }
                    proceed = true;
                }
                catch (OXException e) {
                    if (MailServletInterfaceImpl.SUBFOLDERS_NOT_ALLOWED_PREFIX.equals(e.getPrefix()) && e.getCode() == 2012) {
                        exceptionRef.setValue((Object)MailExceptionCode.ARCHIVE_SUBFOLDER_NOT_ALLOWED.create(e, new Object[0]));
                    } else {
                        exceptionRef.setValue((Object)e);
                    }
                }
                catch (RuntimeException e) {
                    exceptionRef.setValue((Object)new OXException((Throwable)e));
                }
                return proceed;
            }
        });
        if (!success) {
            throw (OXException)((Object)exceptionRef.getValue());
        }
        return retval;
    }

    private void move2Archive(MailMessage[] msgs, String fullName, String archiveFullname, char separator, List<AbstractArchiveMailAction.ArchiveDataWrapper> result) throws OXException {
        Calendar cal = Calendar.getInstance(TimeZoneUtils.getTimeZone("UTC"));
        this.move2Archive(msgs, fullName, archiveFullname, separator, cal, result);
    }

    void move2Archive(MailMessage[] msgs, String fullName, String archiveFullname, char separator, Calendar cal, List<AbstractArchiveMailAction.ArchiveDataWrapper> result) throws OXException {
        HashMap<Integer, LinkedList<String>> map = new HashMap<Integer, LinkedList<String>>(4);
        for (MailMessage mailMessage : msgs) {
            Date receivedDate = mailMessage.getReceivedDate();
            cal.setTime(receivedDate);
            Integer year = cal.get(1);
            LinkedList<String> ids = (LinkedList<String>)map.get(year);
            if (null == ids) {
                ids = new LinkedList<String>();
                map.put(year, ids);
            }
            ids.add(mailMessage.getMailId());
        }
        int accountId = this.mailAccess.getAccountId();
        Session session = this.mailAccess.getSession();
        for (Map.Entry entry : map.entrySet()) {
            String sYear = ((Integer)entry.getKey()).toString();
            String fn = archiveFullname + separator + sYear;
            StringBuilder sb = new StringBuilder("default").append(this.mailAccess.getAccountId()).append(separator).append(fn);
            boolean exists = this.mailAccess.getFolderStorage().exists(fn);
            result.add(new AbstractArchiveMailAction.ArchiveDataWrapper(sb.toString(), !exists));
            if (!exists) {
                MailFolderDescription toCreate = new MailFolderDescription();
                toCreate.setAccountId(accountId);
                toCreate.setParentAccountId(accountId);
                toCreate.setParentFullname(archiveFullname);
                toCreate.setExists(false);
                toCreate.setFullname(fn);
                toCreate.setName(sYear);
                toCreate.setSeparator(separator);
                DefaultMailPermission mp = new DefaultMailPermission();
                mp.setEntity(session.getUserId());
                int p = 128;
                mp.setAllPermission(128, 128, 128, 128);
                mp.setFolderAdmin(true);
                mp.setGroupPermission(false);
                toCreate.addPermission(mp);
                try {
                    this.mailAccess.getFolderStorage().createFolder(toCreate);
                }
                catch (OXException e) {
                    if (SUBFOLDERS_NOT_ALLOWED_PREFIX.equals(e.getPrefix()) && e.getCode() == 2012) {
                        if (this.mailAccess.getFolderStorage().exists(archiveFullname)) {
                            fn = archiveFullname;
                        }
                        throw e;
                    }
                    throw e;
                }
                CacheFolderStorage.getInstance().removeFromCache(archiveFullname, "0", true, session);
            }
            List ids = (List)entry.getValue();
            this.mailAccess.getMessageStorage().moveMessages(fullName, fn, ids.toArray(new String[ids.size()]), true);
        }
    }

    String checkArchiveFullNameFor(final ServerSession session, int[] separatorRef, boolean useDefaultName, boolean createIfAbsent) throws OXException {
        String parentFullName;
        char separator;
        String archiveName;
        final int accountId = this.mailAccess.getAccountId();
        MailAccountStorageService service = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class);
        if (null == service) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{MailAccountStorageService.class.getName()});
        }
        MailAccount mailAccount = service.getMailAccount(accountId, session.getUserId(), session.getContextId());
        String archiveFullName = mailAccount.getArchiveFullname();
        if (Strings.isEmpty((String)archiveFullName)) {
            MailAccountStorageService mass;
            String prefix;
            archiveName = mailAccount.getArchive();
            boolean updateAccount = false;
            if (Strings.isEmpty((String)archiveName)) {
                User user = session.getUser();
                if (!useDefaultName) {
                    String i18nArchive = StringHelper.valueOf(user.getLocale()).getString(MailStrings.ARCHIVE);
                    throw MailExceptionCode.MISSING_DEFAULT_FOLDER_NAME.create(Category.CATEGORY_USER_INPUT, new Object[]{i18nArchive});
                }
                archiveName = StringHelper.valueOf(user.getLocale()).getString(MailStrings.DEFAULT_ARCHIVE);
                updateAccount = true;
            }
            if (Strings.isEmpty((String)(prefix = this.mailAccess.getFolderStorage().getDefaultFolderPrefix()))) {
                separator = this.mailAccess.getFolderStorage().getFolder(INBOX_ID).getSeparator();
                archiveFullName = archiveName;
                parentFullName = "default";
            } else {
                separator = prefix.charAt(prefix.length() - 1);
                archiveFullName = prefix + archiveName;
                parentFullName = prefix.substring(0, prefix.length() - 1);
            }
            if (updateAccount && null != (mass = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class))) {
                final String af = archiveFullName;
                ThreadPools.getThreadPool().submit((Task)new AbstractTask<Void>(){

                    public Void call() throws Exception {
                        MailAccountDescription mad = new MailAccountDescription();
                        mad.setId(accountId);
                        mad.setArchiveFullname(af);
                        mass.updateMailAccount(mad, EnumSet.of(Attribute.ARCHIVE_FULLNAME_LITERAL), session.getUserId(), session.getContextId(), session);
                        return null;
                    }
                });
            }
        } else {
            separator = this.mailAccess.getFolderStorage().getFolder(INBOX_ID).getSeparator();
            int pos = archiveFullName.lastIndexOf(separator);
            if (pos > 0) {
                parentFullName = archiveFullName.substring(0, pos);
                archiveName = archiveFullName.substring(pos + 1);
            } else {
                parentFullName = "default";
                archiveName = archiveFullName;
            }
        }
        if (!this.mailAccess.getFolderStorage().exists(archiveFullName)) {
            if (!createIfAbsent) {
                throw MailExceptionCode.FOLDER_NOT_FOUND.create(archiveFullName);
            }
            MailFolderDescription toCreate = new MailFolderDescription();
            toCreate.setAccountId(accountId);
            toCreate.setParentAccountId(accountId);
            toCreate.setParentFullname(parentFullName);
            toCreate.setExists(false);
            toCreate.setFullname(archiveFullName);
            toCreate.setName(archiveName);
            toCreate.setSeparator(separator);
            DefaultMailPermission mp = new DefaultMailPermission();
            mp.setEntity(session.getUserId());
            int p = 128;
            mp.setAllPermission(128, 128, 128, 128);
            mp.setFolderAdmin(true);
            mp.setGroupPermission(false);
            toCreate.addPermission(mp);
            this.mailAccess.getFolderStorage().createFolder(toCreate);
            CacheFolderStorage.getInstance().removeFromCache(parentFullName, "0", true, session);
        }
        separatorRef[0] = separator;
        return archiveFullName;
    }

    static {
        MailReloadable.getInstance().addReloadable(new Reloadable(){

            public void reloadConfiguration(ConfigurationService configService) {
                maxForwardCount = null;
            }

            public Map<String, String[]> getConfigFileNames() {
                return null;
            }
        });
        FIELDS_FLAGS = new MailListField[]{MailListField.FLAGS};
        ARGS_FLAG_SEEN_SET = new Object[]{32};
        ARGS_FLAG_SEEN_UNSET = new Object[]{-32};
        FIELDS_COLOR_LABEL = new MailListField[]{MailListField.COLOR_LABEL};
        HashMap<String, String> m = new HashMap<String, String>(1, 1.0f);
        m.put("operation", "updateMessageColorLabel");
        MORE_PROPS_UPDATE_LABEL = Collections.unmodifiableMap(m);
        m = new HashMap(1, 1.0f);
        m.put("operation", "updateMessageFlags");
        MORE_PROPS_UPDATE_FLAGS = Collections.unmodifiableMap(m);
    }

    private static final class SimpleMailFolderComparator
    implements Comparator<MailFolder> {
        private final Collator collator;

        public SimpleMailFolderComparator(Locale locale) {
            this.collator = Collators.getSecondaryInstance((Locale)locale);
        }

        @Override
        public int compare(MailFolder o1, MailFolder o2) {
            return this.collator.compare(o1.getName(), o2.getName());
        }
    }

    private static final class MailFolderComparator
    implements Comparator<MailFolder> {
        private final Map<String, Integer> indexMap;
        private final Collator collator;
        private final Integer na;

        public MailFolderComparator(String[] names, Locale locale) {
            this.indexMap = new HashMap<String, Integer>(names.length);
            for (int i = 0; i < names.length; ++i) {
                this.indexMap.put(names[i], i);
            }
            this.na = names.length;
            this.collator = Collators.getSecondaryInstance((Locale)locale);
        }

        private Integer getNumberOf(String name) {
            Integer ret = this.indexMap.get(name);
            if (null == ret) {
                return this.na;
            }
            return ret;
        }

        @Override
        public int compare(MailFolder o1, MailFolder o2) {
            if (o1.isDefaultFolder()) {
                if (o2.isDefaultFolder()) {
                    return this.getNumberOf(o1.getFullname()).compareTo(this.getNumberOf(o2.getFullname()));
                }
                return -1;
            }
            if (o2.isDefaultFolder()) {
                return 1;
            }
            return this.collator.compare(o1.getName(), o2.getName());
        }
    }
}

