/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.login.internal;

import com.openexchange.authentication.Authenticated;
import com.openexchange.authentication.Cookie;
import com.openexchange.authentication.GuestAuthenticated;
import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.authentication.ResponseEnhancement;
import com.openexchange.authentication.ResultCode;
import com.openexchange.authentication.SessionEnhancement;
import com.openexchange.authorization.Authorization;
import com.openexchange.authorization.AuthorizationService;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextExceptionCodes;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Strings;
import com.openexchange.log.LogProperties;
import com.openexchange.login.Blocking;
import com.openexchange.login.LoginHandlerService;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.LoginResult;
import com.openexchange.login.NonTransient;
import com.openexchange.login.internal.AddSessionParameterImpl;
import com.openexchange.login.internal.AutoLoginMethod;
import com.openexchange.login.internal.LoginHandlerRegistry;
import com.openexchange.login.internal.LoginMethodClosure;
import com.openexchange.login.internal.LoginPerformerTask;
import com.openexchange.login.internal.LoginResultImpl;
import com.openexchange.login.internal.NormalLoginMethod;
import com.openexchange.login.internal.format.DefaultLoginFormatter;
import com.openexchange.login.internal.format.LoginFormatter;
import com.openexchange.login.listener.LoginListener;
import com.openexchange.login.listener.internal.LoginListenerRegistryImpl;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.AddSessionParameter;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolCompletionService;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.threadpool.behavior.CallerRunsBehavior;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoginPerformer {
    private static final Logger LOG = LoggerFactory.getLogger(LoginPerformer.class);
    private static final LoginPerformer SINGLETON = new LoginPerformer();
    private static final AtomicReference<LoginFormatter> FORMATTER_REF = new AtomicReference();

    private LoginPerformer() {
    }

    public static LoginPerformer getInstance() {
        return SINGLETON;
    }

    public LoginResult doLogin(LoginRequest request) throws OXException {
        return this.doLogin(request, new HashMap<String, Object>(1));
    }

    public LoginResult doLogin(LoginRequest request, Map<String, Object> properties) throws OXException {
        return this.doLogin(request, properties, new NormalLoginMethod(request, properties));
    }

    public LoginResult doAutoLogin(LoginRequest request, Map<String, Object> properties) throws OXException {
        return this.doLogin(request, properties, new AutoLoginMethod(request, properties));
    }

    public LoginResult doAutoLogin(LoginRequest request) throws OXException {
        HashMap<String, Object> properties = new HashMap<String, Object>(1);
        return this.doLogin(request, properties, new AutoLoginMethod(request, properties));
    }

    public LoginResult doLogin(LoginRequest request, Map<String, Object> properties, LoginMethodClosure loginMethod) throws OXException {
        LoginPerformer.sanityChecks(request);
        List<LoginListener> listeners = LoginListenerRegistryImpl.getInstance().getLoginListeners();
        LoginResultImpl retval = new LoginResultImpl();
        retval.setRequest(request);
        try {
            Session session;
            User user;
            Context ctx;
            Cookie[] cookies;
            for (LoginListener listener : listeners) {
                listener.onBeforeAuthentication(request, properties);
            }
            Map<String, List<String>> headers = request.getHeaders();
            if (headers != null) {
                properties.put("headers", headers);
            }
            if (null != (cookies = request.getCookies())) {
                properties.put("cookies", cookies);
            }
            String userLoginLanguage = request.getLanguage();
            boolean storeLanguage = request.isStoreLanguage();
            Authenticated authed = loginMethod.doAuthentication(retval);
            if (null == authed) {
                LoginResult loginResult = null;
                return loginResult;
            }
            if (authed instanceof ResponseEnhancement) {
                ResponseEnhancement responseEnhancement = (ResponseEnhancement)authed;
                retval.setHeaders(responseEnhancement.getHeaders());
                retval.setCookies(responseEnhancement.getCookies());
                retval.setRedirect(responseEnhancement.getRedirect());
                ResultCode code = responseEnhancement.getCode();
                retval.setCode(code);
                if (ResultCode.REDIRECT.equals((Object)code) || ResultCode.FAILED.equals((Object)code)) {
                    if (ResultCode.FAILED.equals((Object)code)) {
                        for (LoginListener listener : listeners) {
                            listener.onFailedAuthentication(request, properties, null);
                        }
                    } else if (ResultCode.REDIRECT.equals((Object)code)) {
                        for (LoginListener listener : listeners) {
                            listener.onRedirectedAuthentication(request, properties, null);
                        }
                    }
                    Iterator<LoginListener> i$ = retval;
                    return i$;
                }
            }
            if (GuestAuthenticated.class.isInstance(authed)) {
                GuestAuthenticated guestAuthenticated = (GuestAuthenticated)authed;
                ctx = LoginPerformer.getContext(guestAuthenticated.getContextID());
                user = LoginPerformer.getUser(ctx, guestAuthenticated.getUserID());
            } else {
                ctx = LoginPerformer.findContext(authed.getContextInfo());
                user = LoginPerformer.findUser(ctx, authed.getUserInfo());
                AuthorizationService authService = Authorization.getService();
                if (null == authService) {
                    OXException e = ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{AuthorizationService.class.getName()});
                    LOG.error("unable to find AuthorizationService", (Throwable)e);
                    throw e;
                }
                authService.authorizeUser(ctx, user);
            }
            if (storeLanguage && !Strings.isEmpty((String)userLoginLanguage) && !userLoginLanguage.equals(user.getPreferredLanguage())) {
                UserStorage us = UserStorage.getInstance();
                UserImpl impl = new UserImpl(user);
                impl.setPreferredLanguage(userLoginLanguage);
                us.updateUser(impl, ctx);
                user = impl;
            }
            retval.setContext(ctx);
            retval.setUser(user);
            LoginPerformer.checkClient(request, user, ctx);
            SessiondService sessiondService = (SessiondService)SessiondService.SERVICE_REFERENCE.get();
            if (null == sessiondService && null == (sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class))) {
                throw ServiceExceptionCode.absentService(SessiondService.class);
            }
            AddSessionParameterImpl addSession = new AddSessionParameterImpl(authed.getUserInfo(), request, user, ctx);
            if (SessionEnhancement.class.isInstance(authed)) {
                addSession.setEnhancement((SessionEnhancement)authed);
            }
            if (null == (session = sessiondService.addSession((AddSessionParameter)addSession))) {
                throw LoginExceptionCodes.UNKNOWN.create(new Object[]{"Session could not be created."});
            }
            LogProperties.putSessionProperties((Session)session);
            retval.setServerToken((String)session.getParameter("serverToken"));
            retval.setSession(session);
            LoginPerformer.triggerLoginHandlers(retval);
            for (LoginListener listener : listeners) {
                listener.onSucceededAuthentication(retval);
            }
            LoginResultImpl loginResultImpl = retval;
            return loginResultImpl;
        }
        catch (OXException e) {
            if ("DBP".equals(e.getPrefix())) {
                LOG.error(e.getLogMessage(), (Throwable)e);
            }
            if (LoginExceptionCodes.REDIRECT.equals(e)) {
                for (LoginListener listener : listeners) {
                    listener.onRedirectedAuthentication(request, properties, e);
                }
            } else {
                for (LoginListener listener : listeners) {
                    listener.onFailedAuthentication(request, properties, e);
                }
            }
            throw e;
        }
        catch (RuntimeException e) {
            OXException oxe = LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{e.getMessage()});
            for (LoginListener listener : listeners) {
                listener.onFailedAuthentication(request, properties, oxe);
            }
            throw oxe;
        }
        finally {
            LoginPerformer.logLoginRequest(request, retval);
        }
    }

    public static void sanityChecks(LoginRequest request) throws OXException {
        String client = request.getClient();
        if (null != client && client.equals(request.getUserAgent())) {
            throw LoginExceptionCodes.DONT_USER_AGENT.create();
        }
    }

    public static void checkClient(LoginRequest request, User user, Context ctx) throws OXException {
        UserConfigurationStorage ucs;
        UserConfiguration userConfiguration;
        String client = request.getClient();
        if ("USM-JSON".equalsIgnoreCase(client) && !(userConfiguration = (ucs = UserConfigurationStorage.getInstance()).getUserConfiguration(user.getId(), user.getGroups(), ctx)).hasOLOX20()) {
            throw LoginExceptionCodes.CLIENT_DENIED.create(new Object[]{client});
        }
    }

    public static Context findContext(String contextInfo) throws OXException {
        ContextStorage contextStor = ContextStorage.getInstance();
        int contextId = contextStor.getContextId(contextInfo);
        if (-1 == contextId) {
            throw ContextExceptionCodes.NO_MAPPING.create(contextInfo);
        }
        Context context = contextStor.getContext(contextId);
        if (null == context) {
            throw ContextExceptionCodes.NOT_FOUND.create(Autoboxing.I((int)contextId));
        }
        return context;
    }

    public static User findUser(Context ctx, String userInfo) throws OXException {
        String proxyDelimiter = MailProperties.getInstance().getAuthProxyDelimiter();
        UserStorage us = UserStorage.getInstance();
        int userId = null != proxyDelimiter && userInfo.contains(proxyDelimiter) ? us.getUserId(userInfo.substring(userInfo.indexOf(proxyDelimiter) + proxyDelimiter.length(), userInfo.length()), ctx) : us.getUserId(userInfo, ctx);
        return us.getUser(userId, ctx);
    }

    private static Context getContext(int contextID) throws OXException {
        Context context = ContextStorage.getInstance().getContext(contextID);
        if (null == context) {
            throw ContextExceptionCodes.NOT_FOUND.create(Autoboxing.I((int)contextID));
        }
        return context;
    }

    private static User getUser(Context ctx, int userID) throws OXException {
        return UserStorage.getInstance().getUser(userID, ctx);
    }

    public Session doLogout(String sessionId) throws OXException {
        SessiondService sessiondService = (SessiondService)SessiondService.SERVICE_REFERENCE.get();
        if (null == sessiondService && null == (sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class))) {
            throw ServiceExceptionCode.absentService(SessiondService.class);
        }
        Session session = sessiondService.getSession(sessionId);
        if (null == session) {
            LOG.debug("No session found for ID: {}", (Object)sessionId);
            return null;
        }
        ContextStorage contextStor = ContextStorage.getInstance();
        Context context = contextStor.getContext(session.getContextId());
        if (null == context) {
            throw ContextExceptionCodes.NOT_FOUND.create(session.getContextId());
        }
        UserStorage us = UserStorage.getInstance();
        User u = us.getUser(session.getUserId(), context);
        LoginResultImpl logout = new LoginResultImpl(session, context, u);
        sessiondService.removeSession(sessionId);
        LoginPerformer.logLogout(logout);
        LoginPerformer.triggerLogoutHandlers(logout);
        return session;
    }

    public static void triggerLoginHandlers(final LoginResult login) {
        block8: {
            ThreadPoolService executor;
            block7: {
                executor = ThreadPools.getThreadPool();
                if (null != executor) break block7;
                Iterator<LoginHandlerService> it = LoginHandlerRegistry.getInstance().getLoginHandlers();
                while (it.hasNext()) {
                    LoginHandlerService handler = it.next();
                    LoginPerformer.handleSafely(login, handler, true);
                }
                break block8;
            }
            ThreadPoolCompletionService completionService = null;
            int blocking = 0;
            boolean tranzient = login.getSession().isTransient();
            Iterator<LoginHandlerService> it = LoginHandlerRegistry.getInstance().getLoginHandlers();
            while (it.hasNext()) {
                final LoginHandlerService handler = it.next();
                if (tranzient && NonTransient.class.isInstance(handler)) continue;
                if (handler instanceof Blocking) {
                    if (null == completionService) {
                        completionService = new ThreadPoolCompletionService(executor);
                    }
                    Callable<Void> callable = new Callable<Void>(){

                        @Override
                        public Void call() {
                            LoginPerformer.handleSafely(login, handler, true);
                            return null;
                        }
                    };
                    completionService.submit((Callable)callable);
                    ++blocking;
                    continue;
                }
                executor.submit((Task)new LoginPerformerTask(){

                    public Object call() {
                        LoginPerformer.handleSafely(login, handler, true);
                        return null;
                    }
                }, CallerRunsBehavior.getInstance());
            }
            if (blocking <= 0 || null == completionService) break block8;
            for (int i = 0; i < blocking; ++i) {
                try {
                    completionService.take();
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static void triggerLogoutHandlers(final LoginResult logout) {
        block8: {
            ThreadPoolService executor;
            block7: {
                executor = ThreadPools.getThreadPool();
                if (null != executor) break block7;
                Iterator<LoginHandlerService> it = LoginHandlerRegistry.getInstance().getLoginHandlers();
                while (it.hasNext()) {
                    LoginPerformer.handleSafely(logout, it.next(), false);
                }
                break block8;
            }
            ThreadPoolCompletionService completionService = null;
            int blocking = 0;
            Iterator<LoginHandlerService> it = LoginHandlerRegistry.getInstance().getLoginHandlers();
            while (it.hasNext()) {
                final LoginHandlerService handler = it.next();
                if (handler instanceof Blocking) {
                    if (null == completionService) {
                        completionService = new ThreadPoolCompletionService(executor);
                    }
                    Callable<Void> callable = new Callable<Void>(){

                        @Override
                        public Void call() {
                            LoginPerformer.handleSafely(logout, handler, false);
                            return null;
                        }
                    };
                    completionService.submit((Callable)callable);
                    ++blocking;
                    continue;
                }
                executor.submit((Task)new LoginPerformerTask(){

                    public Object call() {
                        LoginPerformer.handleSafely(logout, handler, false);
                        return null;
                    }
                }, CallerRunsBehavior.getInstance());
            }
            if (blocking <= 0 || null == completionService) break block8;
            for (int i = 0; i < blocking; ++i) {
                try {
                    completionService.take();
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected static void handleSafely(LoginResult login, LoginHandlerService handler, boolean isLogin) {
        if (null == login || null == handler) {
            return;
        }
        try {
            if (isLogin) {
                handler.handleLogin(login);
            } else {
                handler.handleLogout(login);
            }
        }
        catch (OXException e) {
            switch (((Category)e.getCategories().get(0)).getLogLevel()) {
                case TRACE: {
                    LOG.trace("", (Throwable)e);
                    break;
                }
                case DEBUG: {
                    LOG.debug("", (Throwable)e);
                    break;
                }
                case INFO: {
                    LOG.info("", (Throwable)e);
                    break;
                }
                case WARNING: {
                    LOG.warn("", (Throwable)e);
                    break;
                }
                case ERROR: {
                    LOG.error("", (Throwable)e);
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void setLoginFormatter(LoginFormatter formatter) {
        FORMATTER_REF.set(formatter);
    }

    private static void logLoginRequest(LoginRequest request, LoginResult result) {
        LoginFormatter formatter = FORMATTER_REF.get();
        StringBuilder sb = new StringBuilder(1024);
        if (null == formatter) {
            DefaultLoginFormatter.getInstance().formatLogin(request, result, sb);
        } else {
            formatter.formatLogin(request, result, sb);
        }
        LOG.info(sb.toString());
    }

    private static void logLogout(LoginResult result) {
        LoginFormatter formatter = FORMATTER_REF.get();
        StringBuilder sb = new StringBuilder(512);
        if (null == formatter) {
            DefaultLoginFormatter.getInstance().formatLogout(result, sb);
        } else {
            formatter.formatLogout(result, sb);
        }
        LOG.info(sb.toString());
    }

    public Session lookupSession(String sessionId) throws OXException {
        return ServerServiceRegistry.getInstance().getService(SessiondService.class, true).getSession(sessionId);
    }

    public Session lookupSessionWithTokens(String clientToken, String serverToken) throws OXException {
        return ServerServiceRegistry.getInstance().getService(SessiondService.class, true).getSessionWithTokens(clientToken, serverToken);
    }
}

