/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks.objectusagecount;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.objectusagecount.CreateObjectUseCountTableService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class CreateObjectUseCountTableTask
extends UpdateTaskAdapter {
    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class, true);
        Connection writeCon = dbService.getForUpdateTask(contextId);
        PreparedStatement stmt = null;
        try {
            CreateObjectUseCountTableService tmp = new CreateObjectUseCountTableService();
            String createStmt = tmp.getCreateStatements()[0];
            String tableName = tmp.tablesToCreate()[0];
            if (!DBUtils.tableExists(writeCon, tableName)) {
                stmt = writeCon.prepareStatement(createStmt);
                stmt.executeUpdate();
                DBUtils.closeSQLStuff(stmt);
            }
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
            dbService.backForUpdateTask(contextId, writeCon);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }
}

