/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.Databases;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.UserSettingServerAddUuidUpdateTask;
import com.openexchange.java.util.UUIDs;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.UUID;

public class UserSettingServerAddPrimaryKeyUpdateTask
extends UpdateTaskAdapter {
    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        Connection con = Database.getNoTimeout(cid, true);
        Column column = new Column("uuid", "BINARY(16) NOT NULL");
        try {
            con.setAutoCommit(false);
            this.setUUID(con);
            Tools.modifyColumns(con, "user_setting_server", column);
            this.dropDuplicates(con);
            String foreignKey = Tools.existsForeignKey(con, "user", new String[]{"cid", "id"}, "user_setting_server", new String[]{"cid", "user"});
            if (null != foreignKey && !foreignKey.equals("")) {
                Tools.dropForeignKey(con, "user_setting_server", foreignKey);
            }
            this.dropOrphaned(con);
            Tools.createPrimaryKeyIfAbsent(con, "user_setting_server", new String[]{"cid", "user", column.name});
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropOrphaned(Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block5: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT uss.cid, user, hex(uuid) FROM user_setting_server AS uss LEFT JOIN user ON uss.cid = user.cid AND uss.user = user.id WHERE user.id IS NULL");
            rs = stmt.executeQuery();
            if (rs.next()) break block5;
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return;
        }
        try {
            class Orphaned {
                final UUID uuid;
                final int cid;
                final int user;

                Orphaned(int cid, int user, UUID uuid) {
                    this.cid = cid;
                    this.user = user;
                    this.uuid = uuid;
                }
            }
            LinkedList<Orphaned> orphaneds = new LinkedList<Orphaned>();
            do {
                orphaneds.add(new Orphaned(rs.getInt(1), rs.getInt(2), UUIDs.fromUnformattedString((String)rs.getString(3))));
            } while (rs.next());
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            rs = null;
            stmt = null;
            for (Orphaned orphaned : orphaneds) {
                stmt = con.prepareStatement("DELETE FROM user_setting_server WHERE cid=? AND user=? AND ?=HEX(uuid)");
                stmt.setInt(1, orphaned.cid);
                stmt.setInt(2, orphaned.user);
                stmt.setString(3, UUIDs.getUnformattedString((UUID)orphaned.uuid));
                stmt.executeUpdate();
                Databases.closeSQLStuff((Statement)stmt);
                stmt = null;
            }
        }
        catch (Throwable throwable) {
            Databases.closeSQLStuff(rs, (Statement)stmt);
            throw throwable;
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropDuplicates(Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT cid, user, HEX(uuid) FROM user_setting_server GROUP BY cid, user, uuid HAVING count(*) > 1");
            rs = stmt.executeQuery();
            if (rs.next()) break block6;
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return;
        }
        try {
            class Dup {
                final UUID uuid;
                final int cid;
                final int user;

                Dup(int cid, int user, UUID uuid) {
                    this.cid = cid;
                    this.user = user;
                    this.uuid = uuid;
                }
            }
            LinkedList<Dup> dups = new LinkedList<Dup>();
            do {
                dups.add(new Dup(rs.getInt(1), rs.getInt(2), UUIDs.fromUnformattedString((String)rs.getString(3))));
            } while (rs.next());
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            rs = null;
            stmt = null;
            for (Dup dup : dups) {
                stmt = con.prepareStatement("SELECT cid, user, contact_collect_folder, contact_collect_enabled, defaultStatusPrivate, defaultStatusPublic, contactCollectOnMailAccess, contactCollectOnMailTransport, folderTree FROM user_setting_server WHERE cid=? AND user=? AND ?=HEX(uuid)");
                stmt.setInt(1, dup.cid);
                stmt.setInt(2, dup.user);
                stmt.setString(3, UUIDs.getUnformattedString((UUID)dup.uuid));
                rs = stmt.executeQuery();
                if (rs.next()) {
                    int cid = rs.getInt(1);
                    int user = rs.getInt(2);
                    int contact_collect_folder = rs.getInt(3);
                    int contact_collect_enabled = rs.getInt(4);
                    int defaultStatusPrivate = rs.getInt(5);
                    int defaultStatusPublic = rs.getInt(6);
                    int contactCollectOnMailAccess = rs.getInt(7);
                    int contactCollectOnMailTransport = rs.getInt(8);
                    int folderTree = rs.getInt(9);
                    Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                    rs = null;
                    stmt = null;
                    stmt = con.prepareStatement("DELETE FROM user_setting_server WHERE cid=? AND user=? AND ?=HEX(uuid)");
                    stmt.setInt(1, dup.cid);
                    stmt.setInt(2, dup.user);
                    stmt.setString(3, UUIDs.getUnformattedString((UUID)dup.uuid));
                    stmt.executeUpdate();
                    Databases.closeSQLStuff((Statement)stmt);
                    stmt = null;
                    stmt = con.prepareStatement("INSERT INTO user_setting_server (cid,user,contact_collect_folder,contact_collect_enabled,defaultStatusPrivate,defaultStatusPublic,contactCollectOnMailAccess,contactCollectOnMailTransport,folderTree,uuid) VALUES (?,?,?,?,?,?,?,?,?,UNHEX(?))");
                    stmt.setInt(1, cid);
                    stmt.setInt(2, user);
                    stmt.setInt(3, contact_collect_folder);
                    stmt.setInt(4, contact_collect_enabled);
                    stmt.setInt(5, defaultStatusPrivate);
                    stmt.setInt(6, defaultStatusPublic);
                    stmt.setInt(7, contactCollectOnMailAccess);
                    stmt.setInt(8, contactCollectOnMailTransport);
                    stmt.setInt(9, folderTree);
                    stmt.setString(10, UUIDs.getUnformattedString((UUID)dup.uuid));
                    stmt.executeUpdate();
                    Databases.closeSQLStuff((Statement)stmt);
                    stmt = null;
                }
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                rs = null;
                stmt = null;
            }
        }
        catch (Throwable throwable) {
            Databases.closeSQLStuff(rs, (Statement)stmt);
            throw throwable;
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
    }

    @Override
    public String[] getDependencies() {
        return new String[]{UserSettingServerAddUuidUpdateTask.class.getName()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUUID(Connection con) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT cid, user, contact_collect_folder, contact_collect_enabled, defaultStatusPrivate, defaultStatusPublic, contactCollectOnMailTransport, contactCollectOnMailAccess, folderTree FROM user_setting_server WHERE uuid IS NULL FOR UPDATE");
            rs = stmt.executeQuery();
            PreparedStatement stmt2 = null;
            try {
                while (rs.next()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("UPDATE user_setting_server SET uuid = ? WHERE cid ");
                    int oldPos = 1;
                    int cid = rs.getInt(oldPos++);
                    boolean cidNull = rs.wasNull();
                    if (cidNull) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND user ");
                    int user = rs.getInt(oldPos++);
                    boolean userNull = rs.wasNull();
                    if (userNull) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND contact_collect_folder ");
                    int contactCollectFolder = rs.getInt(oldPos++);
                    boolean contactCollectFolderNull = rs.wasNull();
                    if (contactCollectFolderNull) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND contact_collect_enabled ");
                    boolean contactCollectEnabled = rs.getBoolean(oldPos++);
                    boolean contactCollectEnabledNull = rs.wasNull();
                    if (contactCollectEnabledNull) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND defaultStatusPrivate ");
                    int defaultStatusPrivate = rs.getInt(oldPos++);
                    boolean defaultStatusPrivateNull = rs.wasNull();
                    if (defaultStatusPrivateNull) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND defaultStatusPublic ");
                    int defaultStatusPublic = rs.getInt(oldPos++);
                    boolean defaultStatusPublicNull = rs.wasNull();
                    if (defaultStatusPublicNull) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND contactCollectOnMailTransport ");
                    boolean contactCollectOnMailTransport = rs.getBoolean(oldPos++);
                    boolean contactCollectOnMailTransportNull = rs.wasNull();
                    if (contactCollectOnMailTransportNull) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND contactCollectOnMailAccess ");
                    boolean contactCollectOnMailAccess = rs.getBoolean(oldPos++);
                    boolean contactCollectOnMailAccessNull = rs.wasNull();
                    if (contactCollectOnMailAccessNull) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND folderTree ");
                    int folderTree = rs.getInt(oldPos++);
                    boolean folderTreeNull = rs.wasNull();
                    if (folderTreeNull) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    stmt2 = con.prepareStatement(sb.toString());
                    int newPos = 1;
                    UUID uuid = UUID.randomUUID();
                    stmt2.setBytes(newPos++, UUIDs.toByteArray((UUID)uuid));
                    if (!cidNull) {
                        stmt2.setInt(newPos++, cid);
                    } else {
                        stmt2.setNull(newPos++, 4);
                    }
                    if (!userNull) {
                        stmt2.setInt(newPos++, user);
                    } else {
                        stmt2.setNull(newPos++, 4);
                    }
                    if (!contactCollectFolderNull) {
                        stmt2.setInt(newPos++, contactCollectFolder);
                    } else {
                        stmt2.setNull(newPos++, 4);
                    }
                    if (!contactCollectEnabledNull) {
                        stmt2.setBoolean(newPos++, contactCollectEnabled);
                    } else {
                        stmt2.setNull(newPos++, 16);
                    }
                    if (!defaultStatusPrivateNull) {
                        stmt2.setInt(newPos++, defaultStatusPrivate);
                    } else {
                        stmt2.setNull(newPos++, 4);
                    }
                    if (!defaultStatusPublicNull) {
                        stmt2.setInt(newPos++, defaultStatusPublic);
                    } else {
                        stmt2.setNull(newPos++, 4);
                    }
                    if (!contactCollectOnMailTransportNull) {
                        stmt2.setBoolean(newPos++, contactCollectOnMailTransport);
                    } else {
                        stmt2.setNull(newPos++, 16);
                    }
                    if (!contactCollectOnMailAccessNull) {
                        stmt2.setBoolean(newPos++, contactCollectOnMailAccess);
                    } else {
                        stmt2.setNull(newPos++, 16);
                    }
                    if (!folderTreeNull) {
                        stmt2.setInt(newPos++, folderTree);
                    } else {
                        stmt2.setNull(newPos++, 4);
                    }
                    stmt2.execute();
                }
            }
            finally {
                DBUtils.closeSQLStuff(stmt2);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
    }
}

