/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang.Validate;

public class MakeFolderIdPrimaryForDelContactsTable
extends UpdateTaskAdapter {
    protected static final String DEL_CONTACTS = "del_contacts";
    protected static final String PRG_CONTACTS = "prg_contacts";

    @Override
    public void perform(PerformParameters params) throws OXException {
        Validate.notNull((Object)params);
        int cid = params.getContextId();
        Connection con = Database.getNoTimeout(cid, true);
        try {
            con.setAutoCommit(false);
            if (Tools.hasPrimaryKey(con, DEL_CONTACTS)) {
                Tools.dropPrimaryKey(con, DEL_CONTACTS);
            }
            Tools.createPrimaryKey(con, DEL_CONTACTS, new String[]{"cid", "intfield01", "fid"});
            if (Tools.hasPrimaryKey(con, PRG_CONTACTS)) {
                Tools.dropPrimaryKey(con, PRG_CONTACTS);
            }
            Tools.createPrimaryKey(con, PRG_CONTACTS, new String[]{"cid", "intfield01", "fid"});
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }
}

