/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.Databases;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class MailAccountAddArchiveTask
extends UpdateTaskAdapter {
    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BLOCKING);
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void perform(PerformParameters params) throws OXException {
        PreparedStatement stmt;
        Connection con;
        int contextId;
        block7: {
            contextId = params.getContextId();
            con = Database.getNoTimeout(contextId, true);
            stmt = null;
            boolean doRollback = false;
            try {
                Databases.startTransaction((Connection)con);
                doRollback = true;
                if (!Tools.columnExists(con, "user_mail_account", "archive")) {
                    stmt = con.prepareStatement("ALTER TABLE user_mail_account ADD COLUMN archive VARCHAR(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT ''");
                    stmt.executeUpdate();
                    stmt.close();
                    stmt = null;
                }
                if (!Tools.columnExists(con, "user_mail_account", "archive_fullname")) {
                    stmt = con.prepareStatement("ALTER TABLE user_mail_account ADD COLUMN archive_fullname VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT ''");
                    stmt.executeUpdate();
                    stmt.close();
                    stmt = null;
                }
                con.commit();
                doRollback = false;
                if (!doRollback) break block7;
            }
            catch (SQLException e) {
                try {
                    throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    if (doRollback) {
                        Databases.rollback((Connection)con);
                    }
                    DBUtils.closeSQLStuff(stmt);
                    Database.backNoTimeout(contextId, true, con);
                    throw throwable;
                }
            }
            Databases.rollback((Connection)con);
        }
        DBUtils.closeSQLStuff(stmt);
        Database.backNoTimeout(contextId, true, con);
    }
}

