/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.CalendarAddConfirmPerOccurrenceTask;
import com.openexchange.groupware.update.tasks.DelDatesMembersPrimaryKeyUpdateTask;
import com.openexchange.groupware.update.tasks.PrgDatesMembersPrimaryKeyUpdateTask;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;

public class CalendarAddNewPrimaryKeyForConfirmPerOccurrence
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[]{PrgDatesMembersPrimaryKeyUpdateTask.class.getName(), DelDatesMembersPrimaryKeyUpdateTask.class.getName(), CalendarAddConfirmPerOccurrenceTask.class.getName()};
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextID = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection connnection = dbService.getForUpdateTask(contextID);
        boolean rollback = false;
        try {
            connnection.setAutoCommit(false);
            rollback = true;
            String[] tables = new String[]{"prg_dates_members", "del_dates_members"};
            String[] columns = new String[]{"cid", "object_id", "member_uid", "pfid", "occurrence"};
            int[] lengths = new int[5];
            Arrays.fill(lengths, 0);
            this.checkPrimaryKey(columns, lengths, tables, connnection);
            String[] oldCols = new String[]{"cid", "member_uid", "object_id"};
            String[] newCols = new String[]{"cid", "member_uid", "object_id", "occurrence"};
            this.checkUniqueKey(oldCols, newCols, tables, connnection);
            String foreignKey = Tools.existsForeignKey(connnection, "prg_dates", new String[]{"cid", "intfield01"}, "dateExternal", new String[]{"cid", "objectId"});
            if (null != foreignKey && !foreignKey.equals("")) {
                Tools.dropForeignKey(connnection, "dateExternal", foreignKey);
            }
            if (null != (foreignKey = Tools.existsForeignKey(connnection, "del_dates", new String[]{"cid", "intfield01"}, "delDateExternal", new String[]{"cid", "objectId"})) && !foreignKey.equals("")) {
                Tools.dropForeignKey(connnection, "delDateExternal", foreignKey);
            }
            String[] tables2 = new String[]{"dateExternal", "delDateExternal"};
            String[] columns2 = new String[]{"cid", "objectId", "mailAddress", "occurrence"};
            int[] lengths2 = new int[4];
            Arrays.fill(lengths2, 0);
            lengths2[2] = 255;
            this.checkPrimaryKey(columns2, lengths2, tables2, connnection);
            connnection.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(connnection);
            }
            DBUtils.autocommit(connnection);
            Database.backNoTimeout(contextID, true, connnection);
        }
    }

    private void checkPrimaryKey(String[] columns, int[] lengths, String[] tables, Connection connnection) throws SQLException {
        for (String table : tables) {
            if (Tools.existsPrimaryKey(connnection, table, columns)) continue;
            try {
                Tools.dropPrimaryKey(connnection, table);
            }
            catch (Exception x) {
                // empty catch block
            }
            Tools.createPrimaryKey(connnection, table, columns, lengths);
        }
    }

    private void checkUniqueKey(String[] oldColumns, String[] newColumns, String[] tables, Connection connnection) throws SQLException {
        for (String table : tables) {
            String newIndex;
            String oldIndex = Tools.existsIndex(connnection, table, oldColumns);
            if (null != oldIndex) {
                Tools.dropIndex(connnection, table, oldIndex);
            }
            if (null != (newIndex = Tools.existsIndex(connnection, table, newColumns))) continue;
            Tools.createIndex(connnection, table, "member", newColumns, true);
        }
    }
}

