/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.impl;

import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptions;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.SettingExceptionCodes;
import com.openexchange.groupware.settings.impl.SettingStorage;
import com.openexchange.groupware.settings.impl.Tools;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.server.impl.DBPool;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbSettingStorage
extends SettingStorage {
    private static final Logger LOG = LoggerFactory.getLogger(RdbSettingStorage.class);
    private static final String SELECT_VALUE = "SELECT value FROM user_setting WHERE cid=? AND user_id=? AND path_id=?";
    private static final String INSERT_SETTING = "INSERT INTO user_setting (value,cid,user_id,path_id) VALUES (?,?,?,?)";
    private static final String UPDATE_SETTING_CAS = "UPDATE user_setting SET value=? WHERE cid=? AND user_id=? AND path_id=? AND value=?";
    private final Session session;
    private final int ctxId;
    private final int userId;
    private final Context ctx;
    private final User user;
    private final UserConfiguration userConfig;
    private static final int MAX_RETRY = 3;

    RdbSettingStorage(Session session) throws OXException {
        this(session, session.getContextId(), session.getUserId());
    }

    RdbSettingStorage(Session session, int ctxId, int userId) throws OXException {
        this.session = session;
        this.ctxId = ctxId;
        this.userId = userId;
        if (session instanceof ServerSession) {
            ServerSession serverSession = (ServerSession)session;
            this.ctx = serverSession.getContext();
            this.user = serverSession.getUser();
            this.userConfig = serverSession.getUserConfiguration();
        } else {
            this.ctx = Tools.getContext(ctxId);
            this.user = Tools.getUser(this.ctx, userId);
            this.userConfig = Tools.getUserConfiguration(this.ctx, userId);
        }
    }

    RdbSettingStorage(Session session, Context ctx, User user, UserConfiguration userConfig) {
        this.session = session;
        this.ctx = ctx;
        this.ctxId = ctx.getContextId();
        this.user = user;
        this.userId = user.getId();
        this.userConfig = userConfig;
    }

    RdbSettingStorage(int ctxId, int userId) {
        this.session = null;
        this.ctxId = ctxId;
        this.userId = userId;
        this.ctx = null;
        this.user = null;
        this.userConfig = null;
    }

    @Override
    public void save(Setting setting) throws OXException {
        this.save(null, setting);
    }

    @Override
    public void save(Connection con, Setting setting) throws OXException {
        if (!setting.isLeaf()) {
            throw SettingExceptionCodes.NOT_LEAF.create(setting.getName());
        }
        if (setting.isShared()) {
            IValueHandler value = RdbSettingStorage.getSharedValue(setting);
            if (null != value && value.isWritable()) {
                value.writeValue(this.session, this.ctx, this.user, setting);
            } else {
                LOG.debug("Writing the setting {} is not permitted.", (Object)setting.getName());
            }
        } else {
            this.saveInternal(con, setting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveInternal(Connection con, Setting setting) throws OXException {
        if (null == con) {
            Connection myCon = null;
            try {
                myCon = DBPool.pickupWriteable(this.ctx);
                this.saveInternal2(myCon, setting);
            }
            finally {
                if (null != myCon) {
                    DBPool.closeWriterSilent(this.ctx, myCon);
                }
            }
        } else {
            this.saveInternal2(con, setting);
        }
    }

    private void saveInternal2(Connection con, Setting setting) throws OXException {
        this.saveInternalCAS(con, setting, 3);
    }

    private void saveInternalCAS(Connection con, Setting setting, int retryCount) throws OXException {
        try {
            String val = null;
            int retry = 0;
            boolean tryInsert = true;
            while (val == null) {
                String cur;
                do {
                    if ((cur = this.performSelect(setting, con)) == null) {
                        if (tryInsert) {
                            if (this.performInsert(setting, con)) {
                                return;
                            }
                            tryInsert = false;
                        }
                        cur = this.performSelect(setting, con);
                    }
                    if (retry++ <= retryCount) continue;
                    throw SettingExceptionCodes.MAX_RETRY.create();
                } while (!this.compareAndSet(setting, cur, con));
                val = setting.getSingleValue().toString();
            }
            return;
        }
        catch (DataTruncation e) {
            String name = setting.getName();
            if (null == name) {
                name = Integer.toString(setting.getId());
            }
            throw SettingExceptionCodes.DATA_TRUNCATION.create(name, e);
        }
        catch (SQLException e) {
            throw SettingExceptionCodes.SQL_ERROR.create(e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compareAndSet(Setting setting, String expected, Connection con) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(UPDATE_SETTING_CAS);
            int pos = 1;
            stmt.setString(pos++, setting.getSingleValue().toString());
            stmt.setInt(pos++, this.ctxId);
            stmt.setInt(pos++, this.userId);
            stmt.setInt(pos++, setting.getId());
            stmt.setString(pos, expected);
            int result = stmt.executeUpdate();
            boolean bl = result > 0;
            return bl;
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performInsert(Setting setting, Connection con) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(INSERT_SETTING);
            int pos = 1;
            stmt.setString(pos++, setting.getSingleValue().toString());
            stmt.setInt(pos++, this.ctxId);
            stmt.setInt(pos++, this.userId);
            stmt.setInt(pos, setting.getId());
            try {
                int result = stmt.executeUpdate();
                boolean bl = result > 0;
                return bl;
            }
            catch (SQLException e) {
                boolean bl = false;
                DBUtils.closeSQLStuff(stmt);
                return bl;
            }
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private String performSelect(Setting setting, Connection con) throws OXException {
        String string;
        ResultSet result;
        PreparedStatement stmt;
        block5: {
            stmt = null;
            result = null;
            stmt = con.prepareStatement("SELECT value FROM user_setting WHERE cid=? AND user_id=? AND path_id=? FOR UPDATE");
            int pos = 1;
            stmt.setInt(pos++, this.ctxId);
            stmt.setInt(pos++, this.userId);
            stmt.setInt(pos, setting.getId());
            result = stmt.executeQuery();
            if (!result.next()) break block5;
            String string2 = result.getString(1);
            DBUtils.closeSQLStuff(result, stmt);
            return string2;
        }
        try {
            string = null;
        }
        catch (SQLException e) {
            try {
                throw SettingExceptionCodes.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readValues(Setting setting) throws OXException {
        if (!setting.isLeaf()) {
            this.readSubValues(setting);
            return;
        }
        if (setting.isShared()) {
            this.readSharedValue(setting);
        } else {
            Connection con = DBPool.pickup(this.ctx);
            try {
                this.readValues(con, setting);
            }
            finally {
                DBPool.closeReaderSilent(this.ctx, con);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void readValues(Connection con, Setting setting) throws OXException {
        ResultSet result;
        PreparedStatement stmt;
        block7: {
            if (!setting.isLeaf()) {
                this.readSubValues(setting);
                return;
            }
            if (setting.isShared()) {
                this.readSharedValue(setting);
                return;
            }
            stmt = null;
            result = null;
            try {
                stmt = con.prepareStatement(SELECT_VALUE);
                int pos = 1;
                stmt.setInt(pos++, this.ctxId);
                stmt.setInt(pos++, this.userId);
                stmt.setInt(pos++, setting.getId());
                result = stmt.executeQuery();
                if (result.next()) {
                    setting.setSingleValue(result.getString(1));
                    break block7;
                }
                setting.setSingleValue(null);
            }
            catch (SQLException e) {
                try {
                    throw SettingExceptionCodes.SQL_ERROR.create(e, new Object[0]);
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return;
    }

    private void readSharedValue(Setting setting) throws OXException {
        block8: {
            IValueHandler reader = RdbSettingStorage.getSharedValue(setting);
            if (null != reader) {
                if (reader.isAvailable(this.userConfig)) {
                    try {
                        Setting parent;
                        reader.getValue(this.session, this.ctx, this.user, this.userConfig, setting);
                        if (setting.getSingleValue() != null && setting.getSingleValue().equals(IValueHandler.UNDEFINED) && null != (parent = setting.getParent())) {
                            parent.removeElement(setting);
                        }
                    }
                    catch (OXException e) {
                        if (OXExceptions.isPermissionDenied((OXException)e)) {
                            LOG.debug("Problem while reading setting value.", (Throwable)e);
                            break block8;
                        }
                        LOG.error("Problem while reading setting value.", (Throwable)e);
                    }
                } else {
                    Setting parent = setting.getParent();
                    if (null != parent) {
                        parent.removeElement(setting);
                    }
                }
            }
        }
    }

    private void readSubValues(Setting setting) throws OXException {
        Setting parent;
        for (Setting subSetting : setting.getElements()) {
            this.readValues(subSetting);
        }
        if (setting.isLeaf() && null != (parent = setting.getParent())) {
            parent.removeElement(setting);
        }
    }

    static IValueHandler getSharedValue(Setting setting) {
        IValueHandler retval = null;
        if (setting.isLeaf()) {
            retval = setting.getShared();
        }
        return retval;
    }
}

