/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.notify.hostname.internal;

import com.openexchange.dispatcher.DispatcherPrefixService;
import com.openexchange.groupware.notify.hostname.HostnameService;
import com.openexchange.groupware.notify.hostname.internal.HostDataImpl;
import com.openexchange.login.BlockingLoginHandlerService;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.LoginResult;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.systemname.SystemNameService;
import com.openexchange.tools.servlet.http.Tools;

public final class HostDataLoginHandler
implements BlockingLoginHandlerService {
    private final SystemNameService systemNameService;
    private final DispatcherPrefixService dispatcherPrefixService;
    private final ServiceLookup services;

    public HostDataLoginHandler(ServiceLookup services) {
        this.services = services;
        this.systemNameService = (SystemNameService)services.getService(SystemNameService.class);
        this.dispatcherPrefixService = (DispatcherPrefixService)services.getService(DispatcherPrefixService.class);
    }

    @Override
    public void handleLogin(LoginResult login) {
        LoginRequest request = login.getRequest();
        Session session = login.getSession();
        HostDataImpl hostData = new HostDataImpl(request.isSecure(), this.determineHost(login, session.getContextId(), session.getUserId()), request.getServerPort(), request.getHttpSessionID(), Tools.extractRoute(request.getHttpSessionID()), this.dispatcherPrefixService.getPrefix());
        session.setParameter("com.openexchange.groupware.hostdata", (Object)hostData);
    }

    private String determineHost(LoginResult loginResult, int contextId, int userId) {
        String tmp;
        String host = loginResult.getRequest().getServerName();
        HostnameService hostnameService = (HostnameService)this.services.getOptionalService(HostnameService.class);
        if (null != hostnameService && null != (tmp = loginResult.getUser().isGuest() ? hostnameService.getGuestHostname(userId, contextId) : hostnameService.getHostname(userId, contextId))) {
            host = tmp;
        }
        return host;
    }

    private String determineRoute(String httpSessionId) {
        String retval = null == httpSessionId ? "0123456789." + this.systemNameService.getSystemName() : (httpSessionId.indexOf(46) > 0 ? httpSessionId : httpSessionId + '.' + this.systemNameService.getSystemName());
        return retval;
    }

    @Override
    public void handleLogout(LoginResult logout) {
    }
}

