/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.webdav;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.webdav.PropertyStore;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.session.SessionHolder;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropertyHelper {
    private final Map<WebdavProperty, WebdavProperty> properties = new HashMap<WebdavProperty, WebdavProperty>();
    private final Set<WebdavProperty> removedProperties = new HashSet<WebdavProperty>();
    private boolean loadedAllProps;
    private final List<WebdavProperty> changedProps = new ArrayList<WebdavProperty>();
    private final PropertyStore propertyStore;
    private final SessionHolder sessionHolder;
    private int id;
    private final WebdavPath url;
    private boolean changed;

    public PropertyHelper(PropertyStore props, SessionHolder sessionHolder, WebdavPath url) {
        this.propertyStore = props;
        this.sessionHolder = sessionHolder;
        this.url = url;
    }

    public List<WebdavProperty> getAllProps() throws WebdavProtocolException {
        this.loadAllProperties();
        return new ArrayList<WebdavProperty>(this.properties.values());
    }

    public WebdavProperty getProperty(String namespace, String name) throws WebdavProtocolException {
        this.loadProperty(namespace, name);
        return this.properties.get(new WebdavProperty(namespace, name));
    }

    public void putProperty(WebdavProperty prop) {
        this.properties.put(new WebdavProperty(prop.getNamespace(), prop.getName()), prop);
        this.markSetProperty(prop);
        this.markChanged();
    }

    public void setId(int id) {
        this.id = id;
    }

    public void removeProperty(String namespace, String name) {
        if (this.properties.remove(new WebdavProperty(namespace, name)) != null) {
            this.markRemovedProperty(new WebdavProperty(namespace, name));
        }
    }

    public boolean isRemoved(WebdavProperty property) {
        return this.removedProperties.contains(property);
    }

    private void markRemovedProperty(WebdavProperty property) {
        this.removedProperties.add(property);
        this.changedProps.remove(this.properties.get(property));
    }

    private void markSetProperty(WebdavProperty property) {
        this.removedProperties.remove(property);
        this.changedProps.add(property);
    }

    private void markChanged() {
        this.changed = true;
    }

    public boolean mustWrite() {
        return this.changed;
    }

    private void loadProperty(String namespace, String name) throws WebdavProtocolException {
        if (this.removedProperties.contains(new WebdavProperty(namespace, name))) {
            return;
        }
        if (this.loadedAllProps) {
            return;
        }
        try {
            ServerSession session = this.getSession();
            List<WebdavProperty> list = this.propertyStore.loadProperties(this.id, Arrays.asList(new WebdavProperty(namespace, name)), session.getContext());
            if (list.isEmpty()) {
                return;
            }
            WebdavProperty prop = list.get(0);
            this.properties.put(new WebdavProperty(prop.getNamespace(), prop.getName()), prop);
        }
        catch (OXException e) {
            throw WebdavProtocolException.generalError(e, this.url, 500);
        }
    }

    private void loadAllProperties() throws WebdavProtocolException {
        if (this.loadedAllProps) {
            return;
        }
        this.loadedAllProps = true;
        try {
            ServerSession session = this.getSession();
            List<WebdavProperty> list = this.propertyStore.loadAllProperties(this.id, session.getContext());
            for (WebdavProperty prop : list) {
                this.properties.put(new WebdavProperty(prop.getNamespace(), prop.getName()), prop);
            }
        }
        catch (OXException e) {
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.url, 500, e, new Object[0]);
        }
    }

    public void dumpPropertiesToDB() throws OXException {
        if (!this.changed) {
            return;
        }
        this.changed = false;
        ServerSession session = this.getSession();
        this.propertyStore.saveProperties(this.id, new ArrayList<WebdavProperty>(this.changedProps), session.getContext());
        this.changedProps.clear();
        this.propertyStore.removeProperties(this.id, new ArrayList<WebdavProperty>(this.removedProperties), session.getContext());
        this.removedProperties.clear();
    }

    public void deleteProperties() throws OXException {
        ServerSession session = this.getSession();
        this.propertyStore.removeAll(this.id, session.getContext());
    }

    private ServerSession getSession() throws OXException {
        return ServerSessionAdapter.valueOf(this.sessionHolder.getSessionObject());
    }
}

