/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.facade.impl;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.database.impl.InfostoreQueryCatalog;
import com.openexchange.groupware.infostore.facade.impl.DbMetadataLoader;
import com.openexchange.java.Autoboxing;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class NumberOfVersionsLoader
extends DbMetadataLoader<Integer> {
    public NumberOfVersionsLoader(DBProvider provider) {
        super(provider);
    }

    @Override
    protected DocumentMetadata set(DocumentMetadata document, Integer metadata) {
        document.setNumberOfVersions(metadata);
        return document;
    }

    @Override
    public Map<Integer, Integer> load(Collection<Integer> ids, Context context) throws OXException {
        if (null == ids || 0 == ids.size()) {
            return Collections.emptyMap();
        }
        final HashMap<Integer, Integer> numberOfVersions = new HashMap<Integer, Integer>(ids.size());
        ArrayList<Integer> parameters = new ArrayList<Integer>(ids.size() + 1);
        parameters.add(Autoboxing.I((int)context.getContextId()));
        parameters.addAll(ids);
        String query = InfostoreQueryCatalog.getInstance().getNumberOfVersionsQueryForDocuments(Autoboxing.I2i(ids));
        try {
            this.performQuery(context, query, new DbMetadataLoader.ResultProcessor<Void>(){

                @Override
                public Void process(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        numberOfVersions.put(Autoboxing.I((int)rs.getInt(1)), Autoboxing.I((int)(rs.getInt(2) - 1)));
                    }
                    return null;
                }
            }, parameters.toArray(new Object[parameters.size()]));
        }
        catch (SQLException e) {
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        return numberOfVersions;
    }
}

