/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import com.openexchange.folderstorage.DefaultPermission;
import com.openexchange.folderstorage.Permissions;
import java.io.Serializable;
import java.security.acl.Permission;

public class ObjectPermission
implements Permission,
Serializable {
    public static final int NONE = 0;
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int DELETE = 4;
    private static final long serialVersionUID = 29807878639680055L;
    private int entity;
    private boolean group;
    private int permissions;

    public ObjectPermission() {
    }

    public ObjectPermission(int entity, boolean group, int permissions) {
        this.entity = entity;
        this.group = group;
        this.permissions = permissions;
    }

    public int getEntity() {
        return this.entity;
    }

    public void setEntity(int entity) {
        this.entity = entity;
    }

    public boolean isGroup() {
        return this.group;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public void setPermissions(int permissions) {
        this.permissions = permissions;
    }

    public boolean canRead() {
        return this.permissions >= 1;
    }

    public boolean canWrite() {
        return this.permissions >= 2;
    }

    public boolean canDelete() {
        return this.permissions >= 4;
    }

    public static int toFolderPermissionBits(ObjectPermission permission) {
        DefaultPermission fp = new DefaultPermission();
        fp.setEntity(permission.entity);
        fp.setGroup(false);
        fp.setAdmin(false);
        fp.setFolderPermission(2);
        fp.setReadPermission(permission.canRead() ? 4 : 0);
        fp.setWritePermission(permission.canWrite() ? 4 : 0);
        fp.setDeletePermission(permission.canDelete() ? 4 : 0);
        return Permissions.createPermissionBits(fp);
    }

    public static int convertFolderPermissionBits(int folderPermissionBits) {
        int objectBits = 0;
        int[] permissionBits = Permissions.parsePermissionBits(folderPermissionBits);
        int rp = permissionBits[1];
        int wp = permissionBits[2];
        int dp = permissionBits[3];
        if (dp >= 4) {
            objectBits = 4;
        } else if (wp >= 4) {
            objectBits = 2;
        } else if (rp >= 4) {
            objectBits = 1;
        }
        return objectBits;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.entity;
        result = 31 * result + (this.group ? 1231 : 1237);
        result = 31 * result + this.permissions;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectPermission)) {
            return false;
        }
        ObjectPermission other = (ObjectPermission)obj;
        if (this.entity != other.entity) {
            return false;
        }
        if (this.group != other.group) {
            return false;
        }
        return this.permissions == other.permissions;
    }

    public String toString() {
        return "ObjectPermission [entity=" + this.entity + ", group=" + this.group + ", permissions=" + this.permissions + "]";
    }
}

