/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.mail.mime.QuotedInternetAddress;
import java.io.Serializable;
import javax.mail.internet.AddressException;

public class DistributionListEntryObject
implements Serializable {
    private static final long serialVersionUID = 3878123169840216186L;
    public static final int INDEPENDENT = 0;
    public static final int EMAILFIELD1 = 1;
    public static final int EMAILFIELD2 = 2;
    public static final int EMAILFIELD3 = 3;
    public static final int INSERT = 1;
    public static final int UPDATE = 2;
    public static final int DELETE = 3;
    private int entry_id;
    private String emailaddress;
    private String displayname;
    private String lastname;
    private String firstname;
    private int emailfield;
    private int folderid;
    private boolean b_entry_id;
    private boolean b_emailaddress;
    private boolean b_displayname;
    private boolean b_firstname;
    private boolean b_lastname;
    private boolean b_emailfield;
    private boolean b_folderid;

    public DistributionListEntryObject() {
    }

    public DistributionListEntryObject(String displayname, String emailaddress, int emailfield) throws OXException {
        this();
        this.setDisplayname(displayname);
        this.setEmailaddress(emailaddress);
        this.setEmailfield(emailfield);
    }

    public int getEntryID() {
        return this.entry_id;
    }

    public int getFolderID() {
        return this.folderid;
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public String getEmailaddress() {
        return this.emailaddress;
    }

    public int getEmailfield() {
        return this.emailfield;
    }

    public String getLastname() {
        return this.lastname;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setEntryID(int entry_id) {
        this.entry_id = entry_id;
        this.b_entry_id = true;
    }

    public void setFolderID(int folderid) {
        this.folderid = folderid;
        this.b_folderid = true;
    }

    public void setDisplayname(String displayname) {
        this.displayname = displayname;
        this.b_displayname = true;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
        this.b_lastname = true;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
        this.b_firstname = true;
    }

    public void setEmailaddress(String emailaddress) throws OXException {
        this.setEmailaddress(emailaddress, null != emailaddress && 0 < emailaddress.length());
    }

    public void setEmailaddress(String emailaddress, boolean verifyAddress) throws OXException {
        if (verifyAddress) {
            try {
                new QuotedInternetAddress(emailaddress);
            }
            catch (AddressException e) {
                throw ContactExceptionCodes.INVALID_EMAIL.create(e, emailaddress);
            }
        }
        this.emailaddress = emailaddress;
        this.b_emailaddress = true;
    }

    public void setEmailfield(int emailfield) {
        this.emailfield = emailfield;
        this.b_emailfield = true;
    }

    public void removeEntryID() {
        this.entry_id = 0;
        this.b_entry_id = false;
    }

    public void removeDisplayname() {
        this.displayname = null;
        this.b_displayname = false;
    }

    public void removeFirstname() {
        this.firstname = null;
        this.b_firstname = false;
    }

    public void removeLastname() {
        this.lastname = null;
        this.b_lastname = false;
    }

    public void removeEmailaddress() {
        this.emailaddress = null;
        this.b_emailaddress = false;
    }

    public void removeEmailfield() {
        this.emailfield = 0;
        this.b_emailfield = false;
    }

    public void removeFolderld() {
        this.folderid = 0;
        this.b_folderid = false;
    }

    public boolean containsEntryID() {
        return this.b_entry_id;
    }

    public boolean containsDisplayname() {
        return this.b_displayname;
    }

    public boolean containsLastname() {
        return this.b_lastname;
    }

    public boolean containsFistname() {
        return this.b_firstname;
    }

    public boolean containsEmailaddress() {
        return this.b_emailaddress;
    }

    public boolean containsEmailfield() {
        return this.b_emailfield;
    }

    public boolean containsFolderld() {
        return this.b_folderid;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.emailaddress.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        DistributionListEntryObject distributionlistentry;
        return o instanceof DistributionListEntryObject && this.emailaddress.equals((distributionlistentry = (DistributionListEntryObject)o).getEmailaddress());
    }

    public boolean searchDlistObject(DistributionListEntryObject dleo) {
        return dleo.getEntryID() > 0 && this.getEntryID() == dleo.getEntryID() && this.getEmailfield() == dleo.getEmailfield();
    }

    public boolean compareDlistObject(DistributionListEntryObject dleo) {
        boolean eq = true;
        if (this.getDisplayname() != null && dleo.getDisplayname() != null) {
            if (!this.getDisplayname().equals(dleo.getDisplayname())) {
                eq = false;
            }
        } else if (this.getDisplayname() == null && dleo.getDisplayname() != null || this.getDisplayname() != null && dleo.getDisplayname() == null) {
            eq = false;
        }
        if (this.getEmailaddress() != null && dleo.getEmailaddress() != null) {
            if (!this.getEmailaddress().equals(dleo.getEmailaddress())) {
                eq = false;
            }
        } else if (this.getEmailaddress() == null && dleo.getEmailaddress() != null || this.getEmailaddress() != null && dleo.getEmailaddress() == null) {
            eq = false;
        }
        if (this.getFirstname() != null && dleo.getFirstname() != null) {
            if (!this.getFirstname().equals(dleo.getFirstname())) {
                eq = false;
            }
        } else if (this.getFirstname() == null && dleo.getFirstname() != null || this.getFirstname() != null && dleo.getFirstname() == null) {
            eq = false;
        }
        if (this.getLastname() != null && dleo.getLastname() != null) {
            if (!this.getLastname().equals(dleo.getLastname())) {
                eq = false;
            }
        } else if (this.getLastname() == null && dleo.getLastname() != null || this.getLastname() != null && dleo.getLastname() == null) {
            eq = false;
        }
        return eq;
    }

    public void reset() {
        this.entry_id = 0;
        this.displayname = null;
        this.lastname = null;
        this.firstname = null;
        this.emailaddress = null;
        this.emailfield = 0;
        this.folderid = 0;
        this.b_entry_id = false;
        this.b_displayname = false;
        this.b_lastname = false;
        this.b_firstname = false;
        this.b_emailaddress = false;
        this.b_emailfield = false;
        this.b_folderid = false;
    }

    public String toString() {
        return "DistributionListEntryObject [emailaddress=" + this.emailaddress + ", displayname=" + this.displayname + "]";
    }
}

