/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.alias.impl;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.alias.UserAliasStorage;
import com.openexchange.groupware.alias.impl.RdbAliasStorage;
import com.openexchange.lock.LockService;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public class CachingAliasStorage
implements UserAliasStorage {
    private static final String REGION_NAME = "UserAlias";
    private final RdbAliasStorage delegate;

    static CacheKey newCacheKey(CacheService cacheService, int userId, int contextId) {
        return cacheService.newCacheKey(contextId, userId);
    }

    public CachingAliasStorage(RdbAliasStorage delegate) {
        this.delegate = delegate;
    }

    @Override
    public void invalidateAliases(int contextId, int userId) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null != cacheService) {
            Cache cache = cacheService.getCache(REGION_NAME);
            cache.remove((Serializable)CachingAliasStorage.newCacheKey(cacheService, userId, contextId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAliases(int contextId, int userId) throws OXException {
        CacheKey key;
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return this.delegate.getAliases(contextId, userId);
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        Object object = cache.get((Serializable)(key = CachingAliasStorage.newCacheKey(cacheService, userId, contextId)));
        if (object instanceof Set) {
            return (Set)object;
        }
        LockService lockService = ServerServiceRegistry.getInstance().getService(LockService.class);
        Lock lock = null == lockService ? LockService.EMPTY_LOCK : lockService.getSelfCleaningLockFor(new StringBuilder(32).append("loadaliases-").append(contextId).append('-').append(userId).toString());
        lock.lock();
        try {
            object = cache.get((Serializable)key);
            if (object instanceof Set) {
                Set set = (Set)object;
                return set;
            }
            Set aliases = this.delegate.getAliases(contextId, userId);
            cache.put((Serializable)key, (Serializable)((Object)aliases), false);
            Set set = aliases;
            return set;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int getUserId(int contextId, String alias) throws OXException {
        return this.delegate.getUserId(contextId, alias);
    }

    @Override
    public boolean createAlias(Connection con, int contextId, int userId, String alias) throws OXException {
        boolean success = this.delegate.createAlias(con, contextId, userId, alias);
        if (success) {
            this.invalidateAliases(contextId, userId);
        }
        return success;
    }

    @Override
    public boolean updateAlias(Connection con, int contextId, int userId, String oldAlias, String newAlias) throws OXException {
        boolean success = this.delegate.updateAlias(con, contextId, userId, oldAlias, newAlias);
        if (success) {
            this.invalidateAliases(contextId, userId);
        }
        return success;
    }

    @Override
    public boolean deleteAlias(Connection con, int contextId, int userId, String alias) throws OXException {
        boolean success = this.delegate.deleteAlias(con, contextId, userId, alias);
        if (success) {
            this.invalidateAliases(contextId, userId);
        }
        return success;
    }

    @Override
    public boolean deleteAliases(Connection con, int contextId, int userId) throws OXException {
        boolean success = this.delegate.deleteAliases(con, contextId, userId);
        if (success) {
            this.invalidateAliases(contextId, userId);
        }
        return success;
    }

    @Override
    public List<Integer> getUserIdsByAliasDomain(int contextId, String domain) throws OXException {
        return this.delegate.getUserIdsByAliasDomain(contextId, domain);
    }
}

