/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.messaging;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.AbstractFolder;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SetterAwareFolder;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.StorageParametersUtility;
import com.openexchange.folderstorage.StoragePriority;
import com.openexchange.folderstorage.StorageType;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.messaging.ExternalMessagingAccountRootFolder;
import com.openexchange.folderstorage.messaging.MessagingAccountAccessFullnameProvider;
import com.openexchange.folderstorage.messaging.MessagingFolderIdentifier;
import com.openexchange.folderstorage.messaging.MessagingFolderImpl;
import com.openexchange.folderstorage.messaging.MessagingFolderType;
import com.openexchange.folderstorage.messaging.MessagingId;
import com.openexchange.folderstorage.messaging.contentType.DraftsContentType;
import com.openexchange.folderstorage.messaging.contentType.MessagingContentType;
import com.openexchange.folderstorage.messaging.contentType.SentContentType;
import com.openexchange.folderstorage.messaging.contentType.SpamContentType;
import com.openexchange.folderstorage.messaging.contentType.TrashContentType;
import com.openexchange.folderstorage.tx.TransactionManager;
import com.openexchange.folderstorage.type.MessagingType;
import com.openexchange.groupware.ldap.User;
import com.openexchange.java.Collators;
import com.openexchange.mail.MailSessionCache;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.messaging.DefaultMessagingFolder;
import com.openexchange.messaging.DefaultMessagingPermission;
import com.openexchange.messaging.MessagingAccount;
import com.openexchange.messaging.MessagingAccountAccess;
import com.openexchange.messaging.MessagingExceptionCodes;
import com.openexchange.messaging.MessagingField;
import com.openexchange.messaging.MessagingFolder;
import com.openexchange.messaging.MessagingFolderAccess;
import com.openexchange.messaging.MessagingMessage;
import com.openexchange.messaging.MessagingMessageAccess;
import com.openexchange.messaging.MessagingPermission;
import com.openexchange.messaging.MessagingService;
import com.openexchange.messaging.OrderDirection;
import com.openexchange.messaging.ServiceAware;
import com.openexchange.messaging.registry.MessagingServiceRegistry;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class MessagingFolderStorage
implements FolderStorage {
    private static final String PARAM = "mssgng.Access";
    private static volatile boolean mailFolderStorageAvailable;
    private static final String PRIVATE_FOLDER_ID;
    private final ServiceLookup services;

    public static void setMailFolderStorageAvailable(boolean mailFolderStorageAvailable) {
        MessagingFolderStorage.mailFolderStorageAvailable = mailFolderStorageAvailable;
    }

    public MessagingFolderStorage(ServiceLookup services) {
        this.services = services;
    }

    @Override
    public void clearCache(int userId, int contextId) {
    }

    @Override
    public void restore(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
    }

    @Override
    public Folder prepareFolder(String treeId, Folder folder, StorageParameters storageParameters) throws OXException {
        return folder;
    }

    @Override
    public void checkConsistency(String treeId, StorageParameters storageParameters) throws OXException {
    }

    @Override
    public SortableId[] getVisibleFolders(String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        throw new UnsupportedOperationException("MessagingFolderStorage.getVisibleSubfolders()");
    }

    @Override
    public SortableId[] getUserSharedFolders(String treeId, ContentType contentType, StorageParameters storageParameters) throws OXException {
        throw new UnsupportedOperationException("MessagingFolderStorage.getSharedFolders()");
    }

    private MessagingAccountAccess getMessagingAccessForAccount(String serviceId, int accountId, Session session, ConcurrentMap<Key, MessagingAccountAccess> accesses) throws OXException {
        Key key = Key.newInstance(accountId, serviceId);
        MessagingAccountAccess accountAccess = (MessagingAccountAccess)accesses.get(key);
        if (null == accountAccess) {
            MessagingServiceRegistry reg = (MessagingServiceRegistry)this.services.getService(MessagingServiceRegistry.class);
            MessagingService messagingService = reg.getMessagingService(serviceId, session.getUserId(), session.getContextId());
            accountAccess = messagingService.getAccountAccess(accountId, session);
            MessagingAccountAccess prev = accesses.putIfAbsent(key, accountAccess);
            if (null != prev) {
                accountAccess = prev;
            }
        }
        return accountAccess;
    }

    private void openMessagingAccess(MessagingAccountAccess accountAccess) throws OXException {
        if (!accountAccess.isConnected()) {
            accountAccess.connect();
        }
    }

    @Override
    public ContentType[] getSupportedContentTypes() {
        return new ContentType[]{MessagingContentType.getInstance(), DraftsContentType.getInstance(), SentContentType.getInstance(), SpamContentType.getInstance(), TrashContentType.getInstance()};
    }

    @Override
    public ContentType getDefaultContentType() {
        return MessagingContentType.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitTransaction(StorageParameters params) throws OXException {
        ConcurrentMap accesses = (ConcurrentMap)params.getParameter(MessagingFolderType.getInstance(), PARAM);
        if (null != accesses) {
            try {
                Collection values = accesses.values();
                for (MessagingAccountAccess messagingAccess : values) {
                    messagingAccess.close();
                }
            }
            finally {
                params.putParameter(MessagingFolderType.getInstance(), PARAM, null);
            }
        }
    }

    @Override
    public void createFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        MessagingPermission[] messagingPermissions;
        ConcurrentMap accesses = (ConcurrentMap)storageParameters.getParameter(MessagingFolderType.getInstance(), PARAM);
        if (null == accesses) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        MessagingFolderIdentifier mfi = new MessagingFolderIdentifier(folder.getParentID());
        String serviceId = mfi.getServiceId();
        int accountId = mfi.getAccountId();
        MessagingAccountAccess accountAccess = this.getMessagingAccessForAccount(serviceId, accountId, storageParameters.getSession(), accesses);
        this.openMessagingAccess(accountAccess);
        DefaultMessagingFolder dmf = new DefaultMessagingFolder();
        dmf.setExists(false);
        String parentId = mfi.getFullname();
        dmf.setParentId(parentId);
        dmf.setName(folder.getName());
        dmf.setSubscribed(folder.isSubscribed());
        Session session = storageParameters.getSession();
        if (null == session) {
            throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
        }
        Permission[] permissions = folder.getPermissions();
        if (null != permissions && permissions.length > 0) {
            messagingPermissions = new MessagingPermission[permissions.length];
            for (int i = 0; i < permissions.length; ++i) {
                Permission permission = permissions[i];
                DefaultMessagingPermission dmp = DefaultMessagingPermission.newInstance();
                dmp.setEntity(permission.getEntity());
                dmp.setAllPermissions(permission.getFolderPermission(), permission.getReadPermission(), permission.getWritePermission(), permission.getDeletePermission());
                dmp.setAdmin(permission.isAdmin());
                dmp.setGroup(permission.isGroup());
                messagingPermissions[i] = dmp;
            }
            dmf.setPermissions(Arrays.asList(messagingPermissions));
        } else if ("".equals(parentId)) {
            messagingPermissions = new MessagingPermission[1];
            DefaultMessagingPermission dmp = DefaultMessagingPermission.newInstance();
            dmp.setEntity(session.getUserId());
            dmp.setAllPermissions(128, 128, 128, 128);
            dmp.setAdmin(true);
            dmp.setGroup(false);
            messagingPermissions[0] = dmp;
            dmf.setPermissions(Arrays.asList(messagingPermissions));
        } else {
            MessagingFolder parent = accountAccess.getFolderAccess().getFolder(parentId);
            List parentPermissions = parent.getPermissions();
            MessagingPermission[] messagingPermissions2 = new MessagingPermission[parentPermissions.size()];
            int i = 0;
            for (MessagingPermission parentPerm : parentPermissions) {
                DefaultMessagingPermission dmp = DefaultMessagingPermission.newInstance();
                dmp.setEntity(parentPerm.getEntity());
                dmp.setAllPermissions(parentPerm.getFolderPermission(), parentPerm.getReadPermission(), parentPerm.getWritePermission(), parentPerm.getDeletePermission());
                dmp.setAdmin(parentPerm.isAdmin());
                dmp.setGroup(parentPerm.isGroup());
                messagingPermissions2[i++] = dmp;
            }
            dmf.setPermissions(Arrays.asList(messagingPermissions2));
        }
        String fullname = accountAccess.getFolderAccess().createFolder((MessagingFolder)dmf);
        folder.setID(new MessagingFolderIdentifier(serviceId, accountId, fullname).toString());
    }

    @Override
    public void clearFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        ConcurrentMap accesses = (ConcurrentMap)storageParameters.getParameter(MessagingFolderType.getInstance(), PARAM);
        if (null == accesses) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        MessagingFolderIdentifier mfi = new MessagingFolderIdentifier(folderId);
        MessagingAccountAccess accountAccess = this.getMessagingAccessForAccount(mfi.getServiceId(), mfi.getAccountId(), storageParameters.getSession(), accesses);
        this.openMessagingAccess(accountAccess);
        String fullname = mfi.getFullname();
        MessagingFolderAccess folderAccess = accountAccess.getFolderAccess();
        String trashFolder = folderAccess.getTrashFolder();
        folderAccess.clearFolder(fullname, null != trashFolder && fullname.startsWith(trashFolder));
    }

    @Override
    public void deleteFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        ConcurrentMap accesses = (ConcurrentMap)storageParameters.getParameter(MessagingFolderType.getInstance(), PARAM);
        if (null == accesses) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        MessagingFolderIdentifier mfi = new MessagingFolderIdentifier(folderId);
        MessagingAccountAccess accountAccess = this.getMessagingAccessForAccount(mfi.getServiceId(), mfi.getAccountId(), storageParameters.getSession(), accesses);
        this.openMessagingAccess(accountAccess);
        String fullname = mfi.getFullname();
        MessagingFolderAccess folderAccess = accountAccess.getFolderAccess();
        String trashFolder = folderAccess.getTrashFolder();
        folderAccess.deleteFolder(fullname, null != trashFolder && fullname.startsWith(trashFolder));
    }

    @Override
    public String getDefaultFolderID(User user, String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        if (!(contentType instanceof MessagingContentType)) {
            throw FolderExceptionErrorMessage.UNKNOWN_CONTENT_TYPE.create(contentType.toString());
        }
        String mailServiceId = "com.openexchange.messaging.mail";
        boolean primaryAccountId = false;
        if (MessagingContentType.getInstance().equals(contentType)) {
            return MessagingFolderIdentifier.getFQN("com.openexchange.messaging.mail", 0, "INBOX");
        }
        ConcurrentMap accesses = (ConcurrentMap)storageParameters.getParameter(MessagingFolderType.getInstance(), PARAM);
        if (null == accesses) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        MessagingAccountAccess accountAccess = this.getMessagingAccessForAccount("com.openexchange.messaging.mail", 0, storageParameters.getSession(), accesses);
        this.openMessagingAccess(accountAccess);
        if (DraftsContentType.getInstance().equals(contentType)) {
            return MessagingFolderIdentifier.getFQN("com.openexchange.messaging.mail", 0, accountAccess.getFolderAccess().getDraftsFolder());
        }
        if (SentContentType.getInstance().equals(contentType)) {
            return MessagingFolderIdentifier.getFQN("com.openexchange.messaging.mail", 0, accountAccess.getFolderAccess().getSentFolder());
        }
        if (SpamContentType.getInstance().equals(contentType)) {
            return MessagingFolderIdentifier.getFQN("com.openexchange.messaging.mail", 0, accountAccess.getFolderAccess().getSpamFolder());
        }
        if (TrashContentType.getInstance().equals(contentType)) {
            return MessagingFolderIdentifier.getFQN("com.openexchange.messaging.mail", 0, accountAccess.getFolderAccess().getTrashFolder());
        }
        throw FolderExceptionErrorMessage.UNKNOWN_CONTENT_TYPE.create(contentType.toString());
    }

    @Override
    public Type getTypeByParent(User user, String treeId, String parentId, StorageParameters storageParameters) throws OXException {
        return MessagingType.getInstance();
    }

    @Override
    public boolean containsForeignObjects(User user, String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        ConcurrentMap accesses = (ConcurrentMap)storageParameters.getParameter(MessagingFolderType.getInstance(), PARAM);
        if (null == accesses) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        MessagingFolderIdentifier mfi = new MessagingFolderIdentifier(folderId);
        String serviceId = mfi.getServiceId();
        int accountId = mfi.getAccountId();
        String fullname = mfi.getFullname();
        MessagingAccountAccess accountAccess = this.getMessagingAccessForAccount(serviceId, accountId, storageParameters.getSession(), accesses);
        if (!"".equals(fullname)) {
            this.openMessagingAccess(accountAccess);
            if (!accountAccess.getFolderAccess().exists(fullname)) {
                throw MessagingExceptionCodes.FOLDER_NOT_FOUND.create(new Object[]{fullname, accountId, serviceId, storageParameters.getUserId(), storageParameters.getContextId()});
            }
        }
        return false;
    }

    @Override
    public boolean isEmpty(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        ConcurrentMap accesses = (ConcurrentMap)storageParameters.getParameter(MessagingFolderType.getInstance(), PARAM);
        if (null == accesses) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        MessagingFolderIdentifier mfi = new MessagingFolderIdentifier(folderId);
        String serviceId = mfi.getServiceId();
        int accountId = mfi.getAccountId();
        String fullname = mfi.getFullname();
        MessagingAccountAccess accountAccess = this.getMessagingAccessForAccount(serviceId, accountId, storageParameters.getSession(), accesses);
        if ("".equals(fullname)) {
            return 0 == accountAccess.getRootFolder().getMessageCount();
        }
        this.openMessagingAccess(accountAccess);
        return 0 == accountAccess.getFolderAccess().getFolder(fullname).getMessageCount();
    }

    @Override
    public void updateLastModified(long lastModified, String treeId, String folderId, StorageParameters storageParameters) throws OXException {
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageParameters storageParameters) throws OXException {
        return this.getFolders(treeId, folderIds, StorageType.WORKING, storageParameters);
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageType storageType, StorageParameters storageParameters) throws OXException {
        ArrayList<Folder> ret = new ArrayList<Folder>(folderIds.size());
        for (String folderId : folderIds) {
            ret.add(this.getFolder(treeId, folderId, storageType, storageParameters));
        }
        return ret;
    }

    @Override
    public Folder getFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        return this.getFolder(treeId, folderId, StorageType.WORKING, storageParameters);
    }

    @Override
    public Folder getFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        AbstractFolder retval;
        if (StorageType.BACKUP.equals(storageType)) {
            throw FolderExceptionErrorMessage.UNSUPPORTED_STORAGE_TYPE.create(storageType);
        }
        ConcurrentMap accesses = (ConcurrentMap)storageParameters.getParameter(MessagingFolderType.getInstance(), PARAM);
        if (null == accesses) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        MessagingFolderIdentifier mfi = new MessagingFolderIdentifier(folderId);
        String serviceId = mfi.getServiceId();
        int accountId = mfi.getAccountId();
        String fullname = mfi.getFullname();
        Session session = storageParameters.getSession();
        if ("".equals(fullname)) {
            boolean hasSubfolders;
            MessagingServiceRegistry msr = (MessagingServiceRegistry)this.services.getService(MessagingServiceRegistry.class);
            MessagingService messagingService = msr.getMessagingService(serviceId, session.getUserId(), session.getContextId());
            MessagingAccount messagingAccount = messagingService.getAccountManager().getAccount(accountId, session);
            if ("com.openexchange.messaging.rss".equals(serviceId)) {
                retval = new ExternalMessagingAccountRootFolder(messagingAccount, serviceId, session, messagingService.getStaticRootPermissions());
                hasSubfolders = false;
            } else if ("com.openexchange.messaging.twitter".equals(serviceId)) {
                retval = new ExternalMessagingAccountRootFolder(messagingAccount, serviceId, session, messagingService.getStaticRootPermissions());
                hasSubfolders = false;
            } else {
                MessagingAccountAccess accountAccess = this.getMessagingAccessForAccount(serviceId, accountId, session, accesses);
                this.openMessagingAccess(accountAccess);
                MessagingFolder rootFolder = accountAccess.getFolderAccess().getRootFolder();
                retval = new MessagingFolderImpl(rootFolder, accountId, serviceId, storageParameters.getUser(), null);
                retval.setName(messagingAccount.getDisplayName());
                hasSubfolders = rootFolder.hasSubfolders();
            }
            retval.setSubfolderIDs(hasSubfolders ? null : new String[]{});
        } else {
            MessagingAccountAccess accountAccess = this.getMessagingAccessForAccount(serviceId, accountId, session, accesses);
            this.openMessagingAccess(accountAccess);
            MessagingFolder messagingFolder = accountAccess.getFolderAccess().getFolder(fullname);
            retval = new MessagingFolderImpl(messagingFolder, accountId, serviceId, storageParameters.getUser(), new MessagingAccountAccessFullnameProvider(accountAccess));
            boolean hasSubfolders = messagingFolder.hasSubfolders();
            if ("INBOX".equals(fullname)) {
                retval.setSubfolderIDs(hasSubfolders ? null : new String[]{});
            } else {
                List<MessagingFolder> children = Arrays.asList(accountAccess.getFolderAccess().getSubfolders(fullname, true));
                Collections.sort(children, new SimpleMessagingFolderComparator(storageParameters.getUser().getLocale()));
                String[] subfolderIds = new String[children.size()];
                int i = 0;
                for (MessagingFolder child : children) {
                    subfolderIds[i++] = MessagingFolderIdentifier.getFQN(serviceId, accountId, child.getId());
                }
                retval.setSubfolderIDs(subfolderIds);
            }
        }
        retval.setTreeID(treeId);
        return retval;
    }

    private boolean isDefaultFoldersChecked(int accountId, Session session) {
        Boolean b = (Boolean)MailSessionCache.getInstance(session).getParameter(accountId, MailSessionParameterNames.getParamDefaultFolderChecked());
        return b != null && b != false;
    }

    private String[] getSortedDefaultMessagingFolders(int accountId, Session session) {
        String[] arr = (String[])MailSessionCache.getInstance(session).getParameter(accountId, MailSessionParameterNames.getParamDefaultFolderArray());
        if (arr == null) {
            return new String[0];
        }
        return new String[]{"INBOX", arr[0], arr[1], arr[2], arr[3]};
    }

    @Override
    public FolderType getFolderType() {
        return MessagingFolderType.getInstance();
    }

    @Override
    public SortableId[] getSubfolders(String treeId, String parentId, StorageParameters storageParameters) throws OXException {
        Session s = storageParameters.getSession();
        if (null == s) {
            throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
        }
        ServerSession session = s instanceof ServerSession ? (ServerSession)s : ServerSessionAdapter.valueOf(s);
        if (PRIVATE_FOLDER_ID.equals(parentId)) {
            ArrayList<MessagingAccount> accounts = new ArrayList<MessagingAccount>(8);
            MessagingServiceRegistry registry = (MessagingServiceRegistry)this.services.getService(MessagingServiceRegistry.class);
            List allServices = registry.getAllServices(session.getUserId(), session.getContextId());
            boolean available = mailFolderStorageAvailable;
            String mailMessagingServiceId = "com.openexchange.messaging.mail";
            for (MessagingService messagingService : allServices) {
                if (available && "com.openexchange.messaging.mail".equals(messagingService.getId())) continue;
                List userAccounts = messagingService.getAccountManager().getAccounts((Session)session);
                for (MessagingAccount userAccount : userAccounts) {
                    accounts.add(userAccount);
                }
            }
            if (accounts.isEmpty()) {
                return new SortableId[0];
            }
            int size = accounts.size();
            if (size > 1) {
                Collections.sort(accounts, new MessagingAccountComparator(session.getUser().getLocale()));
            }
            ArrayList<MessagingId> list = new ArrayList<MessagingId>(size);
            for (int j = 0; j < size; ++j) {
                MessagingService tmp;
                MessagingAccount acc = (MessagingAccount)accounts.get(j);
                String serviceId = acc instanceof ServiceAware ? ((ServiceAware)acc).getServiceId() : (null == (tmp = acc.getMessagingService()) ? null : tmp.getId());
                list.add(new MessagingId(MessagingFolderIdentifier.getFQN(serviceId, acc.getId(), ""), j, null));
            }
            return list.toArray(new SortableId[list.size()]);
        }
        ConcurrentMap accesses = (ConcurrentMap)storageParameters.getParameter(MessagingFolderType.getInstance(), PARAM);
        if (null == accesses) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        MessagingFolderIdentifier mfi = new MessagingFolderIdentifier(parentId);
        String serviceId = mfi.getServiceId();
        int accountId = mfi.getAccountId();
        MessagingAccountAccess accountAccess = this.getMessagingAccessForAccount(serviceId, accountId, storageParameters.getSession(), accesses);
        this.openMessagingAccess(accountAccess);
        String fullname = mfi.getFullname();
        List<MessagingFolder> children = Arrays.asList(accountAccess.getFolderAccess().getSubfolders(fullname, true));
        if (!"".equals(fullname) && !"INBOX".equals(fullname)) {
            Collections.sort(children, new SimpleMessagingFolderComparator(storageParameters.getUser().getLocale()));
        } else {
            String[] names;
            if (this.isDefaultFoldersChecked(accountId, storageParameters.getSession())) {
                names = this.getSortedDefaultMessagingFolders(accountId, storageParameters.getSession());
            } else {
                ArrayList<String> tmp = new ArrayList<String>();
                tmp.add("INBOX");
                MessagingFolderAccess folderAccess = accountAccess.getFolderAccess();
                String fn = folderAccess.getDraftsFolder();
                if (null != fn) {
                    tmp.add(fn);
                }
                if (null != (fn = folderAccess.getSentFolder())) {
                    tmp.add(fn);
                }
                if (null != (fn = folderAccess.getSpamFolder())) {
                    tmp.add(fn);
                }
                if (null != (fn = folderAccess.getTrashFolder())) {
                    tmp.add(fn);
                }
                names = tmp.toArray(new String[tmp.size()]);
            }
            Collections.sort(children, new MessagingFolderComparator(names, storageParameters.getUser().getLocale()));
        }
        ArrayList<MessagingId> list = new ArrayList<MessagingId>(children.size());
        int size = children.size();
        for (int j = 0; j < size; ++j) {
            MessagingFolder cur = children.get(j);
            list.add(new MessagingId(MessagingFolderIdentifier.getFQN(serviceId, accountId, cur.getId()), j, cur.getName()));
        }
        return list.toArray(new SortableId[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(StorageParameters params) {
        ConcurrentMap accesses = (ConcurrentMap)params.getParameter(MessagingFolderType.getInstance(), PARAM);
        if (null != accesses) {
            try {
                Collection values = accesses.values();
                for (MessagingAccountAccess access : values) {
                    access.close();
                }
            }
            finally {
                params.putParameter(MessagingFolderType.getInstance(), PARAM, null);
            }
        }
    }

    @Override
    public boolean startTransaction(StorageParameters parameters, boolean modify) throws OXException {
        if (null == parameters.getSession()) {
            throw FolderExceptionErrorMessage.MISSING_SESSION.create();
        }
        boolean started = parameters.putParameterIfAbsent(MessagingFolderType.getInstance(), PARAM, new ConcurrentHashMap());
        if (started && TransactionManager.isManagedTransaction(parameters)) {
            TransactionManager.getTransactionManager(parameters).transactionStarted(this);
            return false;
        }
        return started;
    }

    @Override
    public StoragePriority getStoragePriority() {
        return StoragePriority.NORMAL;
    }

    @Override
    public boolean containsFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        return this.containsFolder(treeId, folderId, StorageType.WORKING, storageParameters);
    }

    @Override
    public boolean containsFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        if (StorageType.BACKUP.equals(storageType)) {
            return false;
        }
        ConcurrentMap accesses = (ConcurrentMap)storageParameters.getParameter(MessagingFolderType.getInstance(), PARAM);
        if (null == accesses) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        MessagingFolderIdentifier mfi = new MessagingFolderIdentifier(folderId);
        String serviceId = mfi.getServiceId();
        int accountId = mfi.getAccountId();
        MessagingAccountAccess accountAccess = this.getMessagingAccessForAccount(serviceId, accountId, storageParameters.getSession(), accesses);
        this.openMessagingAccess(accountAccess);
        return accountAccess.getFolderAccess().exists(mfi.getFullname());
    }

    @Override
    public String[] getDeletedFolderIDs(String treeId, Date timeStamp, StorageParameters storageParameters) throws OXException {
        return new String[0];
    }

    @Override
    public String[] getModifiedFolderIDs(String treeId, Date timeStamp, ContentType[] includeContentTypes, StorageParameters storageParameters) throws OXException {
        if (null == includeContentTypes || includeContentTypes.length == 0) {
            return new String[0];
        }
        ArrayList<String> ret = new ArrayList<String>();
        HashSet<ContentType> supported = new HashSet<ContentType>(Arrays.asList(this.getSupportedContentTypes()));
        for (ContentType includeContentType : includeContentTypes) {
            SortableId[] subfolders;
            if (!supported.contains(includeContentType)) continue;
            for (SortableId sortableId : subfolders = this.getSubfolders(FolderStorage.REAL_TREE_ID, PRIVATE_FOLDER_ID, storageParameters)) {
                ret.add(sortableId.getId());
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        MessagingFolderIdentifier pfi;
        ConcurrentMap accesses = (ConcurrentMap)storageParameters.getParameter(MessagingFolderType.getInstance(), PARAM);
        if (null == accesses) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        MessagingFolderIdentifier mfi = new MessagingFolderIdentifier(folder.getID());
        String serviceId = mfi.getServiceId();
        int accountId = mfi.getAccountId();
        String id = mfi.getFullname();
        MessagingAccountAccess accountAccess = this.getMessagingAccessForAccount(serviceId, accountId, storageParameters.getSession(), accesses);
        this.openMessagingAccess(accountAccess);
        DefaultMessagingFolder dmf = new DefaultMessagingFolder();
        dmf.setExists(true);
        dmf.setId(id);
        if (null != folder.getParentID()) {
            pfi = new MessagingFolderIdentifier(folder.getParentID());
            dmf.setParentId(pfi.getFullname());
        } else {
            pfi = null;
        }
        if (null != folder.getName()) {
            dmf.setName(folder.getName());
        }
        if (folder instanceof SetterAwareFolder) {
            if (((SetterAwareFolder)folder).containsSubscribed()) {
                dmf.setSubscribed(folder.isSubscribed());
            }
        } else {
            dmf.setSubscribed(folder.isSubscribed());
        }
        MessagingPermission[] messagingPermissions = null;
        Permission[] permissions = folder.getPermissions();
        if (null != permissions && permissions.length > 0) {
            messagingPermissions = new MessagingPermission[permissions.length];
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            for (int i = 0; i < permissions.length; ++i) {
                Permission permission = permissions[i];
                DefaultMessagingPermission dmp = DefaultMessagingPermission.newInstance();
                dmp.setEntity(permission.getEntity());
                dmp.setAllPermissions(permission.getFolderPermission(), permission.getReadPermission(), permission.getWritePermission(), permission.getDeletePermission());
                dmp.setAdmin(permission.isAdmin());
                dmp.setGroup(permission.isGroup());
                messagingPermissions[i] = dmp;
            }
            dmf.setPermissions(Arrays.asList(messagingPermissions));
        }
        MessagingFolder storageVersion = accountAccess.getFolderAccess().getFolder(id);
        String oldParent = storageVersion.getParentId();
        String oldName = storageVersion.getName();
        dmf.setSeparator(storageVersion.getSeparator());
        String newName = dmf.getName();
        boolean movePerformed = false;
        String newParent = dmf.getParentId();
        if (newParent != null) {
            int parentAccountID = pfi.getAccountId();
            if (accountId == parentAccountID) {
                if (!newParent.equals(oldParent)) {
                    boolean rename = null != newName && !newName.equals(oldName);
                    this.check4DuplicateFolder(accountAccess, newParent, rename ? newName : oldName);
                    String movedFolder = accountAccess.getFolderAccess().moveFolder(id, newParent);
                    if (rename) {
                        movedFolder = accountAccess.getFolderAccess().renameFolder(movedFolder, newName);
                    }
                    folder.setID(MessagingFolderIdentifier.getFQN(serviceId, accountId, movedFolder));
                    movePerformed = true;
                }
            } else {
                this.openMessagingAccess(otherAccess);
                try (MessagingAccountAccess otherAccess = this.getMessagingAccessForAccount(serviceId, parentAccountID, storageParameters.getSession(), accesses);){
                    MessagingFolder p = otherAccess.getFolderAccess().getFolder(newParent);
                    MessagingPermission ownPermission = p.getOwnPermission();
                    if (ownPermission.getFolderPermission() < 8) {
                        throw MessagingExceptionCodes.NO_CREATE_ACCESS.create(new Object[]{newParent});
                    }
                    this.check4DuplicateFolder(otherAccess, newParent, null == newName ? oldName : newName);
                    String destFullname = MessagingFolderStorage.fullCopy(accountAccess, id, otherAccess, newParent, p.getSeparator(), storageParameters.getUserId(), p.getCapabilities().contains("PERMISSIONS"));
                    accountAccess.getFolderAccess().deleteFolder(id, true);
                    otherAccess.getFolderAccess().updateFolder(destFullname, (MessagingFolder)dmf);
                }
            }
        }
        if (!movePerformed && newName != null && !newName.equals(oldName)) {
            id = accountAccess.getFolderAccess().renameFolder(id, newName);
            folder.setID(MessagingFolderIdentifier.getFQN(serviceId, accountId, id));
        }
        accountAccess.getFolderAccess().updateFolder(id, (MessagingFolder)dmf);
        if (null != messagingPermissions && StorageParametersUtility.isHandDownPermissions(storageParameters)) {
            MessagingFolderStorage.handDown(accountId, id, messagingPermissions, accountAccess);
        }
    }

    private static void handDown(int accountId, String parentId, MessagingPermission[] messagingPermissions, MessagingAccountAccess accountAccess) throws OXException {
        MessagingFolder[] subfolders;
        for (MessagingFolder subfolder : subfolders = accountAccess.getFolderAccess().getSubfolders(parentId, true)) {
            DefaultMessagingFolder dmf = new DefaultMessagingFolder();
            dmf.setExists(true);
            String id = subfolder.getId();
            dmf.setId(id);
            dmf.setPermissions(Arrays.asList(messagingPermissions));
            accountAccess.getFolderAccess().updateFolder(id, (MessagingFolder)dmf);
            MessagingFolderStorage.handDown(accountId, id, messagingPermissions, accountAccess);
        }
    }

    private void check4DuplicateFolder(MessagingAccountAccess accountAccess, String parentId, String name2check) throws OXException {
        MessagingFolder[] subfolders;
        for (MessagingFolder subfolder : subfolders = accountAccess.getFolderAccess().getSubfolders(parentId, true)) {
            if (!name2check.equals(subfolder.getName())) continue;
            throw MessagingExceptionCodes.DUPLICATE_FOLDER.create(new Object[]{name2check, parentId});
        }
    }

    private static String fullCopy(MessagingAccountAccess srcAccess, String srcFullname, MessagingAccountAccess destAccess, String destParent, char destSeparator, int user, boolean hasPermissions) throws OXException {
        MessagingFolder[] tmp;
        MessagingFolder source = srcAccess.getFolderAccess().getFolder(srcFullname);
        DefaultMessagingFolder mfd = new DefaultMessagingFolder();
        mfd.setName(source.getName());
        mfd.setParentId(destParent);
        mfd.setSeparator(destSeparator);
        mfd.setSubscribed(source.isSubscribed());
        if (hasPermissions) {
            List perms = source.getPermissions();
            for (MessagingPermission perm : perms) {
                mfd.addPermission((MessagingPermission)perm.clone());
            }
        }
        String destFullname = destAccess.getFolderAccess().createFolder((MessagingFolder)mfd);
        List msgs = srcAccess.getMessageAccess().getAllMessages(srcFullname, null, MessagingField.RECEIVED_DATE, OrderDirection.ASC, new MessagingField[]{MessagingField.FULL});
        MessagingMessageAccess destMessageStorage = destAccess.getMessageAccess();
        destMessageStorage.appendMessages(destFullname, msgs.toArray(new MessagingMessage[msgs.size()]));
        for (MessagingFolder element : tmp = srcAccess.getFolderAccess().getSubfolders(srcFullname, true)) {
            MessagingFolderStorage.fullCopy(srcAccess, element.getId(), destAccess, destFullname, destSeparator, user, hasPermissions);
        }
        return destFullname;
    }

    static {
        PRIVATE_FOLDER_ID = String.valueOf(1);
    }

    private static final class MessagingFolderComparator
    implements Comparator<MessagingFolder> {
        private final Map<String, Integer> indexMap;
        private final Collator collator;
        private final Integer na;

        MessagingFolderComparator(String[] names, Locale locale) {
            this.indexMap = new HashMap<String, Integer>(names.length);
            for (int i = 0; i < names.length; ++i) {
                this.indexMap.put(names[i], i);
            }
            this.na = names.length;
            this.collator = Collators.getSecondaryInstance((Locale)locale);
        }

        private Integer getNumberOf(String name) {
            Integer ret = this.indexMap.get(name);
            if (null == ret) {
                return this.na;
            }
            return ret;
        }

        @Override
        public int compare(MessagingFolder o1, MessagingFolder o2) {
            if (o1.isDefaultFolder()) {
                if (o2.isDefaultFolder()) {
                    return this.getNumberOf(o1.getId()).compareTo(this.getNumberOf(o2.getId()));
                }
                return -1;
            }
            if (o2.isDefaultFolder()) {
                return 1;
            }
            return this.collator.compare(o1.getName(), o2.getName());
        }
    }

    private static final class SimpleMessagingFolderComparator
    implements Comparator<MessagingFolder> {
        private final Collator collator;

        SimpleMessagingFolderComparator(Locale locale) {
            this.collator = Collators.getSecondaryInstance((Locale)locale);
        }

        @Override
        public int compare(MessagingFolder o1, MessagingFolder o2) {
            return this.collator.compare(o1.getName(), o2.getName());
        }
    }

    private static final class MessagingAccountComparator
    implements Comparator<MessagingAccount> {
        private final Collator collator;

        MessagingAccountComparator(Locale locale) {
            this.collator = Collators.getSecondaryInstance((Locale)locale);
        }

        @Override
        public int compare(MessagingAccount o1, MessagingAccount o2) {
            return this.collator.compare(o1.getDisplayName(), o2.getDisplayName());
        }
    }

    private static final class Key {
        private final int accountId;
        private final String serviceId;
        private final int hash;

        static Key newInstance(int accountId, String serviceId) {
            return new Key(accountId, serviceId);
        }

        private Key(int accountId, String serviceId) {
            this.accountId = accountId;
            this.serviceId = serviceId;
            int prime = 31;
            int result = 1;
            result = 31 * result + accountId;
            this.hash = result = 31 * result + (serviceId == null ? 0 : serviceId.hashCode());
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (this.accountId != other.accountId) {
                return false;
            }
            return !(this.serviceId == null ? other.serviceId != null : !this.serviceId.equals(other.serviceId));
        }
    }
}

